/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift;

import com.jetbrains.cef.remote.thrift.AsyncProcessFunction;
import com.jetbrains.cef.remote.thrift.Logger;
import com.jetbrains.cef.remote.thrift.LoggerFactory;
import com.jetbrains.cef.remote.thrift.TApplicationException;
import com.jetbrains.cef.remote.thrift.TAsyncProcessor;
import com.jetbrains.cef.remote.thrift.TBase;
import com.jetbrains.cef.remote.thrift.TException;
import com.jetbrains.cef.remote.thrift.TProcessor;
import com.jetbrains.cef.remote.thrift.async.AsyncMethodCallback;
import com.jetbrains.cef.remote.thrift.protocol.TMessage;
import com.jetbrains.cef.remote.thrift.protocol.TProtocol;
import com.jetbrains.cef.remote.thrift.protocol.TProtocolException;
import com.jetbrains.cef.remote.thrift.protocol.TProtocolUtil;
import com.jetbrains.cef.remote.thrift.server.AbstractNonblockingServer;
import java.util.Collections;
import java.util.Map;

public class TBaseAsyncProcessor<I>
implements TAsyncProcessor,
TProcessor {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass().getName());
    final I iface;
    final Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap;

    public TBaseAsyncProcessor(I iface, Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap) {
        this.iface = iface;
        this.processMap = processMap;
    }

    public Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> getProcessMapView() {
        return Collections.unmodifiableMap(this.processMap);
    }

    @Override
    public void process(AbstractNonblockingServer.AsyncFrameBuffer fb) throws TException {
        TProtocol in = fb.getInputProtocol();
        TProtocol out = fb.getOutputProtocol();
        TMessage msg = in.readMessageBegin();
        AsyncProcessFunction<I, TBase, ?> fn = this.processMap.get(msg.name);
        if (fn == null) {
            TProtocolUtil.skip(in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            this.LOGGER.debug("Invalid method name", x);
            if (msg.type == 1) {
                out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
                x.write(out);
                out.writeMessageEnd();
                out.getTransport().flush();
            }
            fb.responseReady();
            return;
        }
        TBase args = fn.getEmptyArgsInstance();
        try {
            args.read(in);
        }
        catch (TProtocolException e) {
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(7, e.getMessage());
            this.LOGGER.debug("Could not retrieve function arguments", x);
            if (!fn.isOneway()) {
                out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
                x.write(out);
                out.writeMessageEnd();
                out.getTransport().flush();
            }
            fb.responseReady();
            return;
        }
        in.readMessageEnd();
        if (fn.isOneway()) {
            fb.responseReady();
        }
        AsyncMethodCallback<?> resultHandler = fn.getResultHandler(fb, msg.seqid);
        try {
            fn.start(this.iface, args, resultHandler);
        }
        catch (Exception e) {
            this.LOGGER.debug("Exception handling function", e);
            resultHandler.onError(e);
        }
    }

    @Override
    public void process(TProtocol in, TProtocol out) throws TException {
    }
}

