/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.util.regex;

import ai.grazie.rules.util.regex.RegexPath;
import ai.grazie.rules.util.regex.Term;
import ai.grazie.rules.util.regex.Unsupported;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

record Or(List<Term> components) implements Term
{
    Or {
        assert (components.size() > 1);
    }

    @Override
    @NotNull
    public Set<RegexPath> enumerate(int limit, boolean leanRight) {
        HashSet<RegexPath> result = new HashSet<RegexPath>();
        boolean hasUnsupported = false;
        for (Term component : this.components) {
            Set<RegexPath> inner = component.enumerate(limit, leanRight);
            for (RegexPath path : inner) {
                hasUnsupported |= path.single() instanceof Unsupported;
                result.add(path);
            }
        }
        if (result.size() > limit | hasUnsupported) {
            return Set.of(RegexPath.toUnsupported(result));
        }
        return result;
    }

    @Override
    public boolean isFinite() {
        return this.components.stream().allMatch(Term::isFinite);
    }
}

