/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.input;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.input.DisposedWindowMonitor;
import org.assertj.swing.listener.WeakEventListener;

public class EventNormalizer
implements AWTEventListener {
    private final DisposedWindowMonitor disposedWindowMonitor;
    private WeakEventListener weakEventListener;
    private AWTEventListener listener;

    public EventNormalizer() {
        this(new DisposedWindowMonitor());
    }

    @VisibleForTesting
    EventNormalizer(@Nonnull DisposedWindowMonitor disposedWindowMonitor) {
        this.disposedWindowMonitor = disposedWindowMonitor;
    }

    public void startListening(@Nonnull Toolkit toolkit, @Nonnull AWTEventListener delegate, long mask) {
        this.listener = delegate;
        this.weakEventListener = WeakEventListener.attachAsWeakEventListener(toolkit, this, mask);
    }

    public void stopListening() {
        this.disposeWeakEventListener();
        this.listener = null;
    }

    private void disposeWeakEventListener() {
        if (this.weakEventListener == null) {
            return;
        }
        this.weakEventListener.dispose();
        this.weakEventListener = null;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        boolean discard = this.disposedWindowMonitor.isDuplicateDispose(event);
        if (!discard && this.listener != null) {
            this.delegate(event);
        }
    }

    private void delegate(@Nonnull AWTEvent e) {
        this.listener.eventDispatched(e);
    }
}

