﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/SecondarySubnet.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class CreateSecondarySubnetResponse {
 public:
  AWS_EC2_API CreateSecondarySubnetResponse() = default;
  AWS_EC2_API CreateSecondarySubnetResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API CreateSecondarySubnetResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Information about the secondary subnet.</p>
   */
  inline const SecondarySubnet& GetSecondarySubnet() const { return m_secondarySubnet; }
  template <typename SecondarySubnetT = SecondarySubnet>
  void SetSecondarySubnet(SecondarySubnetT&& value) {
    m_secondarySubnetHasBeenSet = true;
    m_secondarySubnet = std::forward<SecondarySubnetT>(value);
  }
  template <typename SecondarySubnetT = SecondarySubnet>
  CreateSecondarySubnetResponse& WithSecondarySubnet(SecondarySubnetT&& value) {
    SetSecondarySubnet(std::forward<SecondarySubnetT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Unique, case-sensitive identifier to ensure the idempotency of the request.
   * Only returned if a client token was provided in the request.</p>
   */
  inline const Aws::String& GetClientToken() const { return m_clientToken; }
  template <typename ClientTokenT = Aws::String>
  void SetClientToken(ClientTokenT&& value) {
    m_clientTokenHasBeenSet = true;
    m_clientToken = std::forward<ClientTokenT>(value);
  }
  template <typename ClientTokenT = Aws::String>
  CreateSecondarySubnetResponse& WithClientToken(ClientTokenT&& value) {
    SetClientToken(std::forward<ClientTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  CreateSecondarySubnetResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  SecondarySubnet m_secondarySubnet;

  Aws::String m_clientToken;

  ResponseMetadata m_responseMetadata;
  bool m_secondarySubnetHasBeenSet = false;
  bool m_clientTokenHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
