/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.processing.html;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.markdown.InlineMarkdown;
import org.jetbrains.jewel.markdown.MarkdownBlock;
import org.jetbrains.jewel.markdown.WithInlineMarkdown;
import org.jetbrains.jewel.markdown.processing.MarkdownProcessor;
import org.jetbrains.jewel.markdown.processing.html.ConvertersKt;
import org.jetbrains.jewel.markdown.processing.html.HtmlElementConverter;
import org.jetbrains.jewel.markdown.processing.html.MarkdownHtmlInlinesConverter;
import org.jetbrains.jewel.markdown.processing.html.MarkdownHtmlNode;
import org.jetbrains.jewel.markdown.scrolling.ScrollingSynchronizer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\rJ4\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010*\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\rH\u0002J4\u0010\u0012\u001a\u0004\u0018\u00010\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0015H\u0002J\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010*\u00020\u001b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/jewel/markdown/processing/html/MarkdownHtmlConverter;", "", "<init>", "()V", "inlinesConverter", "Lorg/jetbrains/jewel/markdown/processing/html/MarkdownHtmlInlinesConverter;", "convert", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "processor", "Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor;", "htmlElement", "Lorg/jetbrains/jewel/markdown/processing/html/MarkdownHtmlNode;", "transform", "Lkotlin/Function2;", "Lkotlin/ranges/IntRange;", "convertChildren", "", "Lorg/jetbrains/jewel/markdown/processing/html/MarkdownHtmlNode$Element;", "flushHtmlElementsToMarkdownBlocks", "currentInlineHtmlElements", "", "Lkotlin/Function1;", "Lorg/jetbrains/jewel/markdown/InlineMarkdown;", "inlines", "htmlElementsToInlines", "htmlElements", "processToInlines", "", "provideConverter", "Lorg/jetbrains/jewel/markdown/processing/html/HtmlElementConverter;", "tag", "intellij.platform.jewel.markdown.core"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nHtmlElementConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlElementConverter.kt\norg/jetbrains/jewel/markdown/processing/html/MarkdownHtmlConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1#2:158\n1374#3:159\n1460#3,5:160\n*S KotlinDebug\n*F\n+ 1 HtmlElementConverter.kt\norg/jetbrains/jewel/markdown/processing/html/MarkdownHtmlConverter\n*L\n144#1:159\n144#1:160,5\n*E\n"})
public final class MarkdownHtmlConverter {
    @NotNull
    private final MarkdownHtmlInlinesConverter inlinesConverter = new MarkdownHtmlInlinesConverter();
    public static final int $stable;

    @Nullable
    public final MarkdownBlock convert(@NotNull MarkdownProcessor processor, @NotNull MarkdownHtmlNode htmlElement, @NotNull Function2<? super MarkdownBlock, ? super IntRange, ? extends MarkdownBlock> transform) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)htmlElement, (String)"htmlElement");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        MarkdownHtmlNode markdownHtmlNode = htmlElement;
        if (!(markdownHtmlNode instanceof MarkdownHtmlNode.Text)) {
            if (markdownHtmlNode instanceof MarkdownHtmlNode.Element) {
                HtmlElementConverter htmlElementConverter = this.provideConverter(processor, ((MarkdownHtmlNode.Element)htmlElement).getTag());
                if (htmlElementConverter == null) {
                    return null;
                }
                HtmlElementConverter converter = htmlElementConverter;
                MarkdownBlock markdownBlock = converter.convert((MarkdownHtmlNode.Element)htmlElement, (Function1<? super MarkdownHtmlNode.Element, ? extends List<? extends MarkdownBlock>>)((Function1)arg_0 -> MarkdownHtmlConverter.convert$lambda$0(this, processor, transform, arg_0)), (Function1<? super List<? extends MarkdownHtmlNode>, ? extends List<? extends InlineMarkdown>>)((Function1)arg_0 -> MarkdownHtmlConverter.convert$lambda$1(this, processor, arg_0)));
                if (markdownBlock == null) {
                    return null;
                }
                MarkdownBlock convertedBlock = markdownBlock;
                MarkdownBlock transformedBlock = (MarkdownBlock)transform.invoke((Object)convertedBlock, (Object)((MarkdownHtmlNode.Element)htmlElement).getLineRange());
                return ((MarkdownHtmlNode.Element)htmlElement).getAttributes().isEmpty() ? transformedBlock : (MarkdownBlock)transform.invoke((Object)new MarkdownBlock.HtmlBlockWithAttributes(transformedBlock, ((MarkdownHtmlNode.Element)htmlElement).getAttributes()), (Object)((MarkdownHtmlNode.Element)htmlElement).getLineRange());
            }
            throw new NoWhenBranchMatchedException();
        }
        return (MarkdownBlock)CollectionsKt.firstOrNull(processor.processRawMarkdown$intellij_platform_jewel_markdown_core(((MarkdownHtmlNode.Text)htmlElement).getHtmlContent()));
    }

    private final List<MarkdownBlock> convertChildren(MarkdownHtmlNode.Element $this$convertChildren, MarkdownProcessor processor, Function2<? super MarkdownBlock, ? super IntRange, ? extends MarkdownBlock> transform) {
        List blocks;
        block4: {
            blocks = new ArrayList();
            List currentInlineHtmlElements = new ArrayList();
            Ref.IntRef currentLine = new Ref.IntRef();
            currentLine.element = $this$convertChildren.getLineRange().getFirst();
            for (MarkdownHtmlNode child : $this$convertChildren.getChildren()) {
                if (child instanceof MarkdownHtmlNode.Element && ((MarkdownHtmlNode.Element)child).isBlock()) {
                    MarkdownBlock it;
                    MarkdownBlock markdownBlock = this.flushHtmlElementsToMarkdownBlocks(currentInlineHtmlElements, processor, (Function1<? super MarkdownBlock, ? extends MarkdownBlock>)((Function1)arg_0 -> MarkdownHtmlConverter.convertChildren$lambda$0(transform, currentLine, child, arg_0)));
                    if (markdownBlock != null) {
                        it = markdownBlock;
                        boolean bl = false;
                        blocks.add(it);
                    }
                    if (this.convert(processor, child, transform) != null) {
                        boolean bl = false;
                        blocks.add(it);
                    }
                    currentLine.element = ((MarkdownHtmlNode.Element)child).getLineRange().getLast();
                    continue;
                }
                currentInlineHtmlElements.add(child);
            }
            MarkdownBlock markdownBlock = this.flushHtmlElementsToMarkdownBlocks(currentInlineHtmlElements, processor, (Function1<? super MarkdownBlock, ? extends MarkdownBlock>)((Function1)arg_0 -> MarkdownHtmlConverter.convertChildren$lambda$3(transform, currentLine, $this$convertChildren, arg_0)));
            if (markdownBlock == null) break block4;
            MarkdownBlock it = markdownBlock;
            boolean bl = false;
            blocks.add(it);
        }
        return blocks;
    }

    private final MarkdownBlock flushHtmlElementsToMarkdownBlocks(List<MarkdownHtmlNode> currentInlineHtmlElements, MarkdownProcessor processor, Function1<? super MarkdownBlock, ? extends MarkdownBlock> transform) {
        if (currentInlineHtmlElements.isEmpty()) {
            return null;
        }
        List<InlineMarkdown> inlines = this.htmlElementsToInlines(processor, currentInlineHtmlElements);
        currentInlineHtmlElements.clear();
        return (MarkdownBlock)transform.invoke((Object)new MarkdownBlock.Paragraph(this.convert(processor, inlines)));
    }

    @NotNull
    public final List<InlineMarkdown> convert(@NotNull MarkdownProcessor processor, @NotNull List<? extends InlineMarkdown> inlines) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter(inlines, (String)"inlines");
        return this.inlinesConverter.convert$intellij_platform_jewel_markdown_core(processor, inlines);
    }

    private final List<InlineMarkdown> htmlElementsToInlines(MarkdownProcessor processor, List<? extends MarkdownHtmlNode> htmlElements) {
        return this.processToInlines(((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)htmlElements, (CharSequence)"", null, null, (int)0, null, MarkdownHtmlConverter::htmlElementsToInlines$lambda$0, (int)30, null))).toString(), processor);
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlineMarkdown> processToInlines(String $this$processToInlines, MarkdownProcessor processor) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = processor.processRawMarkdown$intellij_platform_jewel_markdown_core($this$processToInlines);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MarkdownBlock markdownBlock = (MarkdownBlock)element$iv$iv;
            boolean bl = false;
            MarkdownBlock ogBlock = markdownBlock instanceof ScrollingSynchronizer.LocatableMarkdownBlock ? ((ScrollingSynchronizer.LocatableMarkdownBlock)markdownBlock).getOriginalBlock() : markdownBlock;
            WithInlineMarkdown withInlineMarkdown = ogBlock instanceof WithInlineMarkdown ? (WithInlineMarkdown)((Object)ogBlock) : null;
            List list = withInlineMarkdown != null ? withInlineMarkdown.getInlineContent() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final HtmlElementConverter provideConverter(MarkdownProcessor processor, String tag) {
        HtmlElementConverter htmlElementConverter = ConvertersKt.getConverters().get(tag);
        if (htmlElementConverter == null) {
            htmlElementConverter = processor.provideExtensionHtmlElementConverterFor$intellij_platform_jewel_markdown_core(tag);
        }
        return htmlElementConverter;
    }

    private static final List convert$lambda$0(MarkdownHtmlConverter this$0, MarkdownProcessor $processor, Function2 $transform, MarkdownHtmlNode.Element $this$convert) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"$this$convert");
        return this$0.convertChildren($this$convert, $processor, (Function2<? super MarkdownBlock, ? super IntRange, ? extends MarkdownBlock>)$transform);
    }

    private static final List convert$lambda$1(MarkdownHtmlConverter this$0, MarkdownProcessor $processor, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.convert($processor, this$0.htmlElementsToInlines($processor, it));
    }

    private static final MarkdownBlock convertChildren$lambda$0(Function2 $transform, Ref.IntRef $currentLine, MarkdownHtmlNode $child, MarkdownBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return (MarkdownBlock)$transform.invoke((Object)block, (Object)RangesKt.until((int)$currentLine.element, (int)((MarkdownHtmlNode.Element)$child).getLineRange().getFirst()));
    }

    private static final MarkdownBlock convertChildren$lambda$3(Function2 $transform, Ref.IntRef $currentLine, MarkdownHtmlNode.Element $this_convertChildren, MarkdownBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return (MarkdownBlock)$transform.invoke((Object)block, (Object)new IntRange($currentLine.element, $this_convertChildren.getLineRange().getLast()));
    }

    private static final CharSequence htmlElementsToInlines$lambda$0(MarkdownHtmlNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getHtmlContent();
    }
}

