/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.CyclicBufferLinesStorage;
import com.jediterm.terminal.model.LinesStorage;
import com.jediterm.terminal.model.LinesStorageKt;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.hyperlinks.TextProcessing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
public class LinesBuffer
implements LinesStorage {
    private static final Logger LOG = LoggerFactory.getLogger(LinesBuffer.class);
    public static final int DEFAULT_MAX_LINES_COUNT = 5000;
    private final LinesStorage myLines;
    @Nullable
    private final TextProcessing myTextProcessing;

    public LinesBuffer(@Nullable TextProcessing textProcessing) {
        this(-1, textProcessing);
    }

    public LinesBuffer(int bufferMaxLinesCount, @Nullable TextProcessing textProcessing) {
        this.myLines = new CyclicBufferLinesStorage(bufferMaxLinesCount);
        this.myTextProcessing = textProcessing;
    }

    public LinesBuffer(@NotNull LinesStorage delegate, @Nullable TextProcessing textProcessing) {
        this.myLines = delegate;
        this.myTextProcessing = textProcessing;
    }

    public String getLines() {
        return LinesStorageKt.getLinesAsString(this.myLines);
    }

    @NotNull
    public List<String> getLineTexts() {
        return this.getLineTexts(0, this.getLineCount());
    }

    @NotNull
    List<String> getLineTexts(int from, int to) {
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = from; i < Math.min(to, this.getLineCount()); ++i) {
            lines.add(this.myLines.get(i).getText());
        }
        return lines;
    }

    public void addNewLine(@NotNull TextStyle style, @NotNull CharBuffer characters) {
        this.addNewLine(new TerminalLine.TextEntry(style, characters));
    }

    private void addNewLine(@NotNull TerminalLine.TextEntry entry) {
        this.addLine(new TerminalLine(entry));
    }

    void addLine(@NotNull TerminalLine line) {
        this.myLines.addToBottom(line);
    }

    public int getLineCount() {
        return this.myLines.getSize();
    }

    public void removeTopLines(int count) {
        LinesStorageKt.removeFromTop(this.myLines, count);
    }

    public String getLineText(int row) {
        TerminalLine line = this.getLine(row);
        return line.getText();
    }

    public void insertLines(int y, int count, int lastLine, @NotNull TerminalLine.TextEntry filler) {
        LinesStorageKt.insertLines(this.myLines, y, count, lastLine, filler);
    }

    @NotNull
    public List<TerminalLine> deleteLines(int y, int count, int lastLine, @NotNull TerminalLine.TextEntry filler) {
        return LinesStorageKt.deleteLines(this.myLines, y, count, lastLine, filler);
    }

    public void writeString(int x, int y, CharBuffer str, @NotNull TextStyle style) {
        TerminalLine line = this.getLine(y);
        line.writeString(x, str, style);
        if (this.myTextProcessing != null) {
            this.myTextProcessing.processHyperlinks(this, line);
        }
    }

    public void clearLines(int startRow, int endRow, @NotNull TerminalLine.TextEntry filler) {
        for (int i = startRow; i <= endRow; ++i) {
            this.getLine(i).clear(filler);
        }
    }

    public void clearAll() {
        this.myLines.clear();
    }

    public void deleteCharacters(int x, int y, int count, @NotNull TextStyle style) {
        TerminalLine line = this.getLine(y);
        line.deleteCharacters(x, count, style);
    }

    public void insertBlankCharacters(int x, int y, int count, int maxLen, @NotNull TextStyle style) {
        TerminalLine line = this.getLine(y);
        line.insertBlankCharacters(x, count, maxLen, style);
    }

    public void clearArea(int leftX, int topY, int rightX, int bottomY, @NotNull TextStyle style) {
        for (int y = topY; y < bottomY; ++y) {
            TerminalLine line = this.getLine(y);
            line.clearArea(leftX, rightX, style);
        }
    }

    public void processLines(int yStart, int yCount, @NotNull StyledTextConsumer consumer) {
        LinesStorageKt.processLines(this.myLines, yStart, yCount, consumer, -this.getLineCount());
    }

    public void processLines(int firstLine, int count, @NotNull StyledTextConsumer consumer, int startRow) {
        LinesStorageKt.processLines(this.myLines, firstLine, count, consumer, startRow);
    }

    int moveTopLinesTo(int count, @NotNull LinesBuffer buffer) {
        if (count < 0) {
            throw new AssertionError((Object)("Moving negative line count: " + count));
        }
        List<TerminalLine> lines = LinesStorageKt.removeFromTop(this.myLines, count);
        buffer.addLines(lines);
        return lines.size();
    }

    public void addLines(@NotNull List<TerminalLine> lines) {
        LinesStorageKt.addAllToBottom(this.myLines, lines);
    }

    @NotNull
    public TerminalLine getLine(int row) {
        if (row < 0) {
            LOG.error("Negative line number: " + row);
            return TerminalLine.createEmpty();
        }
        for (int i = this.getLineCount(); i <= row; ++i) {
            this.addLine(TerminalLine.createEmpty());
        }
        return this.myLines.get(row);
    }

    public void moveBottomLinesTo(int count, @NotNull LinesBuffer buffer) {
        count = Math.min(count, this.getLineCount());
        List<TerminalLine> lines = LinesStorageKt.removeFromBottom(this.myLines, count);
        buffer.addLinesFirst(lines);
    }

    private void addLinesFirst(@NotNull List<TerminalLine> lines) {
        LinesStorageKt.addAllToTop(this.myLines, lines);
    }

    private void removeBottomLines(int count) {
        LinesStorageKt.removeFromBottom(this.myLines, count);
    }

    public int removeBottomEmptyLines(int maxCount) {
        return LinesStorageKt.removeBottomEmptyLines(this.myLines, maxCount);
    }

    int findLineIndex(@NotNull TerminalLine line) {
        return this.myLines.indexOf(line);
    }

    public void clearTypeAheadPredictions() {
        for (TerminalLine line : this.myLines) {
            line.myTypeAheadLine = null;
        }
    }

    @Override
    public int getSize() {
        return this.myLines.getSize();
    }

    @Override
    @NotNull
    public TerminalLine get(int index) {
        return this.myLines.get(index);
    }

    @Override
    public int indexOf(@NotNull TerminalLine line) {
        return this.myLines.indexOf(line);
    }

    @Override
    public void addToTop(@NotNull TerminalLine line) {
        this.myLines.addToTop(line);
    }

    @Override
    public void addToBottom(@NotNull TerminalLine line) {
        this.myLines.addToBottom(line);
    }

    @Override
    @NotNull
    public TerminalLine removeFromTop() {
        return this.myLines.removeFromTop();
    }

    @Override
    @NotNull
    public TerminalLine removeFromBottom() {
        return this.myLines.removeFromBottom();
    }

    @Override
    public void clear() {
        this.myLines.clear();
    }

    @Override
    @NotNull
    public Iterator<TerminalLine> iterator() {
        return this.myLines.iterator();
    }
}

