/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceViewDefaultDeleteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.platform.execution.serviceView.ServiceModel;
import com.intellij.platform.execution.serviceView.ServiceView;
import com.intellij.platform.execution.serviceView.ServiceViewActionProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class ServiceViewDeleteProvider
implements ServiceViewDefaultDeleteProvider {
    ServiceViewDeleteProvider() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(1);
        }
        if ((project = (Project)dataContext.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        List<ServiceModel.ServiceViewItem> selectedItems = ServiceViewActionProvider.getSelectedItems(dataContext);
        List<Pair<ServiceModel.ServiceViewItem, Runnable>> items = ContainerUtil.mapNotNull(selectedItems, item -> {
            Runnable remover = item.getViewDescriptor().getRemover();
            return remover == null ? null : Pair.create((Object)item, (Object)remover);
        });
        if ((items = ServiceViewDeleteProvider.filterChildren((List<? extends Pair<ServiceModel.ServiceViewItem, Runnable>>)items)).isEmpty()) {
            return;
        }
        if (Messages.showYesNoDialog((Project)project, (String)ExecutionBundle.message((String)"service.view.delete.confirmation", (Object[])new Object[]{ExecutionBundle.message((String)"service.view.items", (Object[])new Object[]{items.size()})}), (String)CommonBundle.message((String)"button.delete", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        for (Pair<ServiceModel.ServiceViewItem, Runnable> item2 : items) {
            ((Runnable)item2.second).run();
        }
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        List<ServiceModel.ServiceViewItem> selectedItems;
        if (dataContext == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(2);
        }
        if (!ContainerUtil.exists(selectedItems = ServiceViewActionProvider.getSelectedItems(dataContext), item -> item.getViewDescriptor().getRemover() != null)) {
            return false;
        }
        ServiceView selectedView = ServiceViewActionProvider.getSelectedView(dataContext);
        if (selectedView == null) {
            return false;
        }
        JComponent detailsComponent = selectedView.getUi().getDetailsComponent();
        return detailsComponent == null || !UIUtil.isAncestor((Component)detailsComponent, (Component)((Component)dataContext.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)));
    }

    @NotNull
    private static List<Pair<ServiceModel.ServiceViewItem, Runnable>> filterChildren(List<? extends Pair<ServiceModel.ServiceViewItem, Runnable>> items) {
        List list = ContainerUtil.filter(items, item -> {
            for (ServiceModel.ServiceViewItem parent = ((ServiceModel.ServiceViewItem)item.first).getParent(); parent != null; parent = parent.getParent()) {
                for (Pair pair : items) {
                    if (!((ServiceModel.ServiceViewItem)pair.first).equals(parent)) continue;
                    return false;
                }
            }
            return true;
        });
        if (list == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceViewDeleteProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceViewDeleteProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

