/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm.listeners;

import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchRequestContext;
import org.opensearch.action.search.SearchRequestOperationsListener;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.wlm.WorkloadGroupService;

public class WorkloadGroupRequestOperationListener
extends SearchRequestOperationsListener {
    private final WorkloadGroupService workloadGroupService;
    private final ThreadPool threadPool;

    public WorkloadGroupRequestOperationListener(WorkloadGroupService workloadGroupService, ThreadPool threadPool) {
        this.workloadGroupService = workloadGroupService;
        this.threadPool = threadPool;
    }

    @Override
    protected void onRequestStart(SearchRequestContext searchRequestContext) {
        String workloadGroupId = this.threadPool.getThreadContext().getHeader("workloadGroupId");
        this.workloadGroupService.rejectIfNeeded(workloadGroupId);
    }

    @Override
    protected void onRequestFailure(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
        String workloadGroupId = this.threadPool.getThreadContext().getHeader("workloadGroupId");
        this.workloadGroupService.incrementFailuresFor(workloadGroupId);
    }
}

