/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.matrix.stats;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.ScoreMode;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.ObjectArray;
import org.opensearch.index.fielddata.NumericDoubleValues;
import org.opensearch.search.MultiValueMode;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.matrix.stats.InternalMatrixStats;
import org.opensearch.search.aggregations.matrix.stats.RunningStats;
import org.opensearch.search.aggregations.metrics.MetricsAggregator;
import org.opensearch.search.aggregations.support.ArrayValuesSource;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.internal.SearchContext;

final class MatrixStatsAggregator
extends MetricsAggregator {
    private final ArrayValuesSource.NumericArrayValuesSource valuesSources;
    ObjectArray<RunningStats> stats;

    MatrixStatsAggregator(String name, TreeMap<String, ValuesSource.Numeric> valuesSources, SearchContext context, Aggregator parent, MultiValueMode multiValueMode, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        if (valuesSources != null && !valuesSources.isEmpty()) {
            this.valuesSources = new ArrayValuesSource.NumericArrayValuesSource(valuesSources, multiValueMode);
            this.stats = context.bigArrays().newObjectArray(1L);
        } else {
            this.valuesSources = null;
        }
    }

    public ScoreMode scoreMode() {
        return this.valuesSources != null && this.valuesSources.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSources == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final NumericDoubleValues[] values = new NumericDoubleValues[this.valuesSources.fieldNames().length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.valuesSources.getField(i, ctx);
        }
        return new LeafBucketCollectorBase(sub, values){
            final String[] fieldNames;
            final double[] fieldVals;
            {
                super(arg0, arg1);
                this.fieldNames = MatrixStatsAggregator.this.valuesSources.fieldNames();
                this.fieldVals = new double[this.fieldNames.length];
            }

            public void collect(int doc, long bucket) throws IOException {
                if (this.includeDocument(doc)) {
                    MatrixStatsAggregator.this.stats = bigArrays.grow(MatrixStatsAggregator.this.stats, bucket + 1L);
                    RunningStats stat = (RunningStats)MatrixStatsAggregator.this.stats.get(bucket);
                    if (stat == null) {
                        stat = new RunningStats(this.fieldNames, this.fieldVals);
                        MatrixStatsAggregator.this.stats.set(bucket, (Object)stat);
                    } else {
                        stat.add(this.fieldNames, this.fieldVals);
                    }
                }
            }

            public void collect(DocIdStream stream, long owningBucketOrd) throws IOException {
                super.collect(stream, owningBucketOrd);
            }

            public void collectRange(int min, int max) throws IOException {
                super.collectRange(min, max);
            }

            private boolean includeDocument(int doc) throws IOException {
                for (int i = 0; i < this.fieldVals.length; ++i) {
                    double value;
                    NumericDoubleValues doubleValues = values[i];
                    if (doubleValues.advanceExact(doc)) {
                        value = doubleValues.doubleValue();
                        if (value == Double.NEGATIVE_INFINITY) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    this.fieldVals[i] = value;
                }
                return true;
            }
        };
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSources == null || bucket >= this.stats.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalMatrixStats(this.name, this.stats.size(), (RunningStats)this.stats.get(bucket), null, this.metadata(), this.valuesSources.fieldNames());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalMatrixStats(this.name, 0L, null, null, this.metadata(), null);
    }

    public void doClose() {
        Releasables.close(this.stats);
    }
}

