/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;

final class DisiPriorityQueue2
extends DisiPriorityQueue {
    private DisiWrapper top;
    private DisiWrapper top2;

    DisiPriorityQueue2() {
    }

    @Override
    public Iterator<DisiWrapper> iterator() {
        if (this.top2 != null) {
            return Arrays.asList(this.top, this.top2).iterator();
        }
        if (this.top != null) {
            return Collections.singleton(this.top).iterator();
        }
        return Collections.emptyIterator();
    }

    @Override
    public int size() {
        return this.top2 == null ? (this.top == null ? 0 : 1) : 2;
    }

    @Override
    public DisiWrapper top() {
        return this.top;
    }

    @Override
    public DisiWrapper top2() {
        return this.top2;
    }

    @Override
    public DisiWrapper topList() {
        DisiWrapper topList = null;
        if (this.top != null) {
            this.top.next = null;
            topList = this.top;
            if (this.top2 != null && this.top.doc == this.top2.doc) {
                this.top2.next = topList;
                topList = this.top2;
            }
        }
        return topList;
    }

    @Override
    public DisiWrapper add(DisiWrapper entry) {
        if (this.top == null) {
            this.top = entry;
            return this.top;
        }
        if (this.top2 == null) {
            this.top2 = entry;
            return this.updateTop();
        }
        throw new IllegalStateException("Trying to add a 3rd element to a DisiPriorityQueue configured with a max size of 2");
    }

    @Override
    public DisiWrapper pop() {
        DisiWrapper ret = this.top;
        this.top = this.top2;
        this.top2 = null;
        return ret;
    }

    @Override
    public DisiWrapper updateTop() {
        if (this.top2 != null && this.top2.doc < this.top.doc) {
            DisiWrapper tmp = this.top;
            this.top = this.top2;
            this.top2 = tmp;
        }
        return this.top;
    }

    @Override
    DisiWrapper updateTop(DisiWrapper topReplacement) {
        this.top = topReplacement;
        return this.updateTop();
    }

    @Override
    public void clear() {
        this.top = null;
        this.top2 = null;
    }
}

