/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.udf.udaf;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.sql.calcite.udf.UserDefinedAggFunction;

public class ListAggFunction
implements UserDefinedAggFunction<ListAccumulator> {
    private static final int DEFAULT_LIMIT = 100;

    @Override
    public ListAccumulator init() {
        return new ListAccumulator();
    }

    @Override
    public Object result(ListAccumulator accumulator) {
        return accumulator.value(new Object[0]);
    }

    @Override
    public ListAccumulator add(ListAccumulator acc, Object ... values) {
        if (values == null || values.length == 0) {
            return acc;
        }
        Object value = values[0];
        if (value != null && acc.size() < 100) {
            String stringValue = String.valueOf(value);
            acc.add(stringValue);
        }
        return acc;
    }

    public static class ListAccumulator
    implements UserDefinedAggFunction.Accumulator {
        private final List<String> values = new ArrayList<String>();

        @Override
        public Object value(Object ... argList) {
            return this.values;
        }

        public void add(String value) {
            this.values.add(value);
        }

        public int size() {
            return this.values.size();
        }
    }
}

