/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning;

import java.util.List;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.tree.Bin;
import org.opensearch.sql.calcite.CalcitePlanContext;

public class BinFieldValidator {
    public static String extractFieldName(Bin node) {
        if (node.getField() instanceof Field) {
            Field field = (Field)node.getField();
            return field.getField().toString();
        }
        return node.getField().toString();
    }

    public static void validateFieldExists(String fieldName, CalcitePlanContext context) {
        List availableFields = context.relBuilder.peek().getRowType().getFieldNames();
        if (!availableFields.contains(fieldName)) {
            throw new IllegalArgumentException(String.format("Field '%s' not found in dataset. Available fields: %s", fieldName, availableFields));
        }
    }
}

