/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.parse;

import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.parse.ParseExpression;
import org.opensearch.sql.expression.parse.RegexCommonUtils;

public class RegexExpression
extends ParseExpression {
    private static final Logger log = LogManager.getLogger(RegexExpression.class);
    private final Pattern regexPattern;

    public RegexExpression(Expression sourceField, Expression pattern, Expression identifier) {
        super("regex", sourceField, pattern, identifier);
        this.regexPattern = RegexCommonUtils.getCompiledPattern(pattern.valueOf().stringValue());
    }

    @Override
    public ExprValue parseValue(ExprValue value) throws ExpressionEvaluationException {
        String rawString = value.stringValue();
        String extracted = RegexCommonUtils.extractNamedGroup(rawString, this.regexPattern, this.identifierStr);
        if (extracted != null) {
            return new ExprStringValue(extracted);
        }
        log.debug("failed to extract pattern {} from input ***", (Object)this.regexPattern.pattern());
        return new ExprStringValue("");
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegexExpression)) {
            return false;
        }
        RegexExpression other = (RegexExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegexExpression;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "RegexExpression(regexPattern=" + String.valueOf(this.getRegexPattern()) + ")";
    }

    @Generated
    public Pattern getRegexPattern() {
        return this.regexPattern;
    }
}

