/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.physical.node.join;

import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.sql.legacy.query.planner.core.ExecuteParams;
import org.opensearch.sql.legacy.query.planner.logical.node.Join;
import org.opensearch.sql.legacy.query.planner.physical.PhysicalOperator;
import org.opensearch.sql.legacy.query.planner.physical.Row;
import org.opensearch.sql.legacy.query.planner.physical.estimation.Cost;
import org.opensearch.sql.legacy.query.planner.physical.node.join.CombinedRow;
import org.opensearch.sql.legacy.query.planner.physical.node.join.JoinAlgorithm;
import org.opensearch.sql.legacy.query.planner.resource.blocksize.BlockSize;

public class BlockHashJoin<T>
extends JoinAlgorithm<T> {
    private final boolean isUseTermsFilterOptimization;

    public BlockHashJoin(PhysicalOperator<T> left, PhysicalOperator<T> right, SQLJoinTableSource.JoinType type, Join.JoinCondition condition, BlockSize blockSize, boolean isUseTermsFilterOptimization) {
        super(left, right, type, condition, blockSize);
        this.isUseTermsFilterOptimization = isUseTermsFilterOptimization;
    }

    @Override
    public Cost estimate() {
        return new Cost();
    }

    @Override
    protected void reopenRight() throws Exception {
        Objects.requireNonNull(this.params, "Execute params is not set so unable to add extra filter");
        if (this.isUseTermsFilterOptimization) {
            this.params.add(ExecuteParams.ExecuteParamType.EXTRA_QUERY_FILTER, this.queryForPushedDownOnConds());
        }
        this.right.open(this.params);
    }

    @Override
    protected List<CombinedRow<T>> probe() {
        ArrayList<CombinedRow<T>> combinedRows = new ArrayList<CombinedRow<T>>();
        int totalSize = 0;
        while (this.right.hasNext() && totalSize < this.hashTable.size()) {
            Row rightRow = (Row)this.right.next();
            Collection matchedLeftRows = this.hashTable.match(rightRow);
            if (matchedLeftRows.isEmpty()) continue;
            combinedRows.add(new CombinedRow(rightRow, matchedLeftRows));
            totalSize += matchedLeftRows.size();
        }
        return combinedRows;
    }

    private BoolQueryBuilder queryForPushedDownOnConds() {
        Map<String, Collection<Object>>[] rightNameToLeftValuesGroup;
        BoolQueryBuilder orQuery = QueryBuilders.boolQuery();
        for (Map<String, Collection<Object>> rightNameToLeftValues : rightNameToLeftValuesGroup = this.hashTable.rightFieldWithLeftValues()) {
            if (LOG.isTraceEnabled()) {
                rightNameToLeftValues.forEach((rightName, leftValues) -> LOG.trace("Right name to left values mapping: {} => {}", rightName, leftValues));
            }
            BoolQueryBuilder andQuery = QueryBuilders.boolQuery();
            rightNameToLeftValues.forEach((rightName, leftValues) -> andQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)rightName, (Collection)leftValues)));
            if (LOG.isTraceEnabled()) {
                LOG.trace("Terms filter optimization: {}", (Object)Strings.toString((MediaType)XContentType.JSON, (ToXContent)andQuery));
            }
            orQuery.should((QueryBuilder)andQuery);
        }
        return orQuery;
    }

    public boolean isUseTermsFilterOptimization() {
        return this.isUseTermsFilterOptimization;
    }
}

