"use strict";(self["tileMap_bundle_jsonpfunction"]=self["tileMap_bundle_jsonpfunction"]||[]).push([["0"],{281:function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{GeohashLayer:()=>geohash_layer_GeohashLayer});var _async_to_generator=__webpack_require__(194);var _call_super=__webpack_require__(56);var _class_call_check=__webpack_require__(394);var _create_class=__webpack_require__(379);var _inherits=__webpack_require__(22);var _to_consumable_array=__webpack_require__(754);var external_osdSharedDeps_TsLib_=__webpack_require__(790);var external_osdSharedDeps_Lodash_=__webpack_require__(731);var external_osdSharedDeps_Lodash_default=__webpack_require__.n(external_osdSharedDeps_Lodash_);var external_osdSharedDeps_OsdI18n_=__webpack_require__(528);var maps_legacy_public=__webpack_require__(981);var d3=__webpack_require__(477);var d3_default=__webpack_require__.n(d3);var events=__webpack_require__(621);var heatmap_HeatmapMarkers=function(EventEmitter){"use strict";(0,_inherits._)(HeatmapMarkers,EventEmitter);function HeatmapMarkers(featureCollection,options,zoom,max,leaflet){(0,_class_call_check._)(this,HeatmapMarkers);var _this;_this=(0,_call_super._)(this,HeatmapMarkers);_this._geojsonFeatureCollection=featureCollection;var points=dataToHeatArray(featureCollection,max);_this._leafletLayer=new leaflet.HeatLayer(points,options);_this._tooltipFormatter=options.tooltipFormatter;_this._zoom=zoom;_this._disableTooltips=false;_this._getLatLng=external_osdSharedDeps_Lodash_default().memoize(function(feature){return leaflet.latLng(feature.geometry.coordinates[1],feature.geometry.coordinates[0])},function(feature){return[feature.geometry.coordinates[1],feature.geometry.coordinates[0]].join(",")});_this._addTooltips();return _this}(0,_create_class._)(HeatmapMarkers,[{key:"getBounds",value:function getBounds(){return this._leafletLayer.getBounds()}},{key:"getLeafletLayer",value:function getLeafletLayer(){return this._leafletLayer}},{key:"appendLegendContents",value:function appendLegendContents(){}},{key:"movePointer",value:function movePointer(type,event){if(type==="mousemove"){this._debounceMoveMoveLocation(event)}else if(type==="mouseout"){this.emit("hideTooltip")}else if(type==="mousedown"){this._disableTooltips=true;this.emit("hideTooltip")}else if(type==="mouseup"){this._disableTooltips=false}}},{key:"_addTooltips",value:function _addTooltips(){var _this=this;var mouseMoveLocation=function(e){if(!_this._geojsonFeatureCollection.features.length||_this._disableTooltips){_this.emit("hideTooltip");return}var feature=_this._nearestFeature(e.latlng);if(_this._tooltipProximity(e.latlng,feature)){var content=_this._tooltipFormatter(feature);if(!content){return}_this.emit("showTooltip",{content:content,position:e.latlng})}else{_this.emit("hideTooltip")}};this._debounceMoveMoveLocation=external_osdSharedDeps_Lodash_default().debounce(mouseMoveLocation.bind(this),15,{leading:true,trailing:false})}},{key:"_nearestFeature",value:function _nearestFeature(latLng){var self1=this;var nearest;if(latLng.lng<-180||latLng.lng>180){return}external_osdSharedDeps_Lodash_default().reduce(this._geojsonFeatureCollection.features,function(distance,feature){var featureLatLng=self1._getLatLng(feature);var dist=latLng.distanceTo(featureLatLng);if(dist<distance){nearest=feature;return dist}return distance},Infinity);return nearest}},{key:"_tooltipProximity",value:function _tooltipProximity(latlng,feature){if(!feature)return;var showTip=false;var featureLatLng=this._getLatLng(feature);var zoomScale=d3_default().scale.linear().domain([1,4,7,10,13,16,18]).range([1e6,3e5,1e5,15e3,2e3,150,50]);var proximity=zoomScale(this._zoom);var distance=latlng.distanceTo(featureLatLng);var maxLngDif=40;var lngDif=Math.abs(latlng.lng-featureLatLng.lng);if(distance<proximity&&lngDif<maxLngDif){showTip=true}d3_default().scale.pow().exponent(.2).domain([1,18]).range([15e5,50]);return showTip}}]);return HeatmapMarkers}(events.EventEmitter);function dataToHeatArray(featureCollection,max){return featureCollection.features.map(function(feature){var lat=feature.geometry.coordinates[1];var lng=feature.geometry.coordinates[0];var heatIntensity=feature.properties.value/max;return[lat,lng,heatIntensity]})}var external_osdSharedDeps_Jquery_=__webpack_require__(760);var external_osdSharedDeps_Jquery_default=__webpack_require__.n(external_osdSharedDeps_Jquery_);var charts_public=__webpack_require__(479);var scaled_circles_ScaledCirclesMarkers=function(EventEmitter){"use strict";(0,_inherits._)(ScaledCirclesMarkers,EventEmitter);function ScaledCirclesMarkers(featureCollection,featureCollectionMetaData,options,targetZoom,opensearchDasbhoardsMap,leaflet){(0,_class_call_check._)(this,ScaledCirclesMarkers);var _this;_this=(0,_call_super._)(this,ScaledCirclesMarkers);_this._featureCollection=featureCollection;_this._featureCollectionMetaData=featureCollectionMetaData;_this._zoom=targetZoom;_this._valueFormatter=options.valueFormatter||function(x){x};_this._tooltipFormatter=options.tooltipFormatter||function(x){x};_this._label=options.label;_this._colorRamp=options.colorRamp;_this._legendColors=null;_this._legendQuantizer=null;_this._leaflet=leaflet;_this._popups=[];var layerOptions={pointToLayer:_this.getMarkerFunction(),style:_this.getStyleFunction(),onEachFeature:function(feature,layer){_this._bindPopup(feature,layer)}};if(!options.isFilteredByCollar){layerOptions.filter=function(feature){var bucketRectBounds=feature.properties.geohash_meta.rectangle;return opensearchDasbhoardsMap.isInside(bucketRectBounds)}}_this._leafletLayer=_this._leaflet.geoJson(null,layerOptions);_this._leafletLayer.addData(_this._featureCollection);return _this}(0,_create_class._)(ScaledCirclesMarkers,[{key:"getLeafletLayer",value:function getLeafletLayer(){return this._leafletLayer}},{key:"getStyleFunction",value:function getStyleFunction(){var min=external_osdSharedDeps_Lodash_default().get(this._featureCollectionMetaData,"min",0);var max=external_osdSharedDeps_Lodash_default().get(this._featureCollectionMetaData,"max",1);var quantizeDomain=min!==max?[min,max]:d3_default().scale.quantize().domain();this._legendColors=this.getLegendColors();this._legendQuantizer=d3_default().scale.quantize().domain(quantizeDomain).range(this._legendColors);return makeStyleFunction(this._legendColors,quantizeDomain)}},{key:"movePointer",value:function movePointer(){}},{key:"getLabel",value:function getLabel(){if(this._popups.length){return this._label}return""}},{key:"appendLegendContents",value:function appendLegendContents(jqueryDiv){var _this=this;if(!this._legendColors||!this._legendQuantizer){return}var titleText=this.getLabel();var $title=external_osdSharedDeps_Jquery_default()("<div>").addClass("visMapLegend__title").text(titleText);jqueryDiv.append($title);this._legendColors.forEach(function(color){var labelText=_this._legendQuantizer.invertExtent(color).map(_this._valueFormatter).join(" –\xa0");var label=external_osdSharedDeps_Jquery_default()("<div>");var icon=external_osdSharedDeps_Jquery_default()("<i>").css({background:color,"border-color":makeColorDarker(color)});var text=external_osdSharedDeps_Jquery_default()("<span>").text(labelText);label.append(icon);label.append(text);jqueryDiv.append(label)})}},{key:"_bindPopup",value:function _bindPopup(feature,layer){var _this=this;var popup=layer.on({mouseover:function(e){var _$layer=e.target;if(!_this._leaflet.Browser.ie&&!_this._leaflet.Browser.opera){_$layer.bringToFront()}_this._showTooltip(feature)},mouseout:function(){_this.emit("hideTooltip")}});this._popups.push(popup)}},{key:"_showTooltip",value:function _showTooltip(feature){var content=this._tooltipFormatter(feature);if(!content){return}var latLng=this._leaflet.latLng(feature.geometry.coordinates[1],feature.geometry.coordinates[0]);this.emit("showTooltip",{content:content,position:latLng})}},{key:"getMarkerFunction",value:function getMarkerFunction(){var _this=this;var scaleFactor=.6;return function(feature,latlng){var value=feature.properties.value;var scaledRadius=_this._radiusScale(value)*scaleFactor;return _this._leaflet.circleMarker(latlng).setRadius(scaledRadius)}}},{key:"_radiusScale",value:function _radiusScale(value){var precisionBiasBase=5;var precisionBiasNumerator=200;var precision=external_osdSharedDeps_Lodash_default().max(this._featureCollection.features.map(function(feature){return String(feature.properties.geohash).length}));var pct=Math.abs(value)/Math.abs(this._featureCollectionMetaData.max);var zoomRadius=.5*Math.pow(2,this._zoom);var precisionScale=precisionBiasNumerator/Math.pow(precisionBiasBase,precision);return Math.pow(pct,.5)*zoomRadius*precisionScale}},{key:"getBounds",value:function getBounds(){return this._leafletLayer.getBounds()}},{key:"getLegendColors",value:function getLegendColors(){var colorRamp=external_osdSharedDeps_Lodash_default().get(charts_public.truncatedColorMaps[this._colorRamp],"value");return maps_legacy_public.colorUtil.getLegendColors(colorRamp)}}]);return ScaledCirclesMarkers}(events.EventEmitter);function makeColorDarker(color){var amount=1.3;return d3_default().hcl(color).darker(amount).toString()}function makeStyleFunction(legendColors,quantizeDomain){var legendQuantizer=d3_default().scale.quantize().domain(quantizeDomain).range(legendColors);return function(feature){var value=external_osdSharedDeps_Lodash_default().get(feature,"properties.value");var color=legendQuantizer(value);return{fillColor:color,color:makeColorDarker(color),weight:1.5,opacity:1,fillOpacity:.75}}};var shaded_circles_ShadedCirclesMarkers=function(ScaledCirclesMarkers){"use strict";(0,_inherits._)(ShadedCirclesMarkers,ScaledCirclesMarkers);function ShadedCirclesMarkers(){(0,_class_call_check._)(this,ShadedCirclesMarkers);return(0,_call_super._)(this,ShadedCirclesMarkers,arguments)}(0,_create_class._)(ShadedCirclesMarkers,[{key:"getMarkerFunction",value:function getMarkerFunction(){var _this=this;var scaleFactor=.8;return function(feature,latlng){var radius=_this._geohashMinDistance(feature)*scaleFactor;return _this._leaflet.circle(latlng,radius)}}},{key:"_geohashMinDistance",value:function _geohashMinDistance(feature){var centerPoint=feature.properties.geohash_meta.center;var geohashRect=feature.properties.geohash_meta.rectangle;var east=this._leaflet.latLng([centerPoint[0],geohashRect[2][1]]);var north=this._leaflet.latLng([geohashRect[3][0],centerPoint[1]]);var center=this._leaflet.latLng([centerPoint[0],centerPoint[1]]);var eastRadius=Math.floor(center.distanceTo(east));var northRadius=Math.floor(center.distanceTo(north));return external_osdSharedDeps_Lodash_default().min([eastRadius,northRadius])}}]);return ShadedCirclesMarkers}(scaled_circles_ScaledCirclesMarkers);var geohash_grid_GeohashGridMarkers=function(ScaledCirclesMarkers){"use strict";(0,_inherits._)(GeohashGridMarkers,ScaledCirclesMarkers);function GeohashGridMarkers(){(0,_class_call_check._)(this,GeohashGridMarkers);return(0,_call_super._)(this,GeohashGridMarkers,arguments)}(0,_create_class._)(GeohashGridMarkers,[{key:"getMarkerFunction",value:function getMarkerFunction(){var _this=this;return function(feature){var geohashRect=feature.properties.geohash_meta.rectangle;var corners=[[geohashRect[3][0],geohashRect[3][1]],[geohashRect[1][0],geohashRect[1][1]]];return _this._leaflet.rectangle(corners)}}}]);return GeohashGridMarkers}(scaled_circles_ScaledCirclesMarkers);var geohash_layer_GeohashLayer=function(OpenSearchDashboardsMapLayer){"use strict";(0,_inherits._)(GeohashLayer,OpenSearchDashboardsMapLayer);function GeohashLayer(featureCollection,featureCollectionMetaData,options,zoom,opensearchDashboardsMap,leaflet){(0,_class_call_check._)(this,GeohashLayer);var _this;_this=(0,_call_super._)(this,GeohashLayer);_this._featureCollection=featureCollection;_this._featureCollectionMetaData=featureCollectionMetaData;_this._geohashOptions=options;_this._zoom=zoom;_this._opensearchDashboardsMap=opensearchDashboardsMap;_this._leaflet=leaflet;var geojson=_this._leaflet.geoJson(_this._featureCollection);_this._bounds=geojson.getBounds();_this._createGeohashMarkers();_this._lastBounds=null;return _this}(0,_create_class._)(GeohashLayer,[{key:"_createGeohashMarkers",value:function _createGeohashMarkers(){var _this=this;var markerOptions={isFilteredByCollar:this._geohashOptions.isFilteredByCollar,valueFormatter:this._geohashOptions.valueFormatter,tooltipFormatter:this._geohashOptions.tooltipFormatter,label:this._geohashOptions.label,colorRamp:this._geohashOptions.colorRamp};switch(this._geohashOptions.mapType){case maps_legacy_public.MapTypes.ScaledCircleMarkers:this._geohashMarkers=new scaled_circles_ScaledCirclesMarkers(this._featureCollection,this._featureCollectionMetaData,markerOptions,this._zoom,this._opensearchDashboardsMap,this._leaflet);break;case maps_legacy_public.MapTypes.ShadedCircleMarkers:this._geohashMarkers=new shaded_circles_ShadedCirclesMarkers(this._featureCollection,this._featureCollectionMetaData,markerOptions,this._zoom,this._opensearchDashboardsMap,this._leaflet);break;case maps_legacy_public.MapTypes.ShadedGeohashGrid:this._geohashMarkers=new geohash_grid_GeohashGridMarkers(this._featureCollection,this._featureCollectionMetaData,markerOptions,this._zoom,this._opensearchDashboardsMap,this._leaflet);break;case maps_legacy_public.MapTypes.Heatmap:var radius=15;if(this._featureCollectionMetaData.geohashGridDimensionsAtEquator){var minGridLength=(0,external_osdSharedDeps_Lodash_.min)(this._featureCollectionMetaData.geohashGridDimensionsAtEquator);var metersPerPixel=this._opensearchDashboardsMap.getMetersPerPixel();radius=minGridLength/metersPerPixel/2}radius=radius*parseFloat(this._geohashOptions.heatmap.heatClusterSize);this._geohashMarkers=new heatmap_HeatmapMarkers(this._featureCollection,{radius:radius,blur:radius,maxZoom:this._opensearchDashboardsMap.getZoomLevel(),minOpacity:.1,tooltipFormatter:this._geohashOptions.tooltipFormatter},this._zoom,this._featureCollectionMetaData.max,this._leaflet);break;default:throw new Error(external_osdSharedDeps_OsdI18n_.i18n.translate("tileMap.geohashLayer.mapTitle",{defaultMessage:"{mapType} mapType not recognized",values:{mapType:this._geohashOptions.mapType}}))}this._geohashMarkers.on("showTooltip",function(event){return _this.emit("showTooltip",event)});this._geohashMarkers.on("hideTooltip",function(event){return _this.emit("hideTooltip",event)});this._leafletLayer=this._geohashMarkers.getLeafletLayer()}},{key:"appendLegendContents",value:function appendLegendContents(jqueryDiv){return this._geohashMarkers.appendLegendContents(jqueryDiv)}},{key:"movePointer",value:function movePointer(){for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}var _this__geohashMarkers;(_this__geohashMarkers=this._geohashMarkers).movePointer.apply(_this__geohashMarkers,(0,_to_consumable_array._)(args))}},{key:"getBounds",value:function getBounds(){return(0,_async_to_generator._)(function(){var geoHashBounds,northEast,southWest;return(0,external_osdSharedDeps_TsLib_.__generator)(this,function(_state){switch(_state.label){case 0:if(!this._geohashOptions.fetchBounds)return[3,2];return[4,this._geohashOptions.fetchBounds()];case 1:geoHashBounds=_state.sent();if(geoHashBounds){northEast=this._leaflet.latLng(geoHashBounds.top_left.lat,geoHashBounds.bottom_right.lon);southWest=this._leaflet.latLng(geoHashBounds.bottom_right.lat,geoHashBounds.top_left.lon);return[2,this._leaflet.latLngBounds(southWest,northEast)]}_state.label=2;case 2:return[2,this._bounds]}})}).call(this)}},{key:"updateExtent",value:function updateExtent(){if(!this._geohashOptions.isFilteredByCollar){var bounds=this._opensearchDashboardsMap.getLeafletBounds();if(!this._lastBounds||!this._lastBounds.equals(bounds)){this._opensearchDashboardsMap.removeLayer(this);this._createGeohashMarkers();this._opensearchDashboardsMap.addLayer(this)}this._lastBounds=bounds}}},{key:"isReusable",value:function isReusable(options){if((0,external_osdSharedDeps_Lodash_.isEqual)(this._geohashOptions,options)){return true}if(this._geohashOptions.colorRamp!==options.colorRamp){return false}else if(this._geohashOptions.mapType!==options.mapType){return false}else if(this._geohashOptions.mapType==="Heatmap"&&!(0,external_osdSharedDeps_Lodash_.isEqual)(this._geohashOptions.heatmap,options)){return false}else{return true}}}]);return GeohashLayer}(maps_legacy_public.OpenSearchDashboardsMapLayer)}}]);