/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.searchonly;

import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.indexmanagement.indexstatemanagement.step.searchonly.AttemptSearchOnlyStep;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.snapshots.SnapshotInProgressException;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u0001H\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\n\u0010\u0012\u001a\u00060\u0015j\u0002`\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u0012\u001a\u00060\u0015j\u0002`\u0016H\u0002J\u001c\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\n\u0010\u0012\u001a\u00060\u0015j\u0002`\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0018H\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/searchonly/AttemptSearchOnlyStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "info", "", "", "", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleSnapshotException", "", "indexName", "e", "Lorg/opensearch/snapshots/SnapshotInProgressException;", "handleRetryableException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isRetryableException", "", "handleException", "getUpdatedManagedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "currentMetadata", "isIdempotent", "Companion", "opensearch-index-management"})
public final class AttemptSearchOnlyStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    @Nullable
    private Map<String, ? extends Object> info;
    @NotNull
    public static final String name = "attempt_search_only";
    @NotNull
    private static final String INDEX_BLOCKS_SEARCH_ONLY_SETTING = "index.blocks.search_only";

    public AttemptSearchOnlyStep() {
        super(name, false, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Step> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var10_2 = $completion;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptSearchOnlyStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((Continuation<? super Step>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                context = this.getContext();
                if (context == null) ** GOTO lbl72
                indexName = context.getMetadata().getIndex();
                clusterState = context.getClusterService().state();
                indexMetadata = clusterState.getMetadata().index(indexName);
                if (indexMetadata != null && (isSearchOnly = indexMetadata.getSettings().getAsBoolean("index.blocks.search_only", Boxing.boxBoolean((boolean)false))).booleanValue()) {
                    this.stepStatus = Step.StepStatus.COMPLETED;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptSearchOnlyStep.Companion.getAlreadySearchOnlyMessage(indexName)));
                    return this;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                $continuation.L$1 = indexName;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)clusterState);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)indexMetadata);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient().admin().indices(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, execute$lambda$0(java.lang.String org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((String)indexName), $continuation);
                ** if (v0 != var11_4) goto lbl31
lbl30:
                // 1 sources

                return var11_4;
lbl31:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                indexMetadata = (IndexMetadata)$continuation.L$3;
                clusterState = (ClusterState)$continuation.L$2;
                indexName = (String)$continuation.L$1;
                context = (StepContext)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl41:
                    // 2 sources

                    if ((response = (AcknowledgedResponse)v0).isAcknowledged()) {
                        this.stepStatus = Step.StepStatus.COMPLETED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptSearchOnlyStep.Companion.getSuccessMessage(indexName)));
                    } else {
                        message = AttemptSearchOnlyStep.Companion.getFailedMessage(indexName);
                        this.logger.warn(message);
                        this.stepStatus = Step.StepStatus.FAILED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
                    }
                }
                catch (RemoteTransportException e) {
                    var8_19 = cause = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (var8_19 instanceof SnapshotInProgressException) {
                        this.handleSnapshotException(indexName, (SnapshotInProgressException)cause);
                    } else if (var8_19 instanceof OpenSearchRejectedExecutionException) {
                        this.handleRetryableException(indexName, (Exception)cause);
                    } else {
                        Intrinsics.checkNotNull((Object)cause, (String)"null cannot be cast to non-null type java.lang.Exception");
                        this.handleException(indexName, (Exception)cause);
                    }
                }
                catch (SnapshotInProgressException e) {
                    this.handleSnapshotException(indexName, e);
                }
                catch (OpenSearchRejectedExecutionException e) {
                    this.handleRetryableException(indexName, (Exception)e);
                }
                catch (Exception e) {
                    if (!this.isRetryableException(e)) ** GOTO lbl71
                    this.handleRetryableException(indexName, e);
                    ** GOTO lbl72
lbl71:
                    // 1 sources

                    this.handleException(indexName, e);
                }
lbl72:
                // 10 sources

                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void handleSnapshotException(String indexName, SnapshotInProgressException e) {
        String message = Companion.getSnapshotMessage(indexName);
        this.logger.warn(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
    }

    private final void handleRetryableException(String indexName, Exception e) {
        String message = Companion.getRetryableMessage(indexName);
        this.logger.warn(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"message", (Object)message);
        String string = e.getMessage();
        if (string == null) {
            string = "Unknown";
        }
        pairArray[1] = TuplesKt.to((Object)"cause", (Object)string);
        this.info = MapsKt.mapOf((Pair[])pairArray);
    }

    private final boolean isRetryableException(Exception e) {
        String string;
        block3: {
            block2: {
                string = e.getMessage();
                if (string == null) break block2;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                string = string2;
                if (string2 != null) break block3;
            }
            return false;
        }
        String message = string;
        return StringsKt.contains$default((CharSequence)message, (CharSequence)"timeout", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"timed out", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"backpressure", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"rejected", (boolean)false, (int)2, null);
    }

    private final void handleException(String indexName, Exception e) {
        String message = Companion.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)message)};
        Map mutableInfo = MapsKt.mutableMapOf((Pair[])pairArray);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = MapsKt.toMap((Map)mutableInfo);
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, null, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, null, (int)251647, null);
    }

    public boolean isIdempotent() {
        return true;
    }

    private static final Unit execute$lambda$0(String $indexName, IndicesAdminClient $this$suspendUntil, ActionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        $this$suspendUntil.prepareScaleSearchOnly($indexName, true).execute(listener);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/searchonly/AttemptSearchOnlyStep$Companion;", "", "<init>", "()V", "name", "", "INDEX_BLOCKS_SEARCH_ONLY_SETTING", "getFailedMessage", "index", "getSuccessMessage", "getAlreadySearchOnlyMessage", "getSnapshotMessage", "getRetryableMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to set index to search-only mode [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully set index to search-only mode [index=" + index2 + "]";
        }

        @NotNull
        public final String getAlreadySearchOnlyMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Index is already in search-only mode [index=" + index2 + "]";
        }

        @NotNull
        public final String getSnapshotMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Index had snapshot in progress, retrying search_only action [index=" + index2 + "]";
        }

        @NotNull
        public final String getRetryableMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Temporary condition prevented search_only operation, retrying [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

