/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec;

import java.util.Collection;
import java.util.Optional;
import org.apache.lucene.codecs.Codec;
import org.opensearch.index.codec.CodecService;
import org.opensearch.index.codec.CodecServiceConfig;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.knn.index.codec.KNN1030Codec.KNN1030Codec;
import org.opensearch.knn.index.codec.KNN9120Codec.KNN9120PerFieldKnnVectorsFormat;
import org.opensearch.knn.index.codec.nativeindex.NativeIndexBuildStrategyFactory;

public class KNNCodecService
extends CodecService {
    private final MapperService mapperService;
    private final NativeIndexBuildStrategyFactory nativeIndexBuildStrategyFactory;

    public KNNCodecService(CodecServiceConfig codecServiceConfig, NativeIndexBuildStrategyFactory nativeIndexBuildStrategyFactory) {
        super(codecServiceConfig.getMapperService(), codecServiceConfig.getIndexSettings(), codecServiceConfig.getLogger(), (Collection)codecServiceConfig.getAdditionalCodecs());
        this.mapperService = codecServiceConfig.getMapperService();
        this.nativeIndexBuildStrategyFactory = nativeIndexBuildStrategyFactory;
    }

    public Codec codec(String name) {
        return KNN1030Codec.builder().delegate(super.codec(name)).mapperService(this.mapperService).knnVectorsFormat(new KNN9120PerFieldKnnVectorsFormat(Optional.ofNullable(this.mapperService), this.nativeIndexBuildStrategyFactory)).build();
    }
}

