/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.warmup;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.knn.common.FieldInfoExtractor;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.MemoryOptimizedSearchSupportSpec;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;
import org.opensearch.knn.memoryoptsearch.faiss.FaissMemoryOptimizedSearcher;

public class MemoryOptimizedSearchWarmup {
    @Generated
    private static final Logger log = LogManager.getLogger(MemoryOptimizedSearchWarmup.class);

    public ArrayList<String> warmUp(LeafReader leafReader, MapperService mapperService, String indexName, Directory directory) {
        if (mapperService == null) {
            return new ArrayList<String>();
        }
        SegmentReader segmentReader = Lucene.segmentReader((LeafReader)leafReader);
        Directory bottomDirectory = FilterDirectory.unwrap((Directory)directory);
        ArrayList<FieldInfo> memOptSearchFields = this.getFieldsForMemoryOptimizedSearch(leafReader, mapperService, indexName);
        for (FieldInfo field : memOptSearchFields) {
            this.loadFullPrecisionVectors(leafReader, field);
        }
        ArrayList<String> warmedUp = new ArrayList<String>();
        for (FieldInfo field : memOptSearchFields) {
            try {
                if (!this.warmUpField(field, segmentReader, bottomDirectory)) continue;
                warmedUp.add(field.getName());
            }
            catch (IOException e) {
                log.error("Failed to warm up field: {}", (Object)field.getName(), (Object)e);
            }
        }
        return warmedUp;
    }

    private boolean warmUpField(FieldInfo field, SegmentReader segmentReader, Directory directory) throws IOException {
        KNNEngine knnEngine = FieldInfoExtractor.extractKNNEngine(field);
        List<String> engineFiles = KNNCodecUtil.getEngineFiles(knnEngine.getExtension(), field.getName(), segmentReader.getSegmentInfo().info);
        if (engineFiles.isEmpty()) {
            log.warn("Could not find an engine file for field [{}]", (Object)field.getName());
            return false;
        }
        Path indexPath = Paths.get(engineFiles.getFirst(), new String[0]);
        try (IndexInput input = directory.openInput(indexPath.toString(), IOContext.READONCE);){
            if (input.length() != 0L) {
                for (long i = 0L; i < input.length(); i += 4096L) {
                    input.seek(i);
                    input.readByte();
                }
                input.seek(input.length() - 1L);
                input.readByte();
            }
        }
        try {
            segmentReader.getVectorReader().search(field.getName(), (float[])null, null, null);
        }
        catch (FaissMemoryOptimizedSearcher.WarmupInitializationException warmupInitializationException) {
            // empty catch block
        }
        return true;
    }

    private boolean isMemoryOptimizedSearchField(FieldInfo fieldInfo, MapperService mapperService, String indexName) {
        if (!fieldInfo.attributes().containsKey("knn_field")) {
            return false;
        }
        MappedFieldType fieldType = mapperService.fieldType(fieldInfo.getName());
        if (fieldType instanceof KNNVectorFieldType) {
            KNNVectorFieldType knnFieldType = (KNNVectorFieldType)fieldType;
            return MemoryOptimizedSearchSupportSpec.isSupportedFieldType(knnFieldType, indexName);
        }
        return false;
    }

    private ArrayList<FieldInfo> getFieldsForMemoryOptimizedSearch(LeafReader leafReader, MapperService mapperService, String indexName) {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        for (FieldInfo field : leafReader.getFieldInfos()) {
            if (!this.isMemoryOptimizedSearchField(field, mapperService, indexName)) continue;
            fields.add(field);
        }
        return fields;
    }

    private void loadFullPrecisionVectors(LeafReader leafReader, FieldInfo field) {
        try {
            FloatVectorValues vectorValues = leafReader.getFloatVectorValues(field.getName());
            if (vectorValues == null) {
                return;
            }
            KnnVectorValues.DocIndexIterator iter = vectorValues.iterator();
            while (iter.nextDoc() != Integer.MAX_VALUE) {
                vectorValues.vectorValue(iter.docID());
            }
        }
        catch (IOException e) {
            log.error("Failed to load vec file for field: {}", (Object)field.getName(), (Object)e);
        }
    }
}

