/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.modes.gcm;

import java.util.Map;
import java.util.WeakHashMap;
import org.bouncycastle.crypto.internal.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.internal.modes.gcm.Tables8kGCMMultiplier;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class GCMMultiplierCache {
    private static final Map<CacheKey, MultiplierProvider> values = new WeakHashMap<CacheKey, MultiplierProvider>();
    private static final CacheKey[] preserve = new CacheKey[8];
    private static int preserveCounter = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GCMMultiplier fetch(byte[] byArray) {
        MultiplierProvider multiplierProvider;
        byte[] byArray2 = Arrays.clone(byArray);
        CacheKey cacheKey = new CacheKey(byArray2);
        Map<CacheKey, MultiplierProvider> map = values;
        synchronized (map) {
            multiplierProvider = values.get(cacheKey);
            if (multiplierProvider == null) {
                multiplierProvider = new MultiplierProvider(byArray2);
                values.put(cacheKey, multiplierProvider);
                GCMMultiplierCache.preserve[GCMMultiplierCache.preserveCounter] = cacheKey;
                preserveCounter = (preserveCounter + 1) % preserve.length;
            }
        }
        return multiplierProvider.getMultiplier();
    }

    public synchronized int size() {
        return values.size();
    }

    public synchronized void clear() {
        values.clear();
        for (int i = 0; i != preserve.length; ++i) {
            GCMMultiplierCache.preserve[i] = null;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class CacheKey {
        private final byte[] H;
        private final int hashCode;

        CacheKey(byte[] byArray) {
            this.H = byArray;
            this.hashCode = Arrays.hashCode(byArray);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CacheKey) {
                CacheKey cacheKey = (CacheKey)object;
                return Arrays.areEqual(cacheKey.H, this.H);
            }
            return false;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class MultiplierProvider {
        private final byte[] H;
        private GCMMultiplier m;

        MultiplierProvider(byte[] byArray) {
            this.H = byArray;
        }

        synchronized GCMMultiplier getMultiplier() {
            if (this.m == null) {
                this.m = new Tables8kGCMMultiplier();
                this.m.init(this.H);
            }
            return this.m;
        }
    }
}

