/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf.impl.v7;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auth.internal.InternalAuthenticationBackend;
import org.opensearch.security.securityconf.impl.DashboardSignInOption;
import org.opensearch.security.setting.DeprecatedSettings;

public class ConfigV7 {
    public static int ALLOWED_TRIES_DEFAULT = 10;
    public static int TIME_WINDOW_SECONDS_DEFAULT = 3600;
    public static int BLOCK_EXPIRY_SECONDS_DEFAULT = 600;
    public static int MAX_BLOCKED_CLIENTS_DEFAULT = 100000;
    public static int MAX_TRACKED_CLIENTS_DEFAULT = 100000;
    public Dynamic dynamic;

    public String toString() {
        return "Config [dynamic=" + String.valueOf(this.dynamic) + "]";
    }

    public static class Dynamic {
        public String filtered_alias_mode = "warn";
        public boolean disable_rest_auth;
        public boolean disable_intertransport_auth;
        public boolean respect_request_indices_options;
        public String license;
        public Kibana kibana = new Kibana();
        public Http http = new Http();
        public Authc authc = new Authc();
        public Authz authz = new Authz();
        public AuthFailureListeners auth_failure_listeners = new AuthFailureListeners();
        public boolean do_not_fail_on_forbidden;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean multi_rolespan_enabled = true;
        public String hosts_resolver_mode = "ip-only";
        public String transport_userrname_attribute;
        public boolean do_not_fail_on_forbidden_empty;
        public OnBehalfOfSettings on_behalf_of = new OnBehalfOfSettings();

        public String toString() {
            return "Dynamic [filtered_alias_mode=" + this.filtered_alias_mode + ", kibana=" + String.valueOf(this.kibana) + ", http=" + String.valueOf(this.http) + ", authc=" + String.valueOf(this.authc) + ", authz=" + String.valueOf(this.authz) + ", on_behalf_of=" + String.valueOf(this.on_behalf_of) + "]";
        }
    }

    public static class OnBehalfOfSettings {
        @JsonProperty(value="enabled")
        private Boolean enabled = Boolean.FALSE;
        @JsonProperty(value="signing_key")
        private String signingKey;
        @JsonProperty(value="encryption_key")
        private String encryptionKey;

        @JsonIgnore
        public String configAsJson() {
            try {
                return DefaultObjectMapper.writeValueAsString(this, false);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public Boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getSigningKey() {
            return this.signingKey;
        }

        public void setSigningKey(String signingKey) {
            this.signingKey = signingKey;
        }

        public String getEncryptionKey() {
            return this.encryptionKey;
        }

        public void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        public String toString() {
            return "OnBehalfOfSettings [ enabled=" + this.enabled + ", signing_key=" + this.signingKey + ", encryption_key=" + this.encryptionKey + "]";
        }
    }

    public static class AuthzDomain {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean http_enabled = true;
        public AuthzBackend authorization_backend = new AuthzBackend();
        public String description;

        public String toString() {
            return "AuthzDomain [http_enabled=" + this.http_enabled + ", authorization_backend=" + String.valueOf(this.authorization_backend) + ", description=" + this.description + "]";
        }

        @JsonAnySetter
        public void unknownPropertiesHandler(String name, Object value) throws JsonMappingException {
            switch (name) {
                case "transport_enabled": {
                    DeprecatedSettings.logCustomDeprecationMessage(String.format("In AuthzDomain, using authorization_backend=%s", this.authorization_backend), name);
                    break;
                }
                default: {
                    throw new UnrecognizedPropertyException(null, "Unrecognized field " + name + " present in the input data for AuthzDomain config", null, AuthzDomain.class, name, null);
                }
            }
        }
    }

    public static class Authz {
        @JsonIgnore
        private final Map<String, AuthzDomain> domains = new HashMap<String, AuthzDomain>();

        @JsonAnySetter
        void setDomains(String key, AuthzDomain value) {
            this.domains.put(key, value);
        }

        @JsonAnyGetter
        public Map<String, AuthzDomain> getDomains() {
            return this.domains;
        }

        public String toString() {
            return "Authz [domains=" + String.valueOf(this.domains) + "]";
        }
    }

    public static class AuthcBackend {
        public String type = InternalAuthenticationBackend.class.getName();
        public Map<String, Object> config = Collections.emptyMap();

        @JsonIgnore
        public String configAsJson() {
            try {
                return DefaultObjectMapper.writeValueAsString(this.config, false);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "AuthcBackend [type=" + this.type + ", config=" + String.valueOf(this.config) + "]";
        }
    }

    public static class AuthzBackend {
        public String type = "noop";
        public Map<String, Object> config = Collections.emptyMap();

        @JsonIgnore
        public String configAsJson() {
            try {
                return DefaultObjectMapper.writeValueAsString(this.config, false);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "AuthzBackend [type=" + this.type + ", config=" + String.valueOf(this.config) + "]";
        }
    }

    public static class HttpAuthenticator {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean challenge = true;
        public String type;
        public Map<String, Object> config = Collections.emptyMap();

        @JsonIgnore
        public String configAsJson() {
            try {
                return DefaultObjectMapper.writeValueAsString(this.config, false);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "HttpAuthenticator [challenge=" + this.challenge + ", type=" + this.type + ", config=" + String.valueOf(this.config) + "]";
        }
    }

    public static class AuthcDomain {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean http_enabled = true;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public int order = 0;
        public HttpAuthenticator http_authenticator = new HttpAuthenticator();
        public AuthcBackend authentication_backend = new AuthcBackend();
        public String description;

        public String toString() {
            return "AuthcDomain [http_enabled=" + this.http_enabled + ", order=" + this.order + ", http_authenticator=" + String.valueOf(this.http_authenticator) + ", authentication_backend=" + String.valueOf(this.authentication_backend) + ", description=" + this.description + "]";
        }

        @JsonAnySetter
        public void unknownPropertiesHandler(String name, Object value) throws JsonMappingException {
            switch (name) {
                case "transport_enabled": {
                    DeprecatedSettings.logCustomDeprecationMessage(String.format("In AuthcDomain, using http_authenticator=%s, authentication_backend=%s", this.http_authenticator, this.authentication_backend), name);
                    break;
                }
                default: {
                    throw new UnrecognizedPropertyException(null, "Unrecognized field " + name + " present in the input data for AuthcDomain config", null, AuthcDomain.class, name, null);
                }
            }
        }
    }

    public static class Authc {
        @JsonIgnore
        private final Map<String, AuthcDomain> domains = new HashMap<String, AuthcDomain>();

        @JsonAnySetter
        void setDomains(String key, AuthcDomain value) {
            this.domains.put(key, value);
        }

        @JsonAnyGetter
        public Map<String, AuthcDomain> getDomains() {
            return this.domains;
        }

        public String toString() {
            return "Authc [domains=" + String.valueOf(this.domains) + "]";
        }
    }

    public static class Xff {
        public boolean enabled = false;
        public String internalProxies = Pattern.compile("10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.1[6-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.2[0-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.3[0-1]{1}\\.\\d{1,3}\\.\\d{1,3}").toString();
        public String remoteIpHeader = "X-Forwarded-For";

        public String toString() {
            return "Xff [enabled=" + this.enabled + ", internalProxies=" + this.internalProxies + ", remoteIpHeader=" + this.remoteIpHeader + "]";
        }
    }

    public static class AuthFailureListener {
        public String type;
        public String authentication_backend;
        public List<String> ignore_hosts;
        public int allowed_tries = ALLOWED_TRIES_DEFAULT;
        public int time_window_seconds = TIME_WINDOW_SECONDS_DEFAULT;
        public int block_expiry_seconds = BLOCK_EXPIRY_SECONDS_DEFAULT;
        public int max_blocked_clients = MAX_BLOCKED_CLIENTS_DEFAULT;
        public int max_tracked_clients = MAX_TRACKED_CLIENTS_DEFAULT;

        public AuthFailureListener() {
        }

        public AuthFailureListener(String type, String authentication_backend, List<String> ignore_hosts, int allowed_tries, int time_window_seconds, int block_expiry_seconds, int max_blocked_clients, int max_tracked_clients) {
            this.type = type;
            this.authentication_backend = authentication_backend;
            this.ignore_hosts = ignore_hosts;
            this.allowed_tries = allowed_tries;
            this.time_window_seconds = time_window_seconds;
            this.block_expiry_seconds = block_expiry_seconds;
            this.max_blocked_clients = max_blocked_clients;
            this.max_tracked_clients = max_tracked_clients;
        }

        @JsonIgnore
        public String asJson() {
            try {
                return DefaultObjectMapper.writeValueAsString(this, false);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class AuthFailureListeners {
        @JsonIgnore
        private final Map<String, AuthFailureListener> listeners = new HashMap<String, AuthFailureListener>();

        @JsonAnySetter
        void setListeners(String key, AuthFailureListener value) {
            this.listeners.put(key, value);
        }

        @JsonAnyGetter
        public Map<String, AuthFailureListener> getListeners() {
            return this.listeners;
        }
    }

    public static class Http {
        public boolean anonymous_auth_enabled = false;
        public Xff xff = new Xff();

        public String toString() {
            return "Http [anonymous_auth_enabled=" + this.anonymous_auth_enabled + ", xff=" + String.valueOf(this.xff) + "]";
        }
    }

    public static class Kibana {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean multitenancy_enabled = true;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public boolean private_tenant_enabled = true;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public String default_tenant = "";
        public String server_username = "kibanaserver";
        public String opendistro_role = null;
        public String index = ".kibana";
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public List<DashboardSignInOption> sign_in_options = Arrays.asList(DashboardSignInOption.BASIC);

        public String toString() {
            return "Kibana [multitenancy_enabled=" + this.multitenancy_enabled + ", private_tenant_enabled=" + this.private_tenant_enabled + ", default_tenant=" + this.default_tenant + ", server_username=" + this.server_username + ", opendistro_role=" + this.opendistro_role + ", index=" + this.index + ", sign_in_options=" + String.valueOf(this.sign_in_options) + "]";
        }
    }
}

