/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.analysis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.DataSourceSchemaName;
import org.opensearch.sql.analysis.AnalysisContext;
import org.opensearch.sql.analysis.DataSourceSchemaIdentifierNameResolver;
import org.opensearch.sql.analysis.ExpressionAnalyzer;
import org.opensearch.sql.analysis.ExpressionReferenceOptimizer;
import org.opensearch.sql.analysis.HighlightAnalyzer;
import org.opensearch.sql.analysis.NamedExpressionAnalyzer;
import org.opensearch.sql.analysis.NestedAnalyzer;
import org.opensearch.sql.analysis.SelectExpressionAnalyzer;
import org.opensearch.sql.analysis.TypeEnvironment;
import org.opensearch.sql.analysis.WindowExpressionAnalyzer;
import org.opensearch.sql.analysis.symbol.Namespace;
import org.opensearch.sql.analysis.symbol.Symbol;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.AggregateFunction;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Map;
import org.opensearch.sql.ast.expression.ParseMethod;
import org.opensearch.sql.ast.expression.PatternMethod;
import org.opensearch.sql.ast.expression.PatternMode;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.WindowFunction;
import org.opensearch.sql.ast.tree.AD;
import org.opensearch.sql.ast.tree.AddColTotals;
import org.opensearch.sql.ast.tree.AddTotals;
import org.opensearch.sql.ast.tree.Aggregation;
import org.opensearch.sql.ast.tree.Append;
import org.opensearch.sql.ast.tree.AppendCol;
import org.opensearch.sql.ast.tree.AppendPipe;
import org.opensearch.sql.ast.tree.Bin;
import org.opensearch.sql.ast.tree.Chart;
import org.opensearch.sql.ast.tree.CloseCursor;
import org.opensearch.sql.ast.tree.Dedupe;
import org.opensearch.sql.ast.tree.Eval;
import org.opensearch.sql.ast.tree.Expand;
import org.opensearch.sql.ast.tree.FetchCursor;
import org.opensearch.sql.ast.tree.FillNull;
import org.opensearch.sql.ast.tree.Filter;
import org.opensearch.sql.ast.tree.Flatten;
import org.opensearch.sql.ast.tree.Head;
import org.opensearch.sql.ast.tree.Join;
import org.opensearch.sql.ast.tree.Kmeans;
import org.opensearch.sql.ast.tree.Limit;
import org.opensearch.sql.ast.tree.Lookup;
import org.opensearch.sql.ast.tree.ML;
import org.opensearch.sql.ast.tree.Multisearch;
import org.opensearch.sql.ast.tree.MvCombine;
import org.opensearch.sql.ast.tree.Paginate;
import org.opensearch.sql.ast.tree.Parse;
import org.opensearch.sql.ast.tree.Patterns;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.ast.tree.Regex;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.RelationSubquery;
import org.opensearch.sql.ast.tree.Rename;
import org.opensearch.sql.ast.tree.Replace;
import org.opensearch.sql.ast.tree.Reverse;
import org.opensearch.sql.ast.tree.Rex;
import org.opensearch.sql.ast.tree.SPath;
import org.opensearch.sql.ast.tree.Search;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.ast.tree.StreamWindow;
import org.opensearch.sql.ast.tree.SubqueryAlias;
import org.opensearch.sql.ast.tree.TableFunction;
import org.opensearch.sql.ast.tree.Transpose;
import org.opensearch.sql.ast.tree.Trendline;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.ast.tree.Values;
import org.opensearch.sql.ast.tree.Window;
import org.opensearch.sql.calcite.utils.CalciteUtils;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.DSL;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.LiteralExpression;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.aggregation.Aggregator;
import org.opensearch.sql.expression.aggregation.NamedAggregator;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.TableFunctionImplementation;
import org.opensearch.sql.expression.parse.ParseExpression;
import org.opensearch.sql.planner.logical.LogicalAD;
import org.opensearch.sql.planner.logical.LogicalAggregation;
import org.opensearch.sql.planner.logical.LogicalCloseCursor;
import org.opensearch.sql.planner.logical.LogicalDedupe;
import org.opensearch.sql.planner.logical.LogicalEval;
import org.opensearch.sql.planner.logical.LogicalFetchCursor;
import org.opensearch.sql.planner.logical.LogicalFilter;
import org.opensearch.sql.planner.logical.LogicalLimit;
import org.opensearch.sql.planner.logical.LogicalML;
import org.opensearch.sql.planner.logical.LogicalMLCommons;
import org.opensearch.sql.planner.logical.LogicalPaginate;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalProject;
import org.opensearch.sql.planner.logical.LogicalRareTopN;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.logical.LogicalRemove;
import org.opensearch.sql.planner.logical.LogicalRename;
import org.opensearch.sql.planner.logical.LogicalSort;
import org.opensearch.sql.planner.logical.LogicalTrendline;
import org.opensearch.sql.planner.logical.LogicalValues;
import org.opensearch.sql.planner.logical.LogicalWindow;
import org.opensearch.sql.planner.physical.datasource.DataSourceTable;
import org.opensearch.sql.storage.Table;
import org.opensearch.sql.utils.ParseUtils;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class Analyzer
extends AbstractNodeVisitor<LogicalPlan, AnalysisContext> {
    private final ExpressionAnalyzer expressionAnalyzer;
    private final SelectExpressionAnalyzer selectExpressionAnalyzer;
    private final NamedExpressionAnalyzer namedExpressionAnalyzer;
    private final DataSourceService dataSourceService;
    private final BuiltinFunctionRepository repository;

    public Analyzer(ExpressionAnalyzer expressionAnalyzer, DataSourceService dataSourceService, BuiltinFunctionRepository repository) {
        this.expressionAnalyzer = expressionAnalyzer;
        this.dataSourceService = dataSourceService;
        this.selectExpressionAnalyzer = new SelectExpressionAnalyzer(expressionAnalyzer);
        this.namedExpressionAnalyzer = new NamedExpressionAnalyzer(expressionAnalyzer);
        this.repository = repository;
    }

    public LogicalPlan analyze(UnresolvedPlan unresolved, AnalysisContext context) {
        return unresolved.accept(this, context);
    }

    @Override
    public LogicalPlan visitSubqueryAlias(SubqueryAlias node, AnalysisContext context) {
        LogicalPlan child = this.analyze(node.getChild().get(0), context);
        if (child instanceof LogicalRelation) {
            TypeEnvironment curEnv = context.peek();
            curEnv.define(new Symbol(Namespace.INDEX_NAME, node.getAlias() == null ? ((LogicalRelation)child).getRelationName() : node.getAlias()), ExprCoreType.STRUCT);
            return child;
        }
        throw CalciteUtils.getOnlyForCalciteException("Subsearch");
    }

    @Override
    public LogicalPlan visitRelation(Relation node, AnalysisContext context) {
        QualifiedName qualifiedName = node.getTableQualifiedName();
        DataSourceSchemaIdentifierNameResolver dataSourceSchemaIdentifierNameResolver = new DataSourceSchemaIdentifierNameResolver(this.dataSourceService, qualifiedName.getParts());
        String tableName = dataSourceSchemaIdentifierNameResolver.getIdentifierName();
        context.push();
        TypeEnvironment curEnv = context.peek();
        Table table = ".DATASOURCES".equals(tableName) ? new DataSourceTable(this.dataSourceService) : this.dataSourceService.getDataSource(dataSourceSchemaIdentifierNameResolver.getDataSourceName()).getStorageEngine().getTable(new DataSourceSchemaName(dataSourceSchemaIdentifierNameResolver.getDataSourceName(), dataSourceSchemaIdentifierNameResolver.getSchemaName()), dataSourceSchemaIdentifierNameResolver.getIdentifierName());
        table.getFieldTypes().forEach((k, v) -> curEnv.define(new Symbol(Namespace.FIELD_NAME, (String)k), (ExprType)v));
        table.getReservedFieldTypes().forEach((k, v) -> curEnv.define(new Symbol(Namespace.HIDDEN_FIELD_NAME, (String)k), (ExprType)v));
        return new LogicalRelation(tableName, table);
    }

    @Override
    public LogicalPlan visitRelationSubquery(RelationSubquery node, AnalysisContext context) {
        LogicalPlan subquery = this.analyze(node.getChild().get(0), context);
        TypeEnvironment curEnv = context.peek();
        curEnv.define(new Symbol(Namespace.INDEX_NAME, node.getAliasAsTableName()), ExprCoreType.STRUCT);
        return subquery;
    }

    @Override
    public LogicalPlan visitTableFunction(TableFunction node, AnalysisContext context) {
        QualifiedName qualifiedName = node.getFunctionName();
        DataSourceSchemaIdentifierNameResolver dataSourceSchemaIdentifierNameResolver = new DataSourceSchemaIdentifierNameResolver(this.dataSourceService, qualifiedName.getParts());
        FunctionName functionName = FunctionName.of(dataSourceSchemaIdentifierNameResolver.getIdentifierName());
        List<Expression> arguments = node.getArguments().stream().map(unresolvedExpression -> this.expressionAnalyzer.analyze((UnresolvedExpression)unresolvedExpression, context)).collect(Collectors.toList());
        TableFunctionImplementation tableFunctionImplementation = (TableFunctionImplementation)this.repository.compile(context.getFunctionProperties(), this.dataSourceService.getDataSource(dataSourceSchemaIdentifierNameResolver.getDataSourceName()).getStorageEngine().getFunctions(), functionName, arguments);
        context.push();
        TypeEnvironment curEnv = context.peek();
        Table table = tableFunctionImplementation.applyArguments();
        table.getFieldTypes().forEach((k, v) -> curEnv.define(new Symbol(Namespace.FIELD_NAME, (String)k), (ExprType)v));
        table.getReservedFieldTypes().forEach((k, v) -> curEnv.define(new Symbol(Namespace.HIDDEN_FIELD_NAME, (String)k), (ExprType)v));
        curEnv.define(new Symbol(Namespace.INDEX_NAME, dataSourceSchemaIdentifierNameResolver.getIdentifierName()), ExprCoreType.STRUCT);
        return new LogicalRelation(dataSourceSchemaIdentifierNameResolver.getIdentifierName(), tableFunctionImplementation.applyArguments());
    }

    @Override
    public LogicalPlan visitLimit(Limit node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        return new LogicalLimit(child, node.getLimit(), node.getOffset());
    }

    @Override
    public LogicalPlan visitSearch(Search node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        Function queryStringFunc = AstDSL.function("query_string", AstDSL.unresolvedArg("query", AstDSL.stringLiteral(node.getQueryString())));
        Expression analyzed = this.expressionAnalyzer.analyze(queryStringFunc, context);
        return new LogicalFilter(child, analyzed);
    }

    @Override
    public LogicalPlan visitFilter(Filter node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        Expression condition = this.expressionAnalyzer.analyze(node.getCondition(), context);
        ExpressionReferenceOptimizer optimizer = new ExpressionReferenceOptimizer(this.expressionAnalyzer.getRepository(), child);
        Expression optimized = optimizer.optimize(condition, context);
        return new LogicalFilter(child, optimized);
    }

    private void verifySupportsCondition(Expression condition) {
        if (condition instanceof FunctionExpression) {
            if (((FunctionExpression)condition).getFunctionName().getFunctionName().equalsIgnoreCase(BuiltinFunctionName.NESTED.name())) {
                throw new SyntaxCheckException("Falling back to legacy engine. Nested function is not supported in WHERE, GROUP BY, and HAVING clauses.");
            }
            ((FunctionExpression)condition).getArguments().stream().forEach(e -> this.verifySupportsCondition((Expression)e));
        }
    }

    @Override
    public LogicalPlan visitRename(Rename node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        ImmutableMap.Builder renameMapBuilder = new ImmutableMap.Builder();
        for (Map renameMap : node.getRenameList()) {
            Expression origin = this.expressionAnalyzer.analyze(renameMap.getOrigin(), context);
            if (renameMap.getTarget() instanceof Field) {
                ReferenceExpression target = new ReferenceExpression(((Field)renameMap.getTarget()).getField().toString(), origin.type());
                ReferenceExpression originExpr = DSL.ref(origin.toString(), origin.type());
                TypeEnvironment curEnv = context.peek();
                curEnv.remove(originExpr);
                curEnv.define(target);
                renameMapBuilder.put((Object)originExpr, (Object)target);
                continue;
            }
            throw new SemanticCheckException(String.format("the target expected to be field, but is %s", renameMap.getTarget()));
        }
        return new LogicalRename(child, (java.util.Map<ReferenceExpression, ReferenceExpression>)renameMapBuilder.build());
    }

    @Override
    public LogicalPlan visitAggregation(Aggregation node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        return this.analyzeAggregation(node, child, context);
    }

    @Override
    public LogicalPlan visitRareTopN(RareTopN node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        ImmutableList.Builder groupbyBuilder = new ImmutableList.Builder();
        for (UnresolvedExpression expr : node.getGroupExprList()) {
            groupbyBuilder.add((Object)this.expressionAnalyzer.analyze(expr, context));
        }
        ImmutableList groupBys = groupbyBuilder.build();
        ImmutableList.Builder fieldsBuilder = new ImmutableList.Builder();
        for (Field f : node.getFields()) {
            fieldsBuilder.add((Object)this.expressionAnalyzer.analyze(f, context));
        }
        ImmutableList fields = fieldsBuilder.build();
        context.push();
        TypeEnvironment newEnv = context.peek();
        groupBys.forEach(group -> newEnv.define(new Symbol(Namespace.FIELD_NAME, group.toString()), group.type()));
        fields.forEach(field -> newEnv.define(new Symbol(Namespace.FIELD_NAME, field.toString()), field.type()));
        Integer noOfResults = node.getNoOfResults();
        return new LogicalRareTopN(child, node.getCommandType(), noOfResults, (List<Expression>)fields, (List<Expression>)groupBys);
    }

    @Override
    public LogicalPlan visitProject(Project node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        if (this.isExcludeMode(node)) {
            return this.buildLogicalRemove(node, child, context);
        }
        child = this.processWindowExpressions(node.getProjectList(), child, context);
        child = this.processHighlightExpressions(node.getProjectList(), child, context);
        List<NamedExpression> namedExpressions = this.resolveFieldExpressions(node.getProjectList(), child, context);
        child = this.processNestedAnalysis(node.getProjectList(), namedExpressions, child, context);
        context.push();
        TypeEnvironment newEnv = context.peek();
        namedExpressions.forEach(expr -> newEnv.define(new Symbol(Namespace.FIELD_NAME, expr.getNameOrAlias()), expr.type()));
        return new LogicalProject(child, namedExpressions, context.getNamedParseExpressions());
    }

    private boolean isExcludeMode(Project node) {
        if (!node.hasArgument()) {
            return false;
        }
        try {
            Argument argument = node.getArgExprList().get(0);
            Object value = argument.getValue().getValue();
            return Boolean.TRUE.equals(value);
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            return false;
        }
    }

    private LogicalRemove buildLogicalRemove(Project node, LogicalPlan child, AnalysisContext context) {
        Set fieldsToExclude;
        TypeEnvironment curEnv = context.peek();
        List<ReferenceExpression> referenceExpressions = this.collectExclusionFields(node.getProjectList(), context);
        Set<String> allFields = curEnv.lookupAllFields(Namespace.FIELD_NAME).keySet();
        if (allFields.equals(fieldsToExclude = referenceExpressions.stream().map(ReferenceExpression::getAttr).collect(Collectors.toSet()))) {
            throw new IllegalArgumentException("Invalid field exclusion: operation would exclude all fields from the result set");
        }
        referenceExpressions.forEach(curEnv::remove);
        return new LogicalRemove(child, (Set<ReferenceExpression>)ImmutableSet.copyOf(referenceExpressions));
    }

    private LogicalPlan processWindowExpressions(List<UnresolvedExpression> projectList, LogicalPlan child, AnalysisContext context) {
        for (UnresolvedExpression expr : projectList) {
            child = new WindowExpressionAnalyzer(this.expressionAnalyzer, child).analyze(expr, context);
        }
        return child;
    }

    private LogicalPlan processHighlightExpressions(List<UnresolvedExpression> projectList, LogicalPlan child, AnalysisContext context) {
        for (UnresolvedExpression expr : projectList) {
            child = new HighlightAnalyzer(this.expressionAnalyzer, child).analyze(expr, context);
        }
        return child;
    }

    private List<NamedExpression> resolveFieldExpressions(List<UnresolvedExpression> projectList, LogicalPlan child, AnalysisContext context) {
        return this.selectExpressionAnalyzer.analyze(projectList, context, new ExpressionReferenceOptimizer(this.expressionAnalyzer.getRepository(), child));
    }

    private LogicalPlan processNestedAnalysis(List<UnresolvedExpression> projectList, List<NamedExpression> namedExpressions, LogicalPlan child, AnalysisContext context) {
        for (UnresolvedExpression expr : projectList) {
            child = new NestedAnalyzer(namedExpressions, this.expressionAnalyzer, child).analyze(expr, context);
        }
        return child;
    }

    private List<ReferenceExpression> collectExclusionFields(List<UnresolvedExpression> projectList, AnalysisContext context) {
        List namedExpressions = projectList.stream().map(expr -> this.expressionAnalyzer.analyze((UnresolvedExpression)expr, context)).map(DSL::named).collect(Collectors.toList());
        return namedExpressions.stream().map(field -> (ReferenceExpression)field.getDelegated()).collect(Collectors.toList());
    }

    @Override
    public LogicalPlan visitEval(Eval node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        ImmutableList.Builder expressionsBuilder = new ImmutableList.Builder();
        for (Let let : node.getExpressionList()) {
            Expression expression = this.expressionAnalyzer.analyze(let.getExpression(), context);
            ReferenceExpression ref = DSL.ref(let.getVar().getField().toString(), expression.type());
            expressionsBuilder.add((Object)ImmutablePair.of((Object)ref, (Object)expression));
            TypeEnvironment typeEnvironment = context.peek();
            typeEnvironment.define(ref);
        }
        return new LogicalEval(child, (List<Pair<ReferenceExpression, Expression>>)expressionsBuilder.build());
    }

    @Override
    public LogicalPlan visitAddTotals(AddTotals node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("addtotals");
    }

    @Override
    public LogicalPlan visitAddColTotals(AddColTotals node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("addcoltotals");
    }

    @Override
    public LogicalPlan visitMvCombine(MvCombine node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("mvcombine");
    }

    @Override
    public LogicalPlan visitParse(Parse node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        this.analyzeParseNode(node, context);
        return child;
    }

    @Override
    public LogicalPlan visitPatterns(Patterns node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        if (PatternMethod.SIMPLE_PATTERN.equals((Object)node.getPatternMethod())) {
            Parse parseNode = new Parse(ParseMethod.PATTERNS, node.getSourceField(), node.getArguments().getOrDefault("pattern", AstDSL.stringLiteral("")), node.getArguments());
            this.analyzeParseNode(parseNode, context);
        } else {
            ArrayList<UnresolvedExpression> funcParamList = new ArrayList<UnresolvedExpression>();
            funcParamList.add(node.getSourceField());
            funcParamList.addAll(node.getArguments().entrySet().stream().map(entry -> new Argument((String)entry.getKey(), (Literal)entry.getValue())).sorted(Comparator.comparing(Argument::getArgName)).toList());
            Alias windowFunction = new Alias(node.getAlias(), (UnresolvedExpression)new WindowFunction(new Function(node.getPatternMethod().getName(), funcParamList), node.getPartitionByList(), List.of()), node.getAlias());
            WindowExpressionAnalyzer windowAnalyzer = new WindowExpressionAnalyzer(this.expressionAnalyzer, child);
            child = windowAnalyzer.analyze(windowFunction, context);
            TypeEnvironment curEnv = context.peek();
            LogicalWindow window = (LogicalWindow)child;
            curEnv.define(new Symbol(Namespace.FIELD_NAME, window.getWindowFunction().getNameOrAlias()), window.getWindowFunction().getDelegated().type());
        }
        if (PatternMode.AGGREGATION.equals((Object)node.getPatternMode())) {
            Aggregation aggNode = this.analyzePatternsAgg(node);
            return this.analyzeAggregation(aggNode, child, context);
        }
        return child;
    }

    @Override
    public LogicalPlan visitSort(Sort node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        return this.buildSort(child, context, node.getCount(), node.getSortList());
    }

    @Override
    public LogicalPlan visitDedupe(Dedupe node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        List<Argument> options = node.getOptions();
        Integer allowedDuplication = (Integer)options.get(0).getValue().getValue();
        Boolean keepEmpty = (Boolean)options.get(1).getValue().getValue();
        Boolean consecutive = (Boolean)options.get(2).getValue().getValue();
        return new LogicalDedupe(child, node.getFields().stream().map(f -> this.expressionAnalyzer.analyze((UnresolvedExpression)f, context)).collect(Collectors.toList()), allowedDuplication, keepEmpty, consecutive);
    }

    @Override
    public LogicalPlan visitHead(Head node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        return new LogicalLimit(child, node.getSize(), node.getFrom());
    }

    @Override
    public LogicalPlan visitValues(Values node, AnalysisContext context) {
        List<List<Literal>> values = node.getValues();
        ArrayList<List<LiteralExpression>> valueExprs = new ArrayList<List<LiteralExpression>>();
        for (List<Literal> value : values) {
            valueExprs.add(value.stream().map(val -> (LiteralExpression)this.expressionAnalyzer.analyze((UnresolvedExpression)val, context)).collect(Collectors.toList()));
        }
        return new LogicalValues((List<List<LiteralExpression>>)valueExprs);
    }

    @Override
    public LogicalPlan visitKmeans(Kmeans node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        java.util.Map<String, Literal> options = node.getArguments();
        TypeEnvironment currentEnv = context.peek();
        currentEnv.define(new Symbol(Namespace.FIELD_NAME, "ClusterID"), ExprCoreType.INTEGER);
        return new LogicalMLCommons(child, "kmeans", options);
    }

    @Override
    public LogicalPlan visitAD(AD node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        java.util.Map<String, Literal> options = node.getArguments();
        TypeEnvironment currentEnv = context.peek();
        currentEnv.define(new Symbol(Namespace.FIELD_NAME, "score"), ExprCoreType.DOUBLE);
        if (Objects.isNull(node.getArguments().get("time_field"))) {
            currentEnv.define(new Symbol(Namespace.FIELD_NAME, "anomalous"), ExprCoreType.BOOLEAN);
        } else {
            currentEnv.define(new Symbol(Namespace.FIELD_NAME, "anomaly_grade"), ExprCoreType.DOUBLE);
            currentEnv.define(new Symbol(Namespace.FIELD_NAME, (String)node.getArguments().get("time_field").getValue()), ExprCoreType.TIMESTAMP);
        }
        return new LogicalAD(child, options);
    }

    @Override
    public LogicalPlan visitFillNull(FillNull node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        ImmutableList.Builder expressionsBuilder = new ImmutableList.Builder();
        for (Pair<Field, UnresolvedExpression> fieldFill : node.getReplacementPairs()) {
            Expression fieldExpr = this.expressionAnalyzer.analyze((UnresolvedExpression)fieldFill.getLeft(), context);
            ReferenceExpression ref = DSL.ref(((Field)fieldFill.getLeft()).getField().toString(), fieldExpr.type());
            FunctionExpression ifNullFunction = DSL.ifnull(ref, this.expressionAnalyzer.analyze((UnresolvedExpression)fieldFill.getRight(), context));
            expressionsBuilder.add((Object)new ImmutablePair((Object)ref, (Object)ifNullFunction));
            TypeEnvironment typeEnvironment = context.peek();
            typeEnvironment.define(ref);
        }
        ImmutableList expressions = expressionsBuilder.build();
        if (expressions.isEmpty()) {
            throw new SemanticCheckException("At least one field is required for fillnull in V2.");
        }
        return new LogicalEval(child, (List<Pair<ReferenceExpression, Expression>>)expressions);
    }

    @Override
    public LogicalPlan visitML(ML node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        TypeEnvironment currentEnv = context.peek();
        node.getOutputSchema(currentEnv).entrySet().stream().forEach(v -> currentEnv.define(new Symbol(Namespace.FIELD_NAME, (String)v.getKey()), (ExprType)v.getValue()));
        return new LogicalML(child, node.getArguments());
    }

    @Override
    public LogicalPlan visitTranspose(Transpose node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Transpose");
    }

    @Override
    public LogicalPlan visitBin(Bin node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Bin");
    }

    @Override
    public LogicalPlan visitExpand(Expand expand, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Expand");
    }

    @Override
    public LogicalPlan visitTrendline(Trendline node, AnalysisContext context) {
        LogicalPlan child = node.getChild().get(0).accept(this, context);
        TypeEnvironment currEnv = context.peek();
        List<Trendline.TrendlineComputation> computations = node.getComputations();
        ImmutableList.Builder computationsAndTypes = ImmutableList.builder();
        computations.forEach(computation -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=27,1892
             *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        if (node.getSortByField().isEmpty()) {
            return new LogicalTrendline(child, (List<Pair<Trendline.TrendlineComputation, ExprCoreType>>)computationsAndTypes.build());
        }
        return new LogicalTrendline(this.buildSort(child, context, 0, Collections.singletonList(node.getSortByField().get())), (List<Pair<Trendline.TrendlineComputation, ExprCoreType>>)computationsAndTypes.build());
    }

    @Override
    public LogicalPlan visitStreamWindow(StreamWindow node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Streamstats");
    }

    @Override
    public LogicalPlan visitFlatten(Flatten node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Flatten");
    }

    @Override
    public LogicalPlan visitReverse(Reverse node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Reverse");
    }

    @Override
    public LogicalPlan visitSpath(SPath node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Spath");
    }

    @Override
    public LogicalPlan visitChart(Chart node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Chart");
    }

    @Override
    public LogicalPlan visitWindow(Window node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Window");
    }

    @Override
    public LogicalPlan visitRegex(Regex node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Regex");
    }

    @Override
    public LogicalPlan visitRex(Rex node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Rex");
    }

    @Override
    public LogicalPlan visitPaginate(Paginate paginate, AnalysisContext context) {
        LogicalPlan child = paginate.getChild().get(0).accept(this, context);
        return new LogicalPaginate(paginate.getPageSize(), List.of(child));
    }

    @Override
    public LogicalPlan visitFetchCursor(FetchCursor cursor, AnalysisContext context) {
        return new LogicalFetchCursor(cursor.getCursor(), this.dataSourceService.getDataSource("@opensearch").getStorageEngine());
    }

    @Override
    public LogicalPlan visitCloseCursor(CloseCursor closeCursor, AnalysisContext context) {
        return new LogicalCloseCursor(closeCursor.getChild().get(0).accept(this, context));
    }

    @Override
    public LogicalPlan visitReplace(Replace node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Replace");
    }

    @Override
    public LogicalPlan visitJoin(Join node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Join");
    }

    @Override
    public LogicalPlan visitLookup(Lookup node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Lookup");
    }

    @Override
    public LogicalPlan visitAppendCol(AppendCol node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Appendcol");
    }

    @Override
    public LogicalPlan visitAppendPipe(AppendPipe node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("AppendPipe");
    }

    @Override
    public LogicalPlan visitAppend(Append node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Append");
    }

    @Override
    public LogicalPlan visitMultisearch(Multisearch node, AnalysisContext context) {
        throw CalciteUtils.getOnlyForCalciteException("Multisearch");
    }

    private LogicalSort buildSort(LogicalPlan child, AnalysisContext context, Integer count, List<Field> sortFields) {
        ExpressionReferenceOptimizer optimizer = new ExpressionReferenceOptimizer(this.expressionAnalyzer.getRepository(), child);
        List<Pair<Sort.SortOption, Expression>> sortList = sortFields.stream().map(sortField -> {
            Expression analyzed = this.expressionAnalyzer.analyze(sortField.getField(), context);
            if (analyzed == null) {
                throw new UnsupportedOperationException(String.format("Invalid use of expression %s", sortField.getField()));
            }
            Expression expression = optimizer.optimize(analyzed, context);
            return ImmutablePair.of((Object)this.analyzeSortOption(sortField.getFieldArgs()), (Object)expression);
        }).collect(Collectors.toList());
        return new LogicalSort(child, count, sortList);
    }

    private Sort.SortOption analyzeSortOption(List<Argument> fieldArgs) {
        Boolean asc = (Boolean)fieldArgs.get(0).getValue().getValue();
        Optional<Argument> nullFirst = fieldArgs.stream().filter(option -> "nullFirst".equals(option.getArgName())).findFirst();
        if (nullFirst.isPresent()) {
            Boolean isNullFirst = (Boolean)nullFirst.get().getValue().getValue();
            return new Sort.SortOption(asc != false ? Sort.SortOrder.ASC : Sort.SortOrder.DESC, isNullFirst != false ? Sort.NullOrder.NULL_FIRST : Sort.NullOrder.NULL_LAST);
        }
        return asc != false ? Sort.SortOption.DEFAULT_ASC : Sort.SortOption.DEFAULT_DESC;
    }

    private void analyzeParseNode(Parse node, AnalysisContext context) {
        Expression sourceField = this.expressionAnalyzer.analyze(node.getSourceField(), context);
        ParseMethod parseMethod = node.getParseMethod();
        java.util.Map<String, Literal> arguments = node.getArguments();
        String pattern = (String)node.getPattern().getValue();
        LiteralExpression patternExpression = DSL.literal(pattern);
        TypeEnvironment curEnv = context.peek();
        ParseUtils.getNamedGroupCandidates(parseMethod, pattern, arguments).forEach(group -> {
            ParseExpression expr = ParseUtils.createParseExpression(parseMethod, sourceField, patternExpression, DSL.literal(group));
            curEnv.define(new Symbol(Namespace.FIELD_NAME, (String)group), expr.type());
            context.getNamedParseExpressions().add(new NamedExpression((String)group, expr));
        });
    }

    private LogicalAggregation analyzeAggregation(Aggregation node, LogicalPlan child, AnalysisContext context) {
        ImmutableList.Builder aggregatorBuilder = new ImmutableList.Builder();
        for (UnresolvedExpression unresolvedExpression : node.getAggExprList()) {
            NamedExpression aggExpr = this.namedExpressionAnalyzer.analyze(unresolvedExpression, context);
            aggregatorBuilder.add((Object)new NamedAggregator(aggExpr.getNameOrAlias(), (Aggregator)aggExpr.getDelegated()));
        }
        ImmutableList.Builder groupbyBuilder = new ImmutableList.Builder();
        if (node.getSpan() != null) {
            groupbyBuilder.add((Object)this.namedExpressionAnalyzer.analyze(node.getSpan(), context));
        }
        for (UnresolvedExpression expr : node.getGroupExprList()) {
            NamedExpression resolvedExpr = this.namedExpressionAnalyzer.analyze(expr, context);
            this.verifySupportsCondition(resolvedExpr.getDelegated());
            groupbyBuilder.add((Object)resolvedExpr);
        }
        ImmutableList immutableList = groupbyBuilder.build();
        ImmutableList aggregators = aggregatorBuilder.build();
        context.push();
        TypeEnvironment newEnv = context.peek();
        aggregators.forEach(aggregator -> newEnv.define(new Symbol(Namespace.FIELD_NAME, aggregator.getName()), aggregator.type()));
        immutableList.forEach(group -> newEnv.define(new Symbol(Namespace.FIELD_NAME, group.getNameOrAlias()), group.type()));
        Argument.ArgumentMap statsArgs = Argument.ArgumentMap.of(node.getArgExprList());
        boolean bucketNullable = (Boolean)statsArgs.getOrDefault("bucket_nullable", Literal.TRUE).getValue();
        return new LogicalAggregation(child, (List<NamedAggregator>)aggregators, (List<NamedExpression>)immutableList, bucketNullable);
    }

    private Aggregation analyzePatternsAgg(Patterns node) {
        Alias patternsField = AstDSL.alias(node.getAlias(), AstDSL.field(node.getAlias()));
        List<UnresolvedExpression> aggExprs = Stream.of(new Alias("pattern_count", new AggregateFunction(BuiltinFunctionName.COUNT.name(), AllFields.of())), new Alias("sample_logs", new AggregateFunction(BuiltinFunctionName.TAKE.name(), node.getSourceField(), (List<UnresolvedExpression>)ImmutableList.of((Object)node.getPatternMaxSampleCount())))).map(alias -> alias).toList();
        ArrayList<UnresolvedExpression> groupByList = new ArrayList<UnresolvedExpression>();
        groupByList.add(patternsField);
        groupByList.addAll(node.getPartitionByList());
        return new Aggregation(aggExprs, (List<UnresolvedExpression>)ImmutableList.of(), groupByList);
    }
}

