/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.executor.ExecutionEngine;

public final class DynamicFieldsResultProcessor {
    public static ExecutionEngine.QueryResponse expandDynamicFields(ExecutionEngine.QueryResponse response) {
        if (!DynamicFieldsResultProcessor.hasDynamicFields(response)) {
            return response;
        }
        Map<String, ExprType> dynamicFieldTypes = DynamicFieldsResultProcessor.getDynamicFieldTypes(response.getResults());
        ExecutionEngine.Schema expandedSchema = DynamicFieldsResultProcessor.createExpandedSchema(response.getSchema(), dynamicFieldTypes);
        List<ExprValue> expandedRows = DynamicFieldsResultProcessor.expandResultRows(response.getResults(), expandedSchema);
        return new ExecutionEngine.QueryResponse(expandedSchema, expandedRows, response.getCursor());
    }

    private static boolean hasDynamicFields(ExecutionEngine.QueryResponse response) {
        return response.getSchema().getColumns().stream().anyMatch(column -> "_MAP".equals(column.getName()));
    }

    private static ExecutionEngine.Schema createExpandedSchema(ExecutionEngine.Schema originalSchema, Map<String, ExprType> dynamicFieldTypes) {
        List<ExecutionEngine.Schema.Column> expandedColumns = originalSchema.getColumns().stream().filter(col -> !"_MAP".equals(col.getName())).collect(Collectors.toList());
        Set staticFields = expandedColumns.stream().map(col -> col.getName()).collect(Collectors.toSet());
        List sortedDynamicFields = dynamicFieldTypes.keySet().stream().sorted().collect(Collectors.toList());
        for (String dynamicFieldName : sortedDynamicFields) {
            ExprType fieldType = dynamicFieldTypes.get(dynamicFieldName);
            if (staticFields.contains(dynamicFieldName)) continue;
            expandedColumns.add(new ExecutionEngine.Schema.Column(dynamicFieldName, null, fieldType));
        }
        return new ExecutionEngine.Schema(expandedColumns);
    }

    private static List<ExprValue> expandResultRows(List<ExprValue> originalResults, ExecutionEngine.Schema expandedSchema) {
        ArrayList<ExprValue> expandedResults = new ArrayList<ExprValue>();
        for (ExprValue row : originalResults) {
            if (row instanceof ExprTupleValue) {
                expandedResults.add(DynamicFieldsResultProcessor.expandRow((ExprTupleValue)row, expandedSchema));
                continue;
            }
            expandedResults.add(row);
        }
        return expandedResults;
    }

    private static ExprTupleValue expandRow(ExprTupleValue row, ExecutionEngine.Schema expandedSchema) {
        LinkedHashMap<String, ExprValue> expandedRow = new LinkedHashMap<String, ExprValue>();
        Map<String, ExprValue> originalRow = row.tupleValue();
        Map<String, ExprValue> dynamicFields = DynamicFieldsResultProcessor.getDynamicFields(row);
        for (ExecutionEngine.Schema.Column column : expandedSchema.getColumns()) {
            String colName = column.getName();
            expandedRow.put(colName, DynamicFieldsResultProcessor.getColValue(originalRow, dynamicFields, colName));
        }
        return ExprTupleValue.fromExprValueMap(expandedRow);
    }

    private static ExprValue getColValue(Map<String, ExprValue> originalRow, Map<String, ExprValue> dynamicFields, String colName) {
        if (originalRow.containsKey(colName)) {
            return originalRow.get(colName);
        }
        if (dynamicFields.containsKey(colName)) {
            return DynamicFieldsResultProcessor.convertToStringValue(dynamicFields.get(colName));
        }
        return ExprValueUtils.nullValue();
    }

    private static ExprValue convertToStringValue(ExprValue v) {
        if (v instanceof ExprStringValue || v instanceof ExprNullValue) {
            return v;
        }
        return new ExprStringValue(String.valueOf(v));
    }

    private static Map<String, ExprType> getDynamicFieldTypes(List<ExprValue> results) {
        Set<String> fieldNames = DynamicFieldsResultProcessor.collectDynamicFields(results);
        LinkedHashMap<String, ExprType> inferredTypes = new LinkedHashMap<String, ExprType>();
        for (String fieldName : fieldNames) {
            inferredTypes.put(fieldName, ExprCoreType.STRING);
        }
        return inferredTypes;
    }

    private static Set<String> collectDynamicFields(List<ExprValue> results) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (ExprValue row : results) {
            if (!(row instanceof ExprTupleValue)) continue;
            Map<String, ExprValue> dynamicFields = DynamicFieldsResultProcessor.getDynamicFields(row);
            fieldNames.addAll(dynamicFields.keySet());
        }
        return fieldNames;
    }

    private static Map<String, ExprValue> getDynamicFields(ExprValue row) {
        ExprValue mapValue = row.tupleValue().get("_MAP");
        if (mapValue == null || mapValue.isNull() || mapValue.isMissing()) {
            return Map.of();
        }
        if (mapValue instanceof ExprTupleValue) {
            return mapValue.tupleValue();
        }
        return Map.of();
    }

    @Generated
    private DynamicFieldsResultProcessor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

