/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;

public interface Utils {
    public static <I> List<Pair<I, Integer>> zipWithIndex(List<I> input) {
        LinkedList<Pair<I, Integer>> result = new LinkedList<Pair<I, Integer>>();
        Iterator<I> iter = input.iterator();
        int index = 0;
        while (iter.hasNext()) {
            result.add(Pair.of(iter.next(), (Object)index++));
        }
        return result;
    }

    @Nullable
    public static String resolveNestedPath(String path, Map<String, ExprType> fieldTypes) {
        if (path == null || fieldTypes == null || fieldTypes.isEmpty()) {
            return null;
        }
        boolean found = false;
        String current = path;
        String parent = StringUtils.substringBeforeLast((String)current, (String)".");
        while (parent != null && !parent.equals(current)) {
            ExprType pathType = fieldTypes.get(parent);
            if (pathType == ExprCoreType.ARRAY) {
                found = true;
                break;
            }
            current = parent;
            parent = StringUtils.substringBeforeLast((String)current, (String)".");
        }
        if (found) {
            return parent;
        }
        return null;
    }
}

