/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.patterns;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PatternUtils {
    public static final String PATTERN = "pattern";
    public static final String PATTERN_COUNT = "pattern_count";
    public static final String SAMPLE_LOGS = "sample_logs";
    public static final String TOKENS = "tokens";
    public static final String WILDCARD_PREFIX = "<*";
    public static final Pattern WILDCARD_PATTERN = Pattern.compile("<\\*[^>]*>");
    public static final String TOKEN_PREFIX = "<token";
    public static final Pattern TOKEN_PATTERN = Pattern.compile("<token\\d+>");
    public static final List<String> VALID_BRAIN_PARAMETERS = ImmutableList.of((Object)"variable_count_threshold", (Object)"frequency_threshold_percentage");

    public static Map<String, Map<String, Object>> mergePatternGroups(Map<String, Map<String, Object>> left, Map<String, Map<String, Object>> right, int maxSampleCount) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        right.forEach((pattern, stat) -> {
            if (left.containsKey(pattern)) {
                Map leftStat = (Map)left.get(pattern);
                leftStat.put(PATTERN_COUNT, (Long)leftStat.get(PATTERN_COUNT) + (Long)stat.get(PATTERN_COUNT));
                List leftSampleLogs = (List)leftStat.get(SAMPLE_LOGS);
                List rightSampleLogs = (List)stat.get(SAMPLE_LOGS);
                if (leftSampleLogs.size() < maxSampleCount) {
                    leftSampleLogs.addAll(rightSampleLogs.subList(0, Math.min(rightSampleLogs.size(), maxSampleCount - leftSampleLogs.size())));
                }
            } else {
                left.put((String)pattern, (Map<String, Object>)stat);
            }
        });
        return left;
    }

    public static void extractVariables(ParseResult parseResult, String original, Map<String, List<String>> result, String prefix) {
        List<String> parts = parseResult.parts;
        List<Boolean> isToken = parseResult.isToken;
        List<String> tokenOrder = parseResult.tokenOrder;
        if (parts.isEmpty()) {
            return;
        }
        int pos = 0;
        int i = 0;
        int tokenIndex = 0;
        while (i < parts.size()) {
            String currentPart = parts.get(i);
            if (isToken.get(i).booleanValue()) {
                String tokenKey = tokenOrder.get(tokenIndex++);
                if (i == parts.size() - 1) {
                    String value = original.substring(pos);
                    PatternUtils.addToResult(result, tokenKey, value);
                    pos = original.length();
                    ++i;
                    continue;
                }
                String nextStatic = parts.get(i + 1);
                int index = original.indexOf(nextStatic, pos);
                if (index == -1) {
                    return;
                }
                String value = original.substring(pos, index);
                PatternUtils.addToResult(result, tokenKey, value);
                pos = index;
                ++i;
                continue;
            }
            if (original.startsWith(currentPart, pos)) {
                pos += currentPart.length();
                ++i;
                continue;
            }
            return;
        }
    }

    public static ParseResult parsePattern(String pattern, Pattern compiledPattern) {
        ArrayList<String> parts = new ArrayList<String>();
        ArrayList<Boolean> isToken = new ArrayList<Boolean>();
        ArrayList<String> tokenOrder = new ArrayList<String>();
        Matcher matcher = compiledPattern.matcher(pattern);
        int lastEnd = 0;
        int tokenCount = 1;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (start > lastEnd) {
                parts.add(pattern.substring(lastEnd, start));
                isToken.add(false);
            }
            String wildcard = matcher.group();
            parts.add(wildcard);
            isToken.add(true);
            tokenOrder.add(TOKEN_PREFIX + tokenCount++ + ">");
            lastEnd = end;
        }
        if (lastEnd < pattern.length()) {
            parts.add(pattern.substring(lastEnd));
            isToken.add(false);
        }
        return new ParseResult(parts, isToken, tokenOrder);
    }

    private static void addToResult(Map<String, List<String>> result, String key, String value) {
        result.computeIfAbsent(key, k -> new ArrayList()).add(value);
    }

    public static class ParseResult {
        final List<String> parts;
        final List<Boolean> isToken;
        final List<String> tokenOrder;

        public ParseResult(List<String> parts, List<Boolean> isToken, List<String> tokenOrder) {
            this.parts = parts;
            this.isToken = isToken;
            this.tokenOrder = tokenOrder;
        }

        public String toTokenOrderString(String prefix) {
            StringBuilder result = new StringBuilder();
            int tokenIndex = 0;
            for (int i = 0; i < this.parts.size(); ++i) {
                String currentPart = this.parts.get(i);
                if (this.isToken.get(i).booleanValue()) {
                    result.append(this.tokenOrder.get(tokenIndex++));
                    continue;
                }
                result.append(currentPart);
            }
            return result.toString();
        }
    }
}

