/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agent;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.StringSubstitutor;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLAgentType;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.connector.ConnectorClientConfig;
import org.opensearch.ml.common.connector.HttpConnector;
import org.opensearch.ml.common.input.execute.agent.ContentBlock;
import org.opensearch.ml.common.input.execute.agent.ImageContent;
import org.opensearch.ml.common.input.execute.agent.Message;
import org.opensearch.ml.common.input.execute.agent.SourceType;
import org.opensearch.ml.common.input.execute.agent.ToolCall;
import org.opensearch.ml.common.model.ModelProvider;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;

public class OpenaiV1ChatCompletionsModelProvider
extends ModelProvider {
    private static final String REQUEST_BODY_TEMPLATE = "{\"model\":\"${parameters.model}\",\"messages\":[${parameters._chat_history:-}${parameters.body}${parameters._interactions:-}]${parameters.tool_configs:-}}";
    private static final String REQUEST_BODY_REASONING_TEMPLATE = "{\"model\":\"${parameters.model}\",\"messages\":[${parameters._chat_history:-}${parameters.body}${parameters._interactions:-}]${parameters.tool_configs:-},\"reasoning_effort\":\"${parameters.reasoning_effort}\"}";
    private static final String TEXT_INPUT_BODY_TEMPLATE = "{\"role\":\"user\",\"content\":\"${parameters.user_text}\"}";
    private static final String CONTENT_BLOCKS_BODY_TEMPLATE = "{\"role\":\"user\",\"content\":[${parameters.content_array}]}";
    private static final String TEXT_CONTENT_TEMPLATE = "{\"type\":\"text\",\"text\":\"${parameters.content_text}\"}";
    private static final String IMAGE_CONTENT_BASE64_TEMPLATE = "{\"type\":\"image_url\",\"image_url\":{\"url\":\"data:image/${parameters.image_format};base64,${parameters.image_data}\"}}";
    private static final String IMAGE_CONTENT_URL_TEMPLATE = "{\"type\":\"image_url\",\"image_url\":{\"url\":\"${parameters.image_data}\"}}";
    private static final String MESSAGE_TEMPLATE = "{\"role\":\"${parameters.msg_role}\",\"content\":[${parameters.msg_content_array}]}";
    private static final String MESSAGE_WITH_TOOL_CALLS_TEMPLATE = "{\"role\":\"${parameters.msg_role}\",\"content\":[${parameters.msg_content_array}],\"tool_calls\":[${parameters.tool_calls_array}]}";
    private static final String MESSAGE_WITH_TOOL_CALL_ID_TEMPLATE = "{\"role\":\"${parameters.msg_role}\",\"content\":[${parameters.msg_content_array}],\"tool_call_id\":\"${parameters.tool_call_id}\"}";
    private static final String OPENAI_REASONING_EFFORT = "reasoning_effort";

    @Override
    public Connector createConnector(String modelId, Map<String, String> credential, Map<String, String> modelParameters) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("model", modelId);
        if (modelParameters != null) {
            parameters.putAll(modelParameters);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer ${credential.openai_api_key}");
        String requestBody = parameters.containsKey(OPENAI_REASONING_EFFORT) ? REQUEST_BODY_REASONING_TEMPLATE : REQUEST_BODY_TEMPLATE;
        ConnectorAction predictAction = ConnectorAction.builder().actionType(ConnectorAction.ActionType.PREDICT).method("POST").url("https://api.openai.com/v1/chat/completions").headers(headers).requestBody(requestBody).build();
        ConnectorClientConfig connectorClientConfig = new ConnectorClientConfig();
        connectorClientConfig.setMaxRetryTimes(3);
        return HttpConnector.builder().name("Auto-generated OpenAI connector for Agent").description("Auto-generated connector for OpenAI Chat Completions API").version("1").protocol("http").parameters(parameters).credential(credential != null ? credential : new HashMap()).actions(List.of(predictAction)).connectorClientConfig(connectorClientConfig).build();
    }

    @Override
    public MLRegisterModelInput createModelInput(String modelName, Connector connector, Map<String, String> modelParameters) {
        return MLRegisterModelInput.builder().functionName(FunctionName.REMOTE).modelName("Auto-generated model for " + modelName).description("Auto-generated model for agent").connector(connector).build();
    }

    @Override
    public String getLLMInterface() {
        return "openai/v1/chat/completions";
    }

    @Override
    public Map<String, String> mapTextInput(String text, MLAgentType type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        HashMap<String, String> templateParams = new HashMap<String, String>();
        if (type == MLAgentType.PLAN_EXECUTE_AND_REFLECT) {
            templateParams.put("user_text", "${parameters.prompt}");
        } else {
            templateParams.put("user_text", StringEscapeUtils.escapeJson((String)text));
        }
        StringSubstitutor substitutor = new StringSubstitutor(templateParams, "${parameters.", "}");
        String body = substitutor.replace(TEXT_INPUT_BODY_TEMPLATE);
        parameters.put("body", body);
        return parameters;
    }

    @Override
    public Map<String, String> mapContentBlocks(List<ContentBlock> contentBlocks, MLAgentType type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String contentArray = this.buildContentArrayFromBlocks(contentBlocks, type);
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("content_array", contentArray);
        StringSubstitutor substitutor = new StringSubstitutor(templateParams, "${parameters.", "}");
        String body = substitutor.replace(CONTENT_BLOCKS_BODY_TEMPLATE);
        parameters.put("body", body);
        return parameters;
    }

    @Override
    public Map<String, String> mapMessages(List<Message> messages, MLAgentType type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String messagesString = this.buildMessagesArray(messages, type);
        parameters.put("body", messagesString);
        parameters.put("no_escape_params", "_chat_history,_tools,_interactions,tool_configs,body");
        return parameters;
    }

    private String buildContentArrayFromBlocks(List<ContentBlock> blocks, MLAgentType type) {
        if (blocks == null || blocks.isEmpty()) {
            return "";
        }
        StringBuilder contentArray = new StringBuilder();
        boolean first = true;
        for (ContentBlock block : blocks) {
            if (!first) {
                contentArray.append(",");
            }
            first = false;
            switch (block.getType()) {
                case TEXT: {
                    HashMap<String, String> textParams = new HashMap<String, String>();
                    if (type == MLAgentType.PLAN_EXECUTE_AND_REFLECT) {
                        textParams.put("content_text", "${parameters.prompt}");
                    } else {
                        textParams.put("content_text", StringEscapeUtils.escapeJson((String)block.getText()));
                    }
                    StringSubstitutor textSubstitutor = new StringSubstitutor(textParams, "${parameters.", "}");
                    contentArray.append(textSubstitutor.replace(TEXT_CONTENT_TEMPLATE));
                    break;
                }
                case IMAGE: {
                    ImageContent image = block.getImage();
                    HashMap<String, String> imageParams = new HashMap<String, String>();
                    imageParams.put("image_format", image.getFormat());
                    imageParams.put("image_data", StringEscapeUtils.escapeJson((String)image.getData()));
                    String imageTemplate = this.mapImageSourceTypeToOpenAI(image.getType());
                    StringSubstitutor imageSubstitutor = new StringSubstitutor(imageParams, "${parameters.", "}");
                    contentArray.append(imageSubstitutor.replace(imageTemplate));
                    break;
                }
                case VIDEO: {
                    throw new IllegalArgumentException("Video content is not supported in OpenAI Chat Completions API. ");
                }
                case DOCUMENT: {
                    throw new IllegalArgumentException("Document content is not supported in OpenAI Chat Completions API. ");
                }
            }
        }
        return contentArray.toString();
    }

    private String buildMessagesArray(List<Message> messages, MLAgentType type) {
        if (messages == null || messages.isEmpty()) {
            return "";
        }
        StringBuilder messagesArray = new StringBuilder();
        boolean first = true;
        for (Message message : messages) {
            if (!first) {
                messagesArray.append(",");
            }
            first = false;
            String contentArray = this.buildContentArrayFromBlocks(message.getContent(), type);
            HashMap<String, String> msgParams = new HashMap<String, String>();
            msgParams.put("msg_role", message.getRole());
            msgParams.put("msg_content_array", contentArray);
            String template = MESSAGE_TEMPLATE;
            if ("assistant".equalsIgnoreCase(message.getRole()) && message.getToolCalls() != null && !message.getToolCalls().isEmpty()) {
                String toolCallsArray = this.buildToolCallsArray(message.getToolCalls());
                msgParams.put("tool_calls_array", toolCallsArray);
                template = MESSAGE_WITH_TOOL_CALLS_TEMPLATE;
            } else if ("tool".equalsIgnoreCase(message.getRole()) && message.getToolCallId() != null) {
                msgParams.put("tool_call_id", message.getToolCallId());
                template = MESSAGE_WITH_TOOL_CALL_ID_TEMPLATE;
            }
            StringSubstitutor msgSubstitutor = new StringSubstitutor(msgParams, "${parameters.", "}");
            messagesArray.append(msgSubstitutor.replace(template));
        }
        return messagesArray.toString();
    }

    private String buildToolCallsArray(List<ToolCall> toolCalls) {
        if (toolCalls == null || toolCalls.isEmpty()) {
            return "";
        }
        StringBuilder toolCallsArray = new StringBuilder();
        boolean first = true;
        for (ToolCall toolCall : toolCalls) {
            if (!first) {
                toolCallsArray.append(",");
            }
            first = false;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tool_call_id", toolCall.getId());
            params.put("tool_call_type", toolCall.getType() != null ? toolCall.getType() : "function");
            params.put("function_name", toolCall.getFunction().getName());
            params.put("function_arguments", StringEscapeUtils.escapeJson((String)toolCall.getFunction().getArguments()));
            String template = "{\"id\":\"${parameters.tool_call_id}\",\"type\":\"${parameters.tool_call_type}\",\"function\":{\"name\":\"${parameters.function_name}\",\"arguments\":\"${parameters.function_arguments}\"}}";
            StringSubstitutor substitutor = new StringSubstitutor(params, "${parameters.", "}");
            toolCallsArray.append(substitutor.replace(template));
        }
        return toolCallsArray.toString();
    }

    private String mapImageSourceTypeToOpenAI(SourceType sourceType) {
        if (sourceType == null) {
            String supportedTypes = Stream.of(SourceType.values()).map(Enum::name).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Image source type is required. Supported types: " + supportedTypes);
        }
        return switch (sourceType) {
            case SourceType.BASE64 -> IMAGE_CONTENT_BASE64_TEMPLATE;
            case SourceType.URL -> IMAGE_CONTENT_URL_TEMPLATE;
            default -> {
                String supportedTypes = Stream.of(SourceType.values()).map(Enum::name).collect(Collectors.joining(", "));
                throw new IllegalArgumentException("Unsupported image source type. Supported types: " + supportedTypes);
            }
        };
    }
}

