/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agui;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public abstract class BaseEvent
implements ToXContentFragment,
Writeable {
    protected String type;
    protected Long timestamp;
    protected Map<String, Object> rawEvent;

    public BaseEvent(StreamInput input) throws IOException {
        this.type = input.readString();
        this.timestamp = input.readOptionalLong();
        if (input.readBoolean()) {
            this.rawEvent = input.readMap();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeOptionalLong(this.timestamp);
        if (this.rawEvent != null) {
            out.writeBoolean(true);
            out.writeMap(this.rawEvent);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", this.type);
        if (this.timestamp != null) {
            builder.field("timestamp", this.timestamp);
        }
        if (this.rawEvent != null) {
            builder.field("rawEvent", this.rawEvent);
        }
        this.addEventSpecificFields(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract void addEventSpecificFields(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public String toJsonString() {
        try {
            return this.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS).toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize event to JSON", e);
        }
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Map<String, Object> getRawEvent() {
        return this.rawEvent;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setRawEvent(Map<String, Object> rawEvent) {
        this.rawEvent = rawEvent;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseEvent)) {
            return false;
        }
        BaseEvent other = (BaseEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, Object> this$rawEvent = this.getRawEvent();
        Map<String, Object> other$rawEvent = other.getRawEvent();
        return !(this$rawEvent == null ? other$rawEvent != null : !((Object)this$rawEvent).equals(other$rawEvent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, Object> $rawEvent = this.getRawEvent();
        result = result * 59 + ($rawEvent == null ? 43 : ((Object)$rawEvent).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BaseEvent(type=" + this.getType() + ", timestamp=" + this.getTimestamp() + ", rawEvent=" + String.valueOf(this.getRawEvent()) + ")";
    }

    @Generated
    public BaseEvent() {
    }

    @Generated
    public BaseEvent(String type, Long timestamp, Map<String, Object> rawEvent) {
        this.type = type;
        this.timestamp = timestamp;
        this.rawEvent = rawEvent;
    }
}

