/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agui;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.agui.BaseEvent;

public class TextMessageStartEvent
extends BaseEvent {
    public static final String TYPE = "TEXT_MESSAGE_START";
    private String messageId;
    private String role;

    public TextMessageStartEvent(String messageId, String role) {
        super(TYPE, System.currentTimeMillis(), null);
        this.messageId = messageId;
        this.role = role != null ? role : "assistant";
    }

    public TextMessageStartEvent(StreamInput input) throws IOException {
        super(input);
        this.messageId = input.readString();
        this.role = input.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.messageId);
        out.writeString(this.role);
    }

    @Override
    protected void addEventSpecificFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("messageId", this.messageId);
        builder.field("role", this.role);
    }

    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Generated
    public void setRole(String role) {
        this.role = role;
    }

    @Override
    @Generated
    public String toString() {
        return "TextMessageStartEvent(messageId=" + this.getMessageId() + ", role=" + this.getRole() + ")";
    }

    @Generated
    public TextMessageStartEvent() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextMessageStartEvent)) {
            return false;
        }
        TextMessageStartEvent other = (TextMessageStartEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        return !(this$role == null ? other$role != null : !this$role.equals(other$role));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TextMessageStartEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        return result;
    }
}

