/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.httpclient;

import java.time.Duration;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.httpclient.MLValidatableAsyncHttpClient;
import org.opensearch.secure_sm.AccessController;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.utils.AttributeMap;

public class MLHttpClientFactory {
    @Generated
    private static final Logger log = LogManager.getLogger(MLHttpClientFactory.class);

    public static SdkAsyncHttpClient getAsyncHttpClient(Duration connectionTimeout, Duration readTimeout, int maxConnections, boolean connectorPrivateIpEnabled) {
        return MLHttpClientFactory.getAsyncHttpClient(connectionTimeout, readTimeout, maxConnections, connectorPrivateIpEnabled, false);
    }

    public static SdkAsyncHttpClient getAsyncHttpClient(Duration connectionTimeout, Duration readTimeout, int maxConnections, boolean connectorPrivateIpEnabled, boolean skipSslVerification) {
        return (SdkAsyncHttpClient)AccessController.doPrivileged(() -> {
            if (skipSslVerification) {
                log.warn("SSL certificate verification is DISABLED. This connection is vulnerable to man-in-the-middle attacks. Only use this setting in trusted environments.");
            }
            log.debug("Creating MLHttpClient with connectionTimeout: {}, readTimeout: {}, maxConnections: {}, skipSslVerification: {}", (Object)connectionTimeout, (Object)readTimeout, (Object)maxConnections, (Object)skipSslVerification);
            SdkAsyncHttpClient delegate = NettyNioAsyncHttpClient.builder().connectionTimeout(connectionTimeout).readTimeout(readTimeout).maxConcurrency(Integer.valueOf(maxConnections)).buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)skipSslVerification).build());
            return new MLValidatableAsyncHttpClient(delegate, connectorPrivateIpEnabled);
        });
    }
}

