/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public enum Format {
    JDBC("jdbc"),
    CSV("csv"),
    RAW("raw"),
    TABLE("table");

    private final String formatName;
    public static final Map<String, Format> RESPONSE_FORMATS;

    public static Optional<Format> of(String formatName) {
        return Optional.ofNullable(RESPONSE_FORMATS.getOrDefault(formatName, null));
    }

    @Generated
    private Format(String formatName) {
        this.formatName = formatName;
    }

    @Generated
    public String getFormatName() {
        return this.formatName;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)Format.JDBC.formatName, (Object)JDBC);
        builder.put((Object)Format.CSV.formatName, (Object)CSV);
        builder.put((Object)Format.RAW.formatName, (Object)RAW);
        builder.put((Object)Format.TABLE.formatName, (Object)TABLE);
        RESPONSE_FORMATS = builder.build();
    }
}

