/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.lookup.Lookup;
import org.apache.calcite.schema.lookup.SnapshotLookup;
import org.apache.calcite.util.NameMap;
import org.apache.calcite.util.NameMultimap;
import org.apache.calcite.util.NameSet;
import org.checkerframework.checker.nullness.qual.Nullable;

class CachingCalciteSchema
extends CalciteSchema {
    private final ConcurrentLinkedDeque<SnapshotLookup<?>> caches = new ConcurrentLinkedDeque();
    private final Cached<NameSet> implicitFunctionCache = new AbstractCached<NameSet>(){

        @Override
        public NameSet build() {
            return NameSet.immutableCopyOf(CachingCalciteSchema.this.schema.getFunctionNames());
        }
    };
    private final Cached<NameSet> implicitTypeCache = new AbstractCached<NameSet>(){

        @Override
        public NameSet build() {
            return NameSet.immutableCopyOf(CachingCalciteSchema.this.schema.getTypeNames());
        }
    };
    private boolean cache = true;

    CachingCalciteSchema(@Nullable CalciteSchema parent, Schema schema, String name) {
        this(parent, schema, name, null, null, null, null, null, null, null, null);
    }

    private CachingCalciteSchema(@Nullable CalciteSchema parent, Schema schema, String name, @Nullable NameMap<CalciteSchema> subSchemaMap, @Nullable NameMap<CalciteSchema.TableEntry> tableMap, @Nullable NameMap<CalciteSchema.LatticeEntry> latticeMap, @Nullable NameMap<CalciteSchema.TypeEntry> typeMap, @Nullable NameMultimap<CalciteSchema.FunctionEntry> functionMap, @Nullable NameSet functionNames, @Nullable NameMap<CalciteSchema.FunctionEntry> nullaryFunctionMap, @Nullable List<? extends List<String>> path) {
        super(parent, schema, name, subSchemaMap, tableMap, latticeMap, typeMap, functionMap, functionNames, nullaryFunctionMap, path);
    }

    @Override
    public void setCache(boolean cache) {
        if (cache == this.cache) {
            return;
        }
        this.enableCaches(cache);
        long now = System.currentTimeMillis();
        this.implicitFunctionCache.enable(now, cache);
        this.cache = cache;
    }

    @Override
    protected boolean isCacheEnabled() {
        return this.cache;
    }

    @Override
    protected CalciteSchema createSubSchema(Schema schema, String name) {
        return new CachingCalciteSchema(this, schema, name);
    }

    @Override
    protected <S> Lookup<S> enhanceLookup(Lookup<S> lookup) {
        SnapshotLookup<S> snapshotLookup = new SnapshotLookup<S>(lookup);
        this.caches.add(snapshotLookup);
        return snapshotLookup;
    }

    @Override
    public CalciteSchema add(String name, Schema schema) {
        CachingCalciteSchema calciteSchema = new CachingCalciteSchema(this, schema, name);
        this.subSchemaMap.put(name, calciteSchema);
        return calciteSchema;
    }

    @Override
    protected @Nullable CalciteSchema.TypeEntry getImplicitType(String name, boolean caseSensitive) {
        long now = System.currentTimeMillis();
        NameSet implicitTypeNames = this.implicitTypeCache.get(now);
        for (String typeName : implicitTypeNames.range(name, caseSensitive)) {
            RelProtoDataType type = this.schema.getType(typeName);
            if (type == null) continue;
            return this.typeEntry(name, type);
        }
        return null;
    }

    @Override
    protected void addImplicitFunctionsToBuilder(ImmutableList.Builder<Function> builder, String name, boolean caseSensitive) {
        long now = System.currentTimeMillis();
        NameSet set = this.implicitFunctionCache.get(now);
        for (String name2 : set.range(name, caseSensitive)) {
            Collection<Function> functions = this.schema.getFunctions(name2);
            if (functions == null) continue;
            builder.addAll(functions);
        }
    }

    @Override
    protected void addImplicitFuncNamesToBuilder(ImmutableSortedSet.Builder<String> builder) {
        long now = System.currentTimeMillis();
        NameSet set = this.implicitFunctionCache.get(now);
        builder.addAll(set.iterable());
    }

    @Override
    protected void addImplicitTypeNamesToBuilder(ImmutableSortedSet.Builder<String> builder) {
        long now = System.currentTimeMillis();
        NameSet set = this.implicitTypeCache.get(now);
        builder.addAll(set.iterable());
    }

    @Override
    protected void addImplicitTablesBasedOnNullaryFunctionsToBuilder(ImmutableSortedMap.Builder<String, Table> builder) {
        ImmutableSortedMap explicitTables = builder.build();
        long now = System.currentTimeMillis();
        NameSet set = this.implicitFunctionCache.get(now);
        for (String s : set.iterable()) {
            if (explicitTables.containsKey((Object)s)) continue;
            for (Function function : this.schema.getFunctions(s)) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply((List<? extends Object>)ImmutableList.of());
                builder.put((Object)s, (Object)table);
            }
        }
    }

    @Override
    protected @Nullable CalciteSchema.TableEntry getImplicitTableBasedOnNullaryFunction(String tableName, boolean caseSensitive) {
        long now = System.currentTimeMillis();
        NameSet set = this.implicitFunctionCache.get(now);
        for (String s : set.range(tableName, caseSensitive)) {
            for (Function function : this.schema.getFunctions(s)) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply((List<? extends Object>)ImmutableList.of());
                return this.tableEntry(tableName, table);
            }
        }
        return null;
    }

    @Override
    protected CalciteSchema snapshot(@Nullable CalciteSchema parent, SchemaVersion version) {
        CachingCalciteSchema snapshot = new CachingCalciteSchema(parent, this.schema.snapshot(version), this.name, null, this.tableMap, this.latticeMap, this.typeMap, this.functionMap, this.functionNames, this.nullaryFunctionMap, this.getPath());
        for (CalciteSchema subSchema : this.subSchemaMap.map().values()) {
            CalciteSchema subSchemaSnapshot = subSchema.snapshot(snapshot, version);
            snapshot.subSchemaMap.put(subSchema.name, subSchemaSnapshot);
        }
        return snapshot;
    }

    @Override
    public boolean removeTable(String name) {
        if (this.cache) {
            this.enableCaches(false);
            this.enableCaches(true);
        }
        return super.removeTable(name);
    }

    @Override
    public boolean removeFunction(String name) {
        if (this.cache) {
            long now = System.nanoTime();
            this.implicitFunctionCache.enable(now, false);
            this.implicitFunctionCache.enable(now, true);
        }
        return super.removeFunction(name);
    }

    private void enableCaches(boolean cache) {
        for (SnapshotLookup<?> lookupCache : this.caches) {
            lookupCache.enable(cache);
        }
    }

    private abstract class AbstractCached<T>
    implements Cached<T> {
        @Nullable T t;
        boolean built = false;

        private AbstractCached() {
        }

        @Override
        public T get(long now) {
            if (!CachingCalciteSchema.this.cache) {
                return this.build();
            }
            if (!this.built) {
                this.t = this.build();
            }
            this.built = true;
            return (T)Nullness.castNonNull(this.t);
        }

        @Override
        public void enable(long now, boolean enabled) {
            if (!enabled) {
                this.t = null;
            }
            this.built = false;
        }
    }

    private static interface Cached<T> {
        public T get(long var1);

        public T build();

        public void enable(long var1, boolean var3);
    }
}

