/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;

public class Combine
extends AbstractRelNode {
    protected final ImmutableList<RelNode> inputs;

    public static Combine create(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs) {
        return new Combine(cluster, traitSet, inputs);
    }

    public Combine(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs) {
        super(cluster, traitSet);
        this.inputs = ImmutableList.copyOf(inputs);
    }

    @Override
    public List<RelNode> getInputs() {
        return this.inputs;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord ord : Ord.zip(this.inputs)) {
            pw.input("input#" + ord.i, (RelNode)ord.e);
        }
        return pw;
    }

    @Override
    protected RelDataType deriveRowType() {
        RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (int i = 0; i < this.inputs.size(); ++i) {
            RelNode input = (RelNode)this.inputs.get(i);
            ((RelDataTypeFactory.Builder)builder).add("QUERY_" + i, input.getRowType());
        }
        return builder.build();
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = 0.0;
        for (RelNode input : this.inputs) {
            Double inputRows = mq.getRowCount(input);
            rowCount += inputRows.doubleValue();
        }
        return planner.getCostFactory().makeCost(rowCount, rowCount * 0.01, 0.0);
    }
}

