/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.rules.ConflictDetectionHelper;
import org.apache.calcite.rel.rules.ConflictRule;
import org.apache.calcite.rel.rules.HyperEdge;
import org.apache.calcite.rel.rules.HyperGraph;
import org.apache.calcite.rel.rules.ImmutableJoinToHyperGraphRule;
import org.apache.calcite.rel.rules.LongBitmap;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexNode;
import org.immutables.value.Value;

@Value.Enclosing
public class JoinToHyperGraphRule
extends RelRule<Config>
implements TransformationRule {
    protected JoinToHyperGraphRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        int leftNodeCount;
        Join origJoin = (Join)call.rel(0);
        Object left = call.rel(1);
        Object right = call.rel(2);
        if (!JoinToHyperGraphRule.supportedJoinType(origJoin.getJoinType())) {
            return;
        }
        long notProjectInputs = 0L;
        ArrayList<RelNode> inputs = new ArrayList<RelNode>();
        ArrayList<HyperEdge> leftSubEdges = new ArrayList<HyperEdge>();
        ArrayList<HyperEdge> rightSubEdges = new ArrayList<HyperEdge>();
        ArrayList<RexNode> joinConds = new ArrayList<RexNode>();
        if (origJoin.getCondition().isAlwaysTrue() || origJoin.getJoinType() != JoinRelType.INNER) {
            joinConds.add(origJoin.getCondition());
        } else {
            RelOptUtil.decomposeConjunction(origJoin.getCondition(), joinConds);
        }
        if (left instanceof HyperGraph && right instanceof HyperGraph) {
            leftNodeCount = left.getInputs().size();
            inputs.addAll(left.getInputs());
            inputs.addAll(right.getInputs());
            notProjectInputs |= ((HyperGraph)left).getNotProjectInputs();
            notProjectInputs |= ((HyperGraph)right).getNotProjectInputs() << leftNodeCount;
            leftSubEdges.addAll(((HyperGraph)left).getEdges());
            rightSubEdges.addAll(((HyperGraph)right).getEdges().stream().map(hyperEdge -> hyperEdge.adjustNodeBit(leftNodeCount)).collect(Collectors.toList()));
        } else if (left instanceof HyperGraph) {
            leftNodeCount = left.getInputs().size();
            inputs.addAll(left.getInputs());
            inputs.add((RelNode)right);
            notProjectInputs |= ((HyperGraph)left).getNotProjectInputs();
            leftSubEdges.addAll(((HyperGraph)left).getEdges());
        } else if (right instanceof HyperGraph) {
            leftNodeCount = 1;
            inputs.add((RelNode)left);
            inputs.addAll(right.getInputs());
            notProjectInputs |= ((HyperGraph)right).getNotProjectInputs() << leftNodeCount;
            rightSubEdges.addAll(((HyperGraph)right).getEdges().stream().map(hyperEdge -> hyperEdge.adjustNodeBit(leftNodeCount)).collect(Collectors.toList()));
        } else {
            leftNodeCount = 1;
            inputs.add((RelNode)left);
            inputs.add((RelNode)right);
        }
        if (inputs.size() > 64) {
            return;
        }
        List<ConflictRule> conflictRules = ConflictDetectionHelper.makeConflictRules(leftSubEdges, rightSubEdges, origJoin.getJoinType());
        HashMap<Integer, Integer> inputRefToNodeIndexMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> inputRefToFieldIndexMap = new HashMap<Integer, Integer>();
        int inputRef = 0;
        for (int nodeIndex = 0; nodeIndex < inputs.size(); ++nodeIndex) {
            if (LongBitmap.isOverlap(notProjectInputs, LongBitmap.newBitmap(nodeIndex))) continue;
            int fieldCount = ((RelNode)inputs.get(nodeIndex)).getRowType().getFieldCount();
            for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
                inputRefToNodeIndexMap.put(inputRef, nodeIndex);
                inputRefToFieldIndexMap.put(inputRef, fieldIndex);
                ++inputRef;
            }
        }
        List<HyperEdge> edges = HyperEdge.createHyperEdgesFromJoinConds(inputRefToNodeIndexMap, inputRefToFieldIndexMap, joinConds, conflictRules, origJoin.getJoinType(), leftNodeCount, inputs.size());
        edges.addAll(leftSubEdges);
        edges.addAll(rightSubEdges);
        if (!origJoin.getJoinType().projectsRight()) {
            notProjectInputs |= LongBitmap.newBitmapBetween(leftNodeCount, inputs.size());
        }
        HyperGraph hyperGraph = new HyperGraph(origJoin.getCluster(), origJoin.getTraitSet(), inputs, notProjectInputs, edges, origJoin.getRowType());
        call.transformTo(hyperGraph);
    }

    private static boolean supportedJoinType(JoinRelType joinType) {
        return joinType == JoinRelType.INNER || joinType == JoinRelType.LEFT || joinType == JoinRelType.FULL || joinType == JoinRelType.SEMI || joinType == JoinRelType.ANTI;
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableJoinToHyperGraphRule.Config.of().withOperandSupplier(b1 -> b1.operand(Join.class).inputs(b2 -> b2.operand(RelNode.class).anyInputs(), b3 -> b3.operand(RelNode.class).anyInputs()));

        @Override
        default public JoinToHyperGraphRule toRule() {
            return new JoinToHyperGraphRule(this);
        }
    }
}

