/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.calcite.DataContexts;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.plan.PlanTooComplexError;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLambda;
import org.apache.calcite.rex.RexLambdaRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexNodeAndFieldIndex;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexVariable;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.RangeSets;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RexUtil {
    public static final RexExecutor EXECUTOR = new RexExecutorImpl(DataContexts.EMPTY);
    public static final RexFinder M2V_FINDER = RexUtil.find(SqlKind.M2V);

    private RexUtil() {
    }

    public static double getSelectivity(@Nullable RexNode exp) {
        if (exp == null || exp.isAlwaysTrue()) {
            return 1.0;
        }
        return 0.1;
    }

    public static List<RexNode> generateCastExpressions(RexBuilder rexBuilder, RelDataType lhsRowType, RelDataType rhsRowType) {
        List<RelDataTypeField> fieldList = rhsRowType.getFieldList();
        int n = fieldList.size();
        assert (n == lhsRowType.getFieldCount()) : "field count: lhs [" + lhsRowType + "] rhs [" + rhsRowType + "]";
        ArrayList<RexNode> rhsExps = new ArrayList<RexNode>();
        for (RelDataTypeField field : fieldList) {
            rhsExps.add(rexBuilder.makeInputRef(field.getType(), field.getIndex()));
        }
        return RexUtil.generateCastExpressions(rexBuilder, lhsRowType, rhsExps);
    }

    public static List<RexNode> generateCastExpressions(RexBuilder rexBuilder, RelDataType lhsRowType, List<RexNode> rhsExps) {
        List<RelDataTypeField> lhsFields = lhsRowType.getFieldList();
        ArrayList<RexNode> castExps = new ArrayList<RexNode>();
        for (Pair<RelDataTypeField, RexNode> pair : Pair.zip(lhsFields, rhsExps, true)) {
            RexNode rhsExp;
            RelDataType rhsType;
            RelDataTypeField lhsField = (RelDataTypeField)pair.left;
            RelDataType lhsType = lhsField.getType();
            if (lhsType.equals(rhsType = (rhsExp = (RexNode)pair.right).getType())) {
                castExps.add(rhsExp);
                continue;
            }
            castExps.add(rexBuilder.makeCast(lhsType, rhsExp, true, false));
        }
        return castExps;
    }

    public static boolean isNullLiteral(RexNode node, boolean allowCast) {
        if (node instanceof RexLiteral) {
            RexLiteral literal = (RexLiteral)node;
            if (literal.getTypeName() == SqlTypeName.NULL) {
                assert (null == literal.getValue());
                return true;
            }
            return false;
        }
        if (allowCast && node.isA(SqlKind.CAST)) {
            RexCall call = (RexCall)node;
            return RexUtil.isNullLiteral((RexNode)call.operands.get(0), false);
        }
        return false;
    }

    public static boolean isNull(RexNode expr) {
        switch (expr.getKind()) {
            case LITERAL: {
                return ((RexLiteral)expr).getValue2() == null;
            }
            case CAST: {
                return RexUtil.isNull((RexNode)((RexCall)expr).operands.get(0));
            }
        }
        return false;
    }

    public static boolean isSymbolLiteral(RexNode expr) {
        switch (expr.getKind()) {
            case LITERAL: {
                return ((RexLiteral)expr).getTypeName() == SqlTypeName.SYMBOL;
            }
            case CAST: {
                return RexUtil.isSymbolLiteral((RexNode)((RexCall)expr).operands.get(0));
            }
        }
        return false;
    }

    public static boolean isLiteral(RexNode node, boolean allowCast) {
        Objects.requireNonNull(node, "node");
        if (node.isA(SqlKind.LITERAL)) {
            return true;
        }
        if (allowCast && node.isA(SqlKind.CAST)) {
            RexCall call = (RexCall)node;
            return RexUtil.isLiteral((RexNode)call.operands.get(0), false);
        }
        return false;
    }

    public static boolean allLiterals(List<RexNode> expressionOperands) {
        for (RexNode rexNode : expressionOperands) {
            if (RexUtil.isLiteral(rexNode, true)) continue;
            return false;
        }
        return true;
    }

    public static boolean isReferenceOrAccess(RexNode node, boolean allowCast) {
        Objects.requireNonNull(node, "node");
        if (node instanceof RexInputRef || node instanceof RexFieldAccess) {
            return true;
        }
        if (allowCast && node.isA(SqlKind.CAST)) {
            RexCall call = (RexCall)node;
            return RexUtil.isReferenceOrAccess((RexNode)call.operands.get(0), false);
        }
        return false;
    }

    public static boolean isNullabilityCast(RelDataTypeFactory typeFactory, RexNode node) {
        switch (node.getKind()) {
            case CAST: {
                RexCall call = (RexCall)node;
                RexNode arg0 = call.getOperands().get(0);
                return SqlTypeUtil.equalSansNullability(typeFactory, arg0.getType(), call.getType());
            }
        }
        return false;
    }

    public static RexNode removeNullabilityCast(RelDataTypeFactory typeFactory, RexNode node) {
        while (RexUtil.isNullabilityCast(typeFactory, node)) {
            node = (RexNode)((RexCall)node).operands.get(0);
        }
        return node;
    }

    public static RexNode removeCast(RexNode e) {
        block3: while (true) {
            switch (e.getKind()) {
                case CAST: {
                    e = (RexNode)((RexCall)e).operands.get(0);
                    continue block3;
                }
            }
            break;
        }
        return e;
    }

    public static <C extends RexNode> ImmutableMap<RexNode, C> predicateConstants(Class<C> clazz, RexBuilder rexBuilder, List<RexNode> predicates) {
        HashMap map = new HashMap();
        HashSet<RexNode> excludeSet = new HashSet<RexNode>();
        for (RexNode predicate : predicates) {
            RexUtil.gatherConstraints(clazz, predicate, map, excludeSet, rexBuilder);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : map.entrySet()) {
            RexNode rexNode = (RexNode)entry.getKey();
            if (RexUtil.overlap(rexNode, excludeSet)) continue;
            builder.put((Object)rexNode, entry.getValue());
        }
        return builder.build();
    }

    private static boolean overlap(RexNode rexNode, Set<RexNode> set) {
        if (rexNode instanceof RexCall) {
            for (RexNode r : ((RexCall)rexNode).getOperands()) {
                if (!RexUtil.overlap(r, set)) continue;
                return true;
            }
            return false;
        }
        return set.contains(rexNode);
    }

    private static void decompose(Set<RexNode> set, RexNode rexNode) {
        if (rexNode instanceof RexCall) {
            for (RexNode r : ((RexCall)rexNode).getOperands()) {
                RexUtil.decompose(set, r);
            }
        } else if (!(rexNode instanceof RexLiteral)) {
            set.add(rexNode);
        }
    }

    private static <C extends RexNode> void gatherConstraints(Class<C> clazz, RexNode predicate, Map<RexNode, C> map, Set<RexNode> excludeSet, RexBuilder rexBuilder) {
        RexNode right;
        RexNode left;
        switch (predicate.getKind()) {
            case EQUALS: 
            case IS_NOT_DISTINCT_FROM: {
                left = ((RexCall)predicate).getOperands().get(0);
                right = ((RexCall)predicate).getOperands().get(1);
                break;
            }
            case IS_NULL: {
                left = ((RexCall)predicate).getOperands().get(0);
                if (!left.getType().isNullable()) {
                    return;
                }
                right = rexBuilder.makeNullLiteral(left.getType());
                break;
            }
            default: {
                RexUtil.decompose(excludeSet, predicate);
                return;
            }
        }
        RexUtil.gatherConstraint(clazz, left, right, map, excludeSet, rexBuilder);
        RexUtil.gatherConstraint(clazz, right, left, map, excludeSet, rexBuilder);
    }

    private static <C extends RexNode> void gatherConstraint(Class<C> clazz, RexNode left, RexNode right, Map<RexNode, C> map, Set<RexNode> excludeSet, RexBuilder rexBuilder) {
        if (!clazz.isInstance(right)) {
            return;
        }
        if (!RexUtil.isConstant(right)) {
            return;
        }
        RexNode constant = (RexNode)clazz.cast(right);
        if (excludeSet.contains(left)) {
            return;
        }
        RexNode existedValue = (RexNode)map.get(left);
        if (existedValue == null) {
            switch (left.getKind()) {
                case CAST: {
                    RexNode castRight;
                    RexNode operand = ((RexCall)left).getOperands().get(0);
                    if (!RexUtil.canAssignFrom(left.getType(), operand.getType(), rexBuilder.getTypeFactory()) || !((castRight = rexBuilder.makeCast(operand.getType(), constant)) instanceof RexLiteral)) break;
                    left = operand;
                    constant = (RexNode)clazz.cast(castRight);
                    break;
                }
            }
            map.put(left, constant);
        } else if (existedValue instanceof RexLiteral && constant instanceof RexLiteral && !Objects.equals(((RexLiteral)existedValue).getValue(), ((RexLiteral)constant).getValue())) {
            map.remove(left);
            excludeSet.add(left);
        }
    }

    private static boolean canAssignFrom(RelDataType type1, RelDataType type2, RelDataTypeFactory typeFactory) {
        SqlTypeName name1 = type1.getSqlTypeName();
        SqlTypeName name2 = type2.getSqlTypeName();
        RelDataType type1Final = type1;
        SqlTypeFamily family = Objects.requireNonNull(name1.getFamily(), () -> "SqlTypeFamily is null for type " + type1Final + ", SqlTypeName " + (Object)((Object)name1));
        if (family == name2.getFamily()) {
            switch (family) {
                case NUMERIC: {
                    if (SqlTypeUtil.isExactNumeric(type1) && SqlTypeUtil.isExactNumeric(type2)) {
                        int scale2;
                        int precision2;
                        int scale1;
                        int precision1;
                        if (name1 == SqlTypeName.DECIMAL) {
                            type1 = typeFactory.decimalOf(type1);
                            precision1 = type1.getPrecision();
                            scale1 = type1.getScale();
                        } else {
                            precision1 = typeFactory.getTypeSystem().getMaxPrecision(name1);
                            scale1 = typeFactory.getTypeSystem().getMaxScale(name1);
                        }
                        if (name2 == SqlTypeName.DECIMAL) {
                            type2 = typeFactory.decimalOf(type2);
                            precision2 = type2.getPrecision();
                            scale2 = type2.getScale();
                        } else {
                            precision2 = typeFactory.getTypeSystem().getMaxPrecision(name2);
                            scale2 = typeFactory.getTypeSystem().getMaxScale(name2);
                        }
                        return precision1 >= precision2 && scale1 >= scale2;
                    }
                    if (!SqlTypeUtil.isApproximateNumeric(type1) || !SqlTypeUtil.isApproximateNumeric(type2)) break;
                    return type1.getPrecision() >= type2.getPrecision() && type1.getScale() >= type2.getScale();
                }
                default: {
                    return type1.getPrecision() >= type2.getPrecision();
                }
            }
        }
        return false;
    }

    public static int nodeCount(List<? extends RexNode> nodes) {
        return RexUtil.nodeCount(0, nodes);
    }

    static int nodeCount(int n, List<? extends RexNode> nodes) {
        for (RexNode rexNode : nodes) {
            n += rexNode.nodeCount();
        }
        return n;
    }

    public static RexFinder find(final SqlKind kind) {
        return new RexFinder(){

            @Override
            public Void visitCall(RexCall call) {
                if (call.getKind() == kind) {
                    throw Util.FoundOne.NULL;
                }
                return (Void)super.visitCall(call);
            }
        };
    }

    public static RexFinder find(final Set<SqlKind> kinds) {
        return new RexFinder(){

            @Override
            public Void visitCall(RexCall call) {
                if (kinds.contains((Object)call.getKind())) {
                    throw Util.FoundOne.NULL;
                }
                return (Void)super.visitCall(call);
            }
        };
    }

    public static RexFinder find(final RexInputRef ref) {
        return new RexFinder(){

            @Override
            public Void visitInputRef(RexInputRef inputRef) {
                if (ref.equals(inputRef)) {
                    throw Util.FoundOne.NULL;
                }
                return (Void)super.visitInputRef(inputRef);
            }
        };
    }

    public static RexNode expandSearch(RexBuilder rexBuilder, @Nullable RexProgram program, RexNode node) {
        return RexUtil.expandSearch(rexBuilder, program, node, -1);
    }

    public static RexNode expandSearch(RexBuilder rexBuilder, @Nullable RexProgram program, RexNode node, int maxComplexity) {
        return node.accept(RexUtil.searchShuttle(rexBuilder, program, maxComplexity));
    }

    public static RexShuttle searchShuttle(RexBuilder rexBuilder, @Nullable RexProgram program, int maxComplexity) {
        return new SearchExpandingShuttle(program, rexBuilder, maxComplexity);
    }

    public static <C extends Comparable<C>> RexNode sargRef(RexBuilder rexBuilder, RexNode ref, Sarg<C> sarg, RelDataType type, RexUnknownAs unknownAs) {
        if (sarg.isAll() || sarg.isNone()) {
            return RexUtil.simpleSarg(rexBuilder, ref, sarg, unknownAs);
        }
        ArrayList<RexNode> orList = new ArrayList<RexNode>();
        if (sarg.nullAs == RexUnknownAs.TRUE && unknownAs == RexUnknownAs.UNKNOWN) {
            orList.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, ref));
        }
        if (sarg.isPoints()) {
            sarg.rangeSet.asRanges().forEach(range -> orList.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, ref, rexBuilder.makeLiteral(range.lowerEndpoint(), type, true, true))));
        } else if (sarg.isComplementedPoints()) {
            List list = (List)sarg.rangeSet.complement().asRanges().stream().map(range -> rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, ref, rexBuilder.makeLiteral(range.lowerEndpoint(), type, true, true))).collect(ImmutableList.toImmutableList());
            orList.add(RexUtil.composeConjunction(rexBuilder, list));
        } else {
            RangeToRex consumer = new RangeToRex(ref, orList, rexBuilder, type);
            RangeSets.forEach(sarg.rangeSet, consumer);
        }
        RexNode node = RexUtil.composeDisjunction(rexBuilder, orList);
        if (sarg.nullAs == RexUnknownAs.FALSE && unknownAs == RexUnknownAs.UNKNOWN) {
            node = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, ref), node);
        }
        return node;
    }

    public static <C extends Comparable<C>> RexNode simpleSarg(RexBuilder rexBuilder, RexNode ref, Sarg<C> sarg, RexUnknownAs unknownAs) {
        RexUnknownAs nullAs;
        assert (sarg.isAll() || sarg.isNone());
        RexUnknownAs rexUnknownAs = nullAs = sarg.nullAs == RexUnknownAs.UNKNOWN ? unknownAs : sarg.nullAs;
        if (sarg.isAll()) {
            switch (nullAs) {
                case TRUE: {
                    return rexBuilder.makeLiteral(true);
                }
                case FALSE: {
                    return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, ref);
                }
                case UNKNOWN: {
                    return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, ref), rexBuilder.makeNullLiteral(rexBuilder.typeFactory.createSqlType(SqlTypeName.BOOLEAN)));
                }
            }
        }
        if (sarg.isNone()) {
            switch (nullAs) {
                case TRUE: {
                    return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, ref);
                }
                case FALSE: {
                    return rexBuilder.makeLiteral(false);
                }
                case UNKNOWN: {
                    return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, ref, ref);
                }
            }
        }
        throw new AssertionError();
    }

    private static RexNode deref(@Nullable RexProgram program, RexNode node) {
        while (node instanceof RexLocalRef) {
            node = Objects.requireNonNull(program, "program").getExprList().get(((RexLocalRef)node).index);
        }
        return node;
    }

    public static boolean isConstant(RexNode node) {
        return node.accept(ConstantFinder.INSTANCE);
    }

    public static boolean isDeterministic(RexNode e) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitCall(RexCall call) {
                    if (!call.getOperator().isDeterministic()) {
                        throw Util.FoundOne.NULL;
                    }
                    return (Void)super.visitCall(call);
                }
            };
            e.accept(visitor);
            return true;
        }
        catch (Util.FoundOne ex) {
            Util.swallow(ex, null);
            return false;
        }
    }

    public static List<RexNode> retainDeterministic(List<RexNode> list) {
        ArrayList<RexNode> conjunctions = new ArrayList<RexNode>();
        for (RexNode x : list) {
            if (!RexUtil.isDeterministic(x)) continue;
            conjunctions.add(x);
        }
        return conjunctions;
    }

    public static @Nullable RexCall findOperatorCall(final SqlOperator operator, RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitCall(RexCall call) {
                    if (call.getOperator().equals(operator)) {
                        throw new Util.FoundOne(call);
                    }
                    return (Void)super.visitCall(call);
                }
            };
            node.accept(visitor);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (RexCall)e.getNode();
        }
    }

    public static boolean containsInputRef(RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitInputRef(RexInputRef inputRef) {
                    throw new Util.FoundOne(inputRef);
                }
            };
            node.accept(visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsFieldAccess(RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitFieldAccess(RexFieldAccess fieldAccess) {
                    throw new Util.FoundOne(fieldAccess);
                }
            };
            node.accept(visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean requiresDecimalExpansion(RexNode expr, boolean recurse) {
        if (!(expr instanceof RexCall)) {
            return false;
        }
        RexCall call = (RexCall)expr;
        boolean localCheck = true;
        switch (call.getKind()) {
            case IS_NULL: 
            case REINTERPRET: {
                localCheck = false;
                break;
            }
            case CAST: {
                RelDataType lhsType = call.getType();
                RelDataType rhsType = ((RexNode)call.operands.get(0)).getType();
                if (rhsType.getSqlTypeName() == SqlTypeName.NULL) {
                    return false;
                }
                if (SqlTypeUtil.inCharFamily(lhsType) || SqlTypeUtil.inCharFamily(rhsType)) {
                    localCheck = false;
                    break;
                }
                if (!SqlTypeUtil.isDecimal(lhsType) || lhsType == rhsType) break;
                return true;
            }
            default: {
                localCheck = call.getOperator().requiresDecimalExpansion();
            }
        }
        if (localCheck) {
            if (SqlTypeUtil.isDecimal(call.getType())) {
                return true;
            }
            for (int i = 0; i < call.operands.size(); ++i) {
                if (!SqlTypeUtil.isDecimal(((RexNode)call.operands.get(i)).getType())) continue;
                return true;
            }
        }
        return recurse && RexUtil.requiresDecimalExpansion(call.operands, true);
    }

    public static boolean requiresDecimalExpansion(List<RexNode> operands, boolean recurse) {
        for (RexNode operand : operands) {
            RexCall call;
            if (!(operand instanceof RexCall) || !RexUtil.requiresDecimalExpansion(call = (RexCall)operand, recurse)) continue;
            return true;
        }
        return false;
    }

    public static boolean requiresDecimalExpansion(RexProgram program, boolean recurse) {
        List<RexNode> exprList = program.getExprList();
        for (RexNode expr : exprList) {
            if (!RexUtil.requiresDecimalExpansion(expr, recurse)) continue;
            return true;
        }
        return false;
    }

    public static boolean canReinterpretOverflow(RexCall call) {
        assert (call.isA(SqlKind.REINTERPRET)) : "call is not a reinterpret";
        return call.operands.size() > 1;
    }

    public static boolean containNoCommonExprs(List<RexNode> exprs, Litmus litmus) {
        ExpressionNormalizer visitor = new ExpressionNormalizer(false);
        for (RexNode expr : exprs) {
            try {
                expr.accept(visitor);
            }
            catch (ExpressionNormalizer.SubExprExistsException e) {
                Util.swallow(e, null);
                return litmus.fail(null, new Object[0]);
            }
        }
        return litmus.succeed();
    }

    public static boolean containNoForwardRefs(List<RexNode> exprs, RelDataType inputRowType, Litmus litmus) {
        ForwardRefFinder visitor = new ForwardRefFinder(inputRowType);
        for (int i = 0; i < exprs.size(); ++i) {
            RexNode expr = exprs.get(i);
            visitor.setLimit(i);
            try {
                expr.accept(visitor);
                continue;
            }
            catch (ForwardRefFinder.IllegalForwardRefException e) {
                Util.swallow(e, null);
                return litmus.fail("illegal forward reference in {}", expr);
            }
        }
        return litmus.succeed();
    }

    static boolean containNoNonTrivialAggs(List<RexNode> exprs, Litmus litmus) {
        for (RexNode expr : exprs) {
            RexCall rexCall;
            if (!(expr instanceof RexCall) || !((rexCall = (RexCall)expr).getOperator() instanceof SqlAggFunction)) continue;
            for (RexNode operand : rexCall.operands) {
                if (operand instanceof RexLocalRef || operand instanceof RexLiteral) continue;
                return litmus.fail("contains non trivial agg: {}", operand);
            }
        }
        return litmus.succeed();
    }

    public static boolean containComplexExprs(List<RexNode> exprs) {
        for (RexNode expr : exprs) {
            if (!(expr instanceof RexCall)) continue;
            for (RexNode operand : ((RexCall)expr).operands) {
                if (RexUtil.isAtomic(operand)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsTableInputRef(List<RexNode> nodes) {
        for (RexNode e : nodes) {
            if (RexUtil.containsTableInputRef(e) == null) continue;
            return true;
        }
        return false;
    }

    public static @Nullable RexTableInputRef containsTableInputRef(RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitTableInputRef(RexTableInputRef inputRef) {
                    throw new Util.FoundOne(inputRef);
                }
            };
            node.accept(visitor);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (RexTableInputRef)e.getNode();
        }
    }

    public static boolean isAtomic(RexNode expr) {
        return expr instanceof RexLiteral || expr instanceof RexVariable;
    }

    public static boolean isCallTo(RexNode expr, SqlOperator op) {
        return expr instanceof RexCall && ((RexCall)expr).getOperator() == op;
    }

    public static RelDataType createStructType(RelDataTypeFactory typeFactory, List<RexNode> exprs) {
        return RexUtil.createStructType(typeFactory, exprs, null, null);
    }

    public static RelDataType createStructType(RelDataTypeFactory typeFactory, List<? extends RexNode> exprs, @Nullable List<? extends @Nullable String> names, @Nullable SqlValidatorUtil.Suggester suggester) {
        if (names != null && suggester != null) {
            names = SqlValidatorUtil.uniquify(names, suggester, typeFactory.getTypeSystem().isSchemaCaseSensitive());
        }
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (int i = 0; i < exprs.size(); ++i) {
            String name;
            if (names == null || (name = names.get(i)) == null) {
                name = "$f" + i;
            }
            ((RelDataTypeFactory.Builder)builder).add(name, exprs.get(i).getType());
        }
        return builder.build();
    }

    @Deprecated
    public static RelDataType createStructType(RelDataTypeFactory typeFactory, List<? extends RexNode> exprs, List<String> names) {
        return RexUtil.createStructType(typeFactory, exprs, names, null);
    }

    public static boolean compatibleTypes(List<RexNode> exprs, RelDataType type, Litmus litmus) {
        List<RelDataTypeField> fields = type.getFieldList();
        if (exprs.size() != fields.size()) {
            return litmus.fail("rowtype mismatches expressions", new Object[0]);
        }
        for (int i = 0; i < fields.size(); ++i) {
            RelDataType fieldType;
            RelDataType exprType = exprs.get(i).getType();
            if (RelOptUtil.eq("type1", exprType, "type2", fieldType = fields.get(i).getType(), litmus)) continue;
            return litmus.fail(null, new Object[0]);
        }
        return litmus.succeed();
    }

    public static Pair<RexNode, String> makeKey(RexNode expr) {
        return Pair.of(expr, expr.getType().getFullTypeString());
    }

    public static boolean containIdentity(List<? extends RexNode> exprs, RelDataType rowType, Litmus litmus) {
        List<RelDataTypeField> fields = rowType.getFieldList();
        if (exprs.size() < fields.size()) {
            return litmus.fail("exprs/rowType length mismatch", new Object[0]);
        }
        for (int i = 0; i < fields.size(); ++i) {
            if (!(exprs.get(i) instanceof RexInputRef)) {
                return litmus.fail("expr[{}] is not a RexInputRef", i);
            }
            RexInputRef inputRef = (RexInputRef)exprs.get(i);
            if (inputRef.getIndex() != i) {
                return litmus.fail("expr[{}] has ordinal {}", i, inputRef.getIndex());
            }
            if (RelOptUtil.eq("type1", exprs.get(i).getType(), "type2", fields.get(i).getType(), litmus)) continue;
            return litmus.fail(null, new Object[0]);
        }
        return litmus.succeed();
    }

    public static boolean isIdentity(List<? extends RexNode> exps, RelDataType inputRowType) {
        return inputRowType.getFieldCount() == exps.size() && RexUtil.containIdentity(exps, inputRowType, Litmus.IGNORE);
    }

    public static RexNode composeConjunction(RexBuilder rexBuilder, Iterable<? extends @Nullable RexNode> nodes) {
        RexNode e = RexUtil.composeConjunction(rexBuilder, nodes, false);
        return Objects.requireNonNull(e, "e");
    }

    public static @Nullable RexNode composeConjunction(RexBuilder rexBuilder, Iterable<? extends @Nullable RexNode> nodes, boolean nullOnEmpty) {
        ImmutableList<RexNode> list = RexUtil.flattenAnd(nodes);
        switch (list.size()) {
            case 0: {
                return nullOnEmpty ? null : rexBuilder.makeLiteral(true);
            }
            case 1: {
                return (RexNode)list.get(0);
            }
        }
        if (RexUtil.containsFalse(list)) {
            return rexBuilder.makeLiteral(false);
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, (List<? extends RexNode>)list);
    }

    public static ImmutableList<RexNode> flattenAnd(Iterable<? extends @Nullable RexNode> nodes) {
        if (nodes instanceof Collection && ((Collection)nodes).isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet<RexNode> set = new HashSet<RexNode>();
        for (RexNode rexNode : nodes) {
            if (rexNode == null) continue;
            RexUtil.addAnd((ImmutableList.Builder<RexNode>)builder, set, rexNode);
        }
        return builder.build();
    }

    private static void addAnd(ImmutableList.Builder<RexNode> builder, Set<RexNode> digests, RexNode node) {
        switch (node.getKind()) {
            case AND: {
                for (RexNode operand : ((RexCall)node).getOperands()) {
                    RexUtil.addAnd(builder, digests, operand);
                }
                return;
            }
        }
        if (!node.isAlwaysTrue() && digests.add(node)) {
            builder.add((Object)node);
        }
    }

    public static RexNode composeDisjunction(RexBuilder rexBuilder, Iterable<? extends RexNode> nodes) {
        RexNode e = RexUtil.composeDisjunction(rexBuilder, nodes, false);
        return Objects.requireNonNull(e, "e");
    }

    public static @Nullable RexNode composeDisjunction(RexBuilder rexBuilder, Iterable<? extends RexNode> nodes, boolean nullOnEmpty) {
        ImmutableList<RexNode> list = RexUtil.flattenOr(nodes);
        switch (list.size()) {
            case 0: {
                return nullOnEmpty ? null : rexBuilder.makeLiteral(false);
            }
            case 1: {
                return (RexNode)list.get(0);
            }
        }
        if (RexUtil.containsTrue(list)) {
            return rexBuilder.makeLiteral(true);
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, (List<? extends RexNode>)list);
    }

    public static ImmutableList<RexNode> flattenOr(Iterable<? extends RexNode> nodes) {
        if (nodes instanceof Collection && ((Collection)nodes).isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet<RexNode> set = new HashSet<RexNode>();
        for (RexNode rexNode : nodes) {
            RexUtil.addOr((ImmutableList.Builder<RexNode>)builder, set, rexNode);
        }
        return builder.build();
    }

    private static void addOr(ImmutableList.Builder<RexNode> builder, Set<RexNode> set, RexNode node) {
        switch (node.getKind()) {
            case OR: {
                for (RexNode operand : ((RexCall)node).getOperands()) {
                    RexUtil.addOr(builder, set, operand);
                }
                return;
            }
        }
        if (!node.isAlwaysFalse() && set.add(node)) {
            builder.add((Object)node);
        }
    }

    public static List<RelCollation> apply(Mappings.TargetMapping mapping, List<RelCollation> collationList) {
        ArrayList<RelCollation> newCollationList = new ArrayList<RelCollation>();
        for (RelCollation collation : collationList) {
            RelCollation newCollation;
            RelFieldCollation fieldCollation;
            RelFieldCollation newFieldCollation;
            ArrayList<RelFieldCollation> newFieldCollationList = new ArrayList<RelFieldCollation>();
            Iterator<RelFieldCollation> iterator = collation.getFieldCollations().iterator();
            while (iterator.hasNext() && (newFieldCollation = RexUtil.apply(mapping, fieldCollation = iterator.next())) != null) {
                newFieldCollationList.add(newFieldCollation);
            }
            if (newFieldCollationList.isEmpty() || newCollationList.contains(newCollation = RelCollations.of(newFieldCollationList))) continue;
            newCollationList.add(newCollation);
        }
        return newCollationList;
    }

    public static RelCollation apply(Mappings.TargetMapping mapping, RelCollation collation) {
        List<RelFieldCollation> fieldCollations = RexUtil.applyFields(mapping, collation.getFieldCollations());
        return fieldCollations.equals(collation.getFieldCollations()) ? collation : RelCollations.of(fieldCollations);
    }

    public static @Nullable RelFieldCollation apply(Mappings.TargetMapping mapping, RelFieldCollation fieldCollation) {
        int target = mapping.getTargetOpt(fieldCollation.getFieldIndex());
        if (target < 0) {
            return null;
        }
        return fieldCollation.withFieldIndex(target);
    }

    public static List<RelFieldCollation> applyFields(Mappings.TargetMapping mapping, List<RelFieldCollation> fieldCollations) {
        RelFieldCollation fieldCollation;
        RelFieldCollation newFieldCollation;
        ArrayList<RelFieldCollation> newFieldCollations = new ArrayList<RelFieldCollation>();
        Iterator<RelFieldCollation> iterator = fieldCollations.iterator();
        while (iterator.hasNext() && (newFieldCollation = RexUtil.apply(mapping, fieldCollation = iterator.next())) != null) {
            newFieldCollations.add(newFieldCollation);
        }
        return newFieldCollations;
    }

    public static RexNode apply(Mappings.TargetMapping mapping, RexNode node) {
        return node.accept(RexPermuteInputsShuttle.of(mapping));
    }

    public static List<RexNode> apply(Mappings.TargetMapping mapping, Iterable<? extends RexNode> nodes) {
        return RexPermuteInputsShuttle.of(mapping).visitList(nodes);
    }

    public static <T extends RexNode> T[] apply(RexVisitor<T> shuttle, T[] exprs) {
        RexNode[] newExprs = (RexNode[])exprs.clone();
        for (int i = 0; i < newExprs.length; ++i) {
            RexNode expr = newExprs[i];
            if (expr == null) continue;
            newExprs[i] = (RexNode)expr.accept(shuttle);
        }
        return newExprs;
    }

    public static void apply(RexVisitor<Void> visitor, RexNode[] exprs, @Nullable RexNode expr) {
        for (RexNode e : exprs) {
            e.accept(visitor);
        }
        if (expr != null) {
            expr.accept(visitor);
        }
    }

    public static void apply(RexVisitor<Void> visitor, List<? extends RexNode> exprs, @Nullable RexNode expr) {
        for (RexNode rexNode : exprs) {
            rexNode.accept(visitor);
        }
        if (expr != null) {
            expr.accept(visitor);
        }
    }

    public static RexNode flatten(RexBuilder rexBuilder, RexNode node) {
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            SqlOperator op = call.getOperator();
            List<RexNode> flattenedOperands = RexUtil.flatten(call.getOperands(), op);
            if (!RexUtil.isFlat(call.getOperands(), op)) {
                return rexBuilder.makeCall(call.getParserPosition(), call.getType(), op, flattenedOperands);
            }
        }
        return node;
    }

    public static List<RexNode> flatten(List<? extends RexNode> exprs, SqlOperator op) {
        if (RexUtil.isFlat(exprs, op)) {
            return exprs;
        }
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RexUtil.flattenRecurse(list, exprs, op);
        return list;
    }

    private static boolean isFlat(List<? extends RexNode> exprs, SqlOperator op) {
        return !RexUtil.isAssociative(op) || !RexUtil.exists(exprs, expr -> RexUtil.isCallTo(expr, op));
    }

    public static boolean isFlat(RexNode expr) {
        if (!(expr instanceof RexCall)) {
            return true;
        }
        RexCall call = (RexCall)expr;
        return RexUtil.isFlat(call.getOperands(), call.getOperator()) && RexUtil.all(call.getOperands(), RexUtil::isFlat);
    }

    private static void flattenRecurse(List<RexNode> list, List<? extends RexNode> exprs, SqlOperator op) {
        for (RexNode rexNode : exprs) {
            if (rexNode instanceof RexCall && ((RexCall)rexNode).getOperator() == op) {
                RexUtil.flattenRecurse(list, ((RexCall)rexNode).getOperands(), op);
                continue;
            }
            list.add(rexNode);
        }
    }

    public static boolean isLosslessCast(RexNode node) {
        if (!node.isA(SqlKind.CAST)) {
            return false;
        }
        return RexUtil.isLosslessCast(((RexCall)node).getOperands().get(0).getType(), node.getType());
    }

    @API(since="1.22", status=API.Status.STABLE)
    public static boolean isLosslessCast(RelDataType source, RelDataType target) {
        SqlTypeName sourceSqlTypeName = source.getSqlTypeName();
        SqlTypeName targetSqlTypeName = target.getSqlTypeName();
        if (SqlTypeUtil.isIntType(source) && SqlTypeUtil.isIntType(target)) {
            boolean sourceIsUnsigned = SqlTypeFamily.UNSIGNED_NUMERIC.getTypeNames().contains((Object)sourceSqlTypeName);
            boolean targetIsUnsigned = SqlTypeFamily.UNSIGNED_NUMERIC.getTypeNames().contains((Object)targetSqlTypeName);
            if (!sourceIsUnsigned && targetIsUnsigned) {
                return false;
            }
            return SqlTypeUtil.integerRangeContains(target, source);
        }
        if (SqlTypeFamily.CHARACTER.getTypeNames().contains((Object)sourceSqlTypeName) && SqlTypeFamily.CHARACTER.getTypeNames().contains((Object)targetSqlTypeName)) {
            return targetSqlTypeName.compareTo(sourceSqlTypeName) >= 0 && source.getPrecision() <= target.getPrecision();
        }
        if (sourceSqlTypeName.getFamily() == SqlTypeFamily.NUMERIC && targetSqlTypeName.getFamily() == SqlTypeFamily.CHARACTER) {
            int targetPrecision;
            int sourceLength = source.getPrecision() + 1;
            if (source.getScale() != -1 && source.getScale() != 0) {
                sourceLength += source.getScale() + 1;
            }
            return (targetPrecision = target.getPrecision()) == -1 || targetPrecision >= sourceLength;
        }
        if (sourceSqlTypeName == SqlTypeName.DECIMAL && targetSqlTypeName == SqlTypeName.DECIMAL) {
            int sourcePrecision = source.getPrecision();
            int sourceScale = Math.max(source.getScale(), 0);
            int targetPrecision = target.getPrecision();
            int targetScale = Math.max(target.getScale(), 0);
            if (sourcePrecision <= 0 || targetPrecision <= 0) {
                return false;
            }
            return targetScale >= sourceScale && targetPrecision - targetScale >= sourcePrecision - sourceScale;
        }
        if (SqlTypeUtil.isIntType(source) && targetSqlTypeName == SqlTypeName.DECIMAL) {
            int targetPrecision = target.getPrecision();
            int targetScale = Math.max(target.getScale(), 0);
            int sourcePrecision = source.getPrecision();
            return sourcePrecision > 0 && targetPrecision - targetScale >= sourcePrecision;
        }
        if (sourceSqlTypeName == SqlTypeName.DECIMAL && SqlTypeUtil.isIntType(target)) {
            if (source.getScale() != 0) {
                return false;
            }
            return SqlTypeUtil.integerRangeContains(target, source);
        }
        if (SqlTypeFamily.APPROXIMATE_NUMERIC.getTypeNames().contains((Object)sourceSqlTypeName) && SqlTypeFamily.APPROXIMATE_NUMERIC.getTypeNames().contains((Object)targetSqlTypeName)) {
            int sourcePrecision = source.getPrecision();
            int targetPrecision = target.getPrecision();
            return targetPrecision >= sourcePrecision;
        }
        if (SqlTypeFamily.EXACT_NUMERIC.getTypeNames().contains((Object)sourceSqlTypeName) && SqlTypeFamily.APPROXIMATE_NUMERIC.getTypeNames().contains((Object)targetSqlTypeName)) {
            int targetPrecision = target.getPrecision();
            if (sourceSqlTypeName == SqlTypeName.DECIMAL) {
                int sourcePrecision = source.getPrecision();
                if (sourcePrecision <= 0 || source.getScale() != 0) {
                    return false;
                }
                return sourcePrecision <= targetPrecision;
            }
            int sourcePrecision = source.getPrecision();
            return sourcePrecision > 0 && sourcePrecision <= targetPrecision;
        }
        return false;
    }

    public static RexNode toCnf(RexBuilder rexBuilder, RexNode rex) {
        return new CnfHelper(rexBuilder, -1).toCnf(rex);
    }

    public static RexNode toCnf(RexBuilder rexBuilder, int maxCnfNodeCount, RexNode rex) {
        return new CnfHelper(rexBuilder, maxCnfNodeCount).toCnf(rex);
    }

    public static RexNode toDnf(RexBuilder rexBuilder, RexNode rex) {
        return new DnfHelper(rexBuilder).toDnf(rex);
    }

    private static boolean isAssociative(SqlOperator op) {
        return op.getKind() == SqlKind.AND || op.getKind() == SqlKind.OR;
    }

    public static <E> boolean exists(List<? extends E> list, Predicate1<E> predicate) {
        for (E e : list) {
            if (!predicate.apply(e)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean all(List<? extends E> list, Predicate1<E> predicate) {
        for (E e : list) {
            if (predicate.apply(e)) continue;
            return false;
        }
        return true;
    }

    public static RexNode shift(RexNode node, int offset) {
        if (offset == 0) {
            return node;
        }
        return node.accept(new RexShiftShuttle(offset));
    }

    public static List<RexNode> shift(Iterable<RexNode> nodes, int offset) {
        return new RexShiftShuttle(offset).visitList(nodes);
    }

    public static RexNode shift(RexNode node, final int start, final int offset) {
        return node.accept(new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef input) {
                int index = input.getIndex();
                if (index < start) {
                    return input;
                }
                return new RexInputRef(index + offset, input.getType());
            }
        });
    }

    public static RelNode shiftFieldAccess(final RexBuilder rexBuilder, RelNode node, final CorrelationId id, RelNode outer, final int offset) {
        if (offset == 0) {
            return node;
        }
        final RexNode correl = rexBuilder.makeCorrel(outer.getRowType(), id);
        return node.accept(new RexShuttle(){

            @Override
            public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
                if (fieldAccess.getReferenceExpr() instanceof RexCorrelVariable && ((RexCorrelVariable)fieldAccess.getReferenceExpr()).id.equals(id)) {
                    return rexBuilder.makeFieldAccess(correl, fieldAccess.getField().getIndex() + offset);
                }
                return fieldAccess;
            }
        });
    }

    public static RexNode pullFactors(RexBuilder rexBuilder, RexNode node) {
        return new CnfHelper(rexBuilder, -1).pull(node);
    }

    @Deprecated
    public static List<RexNode> fixUp(RexBuilder rexBuilder, List<RexNode> nodes, RelDataType rowType) {
        List<RelDataType> typeList = RelOptUtil.getFieldTypeList(rowType);
        return RexUtil.fixUp(rexBuilder, nodes, typeList);
    }

    public static List<RexNode> fixUp(RexBuilder rexBuilder, List<RexNode> nodes, List<RelDataType> fieldTypes) {
        return new FixNullabilityShuttle(rexBuilder, fieldTypes).apply(nodes);
    }

    public static List<RelDataType> types(List<? extends RexNode> nodes) {
        return Util.transform(nodes, RexNode::getType);
    }

    public static List<RelDataTypeFamily> families(List<RelDataType> types) {
        return Util.transform(types, RelDataType::getFamily);
    }

    public static boolean removeAll(List<RexNode> targets, RexNode e) {
        int count = 0;
        Iterator<RexNode> iterator = targets.iterator();
        while (iterator.hasNext()) {
            RexNode next = iterator.next();
            if (!next.equals(e)) continue;
            ++count;
            iterator.remove();
        }
        return count > 0;
    }

    @Deprecated
    public static boolean eq(RexNode e1, RexNode e2) {
        return e1 == e2 || e1.toString().equals(e2.toString());
    }

    @Deprecated
    public static RexNode simplifyPreservingType(RexBuilder rexBuilder, RexNode e) {
        return new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, EXECUTOR).simplifyPreservingType(e);
    }

    @Deprecated
    public static RexNode simplify(RexBuilder rexBuilder, RexNode e) {
        return new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, EXECUTOR).simplify(e);
    }

    @Deprecated
    public static RexNode simplify(RexBuilder rexBuilder, RexNode e, boolean unknownAsFalse) {
        return new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, EXECUTOR).simplifyUnknownAs(e, RexUnknownAs.falseIf(unknownAsFalse));
    }

    @Deprecated
    public static RexNode simplifyAnds(RexBuilder rexBuilder, Iterable<? extends RexNode> nodes) {
        return new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, EXECUTOR).simplifyAnds(nodes, RexUnknownAs.UNKNOWN);
    }

    @Deprecated
    public static RexNode simplifyAnds(RexBuilder rexBuilder, Iterable<? extends RexNode> nodes, boolean unknownAsFalse) {
        return new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, EXECUTOR).simplifyAnds(nodes, RexUnknownAs.falseIf(unknownAsFalse));
    }

    public static RexNode not(RexNode e) {
        switch (e.getKind()) {
            case NOT: {
                return ((RexCall)e).getOperands().get(0);
            }
        }
        return RexUtil.addNot(e);
    }

    private static RexNode addNot(RexNode e) {
        return new RexCall(e.getType(), SqlStdOperatorTable.NOT, (List<? extends RexNode>)ImmutableList.of((Object)e));
    }

    @API(since="1.27.0", status=API.Status.EXPERIMENTAL)
    public static SqlOperator op(SqlKind kind) {
        switch (kind) {
            case IS_FALSE: {
                return SqlStdOperatorTable.IS_FALSE;
            }
            case IS_TRUE: {
                return SqlStdOperatorTable.IS_TRUE;
            }
            case IS_UNKNOWN: {
                return SqlStdOperatorTable.IS_UNKNOWN;
            }
            case IS_NULL: {
                return SqlStdOperatorTable.IS_NULL;
            }
            case IS_NOT_FALSE: {
                return SqlStdOperatorTable.IS_NOT_FALSE;
            }
            case IS_NOT_TRUE: {
                return SqlStdOperatorTable.IS_NOT_TRUE;
            }
            case IS_NOT_NULL: {
                return SqlStdOperatorTable.IS_NOT_NULL;
            }
            case IS_DISTINCT_FROM: {
                return SqlStdOperatorTable.IS_DISTINCT_FROM;
            }
            case IS_NOT_DISTINCT_FROM: {
                return SqlStdOperatorTable.IS_NOT_DISTINCT_FROM;
            }
            case EQUALS: {
                return SqlStdOperatorTable.EQUALS;
            }
            case NOT_EQUALS: {
                return SqlStdOperatorTable.NOT_EQUALS;
            }
            case LESS_THAN: {
                return SqlStdOperatorTable.LESS_THAN;
            }
            case GREATER_THAN: {
                return SqlStdOperatorTable.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
            }
            case AND: {
                return SqlStdOperatorTable.AND;
            }
            case OR: {
                return SqlStdOperatorTable.OR;
            }
            case COALESCE: {
                return SqlStdOperatorTable.COALESCE;
            }
        }
        throw new AssertionError((Object)kind);
    }

    @Deprecated
    public static RexNode simplifyAnd(RexBuilder rexBuilder, RexCall e, boolean unknownAsFalse) {
        return new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, EXECUTOR).simplifyAnd(e, RexUnknownAs.falseIf(unknownAsFalse));
    }

    @Deprecated
    public static RexNode simplifyAnd2(RexBuilder rexBuilder, List<RexNode> terms, List<RexNode> notTerms) {
        return new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, EXECUTOR).simplifyAnd2(terms, notTerms);
    }

    @Deprecated
    public static RexNode simplifyAnd2ForUnknownAsFalse(RexBuilder rexBuilder, List<RexNode> terms, List<RexNode> notTerms) {
        return new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, EXECUTOR).simplifyAnd2ForUnknownAsFalse(terms, notTerms);
    }

    public static @Nullable RexNode negate(RexBuilder rexBuilder, RexCall call) {
        switch (call.getKind()) {
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: {
                SqlOperator op = RexUtil.op(call.getKind().negateNullSafe());
                return rexBuilder.makeCall(call.getParserPosition(), op, call.getOperands());
            }
        }
        return null;
    }

    public static @Nullable RexNode invert(RexBuilder rexBuilder, RexCall call) {
        switch (call.getKind()) {
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: {
                SqlOperator op = Objects.requireNonNull(call.getOperator().reverse());
                return rexBuilder.makeCall(call.getParserPosition(), op, Lists.reverse(call.getOperands()));
            }
        }
        return null;
    }

    @Deprecated
    public static RexNode simplifyOr(RexBuilder rexBuilder, RexCall call) {
        return new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, EXECUTOR).simplifyUnknownAs(call, RexUnknownAs.UNKNOWN);
    }

    @Deprecated
    public static RexNode simplifyOrs(RexBuilder rexBuilder, List<RexNode> terms) {
        return new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, EXECUTOR).simplifyUnknownAs(RexUtil.composeDisjunction(rexBuilder, terms), RexUnknownAs.UNKNOWN);
    }

    public static RexNode andNot(RexBuilder rexBuilder, RexNode e, RexNode ... notTerms) {
        return RexUtil.andNot(rexBuilder, e, Arrays.asList(notTerms));
    }

    public static RexNode andNot(RexBuilder rexBuilder, RexNode e, Iterable<? extends RexNode> notTerms) {
        switch (e.getKind()) {
            case EQUALS: {
                RexCall call = (RexCall)e;
                if (!(call.getOperands().get(1) instanceof RexLiteral)) break;
                notTerms = Util.filter(notTerms, e2 -> {
                    switch (e2.getKind()) {
                        case EQUALS: {
                            RexCall call2 = (RexCall)e2;
                            if (!call2.getOperands().get(0).equals(call.getOperands().get(0)) || !(call2.getOperands().get(1) instanceof RexLiteral) || call.getOperands().get(1).equals(call2.getOperands().get(1))) break;
                            return false;
                        }
                    }
                    return true;
                });
                break;
            }
        }
        return RexUtil.composeConjunction(rexBuilder, Iterables.concat((Iterable)ImmutableList.of((Object)e), Util.transform(notTerms, e2 -> RexUtil.not(rexBuilder, e2))));
    }

    public static boolean isCasePredicate(RexCall call, int i) {
        assert (call.getKind() == SqlKind.CASE);
        return i < call.operands.size() - 1 && (call.operands.size() - i) % 2 == 1;
    }

    private static boolean containsFalse(Iterable<RexNode> nodes) {
        for (RexNode node : nodes) {
            if (!node.isAlwaysFalse()) continue;
            return true;
        }
        return false;
    }

    private static boolean containsTrue(Iterable<RexNode> nodes) {
        for (RexNode node : nodes) {
            if (!node.isAlwaysTrue()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static Function<RexNode, RexNode> notFn(RexBuilder rexBuilder) {
        return e -> RexUtil.not(rexBuilder, e);
    }

    static RexNode not(RexBuilder rexBuilder, RexNode input) {
        return input.isAlwaysTrue() ? rexBuilder.makeLiteral(false) : (input.isAlwaysFalse() ? rexBuilder.makeLiteral(true) : (input.getKind() == SqlKind.NOT ? (RexNode)((RexCall)input).operands.get(0) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, input)));
    }

    public static boolean containsCorrelation(RexNode condition) {
        try {
            condition.accept(CorrelationFinder.INSTANCE);
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    public static RexNode swapTableReferences(RexBuilder rexBuilder, RexNode node, Map<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping) {
        return RexUtil.swapTableColumnReferences(rexBuilder, node, tableMapping, null);
    }

    public static RexNode swapColumnReferences(RexBuilder rexBuilder, RexNode node, Map<RexTableInputRef, Set<RexTableInputRef>> ec) {
        return RexUtil.swapTableColumnReferences(rexBuilder, node, null, ec);
    }

    public static RexNode swapTableColumnReferences(RexBuilder rexBuilder, RexNode node, final @Nullable Map<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, final @Nullable Map<RexTableInputRef, Set<RexTableInputRef>> ec) {
        RexShuttle visitor = new RexShuttle(){

            @Override
            public RexNode visitTableInputRef(RexTableInputRef inputRef) {
                Set s;
                if (tableMapping != null) {
                    RexTableInputRef inputRefFinal = inputRef;
                    inputRef = RexTableInputRef.of((RexTableInputRef.RelTableRef)Objects.requireNonNull(tableMapping.get(inputRef.getTableRef()), () -> "tableMapping.get(...) for " + inputRefFinal.getTableRef()), inputRef.getIndex(), inputRef.getType());
                }
                if (ec != null && (s = (Set)ec.get(inputRef)) != null) {
                    inputRef = (RexTableInputRef)s.iterator().next();
                }
                return inputRef;
            }
        };
        return visitor.apply(node);
    }

    public static RexNode swapColumnTableReferences(RexBuilder rexBuilder, RexNode node, final Map<RexTableInputRef, ? extends @Nullable Set<RexTableInputRef>> ec, final @Nullable Map<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping) {
        RexShuttle visitor = new RexShuttle(){

            @Override
            public RexNode visitTableInputRef(RexTableInputRef inputRef) {
                Set s;
                if (ec != null && (s = (Set)ec.get(inputRef)) != null) {
                    inputRef = (RexTableInputRef)s.iterator().next();
                }
                if (tableMapping != null) {
                    RexTableInputRef inputRefFinal = inputRef;
                    inputRef = RexTableInputRef.of((RexTableInputRef.RelTableRef)Objects.requireNonNull(tableMapping.get(inputRef.getTableRef()), () -> "tableMapping.get(...) for " + inputRefFinal.getTableRef()), inputRef.getIndex(), inputRef.getType());
                }
                return inputRef;
            }
        };
        return visitor.apply(node);
    }

    public static Set<RexTableInputRef.RelTableRef> gatherTableReferences(List<RexNode> nodes) {
        final HashSet<RexTableInputRef.RelTableRef> occurrences = new HashSet<RexTableInputRef.RelTableRef>();
        new RexVisitorImpl<Void>(true){

            @Override
            public Void visitTableInputRef(RexTableInputRef ref) {
                occurrences.add(ref.getTableRef());
                return (Void)super.visitTableInputRef(ref);
            }
        }.visitEach(nodes);
        return occurrences;
    }

    public static ImmutableBitSet getNonConstColumns(List<RexNode> expressions) {
        ImmutableBitSet cols = ImmutableBitSet.range(0, expressions.size());
        return RexUtil.getNonConstColumns(cols, expressions);
    }

    public static ImmutableBitSet getNonConstColumns(ImmutableBitSet columns, List<RexNode> expressions) {
        ImmutableBitSet.Builder nonConstCols = ImmutableBitSet.builder();
        for (int col : columns) {
            if (RexUtil.isLiteral(expressions.get(col), true)) continue;
            nonConstCols.set(col);
        }
        return nonConstCols.build();
    }

    public static List<String> strings(List<RexNode> list) {
        return Util.transform(list, Object::toString);
    }

    private static class SearchExpandingShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final @Nullable RexProgram program;
        private final int maxComplexity;

        SearchExpandingShuttle(@Nullable RexProgram program, RexBuilder rexBuilder, int maxComplexity) {
            this.program = program;
            this.rexBuilder = rexBuilder;
            this.maxComplexity = maxComplexity;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            boolean[] update = new boolean[]{false};
            switch (call.getKind()) {
                case OR: {
                    List<RexNode> clonedOperands = this.visitList((List<? extends RexNode>)call.operands, update);
                    if (update[0]) {
                        return RexUtil.composeDisjunction(this.rexBuilder, clonedOperands);
                    }
                    return call;
                }
                case AND: {
                    List<RexNode> clonedOperands = this.visitList((List<? extends RexNode>)call.operands, update);
                    if (update[0]) {
                        return RexUtil.composeConjunction(this.rexBuilder, clonedOperands);
                    }
                    return call;
                }
                case SEARCH: {
                    RexNode ref = (RexNode)call.operands.get(0);
                    RexLiteral literal = (RexLiteral)RexUtil.deref(this.program, (RexNode)call.operands.get(1));
                    Sarg sarg = Objects.requireNonNull(literal.getValueAs(Sarg.class), "Sarg");
                    if (this.maxComplexity >= 0 && sarg.complexity() >= this.maxComplexity) break;
                    return RexUtil.sargRef(this.rexBuilder, ref, sarg, literal.getType(), RexUnknownAs.UNKNOWN);
                }
            }
            return super.visitCall(call);
        }
    }

    private static class RangeToRex<C extends Comparable<C>>
    implements RangeSets.Consumer<C> {
        private final List<RexNode> list;
        private final RexBuilder rexBuilder;
        private final RelDataType type;
        private final RexNode ref;

        RangeToRex(RexNode ref, List<RexNode> list, RexBuilder rexBuilder, RelDataType type) {
            this.ref = Objects.requireNonNull(ref, "ref");
            this.list = Objects.requireNonNull(list, "list");
            this.rexBuilder = Objects.requireNonNull(rexBuilder, "rexBuilder");
            this.type = Objects.requireNonNull(type, "type");
        }

        private void addAnd(RexNode ... nodes) {
            this.list.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, nodes));
        }

        private RexNode op(SqlOperator op, C value) {
            return this.rexBuilder.makeCall(op, this.ref, this.rexBuilder.makeLiteral(value, this.type, true, true));
        }

        @Override
        public void all() {
            this.list.add(this.rexBuilder.makeLiteral(true));
        }

        @Override
        public void atLeast(C lower) {
            this.list.add(this.op(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, lower));
        }

        @Override
        public void atMost(C upper) {
            this.list.add(this.op(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, upper));
        }

        @Override
        public void greaterThan(C lower) {
            this.list.add(this.op(SqlStdOperatorTable.GREATER_THAN, lower));
        }

        @Override
        public void lessThan(C upper) {
            this.list.add(this.op(SqlStdOperatorTable.LESS_THAN, upper));
        }

        @Override
        public void singleton(C value) {
            this.list.add(this.op(SqlStdOperatorTable.EQUALS, value));
        }

        @Override
        public void closed(C lower, C upper) {
            this.addAnd(this.op(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, lower), this.op(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, upper));
        }

        @Override
        public void closedOpen(C lower, C upper) {
            this.addAnd(this.op(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, lower), this.op(SqlStdOperatorTable.LESS_THAN, upper));
        }

        @Override
        public void openClosed(C lower, C upper) {
            this.addAnd(this.op(SqlStdOperatorTable.GREATER_THAN, lower), this.op(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, upper));
        }

        @Override
        public void open(C lower, C upper) {
            this.addAnd(this.op(SqlStdOperatorTable.GREATER_THAN, lower), this.op(SqlStdOperatorTable.LESS_THAN, upper));
        }
    }

    public static abstract class RexFinder
    extends RexVisitorImpl<Void> {
        RexFinder() {
            super(true);
        }

        public boolean inProject(Project project) {
            return this.anyContain(project.getProjects());
        }

        public boolean notInProject(Project project) {
            return !this.inProject(project);
        }

        public boolean inFilter(Filter filter) {
            return this.contains(filter.getCondition());
        }

        public boolean notInFilter(Filter filter) {
            return !this.inFilter(filter);
        }

        public boolean inCalc(Calc calc) {
            return this.inProgram(calc.getProgram());
        }

        public boolean notInCalc(Calc calc) {
            return !this.inCalc(calc);
        }

        public boolean inProgram(RexProgram program) {
            return this.anyContain(program.getExprList());
        }

        public boolean inJoin(Join join) {
            return this.contains(join.getCondition());
        }

        public boolean notInJoin(Join join) {
            return !this.inJoin(join);
        }

        public boolean contains(RexNode node) {
            try {
                node.accept(this);
                return false;
            }
            catch (Util.FoundOne e) {
                return true;
            }
        }

        public boolean anyContain(Iterable<? extends RexNode> nodes) {
            try {
                for (RexNode rexNode : nodes) {
                    rexNode.accept(this);
                }
                return false;
            }
            catch (Util.FoundOne e) {
                return true;
            }
        }
    }

    @Deprecated
    public static class ExprSimplifier
    extends RexShuttle {
        private final RexSimplify simplify;
        private final Map<RexNode, RexUnknownAs> unknownAsMap = new HashMap<RexNode, RexUnknownAs>();
        private final RexUnknownAs unknownAs;
        private final boolean matchNullability;

        public ExprSimplifier(RexSimplify simplify) {
            this(simplify, RexUnknownAs.UNKNOWN, true);
        }

        public ExprSimplifier(RexSimplify simplify, boolean matchNullability) {
            this(simplify, RexUnknownAs.UNKNOWN, matchNullability);
        }

        public ExprSimplifier(RexSimplify simplify, RexUnknownAs unknownAs, boolean matchNullability) {
            this.simplify = simplify;
            this.unknownAs = unknownAs;
            this.matchNullability = matchNullability;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexUnknownAs unknownAs = this.unknownAs;
            switch (unknownAs) {
                case FALSE: {
                    switch (call.getKind()) {
                        case AND: 
                        case CASE: {
                            unknownAs = this.unknownAsMap.getOrDefault(call, RexUnknownAs.FALSE);
                            break;
                        }
                        default: {
                            unknownAs = RexUnknownAs.FALSE;
                        }
                    }
                    for (RexNode operand : call.operands) {
                        this.unknownAsMap.put(operand, unknownAs);
                    }
                    break;
                }
            }
            RexNode node = super.visitCall(call);
            RexNode simplifiedNode = this.simplify.simplify(node, unknownAs);
            if (node == simplifiedNode) {
                return node;
            }
            if (simplifiedNode.getType().equals(call.getType())) {
                return simplifiedNode;
            }
            return this.simplify.rexBuilder.makeCast(call.getType(), simplifiedNode, this.matchNullability, false);
        }
    }

    public static class SubQueryFinder
    extends RexVisitorImpl<Void> {
        public static final SubQueryFinder INSTANCE = new SubQueryFinder();
        @Deprecated
        public static final com.google.common.base.Predicate<Project> PROJECT_PREDICATE = SubQueryFinder::containsSubQuery;
        @Deprecated
        public static final Predicate<Filter> FILTER_PREDICATE = SubQueryFinder::containsSubQuery;
        @Deprecated
        public static final com.google.common.base.Predicate<Join> JOIN_PREDICATE = SubQueryFinder::containsSubQuery;

        private SubQueryFinder() {
            super(true);
        }

        public static boolean containsSubQuery(Project project) {
            for (RexNode node : project.getProjects()) {
                try {
                    node.accept(INSTANCE);
                }
                catch (Util.FoundOne e) {
                    return true;
                }
            }
            return false;
        }

        public static boolean containsSubQuery(Filter filter) {
            try {
                filter.getCondition().accept(INSTANCE);
                return false;
            }
            catch (Util.FoundOne e) {
                return true;
            }
        }

        public static boolean containsSubQuery(Join join) {
            try {
                join.getCondition().accept(INSTANCE);
                return false;
            }
            catch (Util.FoundOne e) {
                return true;
            }
        }

        @Override
        public Void visitSubQuery(RexSubQuery subQuery) {
            throw new Util.FoundOne(subQuery);
        }

        public static @Nullable RexSubQuery find(Iterable<RexNode> nodes) {
            for (RexNode node : nodes) {
                try {
                    node.accept(INSTANCE);
                }
                catch (Util.FoundOne e) {
                    return (RexSubQuery)e.getNode();
                }
            }
            return null;
        }

        public static @Nullable RexSubQuery find(RexNode node) {
            try {
                node.accept(INSTANCE);
                return null;
            }
            catch (Util.FoundOne e) {
                return (RexSubQuery)e.getNode();
            }
        }
    }

    public static class SubQueryCollector
    extends RexVisitorImpl<Void> {
        private final List<RexSubQuery> subQueries = new ArrayList<RexSubQuery>();

        private SubQueryCollector() {
            super(true);
        }

        @Override
        public Void visitSubQuery(RexSubQuery subQuery) {
            this.subQueries.add(subQuery);
            return null;
        }

        public static List<RexSubQuery> collect(Project project) {
            SubQueryCollector subQueryCollector = new SubQueryCollector();
            for (RexNode node : project.getProjects()) {
                node.accept(subQueryCollector);
            }
            return subQueryCollector.subQueries;
        }
    }

    public static class FixNullabilityShuttle
    extends RexShuttle {
        private final List<RelDataType> typeList;
        private final RexBuilder rexBuilder;

        public FixNullabilityShuttle(RexBuilder rexBuilder, List<RelDataType> typeList) {
            this.typeList = typeList;
            this.rexBuilder = rexBuilder;
        }

        @Override
        public RexNode visitInputRef(RexInputRef ref) {
            RelDataType rightType = this.typeList.get(ref.getIndex());
            RelDataType refType = ref.getType();
            if (refType.equals(rightType)) {
                return ref;
            }
            RelDataType refType2 = this.rexBuilder.getTypeFactory().createTypeWithNullability(refType, rightType.isNullable());
            if (refType2.equals(rightType)) {
                return new RexInputRef(ref.getIndex(), refType2);
            }
            throw new AssertionError((Object)("mismatched type " + ref + " " + rightType));
        }
    }

    private static class CorrelationFinder
    extends RexVisitorImpl<Void> {
        static final CorrelationFinder INSTANCE = new CorrelationFinder();

        private CorrelationFinder() {
            super(true);
        }

        @Override
        public Void visitCorrelVariable(RexCorrelVariable var) {
            throw Util.FoundOne.NULL;
        }

        @Override
        public Void visitSubQuery(RexSubQuery subQuery) {
            if (!this.deep) {
                return null;
            }
            for (RexNode operand : subQuery.operands) {
                operand.accept(this);
            }
            if (!RelOptUtil.getVariablesUsed(subQuery.rel).isEmpty()) {
                throw Util.FoundOne.NULL;
            }
            return null;
        }
    }

    private static class RexShiftShuttle
    extends RexShuttle {
        private final int offset;

        RexShiftShuttle(int offset) {
            this.offset = offset;
        }

        @Override
        public RexNode visitInputRef(RexInputRef input) {
            return new RexInputRef(input.getIndex() + this.offset, input.getType());
        }
    }

    public static abstract class ExpandDisjunctionHelper<K> {
        private final RelBuilder relBuilder;
        private final int maxNodeCount;
        private int expressionIncreaseAmount;

        public ExpandDisjunctionHelper(RelBuilder relBuilder, int maxNodeCount) {
            this.relBuilder = relBuilder;
            this.maxNodeCount = maxNodeCount;
        }

        public Map<K, RexNode> expand(RexNode condition) {
            try {
                this.expressionIncreaseAmount = 0;
                return this.expandDeep(condition);
            }
            catch (PlanTooComplexError e) {
                return new HashMap();
            }
        }

        private Map<K, RexNode> expandDeep(RexNode condition) {
            HashMap<K, RexNode> additionalConditions = new HashMap<K, RexNode>();
            if (this.canReturnEarly(condition, additionalConditions)) {
                return additionalConditions;
            }
            block0 : switch (condition.getKind()) {
                case AND: {
                    ImmutableList<RexNode> andOperands = RexUtil.flattenAnd(((RexCall)condition).getOperands());
                    for (RexNode andOperand : andOperands) {
                        Map<K, RexNode> operandResult = this.expandDeep(andOperand);
                        this.combinePredicatesUsingAnd(additionalConditions, operandResult);
                    }
                    break;
                }
                case OR: {
                    ImmutableList<RexNode> orOperands = RexUtil.flattenOr(((RexCall)condition).getOperands());
                    additionalConditions.putAll(this.expandDeep((RexNode)orOperands.get(0)));
                    for (int i = 1; i < orOperands.size(); ++i) {
                        Map<K, RexNode> operandResult = this.expandDeep((RexNode)orOperands.get(i));
                        this.combinePredicatesUsingOr(additionalConditions, operandResult);
                        if (additionalConditions.isEmpty()) break block0;
                    }
                    break;
                }
            }
            return additionalConditions;
        }

        protected abstract boolean canReturnEarly(RexNode var1, Map<K, RexNode> var2);

        private void combinePredicatesUsingAnd(Map<K, RexNode> baseMap, Map<K, RexNode> forMergeMap) {
            for (Map.Entry<K, RexNode> entry : forMergeMap.entrySet()) {
                RexNode mergedRex = this.relBuilder.and(entry.getValue(), baseMap.getOrDefault(entry.getKey(), this.relBuilder.literal(true)));
                int originalCount = entry.getValue().nodeCount() + (baseMap.containsKey(entry.getKey()) ? baseMap.get(entry.getKey()).nodeCount() : 0);
                this.checkExpandCount(mergedRex.nodeCount() - originalCount);
                baseMap.put(entry.getKey(), mergedRex);
            }
        }

        private void combinePredicatesUsingOr(Map<K, RexNode> baseMap, Map<K, RexNode> forMergeMap) {
            if (baseMap.isEmpty()) {
                return;
            }
            Iterator<Map.Entry<K, RexNode>> iterator = baseMap.entrySet().iterator();
            while (iterator.hasNext()) {
                int forMergeNodeCount = 0;
                Map.Entry<K, RexNode> entry = iterator.next();
                if (!forMergeMap.containsKey(entry.getKey())) {
                    this.checkExpandCount(-entry.getValue().nodeCount());
                    iterator.remove();
                    continue;
                }
                forMergeNodeCount = forMergeMap.get(entry.getKey()).nodeCount();
                RexNode mergedRex = this.relBuilder.or(entry.getValue(), forMergeMap.get(entry.getKey()));
                int originalCount = entry.getValue().nodeCount() + forMergeNodeCount;
                this.checkExpandCount(mergedRex.nodeCount() - originalCount);
                baseMap.put(entry.getKey(), mergedRex);
            }
        }

        protected void checkExpandCount(int changeCount) {
            this.expressionIncreaseAmount += changeCount;
            if (this.maxNodeCount > 0 && this.expressionIncreaseAmount > this.maxNodeCount) {
                throw new PlanTooComplexError();
            }
        }
    }

    private static class DnfHelper {
        final RexBuilder rexBuilder;

        private DnfHelper(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode toDnf(RexNode rex) {
            switch (rex.getKind()) {
                case AND: {
                    ImmutableList<RexNode> operands = RexUtil.flattenAnd(((RexCall)rex).getOperands());
                    RexNode head = (RexNode)operands.get(0);
                    RexNode headDnf = this.toDnf(head);
                    List<RexNode> headDnfs = RelOptUtil.disjunctions(headDnf);
                    RexNode tail = this.and(Util.skip(operands));
                    RexNode tailDnf = this.toDnf(tail);
                    List<RexNode> tailDnfs = RelOptUtil.disjunctions(tailDnf);
                    ArrayList<RexNode> list = new ArrayList<RexNode>();
                    for (RexNode h : headDnfs) {
                        for (RexNode t : tailDnfs) {
                            list.add(this.and((Iterable<? extends RexNode>)ImmutableList.of((Object)h, (Object)t)));
                        }
                    }
                    return this.or(list);
                }
                case OR: {
                    ImmutableList<RexNode> operands = RexUtil.flattenOr(((RexCall)rex).getOperands());
                    return this.or(this.toDnfs((List<RexNode>)operands));
                }
                case NOT: {
                    RexNode arg = ((RexCall)rex).getOperands().get(0);
                    switch (arg.getKind()) {
                        case NOT: {
                            return this.toDnf(((RexCall)arg).getOperands().get(0));
                        }
                        case OR: {
                            List<RexNode> operands = ((RexCall)arg).getOperands();
                            return this.toDnf(this.and(Util.transform(RexUtil.flattenOr(operands), x$0 -> RexUtil.addNot(x$0))));
                        }
                        case AND: {
                            List<RexNode> operands = ((RexCall)arg).getOperands();
                            return this.toDnf(this.or(Util.transform(RexUtil.flattenAnd(operands), x$0 -> RexUtil.addNot(x$0))));
                        }
                    }
                    return rex;
                }
            }
            return rex;
        }

        private List<RexNode> toDnfs(List<RexNode> nodes) {
            ArrayList<RexNode> list = new ArrayList<RexNode>();
            block3: for (RexNode node : nodes) {
                RexNode dnf = this.toDnf(node);
                switch (dnf.getKind()) {
                    case OR: {
                        list.addAll(((RexCall)dnf).getOperands());
                        continue block3;
                    }
                }
                list.add(dnf);
            }
            return list;
        }

        private RexNode and(Iterable<? extends RexNode> nodes) {
            return RexUtil.composeConjunction(this.rexBuilder, nodes);
        }

        private RexNode or(Iterable<? extends RexNode> nodes) {
            return RexUtil.composeDisjunction(this.rexBuilder, nodes);
        }
    }

    private static class CnfHelper {
        final RexBuilder rexBuilder;
        int currentCount;
        final int maxNodeCount;

        private CnfHelper(RexBuilder rexBuilder, int maxNodeCount) {
            this.rexBuilder = rexBuilder;
            this.maxNodeCount = maxNodeCount;
        }

        public RexNode toCnf(RexNode rex) {
            try {
                this.currentCount = 0;
                return this.toCnf2(rex);
            }
            catch (PlanTooComplexError e) {
                Util.swallow(e, null);
                return rex;
            }
        }

        private RexNode toCnf2(RexNode rex) {
            switch (rex.getKind()) {
                case AND: {
                    this.incrementAndCheck();
                    ImmutableList<RexNode> operands = RexUtil.flattenAnd(((RexCall)rex).getOperands());
                    ArrayList<RexNode> cnfOperands = new ArrayList<RexNode>();
                    block13: for (RexNode node : operands) {
                        RexNode cnf = this.toCnf2(node);
                        switch (cnf.getKind()) {
                            case AND: {
                                this.incrementAndCheck();
                                cnfOperands.addAll(((RexCall)cnf).getOperands());
                                continue block13;
                            }
                        }
                        this.incrementAndCheck();
                        cnfOperands.add(cnf);
                    }
                    return this.and(cnfOperands);
                }
                case OR: {
                    this.incrementAndCheck();
                    ImmutableList<RexNode> operands = RexUtil.flattenOr(((RexCall)rex).getOperands());
                    RexNode head = (RexNode)operands.get(0);
                    RexNode headCnf = this.toCnf2(head);
                    List<RexNode> headCnfs = RelOptUtil.conjunctions(headCnf);
                    RexNode tail = this.or(Util.skip(operands));
                    RexNode tailCnf = this.toCnf2(tail);
                    List<RexNode> tailCnfs = RelOptUtil.conjunctions(tailCnf);
                    ArrayList<RexNode> list = new ArrayList<RexNode>();
                    for (RexNode h : headCnfs) {
                        for (RexNode t : tailCnfs) {
                            list.add(this.or((Iterable<? extends RexNode>)ImmutableList.of((Object)h, (Object)t)));
                        }
                    }
                    return this.and(list);
                }
                case NOT: {
                    RexNode arg = ((RexCall)rex).getOperands().get(0);
                    switch (arg.getKind()) {
                        case NOT: {
                            return this.toCnf2(((RexCall)arg).getOperands().get(0));
                        }
                        case OR: {
                            List<RexNode> operands = ((RexCall)arg).getOperands();
                            return this.toCnf2(this.and(Util.transform(RexUtil.flattenOr(operands), x$0 -> RexUtil.addNot(x$0))));
                        }
                        case AND: {
                            List<RexNode> operands = ((RexCall)arg).getOperands();
                            return this.toCnf2(this.or(Util.transform(RexUtil.flattenAnd(operands), x$0 -> RexUtil.addNot(x$0))));
                        }
                    }
                    this.incrementAndCheck();
                    return rex;
                }
            }
            this.incrementAndCheck();
            return rex;
        }

        private void incrementAndCheck() {
            if (this.maxNodeCount >= 0 && ++this.currentCount > this.maxNodeCount) {
                throw new PlanTooComplexError();
            }
        }

        private RexNode pull(RexNode rex) {
            switch (rex.getKind()) {
                case AND: {
                    ImmutableList<RexNode> operands = RexUtil.flattenAnd(((RexCall)rex).getOperands());
                    return this.and(this.pullList((List<RexNode>)operands));
                }
                case OR: {
                    ImmutableList<RexNode> operands = RexUtil.flattenOr(((RexCall)rex).getOperands());
                    LinkedHashMap<RexNode, RexNode> factors = CnfHelper.commonFactors(operands);
                    if (factors.isEmpty()) {
                        return this.or((Iterable<? extends RexNode>)operands);
                    }
                    ArrayList<RexNode> list = new ArrayList<RexNode>();
                    for (RexNode operand : operands) {
                        list.add(this.removeFactor(factors, operand));
                    }
                    return this.and(Iterables.concat(factors.values(), (Iterable)ImmutableList.of((Object)this.or(list))));
                }
            }
            return rex;
        }

        private List<RexNode> pullList(List<RexNode> nodes) {
            ArrayList<RexNode> list = new ArrayList<RexNode>();
            block3: for (RexNode node : nodes) {
                RexNode pulled = this.pull(node);
                switch (pulled.getKind()) {
                    case AND: {
                        list.addAll(((RexCall)pulled).getOperands());
                        continue block3;
                    }
                }
                list.add(pulled);
            }
            return list;
        }

        private static LinkedHashMap<RexNode, RexNode> commonFactors(List<RexNode> nodes) {
            LinkedHashMap<RexNode, RexNode> map = new LinkedHashMap<RexNode, RexNode>();
            int i = 0;
            for (RexNode node : nodes) {
                if (i++ == 0) {
                    for (RexNode conjunction : RelOptUtil.conjunctions(node)) {
                        map.put(conjunction, conjunction);
                    }
                    continue;
                }
                map.keySet().retainAll(RelOptUtil.conjunctions(node));
            }
            return map;
        }

        private RexNode removeFactor(Map<RexNode, RexNode> factors, RexNode node) {
            ArrayList<RexNode> list = new ArrayList<RexNode>();
            for (RexNode operand : RelOptUtil.conjunctions(node)) {
                if (factors.containsKey(operand)) continue;
                list.add(operand);
            }
            return this.and(list);
        }

        private RexNode and(Iterable<? extends RexNode> nodes) {
            return RexUtil.composeConjunction(this.rexBuilder, nodes);
        }

        private RexNode or(Iterable<? extends RexNode> nodes) {
            return RexUtil.composeDisjunction(this.rexBuilder, nodes);
        }
    }

    public static class FieldAccessFinder
    extends RexVisitorImpl<Void> {
        private final List<RexFieldAccess> fieldAccessList = new ArrayList<RexFieldAccess>();

        public FieldAccessFinder() {
            super(true);
        }

        @Override
        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
            this.fieldAccessList.add(fieldAccess);
            return null;
        }

        @Override
        public Void visitCall(RexCall call) {
            this.visitEach((Iterable<? extends RexNode>)call.operands);
            return null;
        }

        public List<RexFieldAccess> getFieldAccessList() {
            return this.fieldAccessList;
        }
    }

    private static class ForwardRefFinder
    extends RexVisitorImpl<Void> {
        private int limit = -1;
        private final RelDataType inputRowType;

        ForwardRefFinder(RelDataType inputRowType) {
            super(true);
            this.inputRowType = inputRowType;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            super.visitInputRef(inputRef);
            if (inputRef.getIndex() >= this.inputRowType.getFieldCount()) {
                throw new IllegalForwardRefException();
            }
            return null;
        }

        @Override
        public Void visitLocalRef(RexLocalRef inputRef) {
            super.visitLocalRef(inputRef);
            if (inputRef.getIndex() >= this.limit) {
                throw new IllegalForwardRefException();
            }
            return null;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        static class IllegalForwardRefException
        extends ControlFlowException {
            IllegalForwardRefException() {
            }
        }
    }

    private static class ExpressionNormalizer
    extends RexVisitorImpl<RexNode> {
        final Map<RexNode, RexNode> map = new HashMap<RexNode, RexNode>();
        final boolean allowDups;

        protected ExpressionNormalizer(boolean allowDups) {
            super(true);
            this.allowDups = allowDups;
        }

        protected RexNode register(RexNode expr) {
            RexNode previous = this.map.put(expr, expr);
            if (!this.allowDups && previous != null) {
                throw new SubExprExistsException(expr);
            }
            return expr;
        }

        protected RexNode lookup(RexNode expr) {
            return Objects.requireNonNull(this.map.get(expr), () -> "missing normalization for expression " + expr);
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            return this.register(inputRef);
        }

        @Override
        public RexNode visitLiteral(RexLiteral literal) {
            return this.register(literal);
        }

        @Override
        public RexNode visitCorrelVariable(RexCorrelVariable correlVariable) {
            return this.register(correlVariable);
        }

        @Override
        public RexNode visitCall(RexCall call) {
            ArrayList<RexNode> normalizedOperands = new ArrayList<RexNode>();
            int diffCount = 0;
            for (RexNode operand : call.getOperands()) {
                operand.accept(this);
                RexNode normalizedOperand = this.lookup(operand);
                normalizedOperands.add(normalizedOperand);
                if (normalizedOperand == operand) continue;
                ++diffCount;
            }
            if (diffCount > 0) {
                call = call.clone(call.getType(), normalizedOperands);
            }
            return this.register(call);
        }

        @Override
        public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
            return this.register(dynamicParam);
        }

        @Override
        public RexNode visitRangeRef(RexRangeRef rangeRef) {
            return this.register(rangeRef);
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            RexNode expr = fieldAccess.getReferenceExpr();
            expr.accept(this);
            RexNode normalizedExpr = this.lookup(expr);
            if (normalizedExpr != expr) {
                fieldAccess = new RexFieldAccess(normalizedExpr, fieldAccess.getField(), fieldAccess.getType());
            }
            return this.register(fieldAccess);
        }

        private static class SubExprExistsException
        extends ControlFlowException {
            SubExprExistsException(RexNode expr) {
                Util.discard(expr);
            }
        }
    }

    static class ConstantFinder
    implements RexVisitor<Boolean> {
        static final ConstantFinder INSTANCE = new ConstantFinder();

        ConstantFinder() {
        }

        @Override
        public Boolean visitLiteral(RexLiteral literal) {
            return true;
        }

        @Override
        public Boolean visitInputRef(RexInputRef inputRef) {
            return false;
        }

        @Override
        public Boolean visitLocalRef(RexLocalRef localRef) {
            return false;
        }

        @Override
        public Boolean visitOver(RexOver over) {
            return false;
        }

        @Override
        public Boolean visitSubQuery(RexSubQuery subQuery) {
            return false;
        }

        @Override
        public Boolean visitTableInputRef(RexTableInputRef ref) {
            return false;
        }

        @Override
        public Boolean visitPatternFieldRef(RexPatternFieldRef fieldRef) {
            return false;
        }

        @Override
        public Boolean visitCorrelVariable(RexCorrelVariable correlVariable) {
            return false;
        }

        @Override
        public Boolean visitDynamicParam(RexDynamicParam dynamicParam) {
            return true;
        }

        @Override
        public Boolean visitCall(RexCall call) {
            return call.getOperator().isDeterministic() && RexVisitorImpl.visitArrayAnd(this, call.getOperands());
        }

        @Override
        public Boolean visitRangeRef(RexRangeRef rangeRef) {
            return false;
        }

        @Override
        public Boolean visitFieldAccess(RexFieldAccess fieldAccess) {
            return fieldAccess.getReferenceExpr().accept(this);
        }

        @Override
        public Boolean visitLambda(RexLambda lambda) {
            return false;
        }

        @Override
        public Boolean visitLambdaRef(RexLambdaRef lambdaRef) {
            return false;
        }

        @Override
        public Boolean visitNodeAndFieldIndex(RexNodeAndFieldIndex nodeAndFieldIndex) {
            return false;
        }
    }
}

