/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import org.apiguardian.api.API;

public enum SqlKind {
    OTHER,
    SELECT,
    HINT,
    TABLE_REF,
    JOIN,
    IDENTIFIER,
    LITERAL,
    INTERVAL_QUALIFIER,
    OTHER_FUNCTION,
    SET_SEMANTICS_TABLE,
    CONVERT,
    CONVERT_ORACLE,
    TRANSLATE,
    POSITION,
    EXPLAIN,
    DESCRIBE_SCHEMA,
    DESCRIBE_TABLE,
    INSERT,
    DELETE,
    UPDATE,
    SET_OPTION,
    DYNAMIC_PARAM,
    GROUP_BY_DISTINCT,
    ORDER_BY,
    WITH,
    WITH_ITEM,
    WITH_ITEM_TABLE_REF,
    ITEM,
    UNION,
    EXCEPT,
    INTERSECT,
    AS,
    MEASURE,
    V2M,
    M2V,
    M2X,
    AGG_M2M,
    AGG_M2V,
    SAME_PARTITION,
    ARGUMENT_ASSIGNMENT,
    DEFAULT,
    OVER,
    RESPECT_NULLS("RESPECT NULLS"),
    IGNORE_NULLS("IGNORE NULLS"),
    FILTER,
    WITHIN_GROUP,
    WITHIN_DISTINCT,
    WINDOW,
    MERGE,
    TABLESAMPLE,
    PIVOT,
    UNPIVOT,
    MATCH_RECOGNIZE,
    SNAPSHOT,
    TIMES,
    DIVIDE,
    MOD,
    PLUS,
    MINUS,
    CHECKED_PLUS,
    CHECKED_MINUS,
    CHECKED_TIMES,
    CHECKED_DIVIDE,
    PATTERN_ALTER,
    PATTERN_CONCAT,
    IN,
    NOT_IN("NOT IN"),
    DRUID_IN,
    DRUID_NOT_IN,
    LESS_THAN("<"),
    GREATER_THAN(">"),
    LESS_THAN_OR_EQUAL("<="),
    GREATER_THAN_OR_EQUAL(">="),
    EQUALS("="),
    NOT_EQUALS("<>"),
    IS_DISTINCT_FROM,
    IS_NOT_DISTINCT_FROM,
    SEARCH,
    OR,
    AND,
    DOT,
    OVERLAPS,
    CONTAINS,
    PRECEDES,
    IMMEDIATELY_PRECEDES("IMMEDIATELY PRECEDES"),
    SUCCEEDS,
    IMMEDIATELY_SUCCEEDS("IMMEDIATELY SUCCEEDS"),
    PERIOD_EQUALS("EQUALS"),
    LIKE,
    RLIKE,
    SIMILAR,
    POSIX_REGEX_CASE_SENSITIVE,
    POSIX_REGEX_CASE_INSENSITIVE,
    BETWEEN,
    DRUID_BETWEEN,
    CASE,
    LAMBDA,
    INTERVAL,
    SEPARATOR,
    NULLIF,
    COALESCE,
    DECODE,
    NVL,
    NVL2,
    GREATEST,
    GREATEST_PG,
    CONCAT2,
    CONCAT_WITH_NULL,
    CONCAT_WS_MSSQL,
    CONCAT_WS_POSTGRESQL,
    CONCAT_WS_SPARK,
    IF,
    LEAST,
    LEAST_PG,
    LOG,
    DATE_ADD,
    ADD_MONTHS,
    DATE_TRUNC,
    DATE_SUB,
    TIME_ADD,
    TIME_SUB,
    TIMESTAMP_ADD,
    TIMESTAMP_DIFF,
    TIMESTAMP_SUB,
    NOT,
    PLUS_PREFIX,
    MINUS_PREFIX,
    CHECKED_MINUS_PREFIX,
    EXISTS,
    SOME,
    ALL,
    VALUES,
    EXPLICIT_TABLE,
    SCALAR_QUERY,
    PROCEDURE_CALL,
    NEW_SPECIFICATION,
    FINAL,
    RUNNING,
    PREV,
    NEXT,
    FIRST,
    LAST,
    CLASSIFIER,
    MATCH_NUMBER,
    SKIP_TO_FIRST,
    SKIP_TO_LAST,
    DESCENDING,
    NULLS_FIRST,
    NULLS_LAST,
    IS_TRUE,
    IS_FALSE,
    IS_NOT_TRUE,
    IS_NOT_FALSE,
    IS_UNKNOWN,
    IS_NULL,
    IS_NOT_NULL,
    CAST_NOT_NULL,
    PRECEDING,
    FOLLOWING,
    FIELD_ACCESS,
    INPUT_REF,
    TABLE_INPUT_REF,
    PATTERN_INPUT_REF,
    LOCAL_REF,
    LAMBDA_REF,
    CORREL_VARIABLE,
    PATTERN_QUANTIFIER,
    ROW,
    COLUMN_LIST,
    CAST,
    SAFE_CAST,
    NEXT_VALUE,
    CURRENT_VALUE,
    FLOOR,
    CEIL,
    TRIM,
    LTRIM,
    RTRIM,
    EXTRACT,
    ARRAY_APPEND,
    ARRAY_COMPACT,
    ARRAY_CONCAT,
    ARRAY_CONTAINS,
    ARRAY_DISTINCT,
    ARRAY_EXCEPT,
    ARRAY_INSERT,
    ARRAY_INTERSECT,
    ARRAY_JOIN,
    ARRAY_LENGTH,
    ARRAY_MAX,
    ARRAY_MIN,
    ARRAY_POSITION,
    ARRAY_PREPEND,
    ARRAY_REMOVE,
    ARRAY_REPEAT,
    ARRAY_REVERSE,
    ARRAY_SIZE,
    ARRAY_SLICE,
    ARRAY_TO_STRING,
    ARRAY_UNION,
    ARRAYS_OVERLAP,
    ARRAYS_ZIP,
    SORT_ARRAY,
    MAP_CONCAT,
    MAP_ENTRIES,
    MAP_KEYS,
    MAP_VALUES,
    MAP_CONTAINS_KEY,
    MAP_FROM_ARRAYS,
    MAP_FROM_ENTRIES,
    STR_TO_MAP,
    SUBSTRING_INDEX,
    REVERSE,
    REVERSE_SPARK,
    SOUNDEX_SPARK,
    SUBSTR_BIG_QUERY,
    SUBSTR_MYSQL,
    SUBSTR_ORACLE,
    SUBSTR_POSTGRESQL,
    CHAR_LENGTH,
    ENDS_WITH,
    STARTS_WITH,
    STRING_TO_ARRAY,
    JDBC_FN,
    MULTISET_VALUE_CONSTRUCTOR,
    MULTISET_QUERY_CONSTRUCTOR,
    JSON_VALUE_EXPRESSION,
    JSON_ARRAYAGG,
    JSON_OBJECTAGG,
    JSON_TYPE,
    UNNEST,
    LATERAL,
    COLLECTION_TABLE,
    ARRAY_VALUE_CONSTRUCTOR,
    ARRAY_QUERY_CONSTRUCTOR,
    MAP_VALUE_CONSTRUCTOR,
    MAP_QUERY_CONSTRUCTOR,
    CURSOR,
    CONTAINS_SUBSTR,
    LITERAL_AGG,
    LITERAL_CHAIN,
    ESCAPE,
    REINTERPRET,
    EXTEND,
    CUBE,
    ROLLUP,
    GROUPING_SETS,
    GROUPING,
    GROUPING_ID,
    GROUP_ID,
    PATTERN_PERMUTE,
    PATTERN_EXCLUDED,
    COUNT,
    SUM,
    SUM0,
    MIN,
    MAX,
    LEAD,
    LAG,
    FIRST_VALUE,
    LAST_VALUE,
    ANY_VALUE,
    COVAR_POP,
    COVAR_SAMP,
    REGR_COUNT,
    REGR_SXX,
    REGR_SYY,
    AVG,
    STDDEV_POP,
    STDDEV_SAMP,
    VAR_POP,
    VAR_SAMP,
    NTILE,
    NTH_VALUE,
    LISTAGG,
    STRING_AGG,
    COUNTIF,
    ARRAY_AGG,
    ARRAY_CONCAT_AGG,
    GROUP_CONCAT,
    COLLECT,
    MODE,
    ARG_MAX,
    ARG_MIN,
    PERCENTILE_CONT,
    PERCENTILE_DISC,
    FUSION,
    INTERSECTION,
    SINGLE_VALUE,
    AGGREGATE_FN,
    BITAND,
    BITOR,
    BITXOR,
    BITNOT,
    BIT_AND,
    BIT_OR,
    BIT_XOR,
    ROW_NUMBER,
    RANK,
    PERCENT_RANK,
    DENSE_RANK,
    CUME_DIST,
    DESCRIPTOR,
    TUMBLE,
    TUMBLE_START,
    TUMBLE_END,
    HOP,
    HOP_START,
    HOP_END,
    SESSION,
    SESSION_START,
    SESSION_END,
    COLUMN_DECL,
    ATTRIBUTE_DEF,
    CHECK,
    UNIQUE,
    PRIMARY_KEY,
    FOREIGN_KEY,
    ST_DWITHIN,
    ST_POINT,
    ST_POINT3,
    ST_MAKE_LINE,
    ST_CONTAINS,
    HILBERT,
    COMMIT,
    ROLLBACK,
    ALTER_SESSION,
    CREATE_SCHEMA,
    CREATE_FOREIGN_SCHEMA,
    DROP_SCHEMA,
    CREATE_TABLE,
    CREATE_TABLE_LIKE,
    ALTER_TABLE,
    DROP_TABLE,
    TRUNCATE_TABLE,
    CREATE_VIEW,
    ALTER_VIEW,
    DROP_VIEW,
    CREATE_MATERIALIZED_VIEW,
    ALTER_MATERIALIZED_VIEW,
    DROP_MATERIALIZED_VIEW,
    CREATE_SEQUENCE,
    ALTER_SEQUENCE,
    DROP_SEQUENCE,
    CREATE_INDEX,
    ALTER_INDEX,
    DROP_INDEX,
    CREATE_TYPE,
    DROP_TYPE,
    CREATE_FUNCTION,
    DROP_FUNCTION,
    OTHER_DDL;

    public static final EnumSet<SqlKind> SET_QUERY;
    public static final EnumSet<SqlKind> AGGREGATE;
    public static final EnumSet<SqlKind> DML;
    public static final EnumSet<SqlKind> DDL;
    public static final EnumSet<SqlKind> QUERY;
    public static final Set<SqlKind> EXPRESSION;
    public static final EnumSet<SqlKind> TOP_LEVEL;
    public static final Set<SqlKind> FUNCTION;
    public static final Set<SqlKind> AVG_AGG_FUNCTIONS;
    public static final Set<SqlKind> COVAR_AVG_AGG_FUNCTIONS;
    public static final Set<SqlKind> COMPARISON;
    public static final Set<SqlKind> ORDER_COMPARISON;
    public static final Set<SqlKind> BINARY_ARITHMETIC;
    public static final Set<SqlKind> CHECKED_ARITHMETIC;
    public static final Set<SqlKind> BINARY_EQUALITY;
    public static final Set<SqlKind> BINARY_COMPARISON;
    @API(since="1.22", status=API.Status.EXPERIMENTAL)
    public static final Set<SqlKind> SYMMETRICAL;
    @API(since="1.22", status=API.Status.EXPERIMENTAL)
    public static final Set<SqlKind> SYMMETRICAL_SAME_ARG_TYPE;
    @API(since="1.24", status=API.Status.EXPERIMENTAL)
    public static final Set<SqlKind> SIMPLE_BINARY_OPS;
    public final String lowerName = this.name().toLowerCase(Locale.ROOT);
    public final String sql;

    private SqlKind() {
        this.sql = this.name();
    }

    private SqlKind(String sql) {
        this.sql = sql;
    }

    public SqlKind reverse() {
        switch (this) {
            case GREATER_THAN: {
                return LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return GREATER_THAN_OR_EQUAL;
            }
        }
        return this;
    }

    public SqlKind negate() {
        switch (this) {
            case IS_TRUE: {
                return IS_NOT_TRUE;
            }
            case IS_FALSE: {
                return IS_NOT_FALSE;
            }
            case IS_NULL: {
                return IS_NOT_NULL;
            }
            case IS_NOT_TRUE: {
                return IS_TRUE;
            }
            case IS_NOT_FALSE: {
                return IS_FALSE;
            }
            case IS_NOT_NULL: {
                return IS_NULL;
            }
            case IS_DISTINCT_FROM: {
                return IS_NOT_DISTINCT_FROM;
            }
            case IS_NOT_DISTINCT_FROM: {
                return IS_DISTINCT_FROM;
            }
        }
        return this;
    }

    public SqlKind negateNullSafe() {
        switch (this) {
            case EQUALS: {
                return NOT_EQUALS;
            }
            case NOT_EQUALS: {
                return EQUALS;
            }
            case LESS_THAN: {
                return GREATER_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN_OR_EQUAL: {
                return GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return LESS_THAN;
            }
            case IN: {
                return NOT_IN;
            }
            case NOT_IN: {
                return IN;
            }
            case DRUID_IN: {
                return DRUID_NOT_IN;
            }
            case DRUID_NOT_IN: {
                return DRUID_IN;
            }
            case IS_TRUE: {
                return IS_FALSE;
            }
            case IS_FALSE: {
                return IS_TRUE;
            }
            case IS_NOT_TRUE: {
                return IS_NOT_FALSE;
            }
            case IS_NOT_FALSE: {
                return IS_NOT_TRUE;
            }
            case IS_NULL: 
            case IS_NOT_NULL: {
                return this;
            }
        }
        return this.negate();
    }

    public final boolean belongsTo(Collection<SqlKind> category) {
        return category.contains((Object)this);
    }

    public SqlKind getFunctionKind() {
        switch (this) {
            case CONVERT: 
            case TRANSLATE: 
            case POSITION: 
            case DECODE: 
            case NVL: 
            case NVL2: 
            case GREATEST: 
            case GREATEST_PG: 
            case CONCAT2: 
            case CONCAT_WITH_NULL: 
            case CONCAT_WS_MSSQL: 
            case CONCAT_WS_POSTGRESQL: 
            case CONCAT_WS_SPARK: 
            case IF: 
            case LEAST: 
            case LEAST_PG: 
            case LOG: 
            case DATE_ADD: 
            case DATE_TRUNC: 
            case DATE_SUB: 
            case TIME_ADD: 
            case TIME_SUB: 
            case TIMESTAMP_ADD: 
            case TIMESTAMP_DIFF: 
            case TIMESTAMP_SUB: 
            case SAFE_CAST: 
            case FLOOR: 
            case CEIL: 
            case TRIM: 
            case LTRIM: 
            case RTRIM: 
            case ARRAY_APPEND: 
            case ARRAY_COMPACT: 
            case ARRAY_CONCAT: 
            case ARRAY_CONTAINS: 
            case ARRAY_DISTINCT: 
            case ARRAY_EXCEPT: 
            case ARRAY_INSERT: 
            case ARRAY_INTERSECT: 
            case ARRAY_JOIN: 
            case ARRAY_LENGTH: 
            case ARRAY_MAX: 
            case ARRAY_MIN: 
            case ARRAY_POSITION: 
            case ARRAY_PREPEND: 
            case ARRAY_REMOVE: 
            case ARRAY_REPEAT: 
            case ARRAY_REVERSE: 
            case ARRAY_SIZE: 
            case ARRAY_SLICE: 
            case ARRAY_TO_STRING: 
            case ARRAY_UNION: 
            case ARRAYS_OVERLAP: 
            case ARRAYS_ZIP: 
            case SORT_ARRAY: 
            case MAP_CONCAT: 
            case MAP_ENTRIES: 
            case MAP_KEYS: 
            case MAP_VALUES: 
            case MAP_CONTAINS_KEY: 
            case MAP_FROM_ARRAYS: 
            case MAP_FROM_ENTRIES: 
            case STR_TO_MAP: 
            case REVERSE: 
            case REVERSE_SPARK: 
            case SOUNDEX_SPARK: 
            case STRING_TO_ARRAY: 
            case SUBSTR_BIG_QUERY: 
            case SUBSTR_MYSQL: 
            case SUBSTR_ORACLE: 
            case SUBSTR_POSTGRESQL: 
            case CHAR_LENGTH: 
            case ENDS_WITH: 
            case STARTS_WITH: 
            case JSON_TYPE: 
            case CONTAINS_SUBSTR: 
            case ST_DWITHIN: 
            case ST_POINT: 
            case ST_POINT3: 
            case ST_MAKE_LINE: 
            case ST_CONTAINS: 
            case HILBERT: {
                return OTHER_FUNCTION;
            }
        }
        return this;
    }

    @SafeVarargs
    private static <E extends Enum<E>> EnumSet<E> concat(EnumSet<E> set0, EnumSet<E> ... sets) {
        Object set = set0.clone();
        for (EnumSet<E> s : sets) {
            ((AbstractCollection)set).addAll(s);
        }
        return set;
    }

    static {
        SET_QUERY = EnumSet.of(UNION, INTERSECT, EXCEPT);
        AGGREGATE = EnumSet.of(COUNT, new SqlKind[]{SUM, SUM0, MIN, MAX, LEAD, LAG, FIRST_VALUE, LAST_VALUE, COVAR_POP, COVAR_SAMP, REGR_COUNT, REGR_SXX, REGR_SYY, AVG, STDDEV_POP, STDDEV_SAMP, VAR_POP, VAR_SAMP, NTILE, COLLECT, MODE, FUSION, SINGLE_VALUE, ROW_NUMBER, RANK, PERCENT_RANK, DENSE_RANK, CUME_DIST, JSON_ARRAYAGG, JSON_OBJECTAGG, BIT_AND, BIT_OR, BIT_XOR, LISTAGG, STRING_AGG, ARRAY_AGG, ARRAY_CONCAT_AGG, GROUP_CONCAT, COUNTIF, PERCENTILE_CONT, PERCENTILE_DISC, INTERSECTION, ANY_VALUE});
        DML = EnumSet.of(INSERT, DELETE, UPDATE, MERGE, PROCEDURE_CALL);
        DDL = EnumSet.of(COMMIT, new SqlKind[]{ROLLBACK, ALTER_SESSION, CREATE_SCHEMA, CREATE_FOREIGN_SCHEMA, DROP_SCHEMA, CREATE_TABLE, CREATE_TABLE_LIKE, ALTER_TABLE, DROP_TABLE, TRUNCATE_TABLE, CREATE_FUNCTION, DROP_FUNCTION, CREATE_VIEW, ALTER_VIEW, DROP_VIEW, CREATE_MATERIALIZED_VIEW, ALTER_MATERIALIZED_VIEW, DROP_MATERIALIZED_VIEW, CREATE_SEQUENCE, ALTER_SEQUENCE, DROP_SEQUENCE, CREATE_INDEX, ALTER_INDEX, DROP_INDEX, CREATE_TYPE, DROP_TYPE, SET_OPTION, OTHER_DDL});
        QUERY = EnumSet.of(SELECT, new SqlKind[]{UNION, INTERSECT, EXCEPT, VALUES, WITH, ORDER_BY, EXPLICIT_TABLE});
        EXPRESSION = EnumSet.complementOf(SqlKind.concat(EnumSet.of(AS, new SqlKind[]{ARGUMENT_ASSIGNMENT, CONVERT, CONVERT_ORACLE, TRANSLATE, DEFAULT, RUNNING, FINAL, LAST, FIRST, PREV, NEXT, FILTER, WITHIN_GROUP, IGNORE_NULLS, RESPECT_NULLS, SEPARATOR, DESCENDING, CUBE, ROLLUP, GROUPING_SETS, EXTEND, LATERAL, SELECT, JOIN, OTHER_FUNCTION, POSITION, CAST, TRIM, FLOOR, CEIL, DATE_ADD, DATE_SUB, TIME_ADD, TIME_SUB, TIMESTAMP_ADD, TIMESTAMP_DIFF, TIMESTAMP_SUB, EXTRACT, INTERVAL, LITERAL_CHAIN, JDBC_FN, PRECEDING, FOLLOWING, ORDER_BY, NULLS_FIRST, NULLS_LAST, COLLECTION_TABLE, TABLESAMPLE, VALUES, WITH, WITH_ITEM, ITEM, SKIP_TO_FIRST, SKIP_TO_LAST, JSON_VALUE_EXPRESSION, UNNEST}), SET_QUERY, AGGREGATE, DML, DDL));
        TOP_LEVEL = SqlKind.concat(QUERY, DML, DDL);
        FUNCTION = EnumSet.of(OTHER_FUNCTION, new SqlKind[]{ROW, TRIM, LTRIM, RTRIM, CAST, REVERSE, JDBC_FN, POSITION, CONVERT});
        AVG_AGG_FUNCTIONS = EnumSet.of(AVG, STDDEV_POP, STDDEV_SAMP, VAR_POP, VAR_SAMP);
        COVAR_AVG_AGG_FUNCTIONS = EnumSet.of(COVAR_POP, COVAR_SAMP, REGR_COUNT, REGR_SXX, REGR_SYY);
        COMPARISON = EnumSet.of(IN, new SqlKind[]{NOT_IN, EQUALS, NOT_EQUALS, LESS_THAN, GREATER_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL});
        ORDER_COMPARISON = EnumSet.of(LESS_THAN, GREATER_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL);
        BINARY_ARITHMETIC = EnumSet.of(PLUS, new SqlKind[]{MINUS, TIMES, DIVIDE, MOD, CHECKED_PLUS, CHECKED_MINUS, CHECKED_TIMES, CHECKED_DIVIDE});
        CHECKED_ARITHMETIC = EnumSet.of(CHECKED_PLUS, CHECKED_MINUS, CHECKED_TIMES, CHECKED_DIVIDE, CHECKED_MINUS_PREFIX);
        BINARY_EQUALITY = EnumSet.of(EQUALS, NOT_EQUALS);
        BINARY_COMPARISON = EnumSet.of(EQUALS, new SqlKind[]{NOT_EQUALS, GREATER_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN, LESS_THAN_OR_EQUAL, IS_DISTINCT_FROM, IS_NOT_DISTINCT_FROM});
        SYMMETRICAL = EnumSet.of(AND, new SqlKind[]{OR, EQUALS, NOT_EQUALS, IS_DISTINCT_FROM, IS_NOT_DISTINCT_FROM, GREATEST, LEAST});
        SYMMETRICAL_SAME_ARG_TYPE = EnumSet.of(PLUS, TIMES, CHECKED_PLUS, CHECKED_TIMES);
        EnumSet<SqlKind> kinds = EnumSet.copyOf(BINARY_ARITHMETIC);
        kinds.remove((Object)MOD);
        kinds.addAll(BINARY_COMPARISON);
        SIMPLE_BINARY_OPS = Sets.immutableEnumSet(kinds);
    }
}

