/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBasicFunction;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDescriptorOperator;
import org.apache.calcite.sql.SqlFilterOperator;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlGroupedWindowFunction;
import org.apache.calcite.sql.SqlHopTableFunction;
import org.apache.calcite.sql.SqlInternalOperator;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLateralOperator;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMatchFunction;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNullTreatmentOperator;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOverOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlProcedureCallOperator;
import org.apache.calcite.sql.SqlRankFunction;
import org.apache.calcite.sql.SqlSessionTableFunction;
import org.apache.calcite.sql.SqlSetOperator;
import org.apache.calcite.sql.SqlSetSemanticsTableOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlTumbleTableFunction;
import org.apache.calcite.sql.SqlUnnestOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlValuesOperator;
import org.apache.calcite.sql.SqlWithinDistinctOperator;
import org.apache.calcite.sql.SqlWithinGroupOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.LibraryOperator;
import org.apache.calcite.sql.fun.SqlAbstractTimeFunction;
import org.apache.calcite.sql.fun.SqlAnyValueAggFunction;
import org.apache.calcite.sql.fun.SqlArgumentAssignmentOperator;
import org.apache.calcite.sql.fun.SqlArrayQueryConstructor;
import org.apache.calcite.sql.fun.SqlArrayValueConstructor;
import org.apache.calcite.sql.fun.SqlAvgAggFunction;
import org.apache.calcite.sql.fun.SqlBasicAggFunction;
import org.apache.calcite.sql.fun.SqlBetweenOperator;
import org.apache.calcite.sql.fun.SqlBitOpAggFunction;
import org.apache.calcite.sql.fun.SqlCaseOperator;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.sql.fun.SqlCoalesceFunction;
import org.apache.calcite.sql.fun.SqlCollectionTableOperator;
import org.apache.calcite.sql.fun.SqlColumnListConstructor;
import org.apache.calcite.sql.fun.SqlConvertFunction;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlCovarAggFunction;
import org.apache.calcite.sql.fun.SqlCurrentDateFunction;
import org.apache.calcite.sql.fun.SqlCursorConstructor;
import org.apache.calcite.sql.fun.SqlDatePartFunction;
import org.apache.calcite.sql.fun.SqlDatetimePlusOperator;
import org.apache.calcite.sql.fun.SqlDatetimeSubtractionOperator;
import org.apache.calcite.sql.fun.SqlDefaultOperator;
import org.apache.calcite.sql.fun.SqlDotOperator;
import org.apache.calcite.sql.fun.SqlExtendOperator;
import org.apache.calcite.sql.fun.SqlExtractFunction;
import org.apache.calcite.sql.fun.SqlFirstLastValueAggFunction;
import org.apache.calcite.sql.fun.SqlFloorFunction;
import org.apache.calcite.sql.fun.SqlGroupIdFunction;
import org.apache.calcite.sql.fun.SqlGroupingFunction;
import org.apache.calcite.sql.fun.SqlHistogramAggFunction;
import org.apache.calcite.sql.fun.SqlInOperator;
import org.apache.calcite.sql.fun.SqlIntervalOperator;
import org.apache.calcite.sql.fun.SqlItemOperator;
import org.apache.calcite.sql.fun.SqlJsonArrayAggAggFunction;
import org.apache.calcite.sql.fun.SqlJsonArrayFunction;
import org.apache.calcite.sql.fun.SqlJsonDepthFunction;
import org.apache.calcite.sql.fun.SqlJsonExistsFunction;
import org.apache.calcite.sql.fun.SqlJsonKeysFunction;
import org.apache.calcite.sql.fun.SqlJsonLengthFunction;
import org.apache.calcite.sql.fun.SqlJsonModifyFunction;
import org.apache.calcite.sql.fun.SqlJsonObjectAggAggFunction;
import org.apache.calcite.sql.fun.SqlJsonObjectFunction;
import org.apache.calcite.sql.fun.SqlJsonPrettyFunction;
import org.apache.calcite.sql.fun.SqlJsonQueryFunction;
import org.apache.calcite.sql.fun.SqlJsonRemoveFunction;
import org.apache.calcite.sql.fun.SqlJsonStorageSizeFunction;
import org.apache.calcite.sql.fun.SqlJsonTypeFunction;
import org.apache.calcite.sql.fun.SqlJsonTypeOperator;
import org.apache.calcite.sql.fun.SqlJsonValueExpressionOperator;
import org.apache.calcite.sql.fun.SqlJsonValueFunction;
import org.apache.calcite.sql.fun.SqlLeadLagAggFunction;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlLikeOperator;
import org.apache.calcite.sql.fun.SqlListaggAggFunction;
import org.apache.calcite.sql.fun.SqlLiteralChainOperator;
import org.apache.calcite.sql.fun.SqlMapQueryConstructor;
import org.apache.calcite.sql.fun.SqlMapValueConstructor;
import org.apache.calcite.sql.fun.SqlMinMaxAggFunction;
import org.apache.calcite.sql.fun.SqlMonotonicBinaryOperator;
import org.apache.calcite.sql.fun.SqlMultisetMemberOfOperator;
import org.apache.calcite.sql.fun.SqlMultisetQueryConstructor;
import org.apache.calcite.sql.fun.SqlMultisetSetOperator;
import org.apache.calcite.sql.fun.SqlMultisetValueConstructor;
import org.apache.calcite.sql.fun.SqlNewOperator;
import org.apache.calcite.sql.fun.SqlNthValueAggFunction;
import org.apache.calcite.sql.fun.SqlNtileAggFunction;
import org.apache.calcite.sql.fun.SqlNullifFunction;
import org.apache.calcite.sql.fun.SqlOverlapsOperator;
import org.apache.calcite.sql.fun.SqlOverlayFunction;
import org.apache.calcite.sql.fun.SqlPositionFunction;
import org.apache.calcite.sql.fun.SqlPosixRegexOperator;
import org.apache.calcite.sql.fun.SqlQuantifyOperator;
import org.apache.calcite.sql.fun.SqlRandIntegerFunction;
import org.apache.calcite.sql.fun.SqlRegrCountAggFunction;
import org.apache.calcite.sql.fun.SqlRollupOperator;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.fun.SqlSearchOperator;
import org.apache.calcite.sql.fun.SqlSequenceValueOperator;
import org.apache.calcite.sql.fun.SqlSingleValueAggFunction;
import org.apache.calcite.sql.fun.SqlStringContextVariable;
import org.apache.calcite.sql.fun.SqlSubstringFunction;
import org.apache.calcite.sql.fun.SqlSumAggFunction;
import org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.apache.calcite.sql.fun.SqlThrowOperator;
import org.apache.calcite.sql.fun.SqlTimestampAddFunction;
import org.apache.calcite.sql.fun.SqlTimestampDiffFunction;
import org.apache.calcite.sql.fun.SqlTranslateFunction;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.ReflectiveSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql2rel.AuxiliaryConverter;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Optionality;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlStdOperatorTable
extends ReflectiveSqlOperatorTable {
    private static final Supplier<SqlStdOperatorTable> INSTANCE = Suppliers.memoize(() -> (SqlStdOperatorTable)new SqlStdOperatorTable().init());
    public static final SqlSetOperator UNION = new SqlSetOperator("UNION", SqlKind.UNION, 12, false);
    public static final SqlSetOperator UNION_ALL = new SqlSetOperator("UNION ALL", SqlKind.UNION, 12, true);
    public static final SqlSetOperator EXCEPT = new SqlSetOperator("EXCEPT", SqlKind.EXCEPT, 12, false);
    public static final SqlSetOperator EXCEPT_ALL = new SqlSetOperator("EXCEPT ALL", SqlKind.EXCEPT, 12, true);
    public static final SqlSetOperator INTERSECT = new SqlSetOperator("INTERSECT", SqlKind.INTERSECT, 14, false);
    public static final SqlSetOperator INTERSECT_ALL = new SqlSetOperator("INTERSECT ALL", SqlKind.INTERSECT, 14, true);
    public static final SqlMultisetSetOperator MULTISET_UNION_DISTINCT = new SqlMultisetSetOperator("MULTISET UNION DISTINCT", 12, false);
    public static final SqlMultisetSetOperator MULTISET_UNION = new SqlMultisetSetOperator("MULTISET UNION ALL", 12, true);
    public static final SqlMultisetSetOperator MULTISET_EXCEPT_DISTINCT = new SqlMultisetSetOperator("MULTISET EXCEPT DISTINCT", 12, false);
    public static final SqlMultisetSetOperator MULTISET_EXCEPT = new SqlMultisetSetOperator("MULTISET EXCEPT ALL", 12, true);
    public static final SqlMultisetSetOperator MULTISET_INTERSECT_DISTINCT = new SqlMultisetSetOperator("MULTISET INTERSECT DISTINCT", 14, false);
    public static final SqlMultisetSetOperator MULTISET_INTERSECT = new SqlMultisetSetOperator("MULTISET INTERSECT ALL", 14, true);
    public static final SqlBinaryOperator AND = new SqlBinaryOperator("AND", SqlKind.AND, 24, true, ReturnTypes.BOOLEAN_NULLABLE_OPTIMIZED, InferTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.BOOLEAN_BOOLEAN);
    public static final SqlAsOperator AS = new SqlAsOperator();
    public static final SqlSpecialOperator ARGUMENT_ASSIGNMENT = new SqlArgumentAssignmentOperator();
    public static final SqlSpecialOperator DEFAULT = new SqlDefaultOperator();
    public static final SqlFilterOperator FILTER = new SqlFilterOperator();
    public static final SqlWithinGroupOperator WITHIN_GROUP = new SqlWithinGroupOperator();
    public static final SqlWithinDistinctOperator WITHIN_DISTINCT = new SqlWithinDistinctOperator();
    public static final SqlInternalOperator CUBE = new SqlRollupOperator("CUBE", SqlKind.CUBE);
    public static final SqlInternalOperator ROLLUP = new SqlRollupOperator("ROLLUP", SqlKind.ROLLUP);
    public static final SqlInternalOperator GROUPING_SETS = new SqlRollupOperator("GROUPING SETS", SqlKind.GROUPING_SETS);
    public static final SqlAggFunction GROUPING = new SqlGroupingFunction("GROUPING");
    public static final SqlAggFunction GROUP_ID = new SqlGroupIdFunction();
    public static final SqlAggFunction GROUPING_ID = new SqlGroupingFunction("GROUPING_ID");
    public static final SqlInternalOperator EXTEND = new SqlExtendOperator();
    public static final SqlBinaryOperator CONCAT = new SqlBinaryOperator("||", SqlKind.OTHER, 60, true, ReturnTypes.ARG0.andThen((opBinding, typeToTransform) -> {
        SqlReturnTypeInference returnType = typeToTransform.getSqlTypeName().getFamily() == SqlTypeFamily.ARRAY ? ReturnTypes.LEAST_RESTRICTIVE : ReturnTypes.DYADIC_STRING_SUM_PRECISION_NULLABLE;
        RelDataType type = returnType.inferReturnType(opBinding);
        if (type == null) {
            throw opBinding.newError(Static.RESOURCE.cannotInferReturnType(opBinding.getOperator().toString(), opBinding.collectOperandTypes().toString()));
        }
        return type;
    }), null, (SqlOperandTypeChecker)OperandTypes.STRING_SAME_SAME_OR_ARRAY_SAME_SAME);
    public static final SqlBinaryOperator DIVIDE = new SqlBinaryOperator("/", SqlKind.DIVIDE, 60, true, ReturnTypes.QUOTIENT_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.DIVISION_OPERATOR);
    public static final SqlBinaryOperator CHECKED_DIVIDE = new SqlBinaryOperator("/", SqlKind.CHECKED_DIVIDE, 60, true, ReturnTypes.QUOTIENT_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.DIVISION_OPERATOR);
    public static final SqlBinaryOperator PERCENT_REMAINDER = new SqlBinaryOperator("%", SqlKind.MOD, 60, true, ReturnTypes.NULLABLE_MOD, null, (SqlOperandTypeChecker)OperandTypes.EXACT_NUMERIC_EXACT_NUMERIC);
    public static final SqlRandIntegerFunction RAND_INTEGER = new SqlRandIntegerFunction();
    public static final SqlBasicFunction RAND = SqlBasicFunction.create("RAND", ReturnTypes.DOUBLE, OperandTypes.NILADIC.or(OperandTypes.NUMERIC), SqlFunctionCategory.NUMERIC).withDeterministic(false).withDynamic(true);
    public static final SqlBinaryOperator DIVIDE_INTEGER = new SqlBinaryOperator("/INT", SqlKind.DIVIDE, 60, true, ReturnTypes.INTEGER_QUOTIENT_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.DIVISION_OPERATOR);
    public static final SqlBinaryOperator CHECKED_DIVIDE_INTEGER = new SqlBinaryOperator("/INT", SqlKind.CHECKED_DIVIDE, 60, true, ReturnTypes.INTEGER_QUOTIENT_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.DIVISION_OPERATOR);
    public static final SqlOperator DOT = new SqlDotOperator();
    public static final SqlBinaryOperator EQUALS = new SqlBinaryOperator("=", SqlKind.EQUALS, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED);
    public static final SqlBinaryOperator GREATER_THAN = new SqlBinaryOperator(">", SqlKind.GREATER_THAN, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, OperandTypes.COMPARABLE_ORDERED_COMPARABLE_ORDERED);
    public static final SqlBinaryOperator IS_DISTINCT_FROM = new SqlBinaryOperator("IS DISTINCT FROM", SqlKind.IS_DISTINCT_FROM, 30, true, ReturnTypes.BOOLEAN, InferTypes.FIRST_KNOWN, OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED);
    public static final SqlBinaryOperator IS_NOT_DISTINCT_FROM = new SqlBinaryOperator("IS NOT DISTINCT FROM", SqlKind.IS_NOT_DISTINCT_FROM, 30, true, ReturnTypes.BOOLEAN, InferTypes.FIRST_KNOWN, OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED);
    public static final SqlBinaryOperator IS_DIFFERENT_FROM = new SqlBinaryOperator("$IS_DIFFERENT_FROM", SqlKind.OTHER, 30, true, ReturnTypes.BOOLEAN, InferTypes.FIRST_KNOWN, OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED);
    public static final SqlBinaryOperator GREATER_THAN_OR_EQUAL = new SqlBinaryOperator(">=", SqlKind.GREATER_THAN_OR_EQUAL, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, OperandTypes.COMPARABLE_ORDERED_COMPARABLE_ORDERED);
    public static final SqlBinaryOperator IN = new SqlInOperator(SqlKind.IN);
    public static final SqlBinaryOperator NOT_IN = new SqlInOperator(SqlKind.NOT_IN);
    public static final SqlInternalOperator SEARCH = new SqlSearchOperator();
    public static final SqlQuantifyOperator SOME_LT = new SqlQuantifyOperator(SqlKind.SOME, SqlKind.LESS_THAN);
    public static final SqlQuantifyOperator SOME_LE = new SqlQuantifyOperator(SqlKind.SOME, SqlKind.LESS_THAN_OR_EQUAL);
    public static final SqlQuantifyOperator SOME_GT = new SqlQuantifyOperator(SqlKind.SOME, SqlKind.GREATER_THAN);
    public static final SqlQuantifyOperator SOME_GE = new SqlQuantifyOperator(SqlKind.SOME, SqlKind.GREATER_THAN_OR_EQUAL);
    public static final SqlQuantifyOperator SOME_EQ = new SqlQuantifyOperator(SqlKind.SOME, SqlKind.EQUALS);
    public static final SqlQuantifyOperator SOME_NE = new SqlQuantifyOperator(SqlKind.SOME, SqlKind.NOT_EQUALS);
    public static final SqlQuantifyOperator ALL_LT = new SqlQuantifyOperator(SqlKind.ALL, SqlKind.LESS_THAN);
    public static final SqlQuantifyOperator ALL_LE = new SqlQuantifyOperator(SqlKind.ALL, SqlKind.LESS_THAN_OR_EQUAL);
    public static final SqlQuantifyOperator ALL_GT = new SqlQuantifyOperator(SqlKind.ALL, SqlKind.GREATER_THAN);
    public static final SqlQuantifyOperator ALL_GE = new SqlQuantifyOperator(SqlKind.ALL, SqlKind.GREATER_THAN_OR_EQUAL);
    public static final SqlQuantifyOperator ALL_EQ = new SqlQuantifyOperator(SqlKind.ALL, SqlKind.EQUALS);
    public static final SqlQuantifyOperator ALL_NE = new SqlQuantifyOperator(SqlKind.ALL, SqlKind.NOT_EQUALS);
    public static final List<SqlQuantifyOperator> QUANTIFY_OPERATORS = ImmutableList.of((Object)SOME_EQ, (Object)SOME_GT, (Object)SOME_GE, (Object)SOME_LE, (Object)SOME_LT, (Object)SOME_NE, (Object)ALL_EQ, (Object)ALL_GT, (Object)ALL_GE, (Object)ALL_LE, (Object)ALL_LT, (Object)ALL_NE, (Object[])new SqlQuantifyOperator[0]);
    public static final SqlBinaryOperator LESS_THAN = new SqlBinaryOperator("<", SqlKind.LESS_THAN, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, OperandTypes.COMPARABLE_ORDERED_COMPARABLE_ORDERED);
    public static final SqlBinaryOperator LESS_THAN_OR_EQUAL = new SqlBinaryOperator("<=", SqlKind.LESS_THAN_OR_EQUAL, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, OperandTypes.COMPARABLE_ORDERED_COMPARABLE_ORDERED);
    public static final SqlBinaryOperator MINUS = new SqlMonotonicBinaryOperator("-", SqlKind.MINUS, 40, true, ReturnTypes.NULLABLE_SUM, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.MINUS_OPERATOR);
    public static final SqlBinaryOperator CHECKED_MINUS = new SqlMonotonicBinaryOperator("-", SqlKind.CHECKED_MINUS, 40, true, ReturnTypes.NULLABLE_SUM, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.MINUS_OPERATOR);
    public static final SqlBinaryOperator MULTIPLY = new SqlMonotonicBinaryOperator("*", SqlKind.TIMES, 60, true, ReturnTypes.PRODUCT_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.MULTIPLY_OPERATOR);
    public static final SqlBinaryOperator CHECKED_MULTIPLY = new SqlMonotonicBinaryOperator("*", SqlKind.CHECKED_TIMES, 60, true, ReturnTypes.PRODUCT_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.MULTIPLY_OPERATOR);
    public static final SqlBinaryOperator NOT_EQUALS = new SqlBinaryOperator("<>", SqlKind.NOT_EQUALS, 30, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED);
    public static final SqlBinaryOperator OR = new SqlBinaryOperator("OR", SqlKind.OR, 22, true, ReturnTypes.BOOLEAN_NULLABLE_OPTIMIZED, InferTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.BOOLEAN_BOOLEAN);
    public static final SqlBinaryOperator PLUS = new SqlMonotonicBinaryOperator("+", SqlKind.PLUS, 40, true, ReturnTypes.NULLABLE_SUM, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.PLUS_OPERATOR);
    public static final SqlBinaryOperator CHECKED_PLUS = new SqlMonotonicBinaryOperator("+", SqlKind.CHECKED_PLUS, 40, true, ReturnTypes.NULLABLE_SUM, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.PLUS_OPERATOR);
    public static final SqlSpecialOperator DATETIME_PLUS = new SqlDatetimePlusOperator();
    public static final SqlSpecialOperator INTERVAL = new SqlIntervalOperator();
    public static final SqlBinaryOperator MEMBER_OF = new SqlMultisetMemberOfOperator();
    public static final SqlBinaryOperator SUBMULTISET_OF = new SqlBinaryOperator("SUBMULTISET OF", SqlKind.OTHER, 30, true, ReturnTypes.BOOLEAN_NULLABLE, null, OperandTypes.MULTISET_MULTISET);
    public static final SqlBinaryOperator NOT_SUBMULTISET_OF = new SqlBinaryOperator("NOT SUBMULTISET OF", SqlKind.OTHER, 30, true, ReturnTypes.BOOLEAN_NULLABLE, null, OperandTypes.MULTISET_MULTISET);
    public static final SqlPostfixOperator DESC = new SqlPostfixOperator("DESC", SqlKind.DESCENDING, 20, ReturnTypes.ARG0, InferTypes.RETURN_TYPE, OperandTypes.ANY);
    public static final SqlPostfixOperator NULLS_FIRST = new SqlPostfixOperator("NULLS FIRST", SqlKind.NULLS_FIRST, 18, ReturnTypes.ARG0, InferTypes.RETURN_TYPE, OperandTypes.ANY);
    public static final SqlPostfixOperator NULLS_LAST = new SqlPostfixOperator("NULLS LAST", SqlKind.NULLS_LAST, 18, ReturnTypes.ARG0, InferTypes.RETURN_TYPE, OperandTypes.ANY);
    public static final SqlPostfixOperator IS_NOT_NULL = new SqlPostfixOperator("IS NOT NULL", SqlKind.IS_NOT_NULL, 28, ReturnTypes.BOOLEAN_NOT_NULL, InferTypes.VARCHAR_1024, OperandTypes.ANY);
    public static final SqlPostfixOperator IS_NULL = new SqlPostfixOperator("IS NULL", SqlKind.IS_NULL, 28, ReturnTypes.BOOLEAN_NOT_NULL, InferTypes.VARCHAR_1024, OperandTypes.ANY);
    public static final SqlPostfixOperator IS_NOT_TRUE = new SqlPostfixOperator("IS NOT TRUE", SqlKind.IS_NOT_TRUE, 28, ReturnTypes.BOOLEAN_NOT_NULL, InferTypes.BOOLEAN, OperandTypes.BOOLEAN);
    public static final SqlPostfixOperator IS_TRUE = new SqlPostfixOperator("IS TRUE", SqlKind.IS_TRUE, 28, ReturnTypes.BOOLEAN_NOT_NULL, InferTypes.BOOLEAN, OperandTypes.BOOLEAN);
    public static final SqlPostfixOperator IS_NOT_FALSE = new SqlPostfixOperator("IS NOT FALSE", SqlKind.IS_NOT_FALSE, 28, ReturnTypes.BOOLEAN_NOT_NULL, InferTypes.BOOLEAN, OperandTypes.BOOLEAN);
    public static final SqlPostfixOperator IS_FALSE = new SqlPostfixOperator("IS FALSE", SqlKind.IS_FALSE, 28, ReturnTypes.BOOLEAN_NOT_NULL, InferTypes.BOOLEAN, OperandTypes.BOOLEAN);
    public static final SqlPostfixOperator IS_NOT_UNKNOWN = new SqlPostfixOperator("IS NOT UNKNOWN", SqlKind.IS_NOT_NULL, 28, ReturnTypes.BOOLEAN_NOT_NULL, InferTypes.BOOLEAN, OperandTypes.BOOLEAN);
    public static final SqlPostfixOperator IS_UNKNOWN = new SqlPostfixOperator("IS UNKNOWN", SqlKind.IS_NULL, 28, ReturnTypes.BOOLEAN_NOT_NULL, InferTypes.BOOLEAN, OperandTypes.BOOLEAN);
    public static final SqlPostfixOperator IS_A_SET = new SqlPostfixOperator("IS A SET", SqlKind.OTHER, 28, ReturnTypes.BOOLEAN, null, OperandTypes.MULTISET);
    public static final SqlPostfixOperator IS_NOT_A_SET = new SqlPostfixOperator("IS NOT A SET", SqlKind.OTHER, 28, ReturnTypes.BOOLEAN, null, OperandTypes.MULTISET);
    public static final SqlPostfixOperator IS_EMPTY = new SqlPostfixOperator("IS EMPTY", SqlKind.OTHER, 28, ReturnTypes.BOOLEAN, null, OperandTypes.COLLECTION_OR_MAP);
    public static final SqlPostfixOperator IS_NOT_EMPTY = new SqlPostfixOperator("IS NOT EMPTY", SqlKind.OTHER, 28, ReturnTypes.BOOLEAN, null, OperandTypes.COLLECTION_OR_MAP);
    public static final SqlPostfixOperator IS_JSON_VALUE = new SqlPostfixOperator("IS JSON VALUE", SqlKind.OTHER, 28, ReturnTypes.BOOLEAN_NULLABLE, null, OperandTypes.CHARACTER);
    public static final SqlPostfixOperator IS_NOT_JSON_VALUE = new SqlPostfixOperator("IS NOT JSON VALUE", SqlKind.OTHER, 28, ReturnTypes.BOOLEAN_NULLABLE, null, OperandTypes.CHARACTER);
    public static final SqlPostfixOperator IS_JSON_OBJECT = new SqlPostfixOperator("IS JSON OBJECT", SqlKind.OTHER, 28, ReturnTypes.BOOLEAN_NULLABLE, null, OperandTypes.CHARACTER);
    public static final SqlPostfixOperator IS_NOT_JSON_OBJECT = new SqlPostfixOperator("IS NOT JSON OBJECT", SqlKind.OTHER, 28, ReturnTypes.BOOLEAN_NULLABLE, null, OperandTypes.CHARACTER);
    public static final SqlPostfixOperator IS_JSON_ARRAY = new SqlPostfixOperator("IS JSON ARRAY", SqlKind.OTHER, 28, ReturnTypes.BOOLEAN_NULLABLE, null, OperandTypes.CHARACTER);
    public static final SqlPostfixOperator IS_NOT_JSON_ARRAY = new SqlPostfixOperator("IS NOT JSON ARRAY", SqlKind.OTHER, 28, ReturnTypes.BOOLEAN_NULLABLE, null, OperandTypes.CHARACTER);
    public static final SqlPostfixOperator IS_JSON_SCALAR = new SqlPostfixOperator("IS JSON SCALAR", SqlKind.OTHER, 28, ReturnTypes.BOOLEAN_NULLABLE, null, OperandTypes.CHARACTER);
    public static final SqlPostfixOperator IS_NOT_JSON_SCALAR = new SqlPostfixOperator("IS NOT JSON SCALAR", SqlKind.OTHER, 28, ReturnTypes.BOOLEAN_NULLABLE, null, OperandTypes.CHARACTER);
    public static final SqlPostfixOperator JSON_VALUE_EXPRESSION = new SqlJsonValueExpressionOperator();
    public static final SqlJsonTypeOperator JSON_TYPE_OPERATOR = new SqlJsonTypeOperator();
    public static final SqlPrefixOperator EXISTS = new SqlPrefixOperator("EXISTS", SqlKind.EXISTS, 40, ReturnTypes.BOOLEAN, null, OperandTypes.ANY){

        @Override
        public boolean argumentMustBeScalar(int ordinal) {
            return false;
        }

        @Override
        public boolean validRexOperands(int count, Litmus litmus) {
            if (count != 0) {
                return litmus.fail("wrong operand count {} for {}", count, this);
            }
            return litmus.succeed();
        }
    };
    public static final SqlPrefixOperator UNIQUE = new SqlPrefixOperator("UNIQUE", SqlKind.UNIQUE, 40, ReturnTypes.BOOLEAN, null, OperandTypes.ANY){

        @Override
        public boolean argumentMustBeScalar(int ordinal) {
            return false;
        }

        @Override
        public boolean validRexOperands(int count, Litmus litmus) {
            if (count != 0) {
                return litmus.fail("wrong operand count {} for {}", count, this);
            }
            return litmus.succeed();
        }
    };
    public static final SqlPrefixOperator NOT = new SqlPrefixOperator("NOT", SqlKind.NOT, 26, ReturnTypes.ARG0, InferTypes.BOOLEAN, OperandTypes.BOOLEAN);
    public static final SqlPrefixOperator UNARY_MINUS = new SqlPrefixOperator("-", SqlKind.MINUS_PREFIX, 80, ReturnTypes.ARG0, InferTypes.RETURN_TYPE, OperandTypes.NUMERIC_OR_INTERVAL);
    public static final SqlPrefixOperator CHECKED_UNARY_MINUS = new SqlPrefixOperator("-", SqlKind.CHECKED_MINUS_PREFIX, 80, ReturnTypes.ARG0, InferTypes.RETURN_TYPE, OperandTypes.NUMERIC_OR_INTERVAL);
    public static final SqlPrefixOperator UNARY_PLUS = new SqlPrefixOperator("+", SqlKind.PLUS_PREFIX, 80, ReturnTypes.ARG0, InferTypes.RETURN_TYPE, OperandTypes.NUMERIC_OR_INTERVAL);
    public static final SqlPrefixOperator EXPLICIT_TABLE = new SqlPrefixOperator("TABLE", SqlKind.EXPLICIT_TABLE, 2, null, null, null);
    public static final SqlPrefixOperator FINAL = new SqlPrefixOperator("FINAL", SqlKind.FINAL, 80, ReturnTypes.ARG0_NULLABLE, null, OperandTypes.ANY);
    public static final SqlPrefixOperator RUNNING = new SqlPrefixOperator("RUNNING", SqlKind.RUNNING, 80, ReturnTypes.ARG0_NULLABLE, null, OperandTypes.ANY);
    public static final SqlAggFunction SUM = new SqlSumAggFunction((RelDataType)Nullness.castNonNull(null));
    public static final SqlAggFunction COUNT = new SqlCountAggFunction("COUNT");
    public static final SqlAggFunction MODE = SqlBasicAggFunction.create("MODE", SqlKind.MODE, ReturnTypes.ARG0_NULLABLE_IF_EMPTY, OperandTypes.ANY).withGroupOrder(Optionality.FORBIDDEN).withFunctionType(SqlFunctionCategory.SYSTEM);
    public static final SqlAggFunction APPROX_COUNT_DISTINCT = new SqlCountAggFunction("APPROX_COUNT_DISTINCT");
    public static final SqlBasicAggFunction ARG_MAX = SqlBasicAggFunction.create("ARG_MAX", SqlKind.ARG_MAX, ReturnTypes.ARG0_NULLABLE_IF_EMPTY, OperandTypes.ANY_COMPARABLE).withGroupOrder(Optionality.FORBIDDEN).withFunctionType(SqlFunctionCategory.SYSTEM);
    public static final SqlBasicAggFunction ARG_MIN = SqlBasicAggFunction.create("ARG_MIN", SqlKind.ARG_MIN, ReturnTypes.ARG0_NULLABLE_IF_EMPTY, OperandTypes.ANY_COMPARABLE).withGroupOrder(Optionality.FORBIDDEN).withFunctionType(SqlFunctionCategory.SYSTEM);
    public static final SqlAggFunction MIN = new SqlMinMaxAggFunction(SqlKind.MIN);
    public static final SqlAggFunction MAX = new SqlMinMaxAggFunction(SqlKind.MAX);
    public static final SqlAggFunction EVERY = new SqlMinMaxAggFunction("EVERY", SqlKind.MIN, OperandTypes.BOOLEAN);
    public static final SqlAggFunction SOME = new SqlMinMaxAggFunction("SOME", SqlKind.MAX, OperandTypes.BOOLEAN);
    public static final SqlAggFunction LAST_VALUE = new SqlFirstLastValueAggFunction(SqlKind.LAST_VALUE);
    public static final SqlAggFunction ANY_VALUE = new SqlAnyValueAggFunction(SqlKind.ANY_VALUE);
    public static final SqlAggFunction FIRST_VALUE = new SqlFirstLastValueAggFunction(SqlKind.FIRST_VALUE);
    public static final SqlAggFunction NTH_VALUE = new SqlNthValueAggFunction(SqlKind.NTH_VALUE);
    public static final SqlAggFunction LEAD = new SqlLeadLagAggFunction(SqlKind.LEAD);
    public static final SqlAggFunction LAG = new SqlLeadLagAggFunction(SqlKind.LAG);
    public static final SqlAggFunction NTILE = new SqlNtileAggFunction();
    public static final SqlAggFunction SINGLE_VALUE = new SqlSingleValueAggFunction((RelDataType)Nullness.castNonNull(null));
    public static final SqlAggFunction AVG = new SqlAvgAggFunction(SqlKind.AVG);
    public static final SqlAggFunction STDDEV_POP = new SqlAvgAggFunction(SqlKind.STDDEV_POP);
    public static final SqlAggFunction REGR_COUNT = new SqlRegrCountAggFunction(SqlKind.REGR_COUNT);
    public static final SqlAggFunction REGR_SXX = new SqlCovarAggFunction(SqlKind.REGR_SXX);
    public static final SqlAggFunction REGR_SYY = new SqlCovarAggFunction(SqlKind.REGR_SYY);
    public static final SqlAggFunction COVAR_POP = new SqlCovarAggFunction(SqlKind.COVAR_POP);
    public static final SqlAggFunction COVAR_SAMP = new SqlCovarAggFunction(SqlKind.COVAR_SAMP);
    public static final SqlAggFunction STDDEV_SAMP = new SqlAvgAggFunction(SqlKind.STDDEV_SAMP);
    public static final SqlAggFunction STDDEV = new SqlAvgAggFunction("STDDEV", SqlKind.STDDEV_SAMP);
    public static final SqlAggFunction VAR_POP = new SqlAvgAggFunction(SqlKind.VAR_POP);
    public static final SqlAggFunction VAR_SAMP = new SqlAvgAggFunction(SqlKind.VAR_SAMP);
    public static final SqlAggFunction VARIANCE = new SqlAvgAggFunction("VARIANCE", SqlKind.VAR_SAMP);
    public static final SqlBasicFunction BITCOUNT = SqlBasicFunction.create("BITCOUNT", ReturnTypes.BIGINT_NULLABLE, OperandTypes.INTEGER.or(OperandTypes.BINARY), SqlFunctionCategory.NUMERIC);
    public static final SqlFunction BITAND = SqlBasicFunction.create("BITAND", SqlKind.BITAND, ReturnTypes.LARGEST_INT_OR_FIRST_NON_NULL, OperandTypes.INTEGER_INTEGER.or(OperandTypes.BINARY_BINARY));
    public static final SqlFunction BITOR = SqlBasicFunction.create("BITOR", SqlKind.BITOR, ReturnTypes.LARGEST_INT_OR_FIRST_NON_NULL, OperandTypes.INTEGER_INTEGER.or(OperandTypes.BINARY_BINARY));
    public static final SqlFunction BITXOR = SqlBasicFunction.create("BITXOR", SqlKind.BITXOR, ReturnTypes.LARGEST_INT_OR_FIRST_NON_NULL, OperandTypes.INTEGER_INTEGER.or(OperandTypes.BINARY_BINARY));
    public static final SqlBinaryOperator BITXOR_OPERATOR = new SqlBinaryOperator("^", SqlKind.BITXOR, 40, true, ReturnTypes.LARGEST_INT_OR_FIRST_NON_NULL, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.INTEGER_INTEGER.or(OperandTypes.BINARY_BINARY).or(OperandTypes.UNSIGNED_NUMERIC_UNSIGNED_NUMERIC));
    public static final SqlBinaryOperator BITAND_OPERATOR = new SqlBinaryOperator("&", SqlKind.BITAND, 50, true, ReturnTypes.LEAST_RESTRICTIVE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.INTEGER_INTEGER.or(OperandTypes.BINARY_BINARY).or(OperandTypes.UNSIGNED_NUMERIC_UNSIGNED_NUMERIC).or(OperandTypes.family(SqlTypeFamily.UNSIGNED_NUMERIC, SqlTypeFamily.INTEGER).or(OperandTypes.family(SqlTypeFamily.INTEGER, SqlTypeFamily.UNSIGNED_NUMERIC))));
    public static final SqlFunction BITNOT = SqlBasicFunction.create("BITNOT", SqlKind.BITNOT, ReturnTypes.ARG0_OR_INTEGER, OperandTypes.INTEGER.or(OperandTypes.BINARY));
    public static final SqlAggFunction BIT_AND = new SqlBitOpAggFunction(SqlKind.BIT_AND);
    public static final SqlAggFunction BIT_OR = new SqlBitOpAggFunction(SqlKind.BIT_OR);
    public static final SqlAggFunction BIT_XOR = new SqlBitOpAggFunction(SqlKind.BIT_XOR);
    public static final SqlBinaryOperator BIT_LEFT_SHIFT = new SqlBinaryOperator("<<", SqlKind.OTHER, 32, true, ReturnTypes.ARG0_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.or(OperandTypes.family(SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.BINARY, SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.UNSIGNED_NUMERIC, SqlTypeFamily.INTEGER)));
    public static final SqlFunction LEFTSHIFT = SqlBasicFunction.create("LEFTSHIFT", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE, OperandTypes.or(OperandTypes.family(SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.BINARY, SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.UNSIGNED_NUMERIC, SqlTypeFamily.INTEGER)));
    public static final SqlAggFunction HISTOGRAM_AGG = new SqlHistogramAggFunction((RelDataType)Nullness.castNonNull(null));
    public static final SqlFunction HISTOGRAM_MIN = SqlBasicFunction.create("$HISTOGRAM_MIN", ReturnTypes.ARG0_NULLABLE, OperandTypes.NUMERIC_OR_STRING, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction HISTOGRAM_MAX = SqlBasicFunction.create("$HISTOGRAM_MAX", ReturnTypes.ARG0_NULLABLE, OperandTypes.NUMERIC_OR_STRING, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction HISTOGRAM_FIRST_VALUE = SqlBasicFunction.create("$HISTOGRAM_FIRST_VALUE", ReturnTypes.ARG0_NULLABLE, OperandTypes.NUMERIC_OR_STRING, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction HISTOGRAM_LAST_VALUE = SqlBasicFunction.create("$HISTOGRAM_LAST_VALUE", ReturnTypes.ARG0_NULLABLE, OperandTypes.NUMERIC_OR_STRING, SqlFunctionCategory.NUMERIC);
    public static final SqlAggFunction SUM0 = new SqlSumEmptyIsZeroAggFunction();
    public static final SqlRankFunction CUME_DIST = new SqlRankFunction(SqlKind.CUME_DIST, ReturnTypes.FRACTIONAL_RANK, true);
    public static final SqlRankFunction DENSE_RANK = new SqlRankFunction(SqlKind.DENSE_RANK, ReturnTypes.RANK, true);
    public static final SqlRankFunction PERCENT_RANK = new SqlRankFunction(SqlKind.PERCENT_RANK, ReturnTypes.FRACTIONAL_RANK, true);
    public static final SqlRankFunction RANK = new SqlRankFunction(SqlKind.RANK, ReturnTypes.RANK, true);
    public static final SqlRankFunction ROW_NUMBER = new SqlRankFunction(SqlKind.ROW_NUMBER, ReturnTypes.RANK, false);
    public static final SqlRowOperator ROW = new SqlRowOperator("ROW");
    public static final SqlNullTreatmentOperator IGNORE_NULLS = new SqlNullTreatmentOperator(SqlKind.IGNORE_NULLS);
    public static final SqlNullTreatmentOperator RESPECT_NULLS = new SqlNullTreatmentOperator(SqlKind.RESPECT_NULLS);
    public static final SqlDatetimeSubtractionOperator MINUS_DATE = new SqlDatetimeSubtractionOperator("-", ReturnTypes.ARG2_NULLABLE);
    public static final SqlMultisetValueConstructor MULTISET_VALUE = new SqlMultisetValueConstructor();
    public static final SqlMultisetQueryConstructor MULTISET_QUERY = new SqlMultisetQueryConstructor();
    public static final SqlMultisetQueryConstructor ARRAY_QUERY = new SqlArrayQueryConstructor();
    public static final SqlMultisetQueryConstructor MAP_QUERY = new SqlMapQueryConstructor();
    public static final SqlCursorConstructor CURSOR = new SqlCursorConstructor();
    public static final SqlColumnListConstructor COLUMN_LIST = new SqlColumnListConstructor();
    public static final SqlUnnestOperator UNNEST = new SqlUnnestOperator(false);
    @LibraryOperator(libraries={})
    public static final SqlUnnestOperator UNNEST_WITH_ORDINALITY = new SqlUnnestOperator(true);
    public static final SqlSpecialOperator LATERAL = new SqlLateralOperator(SqlKind.LATERAL);
    public static final SqlSpecialOperator COLLECTION_TABLE = new SqlCollectionTableOperator("TABLE", SqlModality.RELATION);
    public static final SqlOverlapsOperator OVERLAPS = new SqlOverlapsOperator(SqlKind.OVERLAPS);
    public static final SqlOverlapsOperator CONTAINS = new SqlOverlapsOperator(SqlKind.CONTAINS);
    public static final SqlOverlapsOperator PRECEDES = new SqlOverlapsOperator(SqlKind.PRECEDES);
    public static final SqlOverlapsOperator IMMEDIATELY_PRECEDES = new SqlOverlapsOperator(SqlKind.IMMEDIATELY_PRECEDES);
    public static final SqlOverlapsOperator SUCCEEDS = new SqlOverlapsOperator(SqlKind.SUCCEEDS);
    public static final SqlOverlapsOperator IMMEDIATELY_SUCCEEDS = new SqlOverlapsOperator(SqlKind.IMMEDIATELY_SUCCEEDS);
    public static final SqlOverlapsOperator PERIOD_EQUALS = new SqlOverlapsOperator(SqlKind.PERIOD_EQUALS);
    public static final SqlSpecialOperator VALUES = new SqlValuesOperator();
    public static final SqlLiteralChainOperator LITERAL_CHAIN = new SqlLiteralChainOperator();
    public static final SqlThrowOperator THROW = new SqlThrowOperator();
    public static final SqlFunction JSON_EXISTS = new SqlJsonExistsFunction();
    public static final SqlFunction JSON_VALUE = new SqlJsonValueFunction("JSON_VALUE");
    public static final SqlFunction JSON_QUERY = new SqlJsonQueryFunction();
    public static final SqlFunction JSON_OBJECT = new SqlJsonObjectFunction();
    public static final SqlJsonObjectAggAggFunction JSON_OBJECTAGG = new SqlJsonObjectAggAggFunction(SqlKind.JSON_OBJECTAGG, SqlJsonConstructorNullClause.NULL_ON_NULL);
    public static final SqlFunction JSON_ARRAY = new SqlJsonArrayFunction();
    @Deprecated
    public static final SqlFunction JSON_TYPE = new SqlJsonTypeFunction();
    @Deprecated
    public static final SqlFunction JSON_DEPTH = new SqlJsonDepthFunction();
    @Deprecated
    public static final SqlFunction JSON_LENGTH = new SqlJsonLengthFunction();
    @Deprecated
    public static final SqlFunction JSON_KEYS = new SqlJsonKeysFunction();
    @Deprecated
    public static final SqlFunction JSON_PRETTY = new SqlJsonPrettyFunction();
    @Deprecated
    public static final SqlFunction JSON_REMOVE = new SqlJsonRemoveFunction();
    @Deprecated
    public static final SqlFunction JSON_STORAGE_SIZE = new SqlJsonStorageSizeFunction();
    @Deprecated
    public static final SqlFunction JSON_INSERT = new SqlJsonModifyFunction("JSON_INSERT");
    @Deprecated
    public static final SqlFunction JSON_REPLACE = new SqlJsonModifyFunction("JSON_REPLACE");
    @Deprecated
    public static final SqlFunction JSON_SET = new SqlJsonModifyFunction("JSON_SET");
    public static final SqlJsonArrayAggAggFunction JSON_ARRAYAGG = new SqlJsonArrayAggAggFunction(SqlKind.JSON_ARRAYAGG, SqlJsonConstructorNullClause.ABSENT_ON_NULL);
    public static final SqlBetweenOperator BETWEEN = new SqlBetweenOperator(SqlBetweenOperator.Flag.ASYMMETRIC, false);
    public static final SqlBetweenOperator SYMMETRIC_BETWEEN = new SqlBetweenOperator(SqlBetweenOperator.Flag.SYMMETRIC, false);
    public static final SqlBetweenOperator NOT_BETWEEN = new SqlBetweenOperator(SqlBetweenOperator.Flag.ASYMMETRIC, true);
    public static final SqlBetweenOperator SYMMETRIC_NOT_BETWEEN = new SqlBetweenOperator(SqlBetweenOperator.Flag.SYMMETRIC, true);
    public static final SqlSpecialOperator NOT_LIKE = new SqlLikeOperator("NOT LIKE", SqlKind.LIKE, true, true);
    public static final SqlSpecialOperator LIKE = new SqlLikeOperator("LIKE", SqlKind.LIKE, false, true);
    public static final SqlSpecialOperator NOT_SIMILAR_TO = new SqlLikeOperator("NOT SIMILAR TO", SqlKind.SIMILAR, true, true);
    public static final SqlSpecialOperator SIMILAR_TO = new SqlLikeOperator("SIMILAR TO", SqlKind.SIMILAR, false, true);
    public static final SqlBinaryOperator POSIX_REGEX_CASE_SENSITIVE = new SqlPosixRegexOperator("POSIX REGEX CASE SENSITIVE", SqlKind.POSIX_REGEX_CASE_SENSITIVE, true, false);
    public static final SqlBinaryOperator POSIX_REGEX_CASE_INSENSITIVE = new SqlPosixRegexOperator("POSIX REGEX CASE INSENSITIVE", SqlKind.POSIX_REGEX_CASE_INSENSITIVE, false, false);
    public static final SqlBinaryOperator NEGATED_POSIX_REGEX_CASE_SENSITIVE = new SqlPosixRegexOperator("NEGATED POSIX REGEX CASE SENSITIVE", SqlKind.POSIX_REGEX_CASE_SENSITIVE, true, true);
    public static final SqlBinaryOperator NEGATED_POSIX_REGEX_CASE_INSENSITIVE = new SqlPosixRegexOperator("NEGATED POSIX REGEX CASE INSENSITIVE", SqlKind.POSIX_REGEX_CASE_INSENSITIVE, false, true);
    public static final SqlSpecialOperator ESCAPE = new SqlSpecialOperator("ESCAPE", SqlKind.ESCAPE, 0);
    public static final SqlCaseOperator CASE = SqlCaseOperator.INSTANCE;
    public static final SqlOperator PROCEDURE_CALL = new SqlProcedureCallOperator();
    public static final SqlOperator NEW = new SqlNewOperator();
    public static final SqlBinaryOperator OVER = new SqlOverOperator();
    public static final SqlSpecialOperator REINTERPRET = new SqlSpecialOperator("Reinterpret", SqlKind.REINTERPRET){

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.between(1, 2);
        }
    };
    public static final SqlFunction SUBSTRING = new SqlSubstringFunction();
    public static final SqlFunction REPLACE = SqlBasicFunction.create("REPLACE", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.STRING_STRING_STRING, SqlFunctionCategory.STRING);
    public static final SqlFunction CONVERT = new SqlConvertFunction("CONVERT");
    public static final SqlFunction TRANSLATE = new SqlTranslateFunction("TRANSLATE");
    public static final SqlFunction OVERLAY = new SqlOverlayFunction();
    public static final SqlFunction TRIM = SqlTrimFunction.INSTANCE;
    public static final SqlFunction POSITION = new SqlPositionFunction("POSITION");
    public static final SqlBasicFunction CHAR_LENGTH = SqlBasicFunction.create(SqlKind.CHAR_LENGTH, ReturnTypes.INTEGER_NULLABLE, (SqlOperandTypeChecker)OperandTypes.CHARACTER);
    public static final SqlFunction CHARACTER_LENGTH = CHAR_LENGTH.withName("CHARACTER_LENGTH");
    public static final SqlFunction OCTET_LENGTH = SqlBasicFunction.create("OCTET_LENGTH", ReturnTypes.INTEGER_NULLABLE, OperandTypes.BINARY, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction UPPER = SqlBasicFunction.create("UPPER", ReturnTypes.ARG0_NULLABLE, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
    public static final SqlFunction LOWER = SqlBasicFunction.create("LOWER", ReturnTypes.ARG0_NULLABLE, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
    public static final SqlFunction INITCAP = SqlBasicFunction.create("INITCAP", ReturnTypes.ARG0_NULLABLE, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
    public static final SqlFunction ASCII = SqlBasicFunction.create("ASCII", ReturnTypes.INTEGER_NULLABLE, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
    public static final SqlBasicFunction POWER = SqlBasicFunction.create("POWER", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC_NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction SQRT = SqlBasicFunction.create("SQRT", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
    public static final SqlFunction MOD = SqlBasicFunction.create(SqlKind.MOD, ReturnTypes.NULLABLE_MOD, (SqlOperandTypeChecker)OperandTypes.EXACT_NUMERIC_EXACT_NUMERIC).withFunctionType(SqlFunctionCategory.NUMERIC);
    public static final SqlFunction LN = SqlBasicFunction.create("LN", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction LOG10 = SqlBasicFunction.create("LOG10", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction ABS = SqlBasicFunction.create("ABS", ReturnTypes.ARG0, OperandTypes.NUMERIC_OR_INTERVAL, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction ACOS = SqlBasicFunction.create("ACOS", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction ASIN = SqlBasicFunction.create("ASIN", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction ATAN = SqlBasicFunction.create("ATAN", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction ATAN2 = SqlBasicFunction.create("ATAN2", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC_NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction CBRT = SqlBasicFunction.create("CBRT", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction COS = SqlBasicFunction.create("COS", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction COT = SqlBasicFunction.create("COT", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction DEGREES = SqlBasicFunction.create("DEGREES", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction EXP = SqlBasicFunction.create("EXP", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction RADIANS = SqlBasicFunction.create("RADIANS", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction ROUND = SqlBasicFunction.create("ROUND", ReturnTypes.ARG0_NULLABLE, OperandTypes.NUMERIC.or(OperandTypes.NUMERIC_INT32), SqlFunctionCategory.NUMERIC);
    public static final SqlFunction SIGN = SqlBasicFunction.create("SIGN", ReturnTypes.ARG0, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction SIN = SqlBasicFunction.create("SIN", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlFunction TAN = SqlBasicFunction.create("TAN", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    public static final SqlBasicFunction TRUNCATE = SqlBasicFunction.create("TRUNCATE", ReturnTypes.ARG0_NULLABLE, OperandTypes.NUMERIC.or(OperandTypes.NUMERIC_INT32), SqlFunctionCategory.NUMERIC);
    public static final SqlFunction PI = SqlBasicFunction.create("PI", ReturnTypes.DOUBLE, OperandTypes.NILADIC, SqlFunctionCategory.NUMERIC).withSyntax(SqlSyntax.FUNCTION_ID_CONSTANT);
    public static final SqlFunction TYPEOF = SqlBasicFunction.create("TYPEOF", ReturnTypes.VARCHAR, OperandTypes.VARIANT, SqlFunctionCategory.STRING);
    public static final SqlFunction VARIANTNULL = SqlBasicFunction.create("VARIANTNULL", ReturnTypes.VARIANT, OperandTypes.NILADIC, SqlFunctionCategory.SYSTEM);
    public static final SqlFunction FIRST = SqlBasicFunction.create(SqlKind.FIRST, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.ANY_NUMERIC).withFunctionType(SqlFunctionCategory.MATCH_RECOGNIZE);
    public static final SqlMatchFunction LAST = new SqlMatchFunction("LAST", SqlKind.LAST, ReturnTypes.ARG0_NULLABLE, null, OperandTypes.ANY_NUMERIC, SqlFunctionCategory.MATCH_RECOGNIZE);
    public static final SqlMatchFunction PREV = new SqlMatchFunction("PREV", SqlKind.PREV, ReturnTypes.ARG0_NULLABLE, null, OperandTypes.ANY_NUMERIC, SqlFunctionCategory.MATCH_RECOGNIZE);
    public static final SqlFunction NEXT = SqlBasicFunction.create(SqlKind.NEXT, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.ANY_NUMERIC).withFunctionType(SqlFunctionCategory.MATCH_RECOGNIZE);
    public static final SqlMatchFunction CLASSIFIER = new SqlMatchFunction("CLASSIFIER", SqlKind.CLASSIFIER, ReturnTypes.VARCHAR_2000, null, OperandTypes.NILADIC, SqlFunctionCategory.MATCH_RECOGNIZE);
    public static final SqlFunction MATCH_NUMBER = SqlBasicFunction.create(SqlKind.MATCH_NUMBER, ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NILADIC).withFunctionType(SqlFunctionCategory.MATCH_RECOGNIZE);
    public static final SqlFunction NULLIF = new SqlNullifFunction();
    public static final SqlFunction COALESCE = new SqlCoalesceFunction();
    public static final SqlFunction FLOOR = new SqlFloorFunction(SqlKind.FLOOR);
    public static final SqlFunction CEIL = new SqlFloorFunction(SqlKind.CEIL);
    public static final SqlFunction USER = new SqlStringContextVariable("USER");
    public static final SqlFunction CURRENT_USER = new SqlStringContextVariable("CURRENT_USER");
    public static final SqlFunction SESSION_USER = new SqlStringContextVariable("SESSION_USER");
    public static final SqlFunction SYSTEM_USER = new SqlStringContextVariable("SYSTEM_USER");
    public static final SqlFunction CURRENT_PATH = new SqlStringContextVariable("CURRENT_PATH");
    public static final SqlFunction CURRENT_ROLE = new SqlStringContextVariable("CURRENT_ROLE");
    public static final SqlFunction CURRENT_CATALOG = new SqlStringContextVariable("CURRENT_CATALOG");
    public static final SqlFunction CURRENT_SCHEMA = new SqlStringContextVariable("CURRENT_SCHEMA");
    public static final SqlFunction LOCALTIME = new SqlAbstractTimeFunction("LOCALTIME", SqlTypeName.TIME);
    public static final SqlFunction LOCALTIMESTAMP = new SqlAbstractTimeFunction("LOCALTIMESTAMP", SqlTypeName.TIMESTAMP);
    public static final SqlFunction CURRENT_TIME = new SqlAbstractTimeFunction("CURRENT_TIME", SqlTypeName.TIME);
    public static final SqlFunction CURRENT_TIMESTAMP = new SqlAbstractTimeFunction("CURRENT_TIMESTAMP", SqlTypeName.TIMESTAMP);
    public static final SqlFunction CURRENT_DATE = new SqlCurrentDateFunction();
    public static final SqlFunction TIMESTAMP_ADD = new SqlTimestampAddFunction("TIMESTAMPADD");
    public static final SqlFunction TIMESTAMP_DIFF = new SqlTimestampDiffFunction("TIMESTAMPDIFF", OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME));
    public static final SqlFunction CAST = new SqlCastFunction();
    public static final SqlFunction EXTRACT = new SqlExtractFunction("EXTRACT", false);
    public static final SqlDatePartFunction YEAR = new SqlDatePartFunction("YEAR", TimeUnit.YEAR);
    public static final SqlDatePartFunction QUARTER = new SqlDatePartFunction("QUARTER", TimeUnit.QUARTER);
    public static final SqlDatePartFunction MONTH = new SqlDatePartFunction("MONTH", TimeUnit.MONTH);
    public static final SqlDatePartFunction WEEK = new SqlDatePartFunction("WEEK", TimeUnit.WEEK);
    public static final SqlDatePartFunction DAYOFYEAR = new SqlDatePartFunction("DAYOFYEAR", TimeUnit.DOY);
    public static final SqlDatePartFunction DAYOFMONTH = new SqlDatePartFunction("DAYOFMONTH", TimeUnit.DAY);
    public static final SqlDatePartFunction DAYOFWEEK = new SqlDatePartFunction("DAYOFWEEK", TimeUnit.DOW);
    public static final SqlDatePartFunction HOUR = new SqlDatePartFunction("HOUR", TimeUnit.HOUR);
    public static final SqlDatePartFunction MINUTE = new SqlDatePartFunction("MINUTE", TimeUnit.MINUTE);
    public static final SqlDatePartFunction SECOND = new SqlDatePartFunction("SECOND", TimeUnit.SECOND);
    public static final SqlFunction LAST_DAY = SqlBasicFunction.create("LAST_DAY", ReturnTypes.DATE_NULLABLE, OperandTypes.DATETIME, SqlFunctionCategory.TIMEDATE);
    public static final SqlFunction ELEMENT = SqlBasicFunction.create("ELEMENT", ReturnTypes.MULTISET_ELEMENT_FORCE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.COLLECTION);
    public static final SqlOperator ITEM = new SqlItemOperator("ITEM", OperandTypes.ARRAY_OR_MAP_OR_VARIANT, 1, true);
    public static final SqlArrayValueConstructor ARRAY_VALUE_CONSTRUCTOR = new SqlArrayValueConstructor();
    public static final SqlMapValueConstructor MAP_VALUE_CONSTRUCTOR = new SqlMapValueConstructor();
    public static final SqlInternalOperator SLICE = new SqlInternalOperator("$SLICE", SqlKind.OTHER, 0, false, ReturnTypes.MULTISET_PROJECT0, null, (SqlOperandTypeChecker)OperandTypes.RECORD_COLLECTION){};
    public static final SqlInternalOperator ELEMENT_SLICE = new SqlInternalOperator("$ELEMENT_SLICE", SqlKind.OTHER, 0, false, ReturnTypes.MULTISET_RECORD, null, (SqlOperandTypeChecker)OperandTypes.MULTISET){

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlUtil.unparseFunctionSyntax(this, writer, call, false);
        }
    };
    public static final SqlInternalOperator SCALAR_QUERY = new SqlInternalOperator("$SCALAR_QUERY", SqlKind.SCALAR_QUERY, 0, false, ReturnTypes.RECORD_TO_SCALAR, null, OperandTypes.RECORD_TO_SCALAR){

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
            writer.endList(frame);
        }

        @Override
        public boolean argumentMustBeScalar(int ordinal) {
            return false;
        }
    };
    public static final SqlInternalOperator STRUCT_ACCESS = new SqlInternalOperator("$STRUCT_ACCESS", SqlKind.OTHER);
    public static final SqlFunction CARDINALITY = SqlBasicFunction.create("CARDINALITY", ReturnTypes.INTEGER_NULLABLE, (SqlOperandTypeChecker)OperandTypes.COLLECTION_OR_MAP);
    public static final SqlAggFunction COLLECT = SqlBasicAggFunction.create(SqlKind.COLLECT, ReturnTypes.TO_MULTISET, OperandTypes.ANY).withFunctionType(SqlFunctionCategory.SYSTEM).withGroupOrder(Optionality.OPTIONAL);
    public static final SqlAggFunction PERCENTILE_CONT = SqlBasicAggFunction.create(SqlKind.PERCENTILE_CONT, ReturnTypes.PERCENTILE_DISC_CONT, OperandTypes.UNIT_INTERVAL_NUMERIC_LITERAL).withFunctionType(SqlFunctionCategory.SYSTEM).withGroupOrder(Optionality.MANDATORY).withPercentile(true).withAllowsFraming(false);
    public static final SqlAggFunction PERCENTILE_DISC = SqlBasicAggFunction.create(SqlKind.PERCENTILE_DISC, ReturnTypes.PERCENTILE_DISC_CONT, OperandTypes.UNIT_INTERVAL_NUMERIC_LITERAL).withFunctionType(SqlFunctionCategory.SYSTEM).withGroupOrder(Optionality.MANDATORY).withPercentile(true).withAllowsFraming(false);
    public static final SqlAggFunction LISTAGG = new SqlListaggAggFunction(SqlKind.LISTAGG, ReturnTypes.ARG0_NULLABLE);
    public static final SqlAggFunction FUSION = SqlBasicAggFunction.create(SqlKind.FUSION, ReturnTypes.ARG0, OperandTypes.MULTISET).withFunctionType(SqlFunctionCategory.SYSTEM);
    public static final SqlAggFunction INTERSECTION = SqlBasicAggFunction.create(SqlKind.INTERSECTION, ReturnTypes.ARG0, OperandTypes.MULTISET).withFunctionType(SqlFunctionCategory.SYSTEM);
    public static final SqlOperator NEXT_VALUE = new SqlSequenceValueOperator(SqlKind.NEXT_VALUE);
    public static final SqlOperator CURRENT_VALUE = new SqlSequenceValueOperator(SqlKind.CURRENT_VALUE);
    public static final SqlSpecialOperator TABLESAMPLE = new SqlSpecialOperator("TABLESAMPLE", SqlKind.TABLESAMPLE, 20, true, ReturnTypes.ARG0, null, OperandTypes.VARIADIC){

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            ((SqlNode)call.operand(0)).unparse(writer, leftPrec, 0);
            writer.keyword("TABLESAMPLE");
            ((SqlNode)call.operand(1)).unparse(writer, 0, rightPrec);
        }
    };
    public static final SqlOperator DESCRIPTOR = new SqlDescriptorOperator();
    public static final SqlFunction TUMBLE = new SqlTumbleTableFunction();
    public static final SqlFunction HOP = new SqlHopTableFunction();
    public static final SqlFunction SESSION = new SqlSessionTableFunction();
    public static final SqlGroupedWindowFunction TUMBLE_OLD = new SqlGroupedWindowFunction("$TUMBLE", SqlKind.TUMBLE, null, ReturnTypes.ARG0, null, (SqlOperandTypeChecker)OperandTypes.DATETIME_INTERVAL.or(OperandTypes.DATETIME_INTERVAL_TIME), SqlFunctionCategory.SYSTEM){

        @Override
        public List<SqlGroupedWindowFunction> getAuxiliaryFunctions() {
            return ImmutableList.of((Object)TUMBLE_START, (Object)TUMBLE_END);
        }
    };
    public static final SqlGroupedWindowFunction TUMBLE_START = TUMBLE_OLD.auxiliary(SqlKind.TUMBLE_START);
    public static final SqlGroupedWindowFunction TUMBLE_END = TUMBLE_OLD.auxiliary(SqlKind.TUMBLE_END);
    public static final SqlGroupedWindowFunction HOP_OLD = new SqlGroupedWindowFunction("$HOP", SqlKind.HOP, null, ReturnTypes.ARG0, null, (SqlOperandTypeChecker)OperandTypes.DATETIME_INTERVAL_INTERVAL.or(OperandTypes.DATETIME_INTERVAL_INTERVAL_TIME), SqlFunctionCategory.SYSTEM){

        @Override
        public List<SqlGroupedWindowFunction> getAuxiliaryFunctions() {
            return ImmutableList.of((Object)HOP_START, (Object)HOP_END);
        }
    };
    public static final SqlGroupedWindowFunction HOP_START = HOP_OLD.auxiliary(SqlKind.HOP_START);
    public static final SqlGroupedWindowFunction HOP_END = HOP_OLD.auxiliary(SqlKind.HOP_END);
    public static final SqlGroupedWindowFunction SESSION_OLD = new SqlGroupedWindowFunction("$SESSION", SqlKind.SESSION, null, ReturnTypes.ARG0, null, (SqlOperandTypeChecker)OperandTypes.DATETIME_INTERVAL.or(OperandTypes.DATETIME_INTERVAL_TIME), SqlFunctionCategory.SYSTEM){

        @Override
        public List<SqlGroupedWindowFunction> getAuxiliaryFunctions() {
            return ImmutableList.of((Object)SESSION_START, (Object)SESSION_END);
        }
    };
    public static final SqlGroupedWindowFunction SESSION_START = SESSION_OLD.auxiliary(SqlKind.SESSION_START);
    public static final SqlGroupedWindowFunction SESSION_END = SESSION_OLD.auxiliary(SqlKind.SESSION_END);
    public static final SqlBinaryOperator PATTERN_ALTER = new SqlBinaryOperator("|", SqlKind.PATTERN_ALTER, 70, true, null, null, null);
    public static final SqlBinaryOperator PATTERN_CONCAT = new SqlBinaryOperator("", SqlKind.PATTERN_CONCAT, 80, true, null, null, null);
    public static final SqlSpecialOperator PATTERN_QUANTIFIER = new SqlSpecialOperator("PATTERN_QUANTIFIER", SqlKind.PATTERN_QUANTIFIER, 90){

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            ((SqlNode)call.operand(0)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
            int startNum = ((SqlNumericLiteral)call.operand(1)).intValue(true);
            SqlNumericLiteral endRepNum = (SqlNumericLiteral)call.operand(2);
            boolean isReluctant = ((SqlLiteral)call.operand(3)).booleanValue();
            int endNum = endRepNum.intValue(true);
            if (startNum == endNum) {
                writer.keyword("{ " + startNum + " }");
            } else {
                if (endNum == -1) {
                    if (startNum == 0) {
                        writer.keyword("*");
                    } else if (startNum == 1) {
                        writer.keyword("+");
                    } else {
                        writer.keyword("{ " + startNum + ", }");
                    }
                } else if (startNum == 0 && endNum == 1) {
                    writer.keyword("?");
                } else if (startNum == -1) {
                    writer.keyword("{ , " + endNum + " }");
                } else {
                    writer.keyword("{ " + startNum + ", " + endNum + " }");
                }
                if (isReluctant) {
                    writer.keyword("?");
                }
            }
        }
    };
    public static final SqlSpecialOperator PATTERN_PERMUTE = new SqlSpecialOperator("PATTERN_PERMUTE", SqlKind.PATTERN_PERMUTE, 100){

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            writer.keyword("PERMUTE");
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (int i = 0; i < call.getOperandList().size(); ++i) {
                SqlNode pattern = call.getOperandList().get(i);
                pattern.unparse(writer, 0, 0);
                if (i == call.getOperandList().size() - 1) continue;
                writer.print(",");
            }
            writer.endList(frame);
        }
    };
    public static final SqlSpecialOperator PATTERN_EXCLUDE = new SqlSpecialOperator("PATTERN_EXCLUDE", SqlKind.PATTERN_EXCLUDED, 100){

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlWriter.Frame frame = writer.startList("{-", "-}");
            SqlNode node = call.getOperandList().get(0);
            node.unparse(writer, 0, 0);
            writer.endList(frame);
        }
    };
    public static final SqlInternalOperator SET_SEMANTICS_TABLE = new SqlSetSemanticsTableOperator();

    public static SqlStdOperatorTable instance() {
        return INSTANCE.get();
    }

    @Override
    protected void lookUpOperators(String name, boolean caseSensitive, Consumer<SqlOperator> consumer) {
        super.lookUpOperators(name, false, consumer);
    }

    public static @Nullable SqlGroupedWindowFunction auxiliaryToGroup(SqlKind kind) {
        switch (kind) {
            case TUMBLE_START: 
            case TUMBLE_END: {
                return TUMBLE_OLD;
            }
            case HOP_START: 
            case HOP_END: {
                return HOP_OLD;
            }
            case SESSION_START: 
            case SESSION_END: {
                return SESSION_OLD;
            }
        }
        return null;
    }

    public static @Nullable SqlCall convertAuxiliaryToGroupCall(SqlCall call) {
        SqlOperator op = call.getOperator();
        if (op instanceof SqlGroupedWindowFunction && op.isGroupAuxiliary()) {
            SqlGroupedWindowFunction fun = (SqlGroupedWindowFunction)op;
            return SqlStdOperatorTable.copy(call, Objects.requireNonNull(fun.groupFunction, "groupFunction"));
        }
        return null;
    }

    @Deprecated
    public static List<Pair<SqlNode, AuxiliaryConverter>> convertGroupToAuxiliaryCalls(SqlCall call) {
        ImmutableList.Builder builder = ImmutableList.builder();
        SqlStdOperatorTable.convertGroupToAuxiliaryCalls(call, (k, v) -> builder.add(Pair.of(k, v)));
        return builder.build();
    }

    public static void convertGroupToAuxiliaryCalls(SqlCall call, BiConsumer<SqlNode, AuxiliaryConverter> consumer) {
        SqlOperator op = call.getOperator();
        if (op instanceof SqlGroupedWindowFunction && op.isGroup()) {
            SqlGroupedWindowFunction fun = (SqlGroupedWindowFunction)op;
            fun.getAuxiliaryFunctions().forEach(f -> consumer.accept(SqlStdOperatorTable.copy(call, f), new AuxiliaryConverter.Impl((SqlFunction)f)));
        }
    }

    private static SqlCall copy(SqlCall call, SqlOperator operator) {
        return new SqlBasicCall(operator, call.getOperandList(), call.getParserPosition());
    }

    public static SqlQuantifyOperator some(SqlKind comparisonKind) {
        switch (comparisonKind) {
            case EQUALS: {
                return SOME_EQ;
            }
            case NOT_EQUALS: {
                return SOME_NE;
            }
            case LESS_THAN: {
                return SOME_LT;
            }
            case LESS_THAN_OR_EQUAL: {
                return SOME_LE;
            }
            case GREATER_THAN: {
                return SOME_GT;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SOME_GE;
            }
        }
        throw new AssertionError((Object)comparisonKind);
    }

    public static SqlQuantifyOperator all(SqlKind comparisonKind) {
        switch (comparisonKind) {
            case EQUALS: {
                return ALL_EQ;
            }
            case NOT_EQUALS: {
                return ALL_NE;
            }
            case LESS_THAN: {
                return ALL_LT;
            }
            case LESS_THAN_OR_EQUAL: {
                return ALL_LE;
            }
            case GREATER_THAN: {
                return ALL_GT;
            }
            case GREATER_THAN_OR_EQUAL: {
                return ALL_GE;
            }
        }
        throw new AssertionError((Object)comparisonKind);
    }

    @Deprecated
    public static SqlOperator reverse(SqlOperator operator) {
        switch (operator.getKind()) {
            case GREATER_THAN: {
                return LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return GREATER_THAN_OR_EQUAL;
            }
        }
        return operator;
    }

    public static SqlOperator like(boolean negated, boolean caseSensitive) {
        if (negated) {
            if (caseSensitive) {
                return NOT_LIKE;
            }
            return SqlLibraryOperators.NOT_ILIKE;
        }
        if (caseSensitive) {
            return LIKE;
        }
        return SqlLibraryOperators.ILIKE;
    }

    public static SqlOperator floorCeil(boolean floor, SqlConformance conformance) {
        if (SqlConformanceEnum.BIG_QUERY == conformance) {
            return floor ? SqlLibraryOperators.FLOOR_BIG_QUERY : SqlLibraryOperators.CEIL_BIG_QUERY;
        }
        return floor ? FLOOR : CEIL;
    }

    public static SqlOperator getConvertFuncByConformance(SqlConformance conformance) {
        if (SqlConformanceEnum.ORACLE_10 == conformance || SqlConformanceEnum.ORACLE_12 == conformance) {
            return SqlLibraryOperators.CONVERT_ORACLE;
        }
        return CONVERT;
    }
}

