/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlCollectionTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlMapTypeNameSpec;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlRowTypeNameSpec;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.MeasureSqlType;
import org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.calcite.sql.type.SqlTypeAssignmentRule;
import org.apache.calcite.sql.type.SqlTypeCoercionRule;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeMappingRule;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.NumberUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SqlTypeUtil {
    public static boolean isCharTypeComparable(List<RelDataType> argTypes) {
        Objects.requireNonNull(argTypes, "argTypes");
        assert (argTypes.size() >= 2);
        ArrayList<RelDataType> argTypes2 = new ArrayList<RelDataType>();
        for (RelDataType relDataType : argTypes) {
            if (SqlTypeUtil.isAny(relDataType) || SqlTypeUtil.isNull(relDataType)) continue;
            argTypes2.add(relDataType);
        }
        for (Pair pair : Pair.adjacents(argTypes2)) {
            RelDataType t0 = (RelDataType)pair.left;
            RelDataType t1 = (RelDataType)pair.right;
            if (!SqlTypeUtil.inCharFamily(t0) || !SqlTypeUtil.inCharFamily(t1)) {
                return false;
            }
            if (!NonNullableAccessors.getCharset(t0).equals(NonNullableAccessors.getCharset(t1))) {
                return false;
            }
            if (NonNullableAccessors.getCollation(t0).getCharset().equals(NonNullableAccessors.getCollation(t1).getCharset())) continue;
            return false;
        }
        return true;
    }

    public static boolean hasLiterals(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case UTINYINT: 
            case USMALLINT: 
            case UINTEGER: 
            case UBIGINT: 
            case ANY: 
            case SYMBOL: 
            case MULTISET: 
            case ARRAY: 
            case MAP: 
            case DISTINCT: 
            case STRUCTURED: 
            case ROW: 
            case OTHER: 
            case CURSOR: 
            case COLUMN_LIST: 
            case DYNAMIC_STAR: 
            case GEOMETRY: 
            case MEASURE: 
            case FUNCTION: 
            case SARG: {
                return false;
            }
        }
        return true;
    }

    public static boolean isCharTypeComparable(SqlCallBinding binding, List<SqlNode> operands, boolean throwOnFailure) {
        Objects.requireNonNull(operands, "operands");
        assert (operands.size() >= 2) : "operands.size() should be 2 or greater, actual: " + operands.size();
        if (!SqlTypeUtil.isCharTypeComparable(SqlTypeUtil.deriveType(binding, operands))) {
            if (throwOnFailure) {
                String msg = String.join((CharSequence)", ", Util.transform(operands, String::valueOf));
                throw binding.newError(Static.RESOURCE.operandNotComparable(msg));
            }
            return false;
        }
        return true;
    }

    private static RelDataType uniquify(RelDataTypeFactory factory, RelDataType type) {
        List<String> unique = SqlValidatorUtil.uniquify(type.getFieldNames(), true);
        List<RelDataType> types = type.getFieldList().stream().map(RelDataTypeField::getType).collect(Collectors.toList());
        return factory.createStructType(type.getStructKind(), types, unique);
    }

    public static RelDataType deriveCollectionQueryComponentType(RelDataTypeFactory factory, SqlTypeName collectionType, RelDataType origin) {
        switch (collectionType) {
            case MULTISET: 
            case ARRAY: {
                return origin.isStruct() && origin.getFieldCount() == 1 ? origin.getFieldList().get(0).getType() : SqlTypeUtil.uniquify(factory, origin);
            }
            case MAP: {
                return origin;
            }
        }
        throw new AssertionError((Object)("Impossible to derive component type for " + (Object)((Object)collectionType)));
    }

    @Deprecated
    public static RelDataType deriveCollectionQueryComponentType(SqlTypeName collectionType, RelDataType origin) {
        switch (collectionType) {
            case MULTISET: 
            case ARRAY: {
                return origin.isStruct() && origin.getFieldCount() == 1 ? origin.getFieldList().get(0).getType() : origin;
            }
            case MAP: {
                return origin;
            }
        }
        throw new AssertionError((Object)("Impossible to derive component type for " + (Object)((Object)collectionType)));
    }

    public static List<RelDataType> deriveAndCollectTypes(SqlValidator validator, SqlValidatorScope scope, List<? extends SqlNode> operands) {
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        for (SqlNode sqlNode : operands) {
            types.add(validator.deriveType(scope, sqlNode));
        }
        return types;
    }

    @API(since="1.26", status=API.Status.EXPERIMENTAL)
    public static RelDataType deriveType(SqlCallBinding binding) {
        return SqlTypeUtil.deriveType(binding, binding.getCall());
    }

    @API(since="1.26", status=API.Status.EXPERIMENTAL)
    public static RelDataType deriveType(SqlCallBinding binding, SqlNode node) {
        return binding.getValidator().deriveType(Objects.requireNonNull(binding.getScope(), () -> "scope of " + binding), node);
    }

    @API(since="1.26", status=API.Status.EXPERIMENTAL)
    public static List<RelDataType> deriveType(SqlCallBinding binding, List<? extends SqlNode> nodes) {
        return SqlTypeUtil.deriveAndCollectTypes(binding.getValidator(), Objects.requireNonNull(binding.getScope(), () -> "scope of " + binding), nodes);
    }

    public static RelDataType promoteToRowType(RelDataTypeFactory typeFactory, RelDataType type, @Nullable String fieldName) {
        if (!type.isStruct()) {
            if (fieldName == null) {
                fieldName = "ROW_VALUE";
            }
            type = typeFactory.builder().add(fieldName, type).build();
        }
        return type;
    }

    public static RelDataType makeNullableIfOperandsAre(SqlValidator validator, SqlValidatorScope scope, SqlCall call, RelDataType type) {
        for (SqlNode operand : call.getOperandList()) {
            RelDataType operandType = validator.deriveType(scope, operand);
            if (!SqlTypeUtil.containsNullable(operandType)) continue;
            RelDataTypeFactory typeFactory = validator.getTypeFactory();
            type = typeFactory.createTypeWithNullability(type, true);
            break;
        }
        return type;
    }

    public static RelDataType makeNullableIfOperandsAre(RelDataTypeFactory typeFactory, List<RelDataType> argTypes, RelDataType type) {
        Objects.requireNonNull(type, "type");
        if (SqlTypeUtil.containsNullable(argTypes)) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        return type;
    }

    public static boolean allNullable(List<RelDataType> types) {
        for (RelDataType type : types) {
            if (SqlTypeUtil.containsNullable(type)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsNullable(List<RelDataType> types) {
        for (RelDataType type : types) {
            if (!SqlTypeUtil.containsNullable(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNullable(RelDataType type) {
        if (type.isNullable()) {
            return true;
        }
        if (!type.isStruct()) {
            return false;
        }
        for (RelDataTypeField field : type.getFieldList()) {
            if (!SqlTypeUtil.containsNullable(field.getType())) continue;
            return true;
        }
        return false;
    }

    public static RelDataType keepSourceTypeAndTargetNullability(RelDataType sourceRelDataType, RelDataType targetRelDataType, RelDataTypeFactory typeFactory) {
        Preconditions.checkArgument((targetRelDataType.isStruct() && sourceRelDataType.isStruct() || !targetRelDataType.isStruct() && !sourceRelDataType.isStruct() ? 1 : 0) != 0, (Object)"one is a struct, while the other one is not");
        if (!targetRelDataType.isStruct()) {
            return typeFactory.createTypeWithNullability(sourceRelDataType, targetRelDataType.isNullable());
        }
        List<RelDataTypeField> targetFields = targetRelDataType.getFieldList();
        List<RelDataTypeField> sourceFields = sourceRelDataType.getFieldList();
        ImmutableList.Builder newTargetField = ImmutableList.builder();
        for (int i = 0; i < targetRelDataType.getFieldCount(); ++i) {
            RelDataTypeField targetField = targetFields.get(i);
            RelDataTypeField sourceField = sourceFields.get(i);
            newTargetField.add((Object)new RelDataTypeFieldImpl(sourceField.getName(), sourceField.getIndex(), SqlTypeUtil.keepSourceTypeAndTargetNullability(sourceField.getType(), targetField.getType(), typeFactory)));
        }
        RelDataType relDataType = typeFactory.createStructType((List<? extends Map.Entry<String, RelDataType>>)newTargetField.build());
        return typeFactory.createTypeWithNullability(relDataType, targetRelDataType.isNullable());
    }

    public static boolean isOfSameTypeName(SqlTypeName typeName, RelDataType type) {
        return SqlTypeName.ANY == typeName || typeName == type.getSqlTypeName();
    }

    public static boolean isOfSameTypeName(Collection<SqlTypeName> typeNames, RelDataType type) {
        for (SqlTypeName typeName : typeNames) {
            if (!SqlTypeUtil.isOfSameTypeName(typeName, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDatetime(RelDataType type) {
        return SqlTypeFamily.DATETIME.contains(type);
    }

    public static boolean isDate(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return type.getSqlTypeName() == SqlTypeName.DATE;
    }

    public static boolean isTimestamp(RelDataType type) {
        return SqlTypeFamily.TIMESTAMP.contains(type);
    }

    @EnsuresNonNullIf(expression={"#1.getIntervalQualifier()"}, result=true)
    public static boolean isInterval(RelDataType type) {
        return SqlTypeFamily.DATETIME_INTERVAL.contains(type);
    }

    @EnsuresNonNullIf.List(value={@EnsuresNonNullIf(expression={"#1.getCharset()"}, result=true), @EnsuresNonNullIf(expression={"#1.getCollation()"}, result=true)})
    public static boolean inCharFamily(RelDataType type) {
        return type.getFamily() == SqlTypeFamily.CHARACTER;
    }

    public static boolean inCharFamily(SqlTypeName typeName) {
        return typeName.getFamily() == SqlTypeFamily.CHARACTER;
    }

    public static boolean inBooleanFamily(RelDataType type) {
        return type.getFamily() == SqlTypeFamily.BOOLEAN;
    }

    public static boolean inSameFamily(RelDataType t1, RelDataType t2) {
        return t1.getFamily() == t2.getFamily();
    }

    public static boolean inSameFamilyOrNull(RelDataType t1, RelDataType t2) {
        return t1.getSqlTypeName() == SqlTypeName.NULL || t2.getSqlTypeName() == SqlTypeName.NULL || t1.getFamily() == t2.getFamily();
    }

    public static boolean inCharOrBinaryFamilies(RelDataType type) {
        return type.getFamily() == SqlTypeFamily.CHARACTER || type.getFamily() == SqlTypeFamily.BINARY;
    }

    public static boolean isLob(RelDataType type) {
        return false;
    }

    public static boolean isBoundedVariableWidth(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case MULTISET: 
            case VARCHAR: 
            case VARBINARY: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntType(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case UTINYINT: 
            case USMALLINT: 
            case UINTEGER: 
            case UBIGINT: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDecimal(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return typeName == SqlTypeName.DECIMAL;
    }

    public static boolean isExactNumeric(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case UTINYINT: 
            case USMALLINT: 
            case UINTEGER: 
            case UBIGINT: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    public static boolean integerRangeContains(RelDataType container, RelDataType content) {
        boolean contentIsDecimal;
        Preconditions.checkArgument((boolean)SqlTypeUtil.isIntType(container), (String)"container must be an integer type: %s", (Object)container);
        SqlTypeName contentType = content.getSqlTypeName();
        boolean bl = contentIsDecimal = contentType == SqlTypeName.DECIMAL;
        if (!(SqlTypeUtil.isIntType(content) || contentIsDecimal && content.getScale() == 0)) {
            return false;
        }
        BigInteger containerMin = SqlTypeUtil.integerBound(container, false);
        BigInteger containerMax = SqlTypeUtil.integerBound(container, true);
        if (containerMin == null || containerMax == null) {
            return false;
        }
        BigInteger contentMin = SqlTypeUtil.integerBound(content, false);
        BigInteger contentMax = SqlTypeUtil.integerBound(content, true);
        if (contentMin == null || contentMax == null) {
            return false;
        }
        return containerMin.compareTo(contentMin) <= 0 && containerMax.compareTo(contentMax) >= 0;
    }

    public static @Nullable BigInteger integerBound(RelDataType type, boolean upper) {
        int scale;
        boolean isDecimal;
        SqlTypeName typeName = type.getSqlTypeName();
        boolean bl = isDecimal = typeName == SqlTypeName.DECIMAL;
        if (!isDecimal && !SqlTypeUtil.isIntType(type)) {
            return null;
        }
        if (isDecimal && type.getScale() != 0) {
            return null;
        }
        int precision = isDecimal ? type.getPrecision() : -1;
        Object limit = typeName.getLimit(upper, SqlTypeName.Limit.OVERFLOW, false, precision, scale = isDecimal ? type.getScale() : -1);
        if (limit == null) {
            return null;
        }
        if (limit instanceof BigDecimal) {
            try {
                return ((BigDecimal)limit).toBigIntegerExact();
            }
            catch (ArithmeticException ignored) {
                return null;
            }
        }
        if (limit instanceof Number) {
            return BigInteger.valueOf(((Number)limit).longValue());
        }
        return null;
    }

    public static boolean hasScale(RelDataType type) {
        return type.getScale() != Integer.MIN_VALUE;
    }

    public static long maxValue(RelDataType type) {
        assert (SqlTypeUtil.isIntType(type));
        switch (type.getSqlTypeName()) {
            case TINYINT: {
                return 127L;
            }
            case SMALLINT: {
                return 32767L;
            }
            case INTEGER: {
                return Integer.MAX_VALUE;
            }
            case UTINYINT: {
                return 255L;
            }
            case USMALLINT: {
                return 65535L;
            }
            case UINTEGER: {
                return 0xFFFFFFFFL;
            }
            case BIGINT: {
                return Long.MAX_VALUE;
            }
        }
        throw Util.unexpected(type.getSqlTypeName());
    }

    public static boolean isApproximateNumeric(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case FLOAT: 
            case REAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumeric(RelDataType type) {
        return SqlTypeUtil.isExactNumeric(type) || SqlTypeUtil.isApproximateNumeric(type);
    }

    public static boolean isNull(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return typeName == SqlTypeName.NULL;
    }

    public static boolean sameNamedType(RelDataType t1, RelDataType t2) {
        if (t1.isStruct() || t2.isStruct()) {
            if (!t1.isStruct() || !t2.isStruct()) {
                return false;
            }
            if (t1.getFieldCount() != t2.getFieldCount()) {
                return false;
            }
            List<RelDataTypeField> fields1 = t1.getFieldList();
            List<RelDataTypeField> fields2 = t2.getFieldList();
            for (int i = 0; i < fields1.size(); ++i) {
                if (SqlTypeUtil.sameNamedType(fields1.get(i).getType(), fields2.get(i).getType())) continue;
                return false;
            }
            return true;
        }
        SqlTypeName t1Name = t1.getSqlTypeName();
        SqlTypeName t2Name = t2.getSqlTypeName();
        if (t1Name == SqlTypeName.ARRAY || t1Name == SqlTypeName.MULTISET) {
            if (t1Name != t2Name) {
                return false;
            }
            RelDataType comp1 = Objects.requireNonNull(t1.getComponentType());
            RelDataType comp2 = Objects.requireNonNull(t2.getComponentType());
            return SqlTypeUtil.sameNamedType(comp1, comp2);
        }
        if (t1Name == SqlTypeName.MAP) {
            RelDataType keyType2;
            if (t1Name != t2Name) {
                return false;
            }
            RelDataType keyType1 = Objects.requireNonNull(t1.getKeyType());
            if (!SqlTypeUtil.sameNamedType(keyType1, keyType2 = Objects.requireNonNull(t2.getKeyType()))) {
                return false;
            }
            RelDataType valueType1 = Objects.requireNonNull(t1.getValueType());
            RelDataType valueType2 = Objects.requireNonNull(t2.getValueType());
            return SqlTypeUtil.sameNamedType(valueType1, valueType2);
        }
        return t1Name == t2Name;
    }

    public static int getMaxByteSize(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return 0;
        }
        switch (typeName) {
            case VARCHAR: 
            case CHAR: {
                return (int)Math.ceil((double)type.getPrecision() * (double)NonNullableAccessors.getCharset(type).newEncoder().maxBytesPerChar());
            }
            case VARBINARY: 
            case BINARY: {
                return type.getPrecision();
            }
            case MULTISET: {
                return 4096;
            }
        }
        return 0;
    }

    @Deprecated
    public static long getMinValue(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        switch (typeName) {
            case TINYINT: {
                return -128L;
            }
            case SMALLINT: {
                return -32768L;
            }
            case INTEGER: {
                return Integer.MIN_VALUE;
            }
            case UTINYINT: 
            case USMALLINT: 
            case UINTEGER: 
            case UBIGINT: {
                return 0L;
            }
            case BIGINT: 
            case DECIMAL: {
                return NumberUtil.getMinUnscaled(type.getPrecision()).longValue();
            }
        }
        throw new AssertionError((Object)("getMinValue(" + (Object)((Object)typeName) + ")"));
    }

    @Deprecated
    public static long getMaxValue(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        switch (typeName) {
            case UTINYINT: {
                return 255L;
            }
            case TINYINT: {
                return 127L;
            }
            case USMALLINT: {
                return 65535L;
            }
            case SMALLINT: {
                return 32767L;
            }
            case UINTEGER: {
                return 0xFFFFFFFFL;
            }
            case INTEGER: {
                return Integer.MAX_VALUE;
            }
            case BIGINT: 
            case DECIMAL: {
                return NumberUtil.getMaxUnscaled(type.getPrecision()).longValue();
            }
        }
        throw new AssertionError((Object)("getMaxValue(" + (Object)((Object)typeName) + ")"));
    }

    @Deprecated
    public static boolean isJavaPrimitive(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case SYMBOL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case REAL: 
            case DOUBLE: 
            case BOOLEAN: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static @Nullable String getPrimitiveWrapperJavaClassName(@Nullable RelDataType type) {
        if (type == null) {
            return null;
        }
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return null;
        }
        switch (typeName) {
            case BOOLEAN: {
                return "Boolean";
            }
        }
        return SqlTypeUtil.getNumericJavaClassName(type);
    }

    @Deprecated
    public static @Nullable String getNumericJavaClassName(@Nullable RelDataType type) {
        if (type == null) {
            return null;
        }
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return null;
        }
        switch (typeName) {
            case TINYINT: {
                return "Byte";
            }
            case SMALLINT: {
                return "Short";
            }
            case INTEGER: {
                return "Integer";
            }
            case BIGINT: {
                return "Long";
            }
            case REAL: {
                return "Float";
            }
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: {
                return "Double";
            }
        }
        return null;
    }

    private static boolean isAny(RelDataType t) {
        return t.getFamily() == SqlTypeFamily.ANY;
    }

    private static boolean isVariant(RelDataType t) {
        return t.getFamily() == SqlTypeFamily.VARIANT;
    }

    public static boolean isMeasure(RelDataType t) {
        return t instanceof MeasureSqlType;
    }

    public static boolean canAssignFrom(RelDataType toType, RelDataType fromType) {
        if (SqlTypeUtil.isAny(toType) || SqlTypeUtil.isAny(fromType)) {
            return true;
        }
        if (fromType.getSqlTypeName() == SqlTypeName.NULL) {
            return true;
        }
        if (fromType.getSqlTypeName() == SqlTypeName.ARRAY) {
            if (toType.getSqlTypeName() != SqlTypeName.ARRAY) {
                return false;
            }
            return SqlTypeUtil.canAssignFrom(NonNullableAccessors.getComponentTypeOrThrow(toType), NonNullableAccessors.getComponentTypeOrThrow(fromType));
        }
        if (SqlTypeUtil.areCharacterSetsMismatched(toType, fromType)) {
            return false;
        }
        return toType.getFamily() == fromType.getFamily();
    }

    public static boolean areCharacterSetsMismatched(RelDataType t1, RelDataType t2) {
        if (SqlTypeUtil.isAny(t1) || SqlTypeUtil.isAny(t2)) {
            return false;
        }
        Charset cs1 = t1.getCharset();
        Charset cs2 = t2.getCharset();
        return cs1 != null && cs2 != null && !cs1.equals(cs2);
    }

    public static boolean canCastFrom(RelDataType toType, RelDataType fromType, boolean coerce) {
        return SqlTypeUtil.canCastFrom(toType, fromType, coerce ? SqlTypeCoercionRule.instance() : SqlTypeAssignmentRule.instance());
    }

    public static boolean canCastFrom(RelDataType toType, RelDataType fromType, SqlTypeMappingRule typeMappingRule) {
        IntervalSqlType intervalType;
        RelDataType c2;
        if (toType.equals(fromType)) {
            return true;
        }
        if (SqlTypeUtil.isMeasure(fromType)) {
            return SqlTypeUtil.canCastFrom(toType, Objects.requireNonNull(fromType.getMeasureElementType()), typeMappingRule);
        }
        if (SqlTypeUtil.isAny(toType) || SqlTypeUtil.isAny(fromType) || SqlTypeUtil.isVariant(toType) || SqlTypeUtil.isVariant(fromType)) {
            return true;
        }
        SqlTypeName fromTypeName = fromType.getSqlTypeName();
        SqlTypeName toTypeName = toType.getSqlTypeName();
        if (toTypeName == SqlTypeName.UNKNOWN) {
            return true;
        }
        if (toType.getSqlTypeName() == SqlTypeName.UUID) {
            return fromType.getSqlTypeName() == SqlTypeName.NULL || fromType.getSqlTypeName() == SqlTypeName.UUID || fromType.getFamily() == SqlTypeFamily.CHARACTER || fromType.getFamily() == SqlTypeFamily.BINARY;
        }
        if (toType.isStruct() || fromType.isStruct()) {
            if (toTypeName == SqlTypeName.DISTINCT) {
                if (fromTypeName == SqlTypeName.DISTINCT) {
                    return false;
                }
                return SqlTypeUtil.canCastFrom(toType.getFieldList().get(0).getType(), fromType, typeMappingRule);
            }
            if (fromTypeName == SqlTypeName.DISTINCT) {
                return SqlTypeUtil.canCastFrom(toType, fromType.getFieldList().get(0).getType(), typeMappingRule);
            }
            if (toTypeName == SqlTypeName.ROW) {
                if (fromTypeName != SqlTypeName.ROW) {
                    return fromTypeName == SqlTypeName.NULL;
                }
                int n = toType.getFieldCount();
                if (fromType.getFieldCount() != n) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    RelDataTypeField toField = toType.getFieldList().get(i);
                    RelDataTypeField fromField = fromType.getFieldList().get(i);
                    if (SqlTypeUtil.canCastFrom(toField.getType(), fromField.getType(), typeMappingRule)) continue;
                    return false;
                }
                return true;
            }
            if (toTypeName == SqlTypeName.MULTISET) {
                if (!fromType.isStruct()) {
                    return false;
                }
                if (fromTypeName != SqlTypeName.MULTISET) {
                    return false;
                }
                return SqlTypeUtil.canCastFrom(NonNullableAccessors.getComponentTypeOrThrow(toType), NonNullableAccessors.getComponentTypeOrThrow(fromType), typeMappingRule);
            }
            if (fromTypeName == SqlTypeName.MULTISET) {
                return false;
            }
            return toType.getFamily() == fromType.getFamily();
        }
        RelDataType c1 = toType.getComponentType();
        if (c1 != null && (c2 = fromType.getComponentType()) != null) {
            return SqlTypeUtil.canCastFrom(c1, c2, typeMappingRule);
        }
        if ((SqlTypeUtil.isInterval(fromType) && SqlTypeUtil.isExactNumeric(toType) || SqlTypeUtil.isInterval(toType) && SqlTypeUtil.isExactNumeric(fromType)) && !(intervalType = (IntervalSqlType)(SqlTypeUtil.isInterval(fromType) ? fromType : toType)).getIntervalQualifier().isSingleDatetimeField()) {
            return false;
        }
        if (toTypeName == null || fromTypeName == null) {
            return false;
        }
        return typeMappingRule.canApplyFrom(toTypeName, fromTypeName);
    }

    public static RelDataType flattenRecordType(RelDataTypeFactory typeFactory, RelDataType recordType, int @Nullable [] flatteningMap) {
        if (!recordType.isStruct()) {
            return recordType;
        }
        ArrayList<RelDataTypeField> fieldList = new ArrayList<RelDataTypeField>();
        boolean nested = SqlTypeUtil.flattenFields(typeFactory, recordType, fieldList, flatteningMap);
        if (!nested) {
            return recordType;
        }
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        Map fieldCnt = fieldList.stream().map(RelDataTypeField::getName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        int i = -1;
        for (RelDataTypeField field : fieldList) {
            types.add(field.getType());
            String oriFieldName = field.getName();
            Long fieldCount = fieldCnt.get(oriFieldName);
            String fieldName = fieldCount != null && fieldCount > 1L ? oriFieldName + "_" + ++i : oriFieldName;
            fieldNames.add(fieldName);
        }
        return typeFactory.createStructType(types, fieldNames);
    }

    public static boolean needsNullIndicator(RelDataType recordType) {
        return recordType.getSqlTypeName() == SqlTypeName.STRUCTURED;
    }

    private static boolean flattenFields(RelDataTypeFactory typeFactory, RelDataType type, List<RelDataTypeField> list, int @Nullable [] flatteningMap) {
        boolean nested = false;
        for (RelDataTypeField field : type.getFieldList()) {
            if (flatteningMap != null) {
                flatteningMap[field.getIndex()] = list.size();
            }
            if (field.getType().isStruct()) {
                nested = true;
                SqlTypeUtil.flattenFields(typeFactory, field.getType(), list, null);
                continue;
            }
            if (field.getType().getComponentType() != null) {
                nested = true;
                RelDataType flattenedCollectionType = typeFactory.createMultisetType(SqlTypeUtil.flattenRecordType(typeFactory, NonNullableAccessors.getComponentTypeOrThrow(field.getType()), null), -1L);
                if (field.getType() instanceof ArraySqlType) {
                    flattenedCollectionType = typeFactory.createArrayType(SqlTypeUtil.flattenRecordType(typeFactory, NonNullableAccessors.getComponentTypeOrThrow(field.getType()), null), -1L);
                }
                field = new RelDataTypeFieldImpl(field.getName(), field.getIndex(), flattenedCollectionType);
                list.add(field);
                continue;
            }
            list.add(field);
        }
        return nested;
    }

    public static SqlDataTypeSpec convertTypeToSpec(RelDataType type, @Nullable String charSetName, int maxPrecision, int maxScale) {
        SqlTypeNameSpec typeNameSpec;
        SqlTypeName typeName = type.getSqlTypeName();
        Objects.requireNonNull(typeName, "typeName");
        if (SqlTypeUtil.isAtomic(type) || SqlTypeUtil.isNull(type) || type.getSqlTypeName() == SqlTypeName.UNKNOWN || type.getSqlTypeName() == SqlTypeName.GEOMETRY || SqlTypeUtil.isInterval(type)) {
            int scale;
            int precision;
            int n = precision = typeName.allowsPrec() ? type.getPrecision() : -1;
            if (maxPrecision > 0 && precision > maxPrecision) {
                precision = maxPrecision;
            }
            int n2 = scale = typeName.allowsScale() ? type.getScale() : Integer.MIN_VALUE;
            if (maxScale > 0 && scale > maxScale) {
                scale = maxScale;
            }
            typeNameSpec = new SqlBasicTypeNameSpec(typeName, precision, scale, charSetName, SqlParserPos.ZERO);
        } else if (SqlTypeUtil.isCollection(type)) {
            RelDataType componentType = NonNullableAccessors.getComponentTypeOrThrow(type);
            typeNameSpec = new SqlCollectionTypeNameSpec(SqlTypeUtil.convertTypeToSpec(componentType).getTypeNameSpec(), componentType.isNullable(), typeName, SqlParserPos.ZERO);
        } else if (SqlTypeUtil.isRow(type)) {
            RelRecordType recordType = (RelRecordType)type;
            List<RelDataTypeField> fields = recordType.getFieldList();
            List<SqlIdentifier> fieldNames = fields.stream().map(f -> new SqlIdentifier(f.getName(), SqlParserPos.ZERO)).collect(Collectors.toList());
            List<SqlDataTypeSpec> fieldTypes = fields.stream().map(f -> SqlTypeUtil.convertTypeToSpec(f.getType())).collect(Collectors.toList());
            typeNameSpec = new SqlRowTypeNameSpec(SqlParserPos.ZERO, fieldNames, fieldTypes);
        } else if (SqlTypeUtil.isMap(type)) {
            RelDataType keyType = Objects.requireNonNull(type.getKeyType(), () -> "keyType of " + type);
            RelDataType valueType = Objects.requireNonNull(type.getValueType(), () -> "valueType of " + type);
            SqlDataTypeSpec keyTypeSpec = SqlTypeUtil.convertTypeToSpec(keyType);
            SqlDataTypeSpec valueTypeSpec = SqlTypeUtil.convertTypeToSpec(valueType);
            typeNameSpec = new SqlMapTypeNameSpec(keyTypeSpec, valueTypeSpec, SqlParserPos.ZERO);
        } else {
            throw new UnsupportedOperationException("Unsupported type when convertTypeToSpec: " + (Object)((Object)typeName));
        }
        return new SqlDataTypeSpec(typeNameSpec, SqlParserPos.ZERO).withNullable(type.isNullable());
    }

    public static SqlDataTypeSpec convertTypeToSpec(RelDataType type) {
        String charSetName = SqlTypeUtil.inCharFamily(type) ? type.getCharset().name() : null;
        return SqlTypeUtil.convertTypeToSpec(type, charSetName, -1, Integer.MIN_VALUE);
    }

    public static RelDataType createMultisetType(RelDataTypeFactory typeFactory, RelDataType type, boolean nullable) {
        RelDataType ret = typeFactory.createMultisetType(type, -1L);
        return typeFactory.createTypeWithNullability(ret, nullable);
    }

    public static RelDataType createArrayType(RelDataTypeFactory typeFactory, RelDataType type, boolean nullable) {
        RelDataType ret = typeFactory.createArrayType(type, -1L);
        return typeFactory.createTypeWithNullability(ret, nullable);
    }

    public static RelDataType createMapType(RelDataTypeFactory typeFactory, RelDataType keyType, RelDataType valueType, boolean nullable) {
        RelDataType ret = typeFactory.createMapType(keyType, valueType);
        return typeFactory.createTypeWithNullability(ret, nullable);
    }

    public static RelDataType createMapTypeFromRecord(RelDataTypeFactory typeFactory, RelDataType type) {
        Preconditions.checkArgument((type.getFieldCount() == 2 ? 1 : 0) != 0, (String)"MAP requires exactly two fields, got %s; row type %s", (int)type.getFieldCount(), (Object)type);
        return SqlTypeUtil.createMapType(typeFactory, type.getFieldList().get(0).getType(), type.getFieldList().get(1).getType(), false);
    }

    public static RelDataType createRecordTypeFromMap(RelDataTypeFactory typeFactory, RelDataType type) {
        RelDataType keyType = Objects.requireNonNull(type.getKeyType(), () -> "keyType of " + type);
        RelDataType valueType = Objects.requireNonNull(type.getValueType(), () -> "valueType of " + type);
        return typeFactory.createStructType(Arrays.asList(keyType, valueType), Arrays.asList("f0", "f1"));
    }

    public static RelDataType addCharsetAndCollation(RelDataType type, RelDataTypeFactory typeFactory) {
        SqlCollation collation;
        if (!SqlTypeUtil.inCharFamily(type)) {
            return type;
        }
        Charset charset = type.getCharset();
        if (charset == null) {
            charset = typeFactory.getDefaultCharset();
        }
        if ((collation = type.getCollation()) == null) {
            collation = SqlCollation.IMPLICIT;
        }
        type = typeFactory.createTypeWithCharsetAndCollation(type, charset, collation);
        SqlValidatorUtil.checkCharsetAndCollateConsistentIfCharType(type);
        return type;
    }

    public static boolean equalSansNullability(RelDataTypeFactory factory, RelDataType type1, RelDataType type2) {
        if (type1.isNullable() == type2.isNullable()) {
            return type1.equals(type2);
        }
        return type1.equals(factory.createTypeWithNullability(type2, type1.isNullable()));
    }

    public static boolean equalSansNullability(RelDataType type1, RelDataType type2) {
        if (type1 == type2) {
            return true;
        }
        String x = type1.getFullTypeString();
        String y = type2.getFullTypeString();
        if (x.length() < y.length()) {
            String c = x;
            x = y;
            y = c;
        }
        return (x.length() == y.length() || x.length() == y.length() + " NOT NULL".length() && x.endsWith(" NOT NULL")) && x.startsWith(y);
    }

    public static boolean equalAsCollectionSansNullability(RelDataTypeFactory factory, RelDataType type1, RelDataType type2) {
        Preconditions.checkArgument((boolean)SqlTypeUtil.isCollection(type1), (Object)"Input type1 must be collection type");
        Preconditions.checkArgument((boolean)SqlTypeUtil.isCollection(type2), (Object)"Input type2 must be collection type");
        return type1 == type2 || type1.getSqlTypeName() == type2.getSqlTypeName() && SqlTypeUtil.equalSansNullability(factory, NonNullableAccessors.getComponentTypeOrThrow(type1), NonNullableAccessors.getComponentTypeOrThrow(type2));
    }

    public static boolean equalAsMapSansNullability(RelDataTypeFactory factory, RelDataType type1, RelDataType type2) {
        Preconditions.checkArgument((boolean)SqlTypeUtil.isMap(type1), (Object)"Input type1 must be map type");
        Preconditions.checkArgument((boolean)SqlTypeUtil.isMap(type2), (Object)"Input type2 must be map type");
        MapSqlType mType1 = (MapSqlType)type1;
        MapSqlType mType2 = (MapSqlType)type2;
        return type1 == type2 || SqlTypeUtil.equalSansNullability(factory, mType1.getKeyType(), mType2.getKeyType()) && SqlTypeUtil.equalSansNullability(factory, mType1.getValueType(), mType2.getValueType());
    }

    public static boolean equalAsStructSansNullability(RelDataTypeFactory factory, RelDataType type1, RelDataType type2, @Nullable SqlNameMatcher nameMatcher) {
        Preconditions.checkArgument((boolean)type1.isStruct(), (Object)"Input type1 must be struct type");
        Preconditions.checkArgument((boolean)type2.isStruct(), (Object)"Input type2 must be struct type");
        if (type1 == type2) {
            return true;
        }
        if (type1.getFieldCount() != type2.getFieldCount()) {
            return false;
        }
        for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(type1.getFieldList(), type2.getFieldList())) {
            if (nameMatcher != null && !nameMatcher.matches(((RelDataTypeField)pair.left).getName(), ((RelDataTypeField)pair.right).getName())) {
                return false;
            }
            if (SqlTypeUtil.equalSansNullability(factory, ((RelDataTypeField)pair.left).getType(), ((RelDataTypeField)pair.right).getType())) continue;
            return false;
        }
        return true;
    }

    public static int findField(RelDataType type, String fieldName) {
        List<RelDataTypeField> fields = type.getFieldList();
        for (int i = 0; i < fields.size(); ++i) {
            RelDataTypeField field = fields.get(i);
            if (field.getName().equals(fieldName)) {
                return i;
            }
            RelDataType fieldType = field.getType();
            if (!fieldType.isStruct() || SqlTypeUtil.findField(fieldType, fieldName) == -1) continue;
            return i;
        }
        return -1;
    }

    public static List<RelDataType> projectTypes(RelDataType rowType, final List<? extends Number> requiredFields) {
        final List<RelDataTypeField> fields = rowType.getFieldList();
        return new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return ((RelDataTypeField)fields.get(((Number)requiredFields.get(index)).intValue())).getType();
            }

            @Override
            public int size() {
                return requiredFields.size();
            }
        };
    }

    public static RelDataType createEmptyStructType(RelDataTypeFactory typeFactory) {
        return typeFactory.createStructType((List<RelDataType>)ImmutableList.of(), (List<String>)ImmutableList.of());
    }

    public static boolean isFlat(RelDataType type) {
        if (type.isStruct()) {
            for (RelDataTypeField field : type.getFieldList()) {
                if (!field.getType().isStruct()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isComparable(RelDataType type1, RelDataType type2) {
        RelDataTypeFamily family1 = SqlTypeUtil.family(type1);
        RelDataTypeFamily family2 = SqlTypeUtil.family(type2);
        if (family1 == SqlTypeFamily.NULL || family2 == SqlTypeFamily.NULL) {
            return true;
        }
        if (type1.isStruct() != type2.isStruct()) {
            return false;
        }
        if (type1.isStruct()) {
            int n = type1.getFieldCount();
            if (n != type2.getFieldCount()) {
                return false;
            }
            for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(type1.getFieldList(), type2.getFieldList())) {
                if (SqlTypeUtil.isComparable(((RelDataTypeField)pair.left).getType(), ((RelDataTypeField)pair.right).getType())) continue;
                return false;
            }
            return true;
        }
        SqlTypeName type1Name = type1.getSqlTypeName();
        SqlTypeName type2Name = type2.getSqlTypeName();
        if (type1Name == SqlTypeName.ARRAY || type1Name == SqlTypeName.MULTISET) {
            if (type2Name != type1Name) {
                return false;
            }
            RelDataType elementType1 = Objects.requireNonNull(type1.getComponentType());
            RelDataType elementType2 = Objects.requireNonNull(type2.getComponentType());
            return SqlTypeUtil.isComparable(elementType1, elementType2);
        }
        if (type1Name == SqlTypeName.MAP) {
            if (type2Name != type1Name) {
                return false;
            }
            RelDataType keyType1 = Objects.requireNonNull(type1.getKeyType());
            RelDataType keyType2 = Objects.requireNonNull(type2.getKeyType());
            RelDataType valueType1 = Objects.requireNonNull(type1.getValueType());
            RelDataType valueType2 = Objects.requireNonNull(type2.getValueType());
            return SqlTypeUtil.isComparable(keyType1, keyType2) && SqlTypeUtil.isComparable(valueType1, valueType2);
        }
        if (family1 == family2) {
            return true;
        }
        if (family1 == SqlTypeFamily.ANY || family2 == SqlTypeFamily.ANY) {
            return true;
        }
        return family1 == SqlTypeFamily.CHARACTER && SqlTypeUtil.canConvertStringInCompare(family2) || family2 == SqlTypeFamily.CHARACTER && SqlTypeUtil.canConvertStringInCompare(family1);
    }

    public static @Nullable RelDataType leastRestrictiveForComparison(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        RelDataType type = typeFactory.leastRestrictive((List<RelDataType>)ImmutableList.of((Object)type1, (Object)type2));
        if (type != null) {
            return type;
        }
        RelDataTypeFamily family1 = SqlTypeUtil.family(type1);
        RelDataTypeFamily family2 = SqlTypeUtil.family(type2);
        if (family1 == SqlTypeFamily.ANY) {
            return type2;
        }
        if (family2 == SqlTypeFamily.ANY) {
            return type1;
        }
        if (family1 == SqlTypeFamily.NULL) {
            return type2;
        }
        if (family2 == SqlTypeFamily.NULL) {
            return type1;
        }
        if (family1 == SqlTypeFamily.CHARACTER && SqlTypeUtil.canConvertStringInCompare(family2)) {
            return type2;
        }
        if (family2 == SqlTypeFamily.CHARACTER && SqlTypeUtil.canConvertStringInCompare(family1)) {
            return type1;
        }
        return null;
    }

    protected static RelDataTypeFamily family(RelDataType type) {
        RelDataTypeFamily family = null;
        if (type.getSqlTypeName() != null) {
            family = type.getSqlTypeName().getFamily();
        }
        if (family == null) {
            family = type.getFamily();
        }
        return family;
    }

    public static boolean areSameFamily(Iterable<RelDataType> types) {
        ImmutableList typeList = ImmutableList.copyOf(types);
        if (Sets.newHashSet(RexUtil.families((List<RelDataType>)typeList)).size() < 2) {
            return true;
        }
        for (Pair adjacent : Pair.adjacents(typeList)) {
            if (SqlTypeUtil.isSameFamily((RelDataType)adjacent.left, (RelDataType)adjacent.right)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameFamily(RelDataType type1, RelDataType type2) {
        RelDataTypeFamily family2;
        if (type1.isStruct() != type2.isStruct()) {
            return false;
        }
        if (type1.isStruct()) {
            int n = type1.getFieldCount();
            if (n != type2.getFieldCount()) {
                return false;
            }
            for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(type1.getFieldList(), type2.getFieldList())) {
                if (SqlTypeUtil.isSameFamily(((RelDataTypeField)pair.left).getType(), ((RelDataTypeField)pair.right).getType())) continue;
                return false;
            }
            return true;
        }
        RelDataTypeFamily family1 = SqlTypeUtil.family(type1);
        return family1 == (family2 = SqlTypeUtil.family(type2));
    }

    private static boolean canConvertStringInCompare(RelDataTypeFamily family) {
        if (family instanceof SqlTypeFamily) {
            SqlTypeFamily sqlTypeFamily = (SqlTypeFamily)family;
            switch (sqlTypeFamily) {
                case DATE: 
                case TIME: 
                case TIMESTAMP: 
                case INTERVAL_DAY_TIME: 
                case INTERVAL_YEAR_MONTH: 
                case NUMERIC: 
                case APPROXIMATE_NUMERIC: 
                case EXACT_NUMERIC: 
                case INTEGER: 
                case BOOLEAN: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isUnicode(RelDataType type) {
        Charset charset = type.getCharset();
        if (charset == null) {
            return false;
        }
        return charset.name().startsWith("UTF");
    }

    public static int maxPrecision(int p0, int p1) {
        return p0 == -1 || p0 >= p1 && p1 != -1 ? p0 : p1;
    }

    public static int comparePrecision(int p0, int p1) {
        if (p0 == p1) {
            return 0;
        }
        if (p0 == -1) {
            return 1;
        }
        if (p1 == -1) {
            return -1;
        }
        return Integer.compare(p0, p1);
    }

    public static boolean isArray(RelDataType type) {
        return type.getSqlTypeName() == SqlTypeName.ARRAY;
    }

    public static boolean isRow(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return type.getSqlTypeName() == SqlTypeName.ROW;
    }

    public static boolean isMap(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return type.getSqlTypeName() == SqlTypeName.MAP;
    }

    public static boolean isMultiset(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return type.getSqlTypeName() == SqlTypeName.MULTISET;
    }

    public static boolean isCollection(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return type.getSqlTypeName() == SqlTypeName.ARRAY || type.getSqlTypeName() == SqlTypeName.MULTISET;
    }

    public static boolean isCharacter(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return SqlTypeFamily.CHARACTER.contains(type);
    }

    @Deprecated
    public static boolean hasCharactor(RelDataType type) {
        return SqlTypeUtil.hasCharacter(type);
    }

    public static boolean hasCharacter(RelDataType type) {
        if (SqlTypeUtil.isCharacter(type)) {
            return true;
        }
        if (SqlTypeUtil.isArray(type)) {
            return SqlTypeUtil.hasCharacter(NonNullableAccessors.getComponentTypeOrThrow(type));
        }
        return false;
    }

    public static boolean isString(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return SqlTypeFamily.STRING.contains(type);
    }

    public static boolean isBoolean(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return SqlTypeFamily.BOOLEAN.contains(type);
    }

    public static boolean isBinary(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return SqlTypeFamily.BINARY.contains(type);
    }

    public static boolean isAtomic(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return SqlTypeUtil.isDatetime(type) || SqlTypeUtil.isNumeric(type) || SqlTypeUtil.isString(type) || SqlTypeUtil.isBoolean(type) || typeName == SqlTypeName.UUID;
    }

    public static RelDataType getMaxPrecisionScaleDecimal(RelDataTypeFactory factory) {
        int maxPrecision = factory.getTypeSystem().getMaxNumericPrecision();
        int maxScale = factory.getTypeSystem().getMaxNumericScale();
        int scale = Math.min(maxPrecision / 2, maxScale);
        return factory.createSqlType(SqlTypeName.DECIMAL, maxPrecision, scale);
    }

    public static RelDataType extractLastNFields(RelDataTypeFactory typeFactory, RelDataType type, int numToKeep) {
        assert (type.isStruct());
        assert (type.getFieldCount() >= numToKeep);
        int fieldsCnt = type.getFieldCount();
        return typeFactory.createStructType(type.getFieldList().subList(fieldsCnt - numToKeep, fieldsCnt));
    }

    public static boolean canBeRepresentedExactly(@Nullable BigDecimal value, RelDataType toType) {
        int maxIntDigits;
        int intDigits;
        assert (toType.getSqlTypeName() == SqlTypeName.DECIMAL);
        if (value == null) {
            return true;
        }
        if ((value = value.stripTrailingZeros()).scale() < 0) {
            value = value.setScale(0, RoundingMode.DOWN);
        }
        return (intDigits = value.precision() - value.scale()) <= (maxIntDigits = toType.getPrecision() - toType.getScale()) && value.scale() <= toType.getScale();
    }

    public static boolean isValidDecimalValue(@Nullable BigDecimal value, RelDataType toType) {
        if (value == null) {
            return true;
        }
        switch (toType.getSqlTypeName()) {
            case DECIMAL: {
                int intDigits = value.precision() - value.scale();
                int maxIntDigits = toType.getPrecision() - toType.getScale();
                return intDigits <= maxIntDigits;
            }
        }
        return true;
    }

    public static RelDataType fromMeasure(RelDataTypeFactory typeFactory, RelDataType type) {
        if (type.isStruct()) {
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            int changeCount = 0;
            for (RelDataTypeField field : type.getFieldList()) {
                RelDataType type2 = SqlTypeUtil.fromMeasure(typeFactory, field.getType());
                if (type2 != field.getType()) {
                    ++changeCount;
                }
                ((RelDataTypeFactory.Builder)builder).add(field.getName(), type2);
            }
            return changeCount == 0 ? type : builder.build();
        }
        if (type.isMeasure()) {
            return (RelDataType)((MeasureSqlType)type).types.get(0);
        }
        return type;
    }
}

