/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Objects;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Arrow {
    private final ImmutableBitSet determinants;
    private final ImmutableBitSet dependents;

    private Arrow(ImmutableBitSet determinants, ImmutableBitSet dependents) {
        this.determinants = Objects.requireNonNull(determinants, "determinants must not be null");
        this.dependents = Objects.requireNonNull(dependents, "dependents must not be null");
    }

    public static Arrow of(ImmutableBitSet determinants, ImmutableBitSet dependents) {
        return new Arrow(determinants, dependents);
    }

    public static Arrow of(int determinant, int dependent) {
        return Arrow.of(ImmutableBitSet.of(determinant), ImmutableBitSet.of(dependent));
    }

    public ImmutableBitSet getDeterminants() {
        return this.determinants;
    }

    public ImmutableBitSet getDependents() {
        return this.dependents;
    }

    public boolean isTrivial() {
        return this.determinants.contains(this.dependents);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Arrow)) {
            return false;
        }
        Arrow that = (Arrow)o;
        return this.determinants.equals(that.determinants) && this.dependents.equals(that.dependents);
    }

    public int hashCode() {
        return Objects.hash(this.determinants, this.dependents);
    }

    public String toString() {
        return this.determinants + " -> " + this.dependents;
    }
}

