/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.calcite.util.Arrow;
import org.apache.calcite.util.ImmutableBitSet;

public class ArrowSet {
    public static final ArrowSet EMPTY = new ArrowSet((Set<Arrow>)ImmutableSet.of());
    private ImmutableList<Arrow> arrowSet;
    private final ImmutableMap<ImmutableBitSet, ImmutableBitSet> determinantsToDependentsMap;
    private final ImmutableMap<Integer, ImmutableSet<Arrow>> ordinalToArrows;

    public ArrowSet(Set<Arrow> arrows) {
        Set<Arrow> minimalArrows = ArrowSet.computeMinimalDependencySet(arrows);
        this.arrowSet = ImmutableList.copyOf(minimalArrows);
        HashMap<ImmutableBitSet, ImmutableBitSet> detToDep = new HashMap<ImmutableBitSet, ImmutableBitSet>();
        HashMap<Integer, Set> ordToArrows = new HashMap<Integer, Set>();
        for (Arrow arrow : minimalArrows) {
            ImmutableBitSet determinants = arrow.getDeterminants();
            ImmutableBitSet dependents = arrow.getDependents();
            detToDep.merge(determinants, dependents, ImmutableBitSet::union);
            for (int det : determinants) {
                ordToArrows.computeIfAbsent(det, k -> new HashSet()).add(arrow);
            }
        }
        this.determinantsToDependentsMap = ImmutableMap.copyOf(detToDep);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : ordToArrows.entrySet()) {
            builder.put(entry.getKey(), (Object)ImmutableSet.copyOf((Collection)((Collection)entry.getValue())));
        }
        this.ordinalToArrows = builder.build();
    }

    public ImmutableBitSet dependents(ImmutableBitSet ordinals) {
        if (ordinals.isEmpty()) {
            return ImmutableBitSet.of();
        }
        BitSet closureSet = new BitSet();
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
        for (int attr : ordinals) {
            closureSet.set(attr);
            queue.add(attr);
        }
        HashMap<Arrow, Integer> missingCount = new HashMap<Arrow, Integer>();
        for (Arrow arrow : this.arrowSet) {
            missingCount.put(arrow, arrow.getDeterminants().cardinality());
        }
        while (!queue.isEmpty()) {
            int attr = (Integer)Objects.requireNonNull(queue.poll(), "Queue returned null while computing dependents");
            Set arrows = (Set)this.ordinalToArrows.get((Object)attr);
            if (arrows == null) continue;
            for (Arrow arrow : arrows) {
                int count = (Integer)Objects.requireNonNull(missingCount.get(arrow), "missingCount returned null for Arrow " + arrow);
                if (count <= 0) continue;
                missingCount.put(arrow, --count);
                if (count != 0) continue;
                for (int dep : arrow.getDependents()) {
                    if (closureSet.get(dep)) continue;
                    closureSet.set(dep);
                    queue.add(dep);
                }
            }
        }
        return ImmutableBitSet.of(closureSet.stream().toArray());
    }

    public Set<ImmutableBitSet> determinants(ImmutableBitSet ordinals) {
        if (this.arrowSet.isEmpty()) {
            return ImmutableSet.of((Object)ordinals);
        }
        ImmutableBitSet nonDependentOrdinals = this.findNonDependentAttributes(ordinals);
        if (this.dependents(nonDependentOrdinals).contains(ordinals)) {
            return ImmutableSet.of((Object)nonDependentOrdinals);
        }
        ImmutableSet keys = new HashSet();
        int minSize = Integer.MAX_VALUE;
        PriorityQueue<ImmutableBitSet> queue = new PriorityQueue<ImmutableBitSet>(Comparator.comparingInt(ImmutableBitSet::cardinality));
        HashSet<ImmutableBitSet> visited = new HashSet<ImmutableBitSet>();
        queue.add(nonDependentOrdinals);
        while (!queue.isEmpty()) {
            ImmutableBitSet ords = Objects.requireNonNull(queue.poll(), "queue.poll() returned null");
            if (visited.contains(ords)) continue;
            visited.add(ords);
            if (ords.cardinality() > minSize) continue;
            boolean covered = false;
            for (ImmutableBitSet key : keys) {
                if (!ords.contains(key)) continue;
                covered = true;
                break;
            }
            if (covered) continue;
            ImmutableBitSet closure = this.dependents(ords);
            if (closure.contains(ordinals)) {
                keys.add(ords);
                minSize = ords.cardinality();
                continue;
            }
            for (int attr : ordinals) {
                ImmutableBitSet next;
                if (ords.get(attr) || visited.contains(next = ords.union(ImmutableBitSet.of(attr)))) continue;
                queue.add(next);
            }
        }
        return keys.isEmpty() ? ImmutableSet.of((Object)ordinals) : keys;
    }

    private ImmutableBitSet findNonDependentAttributes(ImmutableBitSet ordinals) {
        ImmutableBitSet dependentsAttrs = this.determinantsToDependentsMap.values().stream().reduce(ImmutableBitSet.of(), ImmutableBitSet::union);
        return ordinals.except(dependentsAttrs);
    }

    public ArrowSet union(ArrowSet other) {
        HashSet<Arrow> unionSet = new HashSet<Arrow>();
        unionSet.addAll((Collection<Arrow>)this.getArrows());
        unionSet.addAll((Collection<Arrow>)other.getArrows());
        return new ArrowSet(unionSet);
    }

    public ImmutableList<Arrow> getArrows() {
        return this.arrowSet;
    }

    public ArrowSet clone() {
        return new ArrowSet(new HashSet<Arrow>((Collection<Arrow>)this.arrowSet));
    }

    public boolean equalTo(ArrowSet other) {
        for (Arrow arrow : this.arrowSet) {
            if (other.implies(arrow.getDeterminants(), arrow.getDependents())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ArrowSet{");
        boolean first = true;
        for (Arrow arrow : this.getArrows()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(arrow);
            first = false;
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean implies(ImmutableBitSet determinants, ImmutableBitSet dependents) {
        ImmutableBitSet dets = (ImmutableBitSet)this.determinantsToDependentsMap.get((Object)determinants);
        if (dets != null && dets.contains(dependents)) {
            return true;
        }
        return this.dependents(determinants).contains(dependents);
    }

    private static Set<Arrow> computeMinimalDependencySet(Set<Arrow> arrows) {
        if (arrows.isEmpty()) {
            return new HashSet<Arrow>();
        }
        HashMap<ImmutableBitSet, ImmutableBitSet> consolidated = new HashMap<ImmutableBitSet, ImmutableBitSet>();
        for (Arrow arrow : arrows) {
            ImmutableBitSet immutableBitSet = arrow.getDeterminants();
            ImmutableBitSet dependents = arrow.getDependents();
            ImmutableBitSet nonTrivialDependents = dependents.except(immutableBitSet);
            if (nonTrivialDependents.isEmpty()) continue;
            consolidated.merge(immutableBitSet, nonTrivialDependents, ImmutableBitSet::union);
        }
        HashSet<ImmutableBitSet> toRemove = new HashSet<ImmutableBitSet>();
        block1: for (Map.Entry entry : consolidated.entrySet()) {
            ImmutableBitSet determinants = (ImmutableBitSet)entry.getKey();
            ImmutableBitSet dependents = (ImmutableBitSet)entry.getValue();
            for (Map.Entry other : consolidated.entrySet()) {
                if (entry.equals(other)) continue;
                ImmutableBitSet otherDeterminants = (ImmutableBitSet)other.getKey();
                ImmutableBitSet otherDependents = (ImmutableBitSet)other.getValue();
                if (!determinants.contains(otherDeterminants) || determinants.cardinality() <= otherDeterminants.cardinality() || !otherDependents.contains(dependents)) continue;
                toRemove.add(determinants);
                continue block1;
            }
        }
        HashSet<Arrow> hashSet = new HashSet<Arrow>();
        for (Map.Entry entry : consolidated.entrySet()) {
            if (toRemove.contains(entry.getKey())) continue;
            hashSet.add(Arrow.of((ImmutableBitSet)entry.getKey(), (ImmutableBitSet)entry.getValue()));
        }
        return hashSet;
    }

    public static class Builder {
        private final Set<Arrow> arrowSet = new HashSet<Arrow>();

        public Builder addArrow(ImmutableBitSet lhs, ImmutableBitSet rhs) {
            this.arrowSet.add(Arrow.of(lhs, rhs));
            return this;
        }

        public Builder addArrow(int lhs, int rhs) {
            this.arrowSet.add(Arrow.of(lhs, rhs));
            return this;
        }

        public Builder addBidirectionalArrow(int lhs, int rhs) {
            this.addArrow(lhs, rhs);
            this.addArrow(rhs, lhs);
            return this;
        }

        public Builder addBidirectionalArrow(ImmutableBitSet lhs, ImmutableBitSet rhs) {
            this.addArrow(lhs, rhs);
            this.addArrow(rhs, lhs);
            return this;
        }

        public Builder addArrowSet(ArrowSet set) {
            for (Arrow arrow : set.getArrows()) {
                this.addArrow(arrow.getDeterminants(), arrow.getDependents());
            }
            return this;
        }

        public ArrowSet build() {
            return new ArrowSet(this.arrowSet);
        }
    }
}

