/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.client;

import com.amazonaws.services.emrserverless.AWSEMRServerless;
import com.amazonaws.services.emrserverless.model.CancelJobRunRequest;
import com.amazonaws.services.emrserverless.model.CancelJobRunResult;
import com.amazonaws.services.emrserverless.model.GetJobRunRequest;
import com.amazonaws.services.emrserverless.model.GetJobRunResult;
import com.amazonaws.services.emrserverless.model.JobDriver;
import com.amazonaws.services.emrserverless.model.SparkSubmit;
import com.amazonaws.services.emrserverless.model.StartJobRunRequest;
import com.amazonaws.services.emrserverless.model.StartJobRunResult;
import com.amazonaws.services.emrserverless.model.ValidationException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.spark.client.EMRServerlessClient;
import org.opensearch.sql.spark.client.StartJobRequest;
import org.opensearch.sql.spark.metrics.EmrMetrics;
import org.opensearch.sql.spark.metrics.MetricsService;

public class EmrServerlessClientImpl
implements EMRServerlessClient {
    private final AWSEMRServerless emrServerless;
    private final MetricsService metricsService;
    private static final Logger logger = LogManager.getLogger(EmrServerlessClientImpl.class);
    private static final int MAX_JOB_NAME_LENGTH = 255;
    public static final String GENERIC_INTERNAL_SERVER_ERROR_MESSAGE = "Internal Server Error.";

    @Override
    public String startJobRun(StartJobRequest startJobRequest) {
        StartJobRunResult startJobRunResult;
        String resultIndex = startJobRequest.getResultIndex() == null ? "query_execution_result" : startJobRequest.getResultIndex();
        StartJobRunRequest request = new StartJobRunRequest().withName(StringUtils.truncate((String)startJobRequest.getJobName(), (int)255)).withApplicationId(startJobRequest.getApplicationId()).withExecutionRoleArn(startJobRequest.getExecutionRoleArn()).withTags(startJobRequest.getTags()).withExecutionTimeoutMinutes(startJobRequest.executionTimeout()).withJobDriver(new JobDriver().withSparkSubmit(new SparkSubmit().withEntryPoint("file:///home/hadoop/.ivy2/jars/org.opensearch_opensearch-spark-sql-application_2.12-0.3.0-SNAPSHOT.jar").withEntryPointArguments(new String[]{resultIndex}).withSparkSubmitParameters(startJobRequest.getSparkSubmitParams())));
        try {
            startJobRunResult = this.emrServerless.startJobRun(request);
        }
        catch (Throwable t) {
            logger.error("Error while making start job request to emr:", t);
            this.metricsService.incrementNumericalMetric(EmrMetrics.EMR_START_JOB_REQUEST_FAILURE_COUNT);
            if (t instanceof ValidationException) {
                throw new IllegalArgumentException("The input fails to satisfy the constraints specified by AWS EMR Serverless.");
            }
            throw new RuntimeException(GENERIC_INTERNAL_SERVER_ERROR_MESSAGE);
        }
        logger.info("Job Run ID: " + startJobRunResult.getJobRunId());
        return startJobRunResult.getJobRunId();
    }

    @Override
    public GetJobRunResult getJobRunResult(String applicationId, String jobId) {
        GetJobRunResult getJobRunResult;
        GetJobRunRequest request = new GetJobRunRequest().withApplicationId(applicationId).withJobRunId(jobId);
        try {
            getJobRunResult = this.emrServerless.getJobRun(request);
        }
        catch (Throwable t) {
            logger.error("Error while making get job run request to emr:", t);
            this.metricsService.incrementNumericalMetric(EmrMetrics.EMR_GET_JOB_RESULT_FAILURE_COUNT);
            throw new RuntimeException(GENERIC_INTERNAL_SERVER_ERROR_MESSAGE);
        }
        logger.info("Job Run state: " + getJobRunResult.getJobRun().getState());
        return getJobRunResult;
    }

    @Override
    public CancelJobRunResult cancelJobRun(String applicationId, String jobId, boolean allowExceptionPropagation) {
        CancelJobRunResult cancelJobRunResult;
        CancelJobRunRequest cancelJobRunRequest = new CancelJobRunRequest().withJobRunId(jobId).withApplicationId(applicationId);
        try {
            cancelJobRunResult = this.emrServerless.cancelJobRun(cancelJobRunRequest);
        }
        catch (Throwable t) {
            if (allowExceptionPropagation) {
                throw t;
            }
            logger.error("Error while making cancel job request to emr: jobId=" + jobId, t);
            this.metricsService.incrementNumericalMetric(EmrMetrics.EMR_CANCEL_JOB_REQUEST_FAILURE_COUNT);
            if (t instanceof ValidationException) {
                throw new IllegalArgumentException("The input fails to satisfy the constraints specified by AWS EMR Serverless.");
            }
            throw new RuntimeException(GENERIC_INTERNAL_SERVER_ERROR_MESSAGE);
        }
        logger.info(String.format("Job : %s cancelled", cancelJobRunResult.getJobRunId()));
        return cancelJobRunResult;
    }

    @Generated
    public EmrServerlessClientImpl(AWSEMRServerless emrServerless, MetricsService metricsService) {
        this.emrServerless = emrServerless;
        this.metricsService = metricsService;
    }
}

