/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.validator;

import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.common.antlr.CaseInsensitiveCharStream;
import org.opensearch.sql.common.antlr.SyntaxAnalysisErrorListener;
import org.opensearch.sql.datasource.model.DataSourceType;
import org.opensearch.sql.spark.antlr.parser.OpenSearchPPLLexer;
import org.opensearch.sql.spark.antlr.parser.OpenSearchPPLParser;
import org.opensearch.sql.spark.validator.GrammarElementValidator;
import org.opensearch.sql.spark.validator.GrammarElementValidatorProvider;
import org.opensearch.sql.spark.validator.PPLQueryValidationVisitor;
import org.opensearch.sql.spark.validator.SQLQueryValidator;

public class PPLQueryValidator {
    private static final Logger log = LogManager.getLogger(SQLQueryValidator.class);
    private final GrammarElementValidatorProvider grammarElementValidatorProvider;

    public void validate(String pplQuery, DataSourceType datasourceType) {
        GrammarElementValidator grammarElementValidator = this.grammarElementValidatorProvider.getValidatorForDatasource(datasourceType);
        PPLQueryValidationVisitor visitor = new PPLQueryValidationVisitor(grammarElementValidator);
        try {
            visitor.visit((ParseTree)PPLQueryValidator.getPplParser(pplQuery).root());
        }
        catch (IllegalArgumentException e) {
            log.error("Query validation failed. DataSourceType=" + String.valueOf(datasourceType), (Throwable)e);
            throw e;
        }
    }

    public static OpenSearchPPLParser getPplParser(String pplQuery) {
        OpenSearchPPLParser sqlBaseParser = new OpenSearchPPLParser((TokenStream)new CommonTokenStream((TokenSource)new OpenSearchPPLLexer((CharStream)new CaseInsensitiveCharStream(pplQuery))));
        sqlBaseParser.addErrorListener((ANTLRErrorListener)new SyntaxAnalysisErrorListener());
        return sqlBaseParser;
    }

    @Generated
    public PPLQueryValidator(GrammarElementValidatorProvider grammarElementValidatorProvider) {
        this.grammarElementValidatorProvider = grammarElementValidatorProvider;
    }
}

