/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.geospatial.action.IpEnrichmentActionClient;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.data.model.ExprIpValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;
import org.opensearch.transport.client.node.NodeClient;

public class GeoIpFunction
extends ImplementorUDF {
    public GeoIpFunction(NodeClient nodeClient) {
        super((NotNullImplementor)new GeoIPImplementor(nodeClient), NullPolicy.ANY);
    }

    public SqlReturnTypeInference getReturnTypeInference() {
        return op -> {
            RelDataTypeFactory typeFactory = op.getTypeFactory();
            RelDataType varcharType = typeFactory.createSqlType(SqlTypeName.VARCHAR);
            RelDataType anyType = typeFactory.createSqlType(SqlTypeName.ANY);
            return typeFactory.createMapType(varcharType, anyType);
        };
    }

    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrapUDT(List.of(List.of(ExprCoreType.STRING, ExprCoreType.IP), List.of(ExprCoreType.STRING, ExprCoreType.IP, ExprCoreType.STRING)));
    }

    public static class GeoIPImplementor
    implements NotNullImplementor {
        private static NodeClient nodeClient;

        public GeoIPImplementor(NodeClient nodeClient) {
            GeoIPImplementor.nodeClient = nodeClient;
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            if (GeoIPImplementor.getNodeClient() == null) {
                throw new IllegalStateException("nodeClient is null.");
            }
            ArrayList<Expression> operandsWithClient = new ArrayList<Expression>(translatedOperands);
            operandsWithClient.add((Expression)Expressions.call(GeoIPImplementor.class, (String)"getNodeClient", (Expression[])new Expression[0]));
            return Expressions.call(GeoIPImplementor.class, (String)"fetchIpEnrichment", operandsWithClient);
        }

        public static Map<String, ?> fetchIpEnrichment(String dataSource, ExprIpValue ipAddress, NodeClient nodeClient) {
            return GeoIPImplementor.fetchIpEnrichment(dataSource, ipAddress.toString(), Collections.emptySet(), nodeClient);
        }

        public static Map<String, ?> fetchIpEnrichment(String dataSource, Object ipAddress, NodeClient nodeClient) {
            return GeoIPImplementor.fetchIpEnrichment(dataSource, ipAddress.toString(), Collections.emptySet(), nodeClient);
        }

        public static Map<String, ?> fetchIpEnrichment(String dataSource, ExprIpValue ipAddress, String commaSeparatedOptions, NodeClient nodeClient) {
            String unquotedOptions = StringUtils.unquoteText((String)commaSeparatedOptions);
            Set<String> options = Arrays.stream(unquotedOptions.split(",")).map(String::trim).collect(Collectors.toSet());
            return GeoIPImplementor.fetchIpEnrichment(dataSource, ipAddress.toString(), options, nodeClient);
        }

        private static Map<String, ?> fetchIpEnrichment(String dataSource, String ipAddress, Set<String> options, NodeClient nodeClient) {
            IpEnrichmentActionClient ipClient = new IpEnrichmentActionClient(nodeClient);
            dataSource = StringUtils.unquoteText((String)dataSource);
            try {
                Map geoLocationData = ipClient.getGeoLocationData(ipAddress, dataSource);
                Map<String, ExprValue> enrichmentResult = geoLocationData.entrySet().stream().filter(entry -> options.isEmpty() || options.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, v -> new ExprStringValue(v.getValue().toString())));
                Map result = (Map)ExprTupleValue.fromExprValueMap(enrichmentResult).valueForCalcite();
                return result;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Generated
        public static NodeClient getNodeClient() {
            return nodeClient;
        }
    }
}

