/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.physical;

import java.util.List;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.EnumerableAggregateBase;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CalciteEnumerableNestedAggregate
extends EnumerableAggregateBase
implements EnumerableRel {
    public CalciteEnumerableNestedAggregate(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode input, ImmutableBitSet groupSet, @Nullable List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        super(cluster, traitSet, hints, input, groupSet, groupSets, aggCalls);
        assert (this.getConvention() instanceof EnumerableConvention);
        for (AggregateCall aggCall : aggCalls) {
            if (aggCall.isDistinct()) {
                throw new InvalidRelException("distinct aggregation not supported");
            }
            if (aggCall.distinctKeys != null) {
                throw new InvalidRelException("within-distinct aggregation not supported");
            }
            AggImplementor implementor2 = RexImpTable.INSTANCE.get(aggCall.getAggregation(), false);
            if (implementor2 != null) continue;
            throw new InvalidRelException("aggregation " + String.valueOf(aggCall.getAggregation()) + " not supported");
        }
    }

    public CalciteEnumerableNestedAggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, @Nullable List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        try {
            return new CalciteEnumerableNestedAggregate(this.getCluster(), traitSet, (List<RelHint>)this.getHints(), input, groupSet, groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        throw new UnsupportedOperationException(String.format("Cannot execute nested aggregation on %s since pushdown cannot be applied.", this.aggCalls));
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.9);
    }
}

