/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.rules;

import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.sql.calcite.utils.PPLHintUtils;
import org.opensearch.sql.opensearch.planner.physical.CalciteEnumerableNestedAggregate;

public class EnumerableNestedAggregateRule
extends ConverterRule {
    private static final Logger LOG = LogManager.getLogger();
    public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalAggregate.class, (RelTrait)Convention.NONE, (RelTrait)EnumerableConvention.INSTANCE, "EnumerableNestedAggregateRule").withRuleFactory(EnumerableNestedAggregateRule::new);

    protected EnumerableNestedAggregateRule(ConverterRule.Config config) {
        super(config);
    }

    public @Nullable RelNode convert(RelNode rel) {
        Aggregate agg = (Aggregate)rel;
        if (PPLHintUtils.hasNestedAggCall((Aggregate)agg)) {
            RelTraitSet traitSet = rel.getCluster().traitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
            try {
                return new CalciteEnumerableNestedAggregate(rel.getCluster(), traitSet, (List<RelHint>)agg.getHints(), EnumerableNestedAggregateRule.convert((RelNode)agg.getInput(), (RelTraitSet)traitSet), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(e.toString());
                }
                return null;
            }
        }
        return null;
    }
}

