/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.rules;

import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.immutables.value.Value;
import org.opensearch.sql.calcite.plan.rule.OpenSearchRuleConfig;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.opensearch.planner.rules.ImmutableFilterIndexScanRule;
import org.opensearch.sql.opensearch.planner.rules.InterruptibleRelRule;
import org.opensearch.sql.opensearch.storage.scan.AbstractCalciteIndexScan;
import org.opensearch.sql.opensearch.storage.scan.CalciteLogicalIndexScan;

@Value.Enclosing
public class FilterIndexScanRule
extends InterruptibleRelRule<Config> {
    protected FilterIndexScanRule(Config config) {
        super(config);
    }

    @Override
    protected void onMatchImpl(RelOptRuleCall call) {
        if (call.rels.length != 2) {
            throw new AssertionError((Object)String.format("The length of rels should be %s but got %s", this.operands.size(), call.rels.length));
        }
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        CalciteLogicalIndexScan scan = (CalciteLogicalIndexScan)call.rel(1);
        this.apply(call, (Filter)filter, scan);
    }

    protected void apply(RelOptRuleCall call, Filter filter, CalciteLogicalIndexScan scan) {
        AbstractRelNode newRel = scan.pushDownFilter(filter);
        if (newRel != null) {
            call.transformTo((RelNode)newRel);
            PlanUtils.tryPruneRelNodes((RelOptRuleCall)call);
        }
    }

    @Value.Immutable
    public static interface Config
    extends OpenSearchRuleConfig {
        public static final Config DEFAULT = ImmutableFilterIndexScanRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalFilter.class).oneInput(b1 -> b1.operand(CalciteLogicalIndexScan.class).predicate(Predicate.not(AbstractCalciteIndexScan::isLimitPushed).and(AbstractCalciteIndexScan::noAggregatePushed)).noInputs()));

        default public FilterIndexScanRule toRule() {
            return new FilterIndexScanRule(this);
        }
    }
}

