/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.rules;

import java.util.Objects;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.immutables.value.Value;
import org.opensearch.sql.calcite.plan.rule.OpenSearchRuleConfig;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.opensearch.planner.rules.ImmutableLimitIndexScanRule;
import org.opensearch.sql.opensearch.planner.rules.InterruptibleRelRule;
import org.opensearch.sql.opensearch.storage.scan.CalciteLogicalIndexScan;

@Value.Enclosing
public class LimitIndexScanRule
extends InterruptibleRelRule<Config> {
    protected LimitIndexScanRule(Config config) {
        super(config);
    }

    @Override
    protected void onMatchImpl(RelOptRuleCall call) {
        AbstractRelNode newOperator;
        LogicalSort sort = (LogicalSort)call.rel(0);
        CalciteLogicalIndexScan scan = (CalciteLogicalIndexScan)call.rel(1);
        if (!sort.getCollation().getFieldCollations().isEmpty() && sort.getCollation() != scan.getTraitSet().getCollation()) {
            return;
        }
        Integer limitValue = LimitIndexScanRule.extractLimitValue(sort.fetch);
        Integer offsetValue = LimitIndexScanRule.extractOffsetValue(sort.offset);
        if (limitValue != null && offsetValue != null && (newOperator = scan.pushDownLimit(sort, limitValue, offsetValue)) != null) {
            call.transformTo((RelNode)newOperator);
            PlanUtils.tryPruneRelNodes((RelOptRuleCall)call);
        }
    }

    public static Integer extractLimitValue(RexNode fetch) {
        if (fetch instanceof RexLiteral) {
            return (Integer)((RexLiteral)fetch).getValueAs(Integer.class);
        }
        return null;
    }

    public static Integer extractOffsetValue(RexNode offset) {
        if (Objects.isNull(offset)) {
            return 0;
        }
        if (offset instanceof RexLiteral) {
            return (Integer)((RexLiteral)offset).getValueAs(Integer.class);
        }
        return null;
    }

    @Value.Immutable
    public static interface Config
    extends OpenSearchRuleConfig {
        public static final Config DEFAULT = ImmutableLimitIndexScanRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalSort.class).predicate(PlanUtils::isLogicalSortLimit).oneInput(b1 -> b1.operand(CalciteLogicalIndexScan.class).noInputs()));

        default public LimitIndexScanRule toRule() {
            return new LimitIndexScanRule(this);
        }
    }
}

