/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan.context;

import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexNode;
import org.jetbrains.annotations.NotNull;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.opensearch.request.OpenSearchRequestBuilder;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;
import org.opensearch.sql.opensearch.storage.scan.context.AbstractAction;
import org.opensearch.sql.opensearch.storage.scan.context.AggPushDownAction;
import org.opensearch.sql.opensearch.storage.scan.context.FilterDigest;
import org.opensearch.sql.opensearch.storage.scan.context.LimitDigest;
import org.opensearch.sql.opensearch.storage.scan.context.OSRequestBuilderAction;
import org.opensearch.sql.opensearch.storage.scan.context.ProjectDigest;
import org.opensearch.sql.opensearch.storage.scan.context.PushDownOperation;
import org.opensearch.sql.opensearch.storage.scan.context.PushDownType;

public class PushDownContext
extends AbstractCollection<PushDownOperation> {
    private final OpenSearchIndex osIndex;
    private ArrayDeque<PushDownOperation> queue = new ArrayDeque();
    private ArrayDeque<PushDownOperation> operationsForRequestBuilder;
    private boolean isAggregatePushed = false;
    private AggPushDownAction aggPushDownAction;
    private ArrayDeque<PushDownOperation> operationsForAgg;
    private int startFrom = 0;
    private boolean isLimitPushed = false;
    private boolean isProjectPushed = false;
    private boolean isMeasureOrderPushed = false;
    private boolean isSortPushed = false;
    private boolean isSortExprPushed = false;
    private boolean isTopKPushed = false;
    private boolean isRareTopPushed = false;
    private boolean isScriptPushed = false;

    public PushDownContext(OpenSearchIndex osIndex) {
        this.osIndex = osIndex;
    }

    public PushDownContext clone() {
        PushDownContext newContext = new PushDownContext(this.osIndex);
        newContext.addAll(this);
        return newContext;
    }

    public PushDownContext cloneWithoutSort() {
        PushDownContext newContext = new PushDownContext(this.osIndex);
        for (PushDownOperation action : this) {
            if (action.type() == PushDownType.SORT || action.type() == PushDownType.SORT_EXPR) continue;
            newContext.add(action);
        }
        return newContext;
    }

    public PushDownContext cloneForAggregate(Aggregate aggregate, @Nullable Project project) {
        PushDownContext newContext = new PushDownContext(this.osIndex);
        ArrayDeque<PushDownOperation> tempQueue = new ArrayDeque<PushDownOperation>(this.queue);
        while (!tempQueue.isEmpty()) {
            PushDownOperation operation = tempQueue.pollFirst();
            if (operation.type() == PushDownType.SORT || operation.type() == PushDownType.SORT_EXPR || operation.type() == PushDownType.PROJECT) continue;
            if (operation.type() == PushDownType.FILTER) {
                List<Integer> currentColumns = null;
                while (!tempQueue.isEmpty() && tempQueue.peekFirst().type() == PushDownType.PROJECT) {
                    ProjectDigest projectDigest = (ProjectDigest)tempQueue.pollFirst().digest();
                    List<Integer> selectedColumns = projectDigest.selectedColumns();
                    currentColumns = currentColumns == null ? selectedColumns : selectedColumns.stream().map(currentColumns::get).toList();
                }
                if (tempQueue.isEmpty() && PlanUtils.isNotNullDerivedFromAgg((RexNode)((FilterDigest)operation.digest()).condition(), (Aggregate)aggregate, (Project)project, currentColumns)) continue;
            }
            newContext.add(operation);
        }
        return newContext;
    }

    @Override
    @NotNull
    public Iterator<PushDownOperation> iterator() {
        return this.queue.iterator();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    void addOperationForRequestBuilder(PushDownOperation operation) {
        if (this.operationsForRequestBuilder == null) {
            this.operationsForRequestBuilder = new ArrayDeque();
        }
        this.operationsForRequestBuilder.add(operation);
        this.queue.add(operation);
    }

    void addOperationForAgg(PushDownOperation operation) {
        if (this.operationsForAgg == null) {
            this.operationsForAgg = new ArrayDeque();
        }
        this.operationsForAgg.add(operation);
        this.queue.add(operation);
    }

    @Override
    public boolean add(PushDownOperation operation) {
        operation.action().pushOperation(this, operation);
        if (operation.type() == PushDownType.AGGREGATION) {
            this.isAggregatePushed = true;
            this.aggPushDownAction = (AggPushDownAction)operation.action();
        }
        if (operation.type() == PushDownType.LIMIT) {
            this.startFrom += ((LimitDigest)operation.digest()).offset();
            if (this.startFrom >= this.osIndex.getMaxResultWindow()) {
                throw new OpenSearchRequestBuilder.PushDownUnSupportedException(String.format("[INTERNAL] Requested offset %d should be less than the max result window %d", this.startFrom, this.osIndex.getMaxResultWindow()));
            }
            this.isLimitPushed = true;
            if (this.isSortPushed || this.isMeasureOrderPushed || this.isSortExprPushed) {
                this.isTopKPushed = true;
            }
        }
        if (operation.type() == PushDownType.PROJECT) {
            this.isProjectPushed = true;
        }
        if (operation.type() == PushDownType.SORT) {
            this.isSortPushed = true;
        }
        if (operation.type() == PushDownType.SORT_EXPR) {
            this.isSortExprPushed = true;
        }
        if (operation.type() == PushDownType.SORT_AGG_METRICS) {
            this.isMeasureOrderPushed = true;
        }
        if (operation.type() == PushDownType.RARE_TOP) {
            this.isRareTopPushed = true;
        }
        if (operation.type() == PushDownType.SCRIPT) {
            this.isScriptPushed = true;
        }
        return true;
    }

    public void add(PushDownType type, Object digest, AbstractAction<?> action) {
        this.add(new PushDownOperation(type, digest, action));
    }

    public boolean containsDigest(Object digest) {
        return this.stream().anyMatch(action -> action.digest().equals(digest));
    }

    public boolean containsDigestOnTop(Object digest) {
        return this.queue.peekLast() != null && this.queue.peekLast().digest().equals(digest);
    }

    public Object getDigestByType(PushDownType type) {
        return this.stream().filter(operation -> operation.type() == type).map(PushDownOperation::digest).findFirst().orElse(null);
    }

    public OpenSearchRequestBuilder createRequestBuilder() {
        OpenSearchRequestBuilder newRequestBuilder = this.osIndex.createRequestBuilder();
        if (this.operationsForRequestBuilder != null) {
            this.operationsForRequestBuilder.forEach((? super E operation) -> ((OSRequestBuilderAction)operation.action()).apply(newRequestBuilder));
        }
        return newRequestBuilder;
    }

    @Generated
    public OpenSearchIndex getOsIndex() {
        return this.osIndex;
    }

    @Generated
    public ArrayDeque<PushDownOperation> getQueue() {
        return this.queue;
    }

    @Generated
    public ArrayDeque<PushDownOperation> getOperationsForRequestBuilder() {
        return this.operationsForRequestBuilder;
    }

    @Generated
    public boolean isAggregatePushed() {
        return this.isAggregatePushed;
    }

    @Generated
    public AggPushDownAction getAggPushDownAction() {
        return this.aggPushDownAction;
    }

    @Generated
    public ArrayDeque<PushDownOperation> getOperationsForAgg() {
        return this.operationsForAgg;
    }

    @Generated
    public int getStartFrom() {
        return this.startFrom;
    }

    @Generated
    public boolean isLimitPushed() {
        return this.isLimitPushed;
    }

    @Generated
    public boolean isProjectPushed() {
        return this.isProjectPushed;
    }

    @Generated
    public boolean isMeasureOrderPushed() {
        return this.isMeasureOrderPushed;
    }

    @Generated
    public boolean isSortPushed() {
        return this.isSortPushed;
    }

    @Generated
    public boolean isSortExprPushed() {
        return this.isSortExprPushed;
    }

    @Generated
    public boolean isTopKPushed() {
        return this.isTopKPushed;
    }

    @Generated
    public boolean isRareTopPushed() {
        return this.isRareTopPushed;
    }

    @Generated
    public boolean isScriptPushed() {
        return this.isScriptPushed;
    }
}

