/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.PrintStream;
import java.time.chrono.ChronoZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.LabelTarget;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutable;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.script.AggregationScript;
import org.opensearch.script.FieldScript;
import org.opensearch.script.FilterScript;
import org.opensearch.script.NumberSortScript;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.script.StringSortScript;
import org.opensearch.search.lookup.SourceLookup;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.opensearch.storage.script.aggregation.CalciteAggregationScriptFactory;
import org.opensearch.sql.opensearch.storage.script.field.CalciteFieldScriptFactory;
import org.opensearch.sql.opensearch.storage.script.filter.CalciteFilterScriptFactory;
import org.opensearch.sql.opensearch.storage.script.sort.CalciteNumberSortScriptFactory;
import org.opensearch.sql.opensearch.storage.script.sort.CalciteStringSortScriptFactory;
import org.opensearch.sql.opensearch.storage.serde.RelJsonSerializer;

public class CalciteScriptEngine
implements ScriptEngine {
    private final RelJsonSerializer relJsonSerializer;
    public static final String EXPRESSION_LANG_NAME = "opensearch_calcite_expression";
    private static final Map<ScriptContext<?>, BiFunction<Function1<DataContext, Object[]>, RelDataType, Object>> CONTEXTS = new ImmutableMap.Builder().put((Object)FilterScript.CONTEXT, CalciteFilterScriptFactory::new).put((Object)AggregationScript.CONTEXT, CalciteAggregationScriptFactory::new).put((Object)NumberSortScript.CONTEXT, CalciteNumberSortScriptFactory::new).put((Object)StringSortScript.CONTEXT, CalciteStringSortScriptFactory::new).put((Object)FieldScript.CONTEXT, CalciteFieldScriptFactory::new).build();

    public CalciteScriptEngine(RelOptCluster relOptCluster) {
        this.relJsonSerializer = new RelJsonSerializer(relOptCluster);
    }

    public String getType() {
        return EXPRESSION_LANG_NAME;
    }

    public <T> T compile(String scriptName, String scriptCode, ScriptContext<T> context, Map<String, String> options) {
        RexNode rexNode = this.relJsonSerializer.deserialize(scriptCode);
        RexToLixTranslator.InputGetter getter = (blockBuilder, i, type) -> {
            throw new UnsupportedScriptException("[BUG]There shouldn't be RexInputRef in the RexNode.");
        };
        String code = CalciteScriptEngine.translate(this.relJsonSerializer.getCluster().getRexBuilder(), List.of(rexNode), getter, (RelDataType)new RelRecordType(List.of()));
        Function1 function = new RexExecutable(code, (Object)"generated Rex code").getFunction();
        if (CONTEXTS.containsKey(context)) {
            return context.factoryClazz.cast(CONTEXTS.get(context).apply((Function1<DataContext, Object[]>)function, rexNode.getType()));
        }
        throw new IllegalStateException(String.format("Script context is currently not supported: all supported contexts [%s], given context [%s] ", CONTEXTS, context));
    }

    public Set<ScriptContext<?>> getSupportedContexts() {
        return CONTEXTS.keySet();
    }

    public static String translate(RexBuilder rexBuilder, List<RexNode> constExps, RexToLixTranslator.InputGetter getter, RelDataType rowType) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(rowType, rexBuilder);
        for (RexNode node : constExps) {
            programBuilder.addProject(node, "c" + programBuilder.getProjectList().size());
        }
        RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
        JavaTypeFactory javaTypeFactory = typeFactory instanceof JavaTypeFactory ? (JavaTypeFactory)typeFactory : new JavaTypeFactoryImpl(typeFactory.getTypeSystem());
        BlockBuilder blockBuilder = new BlockBuilder();
        ParameterExpression root0_ = Expressions.parameter(Object.class, (String)"root0");
        ParameterExpression root_ = DataContext.ROOT;
        blockBuilder.add((Statement)Expressions.declare((int)16, (ParameterExpression)root_, (Expression)Expressions.convert_((Expression)root0_, DataContext.class)));
        SqlConformanceEnum conformance = SqlConformanceEnum.DEFAULT;
        RexProgram program = programBuilder.getProgram();
        List expressions = RexToLixTranslator.translateProjects((RexProgram)program, (JavaTypeFactory)javaTypeFactory, (SqlConformance)conformance, (BlockBuilder)blockBuilder, (BlockBuilder)null, (PhysType)null, (Expression)root_, (RexToLixTranslator.InputGetter)getter, (Function1)null);
        blockBuilder.add((Statement)Expressions.return_((LabelTarget)null, (Expression)Expressions.newArrayInit(Object[].class, (Iterable)expressions)));
        MethodDeclaration methodDecl = Expressions.methodDecl((int)1, Object[].class, (String)BuiltInMethod.FUNCTION1_APPLY.method.getName(), (Iterable)ImmutableList.of((Object)root0_), (BlockStatement)blockBuilder.toBlock());
        String code = Expressions.toString((Node)methodDecl);
        if (((Boolean)CalciteSystemProperty.DEBUG.value()).booleanValue()) {
            Util.debugCode((PrintStream)System.out, (String)code);
        }
        return code;
    }

    @Generated
    public CalciteScriptEngine(RelJsonSerializer relJsonSerializer) {
        this.relJsonSerializer = relJsonSerializer;
    }

    public static final class UnsupportedScriptException
    extends RuntimeException {
        public UnsupportedScriptException(String message) {
            super(message);
        }

        public UnsupportedScriptException(Throwable cause) {
            super(cause);
        }
    }

    public static enum Source {
        DOC_VALUE(0),
        SOURCE(1),
        LITERAL(2);

        private final int value;
        private static final Map<Integer, Source> VALUE_TO_SOURCE;

        private Source(int value) {
            this.value = value;
        }

        public static Source fromValue(int value) {
            Source source = VALUE_TO_SOURCE.get(value);
            if (source == null) {
                throw new IllegalArgumentException("No Source with value: " + value);
            }
            return source;
        }

        @Generated
        public int getValue() {
            return this.value;
        }

        static {
            VALUE_TO_SOURCE = new HashMap<Integer, Source>();
            for (Source source : Source.values()) {
                VALUE_TO_SOURCE.put(source.value, source);
            }
        }
    }

    public static class ScriptDataContext
    implements DataContext {
        private final Map<String, ScriptDocValues<?>> docProvider;
        private final SourceLookup sourceLookup;
        private final long utcTimestamp;
        private final List<Source> sources;
        private final List<Object> digests;
        private final Map<String, Integer> parameterToIndex;

        public ScriptDataContext(Map<String, ScriptDocValues<?>> docProvider, SourceLookup sourceLookup, Map<String, Object> params, Map<String, Integer> parameterToIndex) {
            this.docProvider = docProvider;
            this.sourceLookup = sourceLookup;
            this.utcTimestamp = (Long)params.get(DataContext.Variable.UTC_TIMESTAMP.camelName);
            this.sources = ((List)params.get("SOURCES")).stream().map(Source::fromValue).toList();
            this.digests = (List)params.get("DIGESTS");
            this.parameterToIndex = parameterToIndex;
        }

        public @Nullable SchemaPlus getRootSchema() {
            return null;
        }

        public JavaTypeFactory getTypeFactory() {
            return null;
        }

        public QueryProvider getQueryProvider() {
            return null;
        }

        public Object get(String name) {
            if (DataContext.Variable.UTC_TIMESTAMP.camelName.equals(name)) {
                return this.utcTimestamp;
            }
            try {
                int index = this.parameterToIndex.get(name);
                return switch (this.sources.get(index).ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> this.getFromDocValue((String)this.digests.get(index));
                    case 1 -> this.getFromSource((String)this.digests.get(index));
                    case 2 -> this.digests.get(index);
                };
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to get value for parameter " + name);
            }
        }

        public Object getFromDocValue(String name) {
            ScriptDocValues<?> docValue = this.docProvider.get(name);
            if (docValue == null || docValue.isEmpty()) {
                return null;
            }
            Object value = docValue.get(0);
            if (value instanceof ChronoZonedDateTime) {
                return new ExprTimestampValue(((ChronoZonedDateTime)value).toInstant()).value();
            }
            return value;
        }

        public Object getFromSource(String name) {
            return this.sourceLookup.get((Object)name);
        }
    }
}

