/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.directquery.rest;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.datasource.client.exceptions.DataSourceClientException;
import org.opensearch.sql.datasources.exceptions.ErrorMessage;
import org.opensearch.sql.datasources.utils.Scheduler;
import org.opensearch.sql.directquery.rest.model.GetDirectQueryResourcesRequest;
import org.opensearch.sql.directquery.rest.model.WriteDirectQueryResourcesRequest;
import org.opensearch.sql.directquery.transport.TransportGetDirectQueryResourcesRequestAction;
import org.opensearch.sql.directquery.transport.TransportWriteDirectQueryResourcesRequestAction;
import org.opensearch.sql.directquery.transport.format.DirectQueryResourcesRequestConverter;
import org.opensearch.sql.directquery.transport.model.ReadDirectQueryResourcesActionRequest;
import org.opensearch.sql.directquery.transport.model.ReadDirectQueryResourcesActionResponse;
import org.opensearch.sql.directquery.transport.model.WriteDirectQueryResourcesActionRequest;
import org.opensearch.sql.directquery.transport.model.WriteDirectQueryResourcesActionResponse;
import org.opensearch.sql.opensearch.setting.OpenSearchSettings;
import org.opensearch.sql.opensearch.util.RestRequestUtil;
import org.opensearch.transport.client.node.NodeClient;

@ExperimentalApi
public class RestDirectQueryResourcesManagementAction
extends BaseRestHandler {
    public static final String DIRECT_QUERY_RESOURCES_ACTIONS = "direct_query_resources_actions";
    public static final String BASE_DIRECT_QUERY_RESOURCES_URL = "/_plugins/_directquery/_resources/{dataSource}";
    private static final Logger LOG = LogManager.getLogger(RestDirectQueryResourcesManagementAction.class);
    private final OpenSearchSettings settings;

    public String getName() {
        return DIRECT_QUERY_RESOURCES_ACTIONS;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/api/v1/{resourceType}", BASE_DIRECT_QUERY_RESOURCES_URL)), (Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/api/v1/{resourceType}/{resourceName}/values", BASE_DIRECT_QUERY_RESOURCES_URL)), (Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/alertmanager/api/v2/alerts/groups", BASE_DIRECT_QUERY_RESOURCES_URL)), (Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/alertmanager/api/v2/{resourceType}", BASE_DIRECT_QUERY_RESOURCES_URL)), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/alertmanager/api/v2/{resourceType}", BASE_DIRECT_QUERY_RESOURCES_URL)));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient nodeClient) {
        if (!this.dataSourcesEnabled()) {
            return this.dataSourcesDisabledError(restRequest);
        }
        switch (restRequest.method()) {
            case GET: {
                return this.executeGetResourcesRequest(restRequest, nodeClient);
            }
            case POST: {
                return this.executeWriteResourcesRequest(restRequest, nodeClient);
            }
        }
        return restChannel -> restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, String.valueOf(restRequest.method())));
    }

    private BaseRestHandler.RestChannelConsumer executeGetResourcesRequest(final RestRequest restRequest, NodeClient nodeClient) {
        GetDirectQueryResourcesRequest directQueryRequest = DirectQueryResourcesRequestConverter.toGetDirectRestRequest(restRequest);
        return restChannel -> Scheduler.schedule((NodeClient)nodeClient, () -> nodeClient.execute(TransportGetDirectQueryResourcesRequestAction.ACTION_TYPE, (ActionRequest)new ReadDirectQueryResourcesActionRequest(directQueryRequest), (ActionListener)new ActionListener<ReadDirectQueryResourcesActionResponse>(){

            public void onResponse(ReadDirectQueryResourcesActionResponse response) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", response.getResult()));
            }

            public void onFailure(Exception e) {
                RestDirectQueryResourcesManagementAction.this.handleException(e, restChannel, restRequest.method());
            }
        }));
    }

    private BaseRestHandler.RestChannelConsumer executeWriteResourcesRequest(final RestRequest restRequest, NodeClient nodeClient) {
        WriteDirectQueryResourcesRequest directQueryRequest = DirectQueryResourcesRequestConverter.toWriteDirectRestRequest(restRequest);
        return restChannel -> Scheduler.schedule((NodeClient)nodeClient, () -> nodeClient.execute(TransportWriteDirectQueryResourcesRequestAction.ACTION_TYPE, (ActionRequest)new WriteDirectQueryResourcesActionRequest(directQueryRequest), (ActionListener)new ActionListener<WriteDirectQueryResourcesActionResponse>(){

            public void onResponse(WriteDirectQueryResourcesActionResponse response) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", response.getResult()));
            }

            public void onFailure(Exception e) {
                RestDirectQueryResourcesManagementAction.this.handleException(e, restChannel, restRequest.method());
            }
        }));
    }

    private void handleException(Exception e, RestChannel restChannel, RestRequest.Method requestMethod) {
        if (e instanceof OpenSearchException) {
            OpenSearchException exception = (OpenSearchException)e;
            this.reportError(restChannel, (Exception)exception, exception.status());
        } else {
            LOG.error("Error happened during request handling", (Throwable)e);
            if (RestDirectQueryResourcesManagementAction.isClientError(e)) {
                this.reportError(restChannel, e, RestStatus.BAD_REQUEST);
            } else {
                this.reportError(restChannel, e, RestStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    private void reportError(RestChannel channel, Exception e, RestStatus status) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, new ErrorMessage((Throwable)e, status.getStatus()).toString()));
    }

    private static boolean isClientError(Exception e) {
        return e instanceof IllegalArgumentException || e instanceof IllegalStateException || e instanceof DataSourceClientException || e instanceof IllegalAccessException;
    }

    private boolean dataSourcesEnabled() {
        return (Boolean)this.settings.getSettingValue(Settings.Key.DATASOURCES_ENABLED);
    }

    private BaseRestHandler.RestChannelConsumer dataSourcesDisabledError(RestRequest request) {
        RestRequestUtil.consumeAllRequestParameters((RestRequest)request);
        return channel -> this.reportError((RestChannel)channel, new IllegalAccessException(String.format("%s setting is false", Settings.Key.DATASOURCES_ENABLED.getKeyValue())), RestStatus.BAD_REQUEST);
    }

    @Generated
    public RestDirectQueryResourcesManagementAction(OpenSearchSettings settings) {
        this.settings = settings;
    }
}

