/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListsListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesPanel;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0010J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016R\"\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/ProjectCommittedChangesPanel;", "Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesPanel;", "project", "Lcom/intellij/openapi/project/Project;", "provider", "Lcom/intellij/openapi/vcs/CommittedChangesProvider;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/CommittedChangesProvider;)V", "getProvider", "()Lcom/intellij/openapi/vcs/CommittedChangesProvider;", "setProvider", "(Lcom/intellij/openapi/vcs/CommittedChangesProvider;)V", "cache", "Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesCache;", "kotlin.jvm.PlatformType", "refreshChanges", "", "clearCaches", "passCachedListsToListener", "notification", "Lcom/intellij/openapi/vcs/changes/committed/VcsConfigurationChangeListener$DetailedNotification;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class ProjectCommittedChangesPanel
extends CommittedChangesPanel {
    @NotNull
    private CommittedChangesProvider<?, ?> provider;
    private final CommittedChangesCache cache;

    public ProjectCommittedChangesPanel(@NotNull Project project, @NotNull CommittedChangesProvider<?, ?> provider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        super(project);
        this.provider = provider;
        this.cache = CommittedChangesCache.getInstance(project);
        this.setup(null, this.provider.createActions((DecoratorManager)this.getBrowser(), null));
    }

    @NotNull
    public final CommittedChangesProvider<?, ?> getProvider() {
        return this.provider;
    }

    public final void setProvider(@NotNull CommittedChangesProvider<?, ?> committedChangesProvider) {
        Intrinsics.checkNotNullParameter(committedChangesProvider, (String)"<set-?>");
        this.provider = committedChangesProvider;
    }

    @Override
    public void refreshChanges() {
        this.cache.hasCachesForAnyRoot((Consumer<? super Boolean>)((Consumer)arg_0 -> ProjectCommittedChangesPanel.refreshChanges$lambda$1(arg_0 -> ProjectCommittedChangesPanel.refreshChanges$lambda$0(this, arg_0), arg_0)));
    }

    public final void clearCaches() {
        this.cache.clearCaches(() -> ProjectCommittedChangesPanel.clearCaches$lambda$0(this));
    }

    public final void passCachedListsToListener(@NotNull VcsConfigurationChangeListener.DetailedNotification notification, @Nullable VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        List changeLists2 = new ArrayList();
        this.getBrowser().reportLoadedLists(new CommittedChangeListsListener(changeLists2, notification, this, root){
            final /* synthetic */ List<CommittedChangeList> $changeLists;
            final /* synthetic */ VcsConfigurationChangeListener.DetailedNotification $notification;
            final /* synthetic */ ProjectCommittedChangesPanel this$0;
            final /* synthetic */ VirtualFile $root;
            {
                this.$changeLists = $changeLists;
                this.$notification = $notification;
                this.this$0 = $receiver;
                this.$root = $root;
            }

            public void onBeforeStartReport() {
            }

            public boolean report(CommittedChangeList list) {
                Intrinsics.checkNotNullParameter((Object)list, (String)"list");
                this.$changeLists.add(list);
                return false;
            }

            public void onAfterEndReport() {
                if (!((Collection)this.$changeLists).isEmpty()) {
                    this.$notification.execute(this.this$0.getProject(), this.$root, this.$changeLists);
                }
            }
        });
    }

    private static final Unit refreshChanges$lambda$0(ProjectCommittedChangesPanel this$0, Boolean hasCaches) {
        if (!hasCaches.booleanValue()) {
            this$0.getBrowser().getEmptyText().setText(VcsBundle.message((String)"committed.changes.not.loaded.message", (Object[])new Object[0]));
            return Unit.INSTANCE;
        }
        Function1 changeListsConsumer = arg_0 -> ProjectCommittedChangesPanel.refreshChanges$lambda$0$0(this$0, arg_0);
        Function1 errorHandler = arg_0 -> ProjectCommittedChangesPanel.refreshChanges$lambda$0$1(this$0, arg_0);
        this$0.cache.getProjectChangesAsync(this$0.provider.createDefaultSettings(), 0, true, (Consumer<? super List<CommittedChangeList>>)((Consumer)arg_0 -> ProjectCommittedChangesPanel.refreshChanges$lambda$0$2(changeListsConsumer, arg_0)), (Consumer<? super List<VcsException>>)((Consumer)arg_0 -> ProjectCommittedChangesPanel.refreshChanges$lambda$0$3(errorHandler, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit refreshChanges$lambda$0$0(ProjectCommittedChangesPanel this$0, List changeLists2) {
        Intrinsics.checkNotNullParameter((Object)changeLists2, (String)"changeLists");
        this$0.getBrowser().getEmptyText().setText(VcsBundle.message((String)"committed.changes.empty.message", (Object[])new Object[0]));
        this$0.getBrowser().setItems(changeLists2, CommittedChangesBrowserUseCase.COMMITTED);
        return Unit.INSTANCE;
    }

    private static final Unit refreshChanges$lambda$0$1(ProjectCommittedChangesPanel this$0, List errors) {
        Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
        AbstractVcsHelper.getInstance((Project)this$0.getProject()).showErrors(errors, VcsBundle.message((String)"changes.error.refreshing.vcs.history", (Object[])new Object[0]));
        return Unit.INSTANCE;
    }

    private static final void refreshChanges$lambda$0$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void refreshChanges$lambda$0$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void refreshChanges$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void clearCaches$lambda$0(ProjectCommittedChangesPanel this$0) {
        ActionsKt.runInEdt((ModalityState)ModalityState.nonModal(), () -> ProjectCommittedChangesPanel.clearCaches$lambda$0$0(this$0));
    }

    private static final Unit clearCaches$lambda$0$0(ProjectCommittedChangesPanel this$0) {
        if (this$0.getProject().isDisposed()) {
            return Unit.INSTANCE;
        }
        this$0.getBrowser().getEmptyText().setText(VcsBundle.message((String)"committed.changes.not.loaded.message", (Object[])new Object[0]));
        this$0.getBrowser().setItems(CollectionsKt.emptyList(), CommittedChangesBrowserUseCase.COMMITTED);
        return Unit.INSTANCE;
    }
}

