/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.task;

import java.net.SocketException;
import java.util.logging.Level;
import net.sf.juife.AbstractTask;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.JSI18n;
import org.linuxsampler.lscp.LSException;

public abstract class EnhancedTask<R>
extends AbstractTask<R> {
    public static final int SOCKET_ERROR = 1;
    private boolean stopped = false;
    private boolean silent = false;
    private boolean showErrorDetails;

    public EnhancedTask() {
        this(false);
    }

    public EnhancedTask(boolean bl) {
        this.showErrorDetails = bl;
    }

    @Override
    public void run() {
        try {
            this.exec();
        }
        catch (SocketException socketException) {
            this.setErrorCode(1);
            this.setErrorMessage(JSI18n.i18n.getError("SOCKET_ERROR"));
            CC.getLogger().log(Level.FINE, this.getErrorMessage(), socketException);
        }
        catch (Exception exception) {
            this.setErrorMessage(this.getDescription() + ": " + HF.getErrorMessage(exception));
            if (this.showErrorDetails) {
                this.setErrorDetails(exception);
            }
            CC.getLogger().log(Level.FINE, this.getErrorMessage(), exception);
            this.onError(exception);
        }
    }

    public void exec() throws Exception {
    }

    public void onError(Exception exception) {
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean bl) {
        this.silent = bl;
    }

    public void setErrorDetails(Exception exception) {
        LSException lSException;
        if (exception == null) {
            return;
        }
        if (exception instanceof LSException && (lSException = (LSException)exception).getDetails() != null && lSException.getDetails().length() > 0) {
            this.setErrorDetails(lSException.getDetails());
        }
    }
}

